/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceOverloadConflictResolver;
import org.jetbrains.kotlin.resolve.calls.components.CallableReferenceResolutionKt;
import org.jetbrains.kotlin.resolve.calls.components.CreateFreshVariablesSubstitutor;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.candidate.CallableReferenceResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.components.FreshVariableNewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceCallCandidatesAmbiguity;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.CompatibilityWarning;
import org.jetbrains.kotlin.resolve.calls.model.CompatibilityWarningOnArgument;
import org.jetbrains.kotlin.resolve.calls.model.EagerCallableReferenceAtom;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.LHSResult;
import org.jetbrains.kotlin.resolve.calls.model.NoneCallableReferenceCallCandidates;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallableReferenceArgumentAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedExpressionAtom;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SubKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.tower.TowerUtilsKt;
import org.jetbrains.kotlin.resolve.calls.tower.VisibilityError;
import org.jetbrains.kotlin.resolve.calls.tower.VisibilityErrorOnArgument;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0019\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceArgumentResolver;", "", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceOverloadConflictResolver;", "callableReferenceOverloadConflictResolver", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceOverloadConflictResolver;)V", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallableReferenceArgumentAtom;", "resolvedAtom", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "resolutionCallbacks", "", "processCallableReferenceArgument", "(Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallableReferenceArgumentAtom;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;)V", "Lorg/jetbrains/kotlin/resolve/calls/model/LHSResult;", "lhsResult", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "buildResolvedKtArgument", "(Lorg/jetbrains/kotlin/resolve/calls/model/LHSResult;)Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceOverloadConflictResolver;", "getCallableReferenceOverloadConflictResolver", "()Lorg/jetbrains/kotlin/resolve/calls/components/CallableReferenceOverloadConflictResolver;"})
public final class CallableReferenceArgumentResolver {
    @NotNull
    private final CallableReferenceOverloadConflictResolver callableReferenceOverloadConflictResolver;

    public CallableReferenceArgumentResolver(@NotNull CallableReferenceOverloadConflictResolver callableReferenceOverloadConflictResolver) {
        Intrinsics.checkNotNullParameter(callableReferenceOverloadConflictResolver, "callableReferenceOverloadConflictResolver");
        this.callableReferenceOverloadConflictResolver = callableReferenceOverloadConflictResolver;
    }

    @NotNull
    public final CallableReferenceOverloadConflictResolver getCallableReferenceOverloadConflictResolver() {
        return this.callableReferenceOverloadConflictResolver;
    }

    public final void processCallableReferenceArgument(@NotNull ConstraintSystemBuilder csBuilder, @NotNull ResolvedCallableReferenceArgumentAtom resolvedAtom, @NotNull KotlinDiagnosticsHolder diagnosticsHolder, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        UnwrappedType unwrappedType;
        Intrinsics.checkNotNullParameter(csBuilder, "csBuilder");
        Intrinsics.checkNotNullParameter(resolvedAtom, "resolvedAtom");
        Intrinsics.checkNotNullParameter(diagnosticsHolder, "diagnosticsHolder");
        Intrinsics.checkNotNullParameter(resolutionCallbacks, "resolutionCallbacks");
        CallableReferenceKotlinCallArgument argument = resolvedAtom.getAtom();
        UnwrappedType unwrappedType2 = resolvedAtom.getExpectedType();
        if (unwrappedType2 != null) {
            UnwrappedType it = unwrappedType2;
            boolean bl = false;
            TypeSubstitutorMarker typeSubstitutorMarker = csBuilder.buildCurrentSubstitutor();
            Intrinsics.checkNotNull(typeSubstitutorMarker, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor");
            unwrappedType = ((NewTypeSubstitutor)typeSubstitutorMarker).safeSubstitute(it);
        } else {
            unwrappedType = null;
        }
        UnwrappedType expectedType = unwrappedType;
        Collection<CallableReferenceResolutionCandidate> candidates = resolutionCallbacks.resolveCallableReferenceArgument(resolvedAtom.getAtom(), expectedType, csBuilder.currentStorage());
        if (candidates.size() > 1 && resolvedAtom instanceof EagerCallableReferenceAtom) {
            boolean bl;
            block12: {
                Iterable $this$all$iv = candidates;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        CallableReferenceResolutionCandidate it = (CallableReferenceResolutionCandidate)element$iv;
                        boolean bl2 = false;
                        if (TowerUtilsKt.isInapplicable(it.getResultingApplicability())) continue;
                        bl = false;
                        break block12;
                    }
                    bl = true;
                }
            }
            if (bl) {
                diagnosticsHolder.addDiagnostic(new CallableReferenceCallCandidatesAmbiguity(argument, candidates));
            }
            resolvedAtom.setAnalyzedResults(null, CollectionsKt.listOf(((EagerCallableReferenceAtom)resolvedAtom).transformToPostponed()));
            return;
        }
        CallableReferenceResolutionCandidate chosenCandidate = (CallableReferenceResolutionCandidate)CollectionsKt.singleOrNull((Iterable)candidates);
        if (chosenCandidate != null) {
            FreshVariableNewTypeSubstitutor toFreshSubstitutor = CreateFreshVariablesSubstitutor.INSTANCE.createToFreshVariableSubstitutorAndAddInitialConstraints(chosenCandidate.getCandidate(), resolvedAtom.getAtom().getCall(), csBuilder);
            CallableReferenceResolutionKt.addConstraints(chosenCandidate, csBuilder, toFreshSubstitutor, argument);
            Iterable $this$forEach$iv = chosenCandidate.getDiagnostics();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KotlinCallDiagnostic it = (KotlinCallDiagnostic)element$iv;
                boolean bl = false;
                KotlinCallDiagnostic kotlinCallDiagnostic = it;
                KotlinCallDiagnostic transformedDiagnostic = kotlinCallDiagnostic instanceof CompatibilityWarning ? (KotlinCallDiagnostic)new CompatibilityWarningOnArgument(argument, ((CompatibilityWarning)it).getCandidate()) : (kotlinCallDiagnostic instanceof VisibilityError ? (KotlinCallDiagnostic)new VisibilityErrorOnArgument(argument, ((VisibilityError)it).getInvisibleMember()) : it);
                diagnosticsHolder.addDiagnostic(transformedDiagnostic);
            }
            chosenCandidate.setFreshVariablesSubstitutor$resolution(toFreshSubstitutor);
        } else if (candidates.isEmpty()) {
            diagnosticsHolder.addDiagnostic(new NoneCallableReferenceCallCandidates(argument));
        } else {
            diagnosticsHolder.addDiagnostic(new CallableReferenceCallCandidatesAmbiguity(argument, candidates));
        }
        List<ResolvedAtom> subKtArguments = CollectionsKt.listOfNotNull(this.buildResolvedKtArgument(argument.getLhsResult()));
        resolvedAtom.setAnalyzedResults(chosenCandidate, subKtArguments);
    }

    private final ResolvedAtom buildResolvedKtArgument(LHSResult lhsResult) {
        ResolvedAtom resolvedAtom;
        if (!(lhsResult instanceof LHSResult.Expression)) {
            return null;
        }
        SimpleKotlinCallArgument lshCallArgument = ((LHSResult.Expression)lhsResult).getLshCallArgument();
        if (lshCallArgument instanceof SubKotlinCallArgument) {
            resolvedAtom = ((SubKotlinCallArgument)lshCallArgument).getCallResult();
        } else if (lshCallArgument instanceof ExpressionKotlinCallArgument) {
            resolvedAtom = new ResolvedExpressionAtom((ExpressionKotlinCallArgument)lshCallArgument);
        } else {
            ArgumentsUtilsKt.unexpectedArgument(lshCallArgument);
            throw new KotlinNothingValueException();
        }
        return resolvedAtom;
    }
}

