/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.incremental.UtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.ParameterTypeConversion;
import org.jetbrains.kotlin.resolve.calls.components.candidate.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.LambdaKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.LambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtomsKt;
import org.jetbrains.kotlin.resolve.calls.model.SamConversionDescription;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SubKotlinCallArgument;
import org.jetbrains.kotlin.resolve.sam.SamConversionOracle;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverKt;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0014\u001a\u00020\n2\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J1\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u001f\u0010\u001e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/SamTypeConversions;", "Lorg/jetbrains/kotlin/resolve/calls/components/ParameterTypeConversion;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;", "candidate", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "argument", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "expectedParameterType", "", "conversionDefinitelyNotNeeded", "(Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;Lorg/jetbrains/kotlin/types/UnwrappedType;)Z", "areSuspendOnlySamConversionsSupported", "conversionIsNeededBeforeSubtypingCheck", "(Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;Z)Z", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "subResolvedAtoms", "type", "hasNonAnalyzedLambdaAsReturnType", "(Ljava/util/List;Lorg/jetbrains/kotlin/types/UnwrappedType;)Z", "conversionIsNeededAfterSubtypingCheck", "(Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;)Z", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "parameter", "convertParameterType", "(Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;Lorg/jetbrains/kotlin/types/UnwrappedType;)Lorg/jetbrains/kotlin/types/UnwrappedType;", "typeToConvert", "needCompatibilityResolveForSAM", "(Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;Lorg/jetbrains/kotlin/types/UnwrappedType;)Z", "isJavaParameterCanBeConverted"})
public final class SamTypeConversions
implements ParameterTypeConversion {
    @NotNull
    public static final SamTypeConversions INSTANCE = new SamTypeConversions();

    private SamTypeConversions() {
    }

    @Override
    public boolean conversionDefinitelyNotNeeded(@NotNull ResolutionCandidate candidate, @NotNull KotlinCallArgument argument, @NotNull UnwrappedType expectedParameterType) {
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        Intrinsics.checkNotNullParameter(argument, "argument");
        Intrinsics.checkNotNullParameter(expectedParameterType, "expectedParameterType");
        KotlinCallComponents callComponents = candidate.getCallComponents();
        if (!callComponents.getLanguageVersionSettings().supportsFeature(LanguageFeature.SamConversionPerArgument)) {
            return true;
        }
        if (TypeUtilsKt.isNothing(expectedParameterType)) {
            return true;
        }
        if (FunctionTypesKt.isFunctionType(expectedParameterType)) {
            return true;
        }
        SamConversionOracle samConversionOracle = callComponents.getSamConversionOracle();
        if (!callComponents.getLanguageVersionSettings().supportsFeature(LanguageFeature.SamConversionForKotlinFunctions) && !samConversionOracle.shouldRunSamConversionForFunction(candidate.getResolvedCall().getCandidateDescriptor())) {
            return true;
        }
        ClassifierDescriptor declarationDescriptor = expectedParameterType.getConstructor().getDeclarationDescriptor();
        return declarationDescriptor instanceof ClassDescriptor && ((ClassDescriptor)declarationDescriptor).isDefinitelyNotSamInterface();
    }

    @Override
    public boolean conversionIsNeededBeforeSubtypingCheck(@NotNull KotlinCallArgument argument, boolean areSuspendOnlySamConversionsSupported) {
        boolean bl;
        Intrinsics.checkNotNullParameter(argument, "argument");
        KotlinCallArgument kotlinCallArgument = argument;
        if (kotlinCallArgument instanceof SubKotlinCallArgument) {
            UnwrappedType stableType = ArgumentsUtilsKt.getStableType(((SubKotlinCallArgument)argument).getReceiver());
            if (FunctionTypesKt.isFunctionType(stableType) || areSuspendOnlySamConversionsSupported && FunctionTypesKt.isFunctionOrKFunctionTypeWithAnySuspendability(stableType)) {
                return true;
            }
            bl = this.hasNonAnalyzedLambdaAsReturnType(((SubKotlinCallArgument)argument).getCallResult().getSubResolvedAtoms(), stableType);
        } else if (kotlinCallArgument instanceof SimpleKotlinCallArgument) {
            UnwrappedType $this$conversionIsNeededBeforeSubtypingCheck_u24lambda_u240 = ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument).getReceiver());
            boolean bl2 = false;
            bl = FunctionTypesKt.isFunctionType($this$conversionIsNeededBeforeSubtypingCheck_u24lambda_u240) || areSuspendOnlySamConversionsSupported && FunctionTypesKt.isFunctionOrKFunctionTypeWithAnySuspendability($this$conversionIsNeededBeforeSubtypingCheck_u24lambda_u240);
        } else {
            bl = kotlinCallArgument instanceof LambdaKotlinCallArgument || kotlinCallArgument instanceof CallableReferenceKotlinCallArgument;
        }
        return bl;
    }

    private final boolean hasNonAnalyzedLambdaAsReturnType(List<? extends ResolvedAtom> subResolvedAtoms, UnwrappedType type2) {
        block2: {
            List<? extends ResolvedAtom> list = subResolvedAtoms;
            if (list == null) break block2;
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ResolvedAtom it = (ResolvedAtom)element$iv;
                boolean bl = false;
                if (it instanceof LambdaWithTypeVariableAsExpectedTypeAtom && Intrinsics.areEqual(((LambdaWithTypeVariableAsExpectedTypeAtom)it).getExpectedType().getConstructor(), type2.getConstructor())) {
                    return true;
                }
                boolean hasNonAnalyzedLambda = INSTANCE.hasNonAnalyzedLambdaAsReturnType(it.getSubResolvedAtoms(), type2);
                if (!hasNonAnalyzedLambda) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean conversionIsNeededAfterSubtypingCheck(@NotNull KotlinCallArgument argument) {
        Intrinsics.checkNotNullParameter(argument, "argument");
        return argument instanceof SimpleKotlinCallArgument && FunctionTypesKt.isFunctionTypeOrSubtype(ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument).getReceiver()));
    }

    @Override
    @Nullable
    public UnwrappedType convertParameterType(@NotNull ResolutionCandidate candidate, @NotNull KotlinCallArgument argument, @NotNull ParameterDescriptor parameter, @NotNull UnwrappedType expectedParameterType) {
        ClassifierDescriptor samDescriptor;
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        Intrinsics.checkNotNullParameter(argument, "argument");
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(expectedParameterType, "expectedParameterType");
        KotlinCallComponents callComponents = candidate.getCallComponents();
        ParameterDescriptor parameterDescriptor = parameter.getOriginal();
        Intrinsics.checkNotNullExpressionValue(parameterDescriptor, "getOriginal(...)");
        UnwrappedType originalExpectedType = ArgumentsUtilsKt.getExpectedType(argument, parameterDescriptor, callComponents.getLanguageVersionSettings());
        UnwrappedType unwrappedType = SamConversionResolverImplKt.getFunctionTypeForPossibleSamType(callComponents.getSamConversionResolver(), expectedParameterType, callComponents.getSamConversionOracle());
        if (unwrappedType == null) {
            return null;
        }
        UnwrappedType convertedTypeByCandidate = unwrappedType;
        UnwrappedType convertedTypeByOriginal = Intrinsics.areEqual(expectedParameterType.getConstructor(), originalExpectedType.getConstructor()) ? SamConversionResolverImplKt.getFunctionTypeForPossibleSamType(callComponents.getSamConversionResolver(), originalExpectedType, callComponents.getSamConversionOracle()) : convertedTypeByCandidate;
        UnwrappedType unwrappedType2 = convertedTypeByOriginal;
        boolean bl = Intrinsics.areEqual(convertedTypeByCandidate.getConstructor(), unwrappedType2 != null ? unwrappedType2.getConstructor() : null);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "If original type is SAM type, then candidate should have same type constructor and corresponding function type\noriginalExpectType: " + originalExpectedType + ", candidateExpectType: " + expectedParameterType + "\nfunctionTypeByOriginal: " + convertedTypeByOriginal + ", functionTypeByCandidate: " + convertedTypeByCandidate;
            throw new AssertionError((Object)string2);
        }
        MutableResolvedCallAtom mutableResolvedCallAtom = candidate.getResolvedCall();
        UnwrappedType unwrappedType3 = convertedTypeByOriginal;
        Intrinsics.checkNotNull(unwrappedType3);
        mutableResolvedCallAtom.registerArgumentWithSamConversion(argument, new SamConversionDescription(unwrappedType3, convertedTypeByCandidate, expectedParameterType));
        if (this.needCompatibilityResolveForSAM(candidate, expectedParameterType)) {
            ResolvedCallAtomsKt.markCandidateForCompatibilityResolve$default(candidate, false, 1, null);
        }
        if ((samDescriptor = originalExpectedType.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
            UtilsKt.record(callComponents.getLookupTracker(), candidate.getScopeTower().getLocation(), (ClassDescriptor)samDescriptor, SamConversionResolverKt.getSAM_LOOKUP_NAME());
        }
        return convertedTypeByCandidate;
    }

    private final boolean needCompatibilityResolveForSAM(ResolutionCandidate candidate, UnwrappedType typeToConvert) {
        ClassifierDescriptor descriptor2 = typeToConvert.getConstructor().getDeclarationDescriptor();
        if (descriptor2 instanceof ClassDescriptor && ((ClassDescriptor)descriptor2).isFun()) {
            return false;
        }
        return !candidate.getCallComponents().getSamConversionOracle().isJavaApplicableCandidate(candidate.getResolvedCall().getCandidateDescriptor());
    }

    public final boolean isJavaParameterCanBeConverted(@NotNull ResolutionCandidate candidate, @NotNull UnwrappedType expectedParameterType) {
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        Intrinsics.checkNotNullParameter(expectedParameterType, "expectedParameterType");
        KotlinCallComponents callComponents = candidate.getCallComponents();
        SamConversionOracle samConversionOracle = callComponents.getSamConversionOracle();
        if (!samConversionOracle.isJavaApplicableCandidate(candidate.getResolvedCall().getCandidateDescriptor())) {
            return false;
        }
        ClassifierDescriptor declarationDescriptor = expectedParameterType.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof ClassDescriptor && ((ClassDescriptor)declarationDescriptor).isDefinitelyNotSamInterface()) {
            return false;
        }
        UnwrappedType convertedType = SamConversionResolverImplKt.getFunctionTypeForPossibleSamType(callComponents.getSamConversionResolver(), expectedParameterType, callComponents.getSamConversionOracle());
        return convertedType != null;
    }
}

