/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.calls.components.ParameterTypeConversion;
import org.jetbrains.kotlin.resolve.calls.components.candidate.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemOperation;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtomsKt;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001b\u0010\u0010\u001a\u00020\n*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001b\u0010\u0012\u001a\u00020\n*\u00020\r2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011J\u0013\u0010\u0013\u001a\u00020\n*\u00020\rH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J/\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b\u001c\u0010\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/UnitTypeConversions;", "Lorg/jetbrains/kotlin/resolve/calls/components/ParameterTypeConversion;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;", "candidate", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "argument", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "expectedParameterType", "", "conversionDefinitelyNotNeeded", "(Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;Lorg/jetbrains/kotlin/types/UnwrappedType;)Z", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemOperation;", "c", "hasUnitOrSubtypeReturnType", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemOperation;)Z", "isUnitOrSubtypeOrVariable", "isUnitOrSubtype", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "areSuspendOnlySamConversionsSupported", "conversionIsNeededBeforeSubtypingCheck", "(Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;Z)Z", "conversionIsNeededAfterSubtypingCheck", "(Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;)Z", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "parameter", "convertParameterType", "(Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;Lorg/jetbrains/kotlin/types/UnwrappedType;)Lorg/jetbrains/kotlin/types/UnwrappedType;"})
public final class UnitTypeConversions
implements ParameterTypeConversion {
    @NotNull
    public static final UnitTypeConversions INSTANCE = new UnitTypeConversions();

    private UnitTypeConversions() {
    }

    @Override
    public boolean conversionDefinitelyNotNeeded(@NotNull ResolutionCandidate candidate, @NotNull KotlinCallArgument argument, @NotNull UnwrappedType expectedParameterType) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter(candidate, "candidate");
            Intrinsics.checkNotNullParameter(argument, "argument");
            Intrinsics.checkNotNullParameter(expectedParameterType, "expectedParameterType");
            if (!(argument instanceof SimpleKotlinCallArgument)) {
                return true;
            }
            ReceiverValueWithSmartCastInfo receiver = ((SimpleKotlinCallArgument)argument).getReceiver();
            ConstraintSystemBuilder csBuilder = candidate.getSystem().getBuilder();
            KotlinType kotlinType = receiver.getReceiverValue().getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            if (this.hasUnitOrSubtypeReturnType(kotlinType, csBuilder)) {
                return true;
            }
            Iterable $this$any$iv = receiver.getTypesFromSmartCasts();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.hasUnitOrSubtypeReturnType(it, csBuilder)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return true;
        }
        return !FunctionTypesKt.isBuiltinFunctionalType(expectedParameterType) || !TypeUtilsKt.isUnit(FunctionTypesKt.getReturnTypeFromFunctionType(expectedParameterType));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasUnitOrSubtypeReturnType(KotlinType $this$hasUnitOrSubtypeReturnType, ConstraintSystemOperation c) {
        if (!FunctionTypesKt.isFunctionOrKFunctionTypeWithAnySuspendability($this$hasUnitOrSubtypeReturnType)) return false;
        KotlinType kotlinType = CollectionsKt.last($this$hasUnitOrSubtypeReturnType.getArguments()).getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        if (!this.isUnitOrSubtypeOrVariable(kotlinType, c)) return false;
        return true;
    }

    private final boolean isUnitOrSubtypeOrVariable(KotlinType $this$isUnitOrSubtypeOrVariable, ConstraintSystemOperation c) {
        return this.isUnitOrSubtype($this$isUnitOrSubtypeOrVariable) || c.isTypeVariable($this$isUnitOrSubtypeOrVariable);
    }

    private final boolean isUnitOrSubtype(KotlinType $this$isUnitOrSubtype) {
        return TypeUtilsKt.isUnit($this$isUnitOrSubtype) || DynamicTypesKt.isDynamic($this$isUnitOrSubtype) || TypeUtilsKt.isNothing($this$isUnitOrSubtype);
    }

    @Override
    public boolean conversionIsNeededBeforeSubtypingCheck(@NotNull KotlinCallArgument argument, boolean areSuspendOnlySamConversionsSupported) {
        Intrinsics.checkNotNullParameter(argument, "argument");
        return argument instanceof SimpleKotlinCallArgument && FunctionTypesKt.isFunctionType(ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument).getReceiver()));
    }

    @Override
    public boolean conversionIsNeededAfterSubtypingCheck(@NotNull KotlinCallArgument argument) {
        Intrinsics.checkNotNullParameter(argument, "argument");
        if (!(argument instanceof SimpleKotlinCallArgument)) {
            return false;
        }
        Ref.BooleanRef isFunctionTypeOrSubtype = new Ref.BooleanRef();
        boolean hasReturnTypeInSubtypes = FunctionTypesKt.isFunctionTypeOrSubtype(ArgumentsUtilsKt.getStableType(((SimpleKotlinCallArgument)argument).getReceiver()), arg_0 -> UnitTypeConversions.conversionIsNeededAfterSubtypingCheck$lambda$1(isFunctionTypeOrSubtype, arg_0));
        if (!isFunctionTypeOrSubtype.element) {
            return false;
        }
        return !hasReturnTypeInSubtypes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public UnwrappedType convertParameterType(@NotNull ResolutionCandidate candidate, @NotNull KotlinCallArgument argument, @NotNull ParameterDescriptor parameter, @NotNull UnwrappedType expectedParameterType) {
        Collection<KotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        Intrinsics.checkNotNullParameter(argument, "argument");
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(expectedParameterType, "expectedParameterType");
        Iterable iterable = FunctionTypesKt.getValueParameterTypesFromFunctionType(expectedParameterType);
        List<KotlinType> list = FunctionTypesKt.getContextReceiverTypesFromFunctionType(expectedParameterType);
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(expectedParameterType);
        Annotations annotations2 = expectedParameterType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = candidate.getCallComponents().getBuiltIns();
        boolean $i$f$map = false;
        void var8_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            KotlinType kotlinType2 = it.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
            collection.add(kotlinType2);
        }
        collection = (List)destination$iv$iv;
        SimpleType simpleType2 = candidate.getCallComponents().getBuiltIns().getNullableAnyType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getNullableAnyType(...)");
        SimpleType nonUnitReturnedParameterType = FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, list, collection, null, simpleType2, FunctionTypesKt.isSuspendFunctionType(expectedParameterType));
        candidate.getResolvedCall().registerArgumentWithUnitConversion(argument, nonUnitReturnedParameterType);
        ResolvedCallAtomsKt.markCandidateForCompatibilityResolve$default(candidate, false, 1, null);
        return nonUnitReturnedParameterType;
    }

    private static final boolean conversionIsNeededAfterSubtypingCheck$lambda$1(Ref.BooleanRef $isFunctionTypeOrSubtype, KotlinType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $isFunctionTypeOrSubtype.element = true;
        return INSTANCE.isUnitOrSubtype(FunctionTypesKt.getReturnTypeFromFunctionType(it));
    }
}

