/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.context;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCache;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionResultsCacheImpl;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0003\u0010\u0004JA\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00052\u0010\u0010\t\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u0005H\u0097\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0002\u001a\u00020\u00018\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0002\u0010\u0018R\u0014\u0010\u001a\u001a\u00020\u00198\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/context/TemporaryResolutionResultsCache;", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionResultsCache;", "parentCache", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionResultsCache;)V", "Lorg/jetbrains/kotlin/psi/Call;", "call", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "results", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "deferredComputation", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "tracing", "Lorg/jetbrains/kotlin/resolve/DelegatingBindingTrace;", "resolutionTrace", "", "record", "(Lorg/jetbrains/kotlin/psi/Call;Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;Lorg/jetbrains/kotlin/resolve/DelegatingBindingTrace;)V", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionResultsCache$CachedData;", "get", "(Lorg/jetbrains/kotlin/psi/Call;)Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionResultsCache$CachedData;", "commit", "()V", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionResultsCache;", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionResultsCacheImpl;", "innerCache", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionResultsCacheImpl;"})
public final class TemporaryResolutionResultsCache
implements ResolutionResultsCache {
    @NotNull
    private final ResolutionResultsCache parentCache;
    @NotNull
    private final ResolutionResultsCacheImpl innerCache;

    public TemporaryResolutionResultsCache(@NotNull ResolutionResultsCache parentCache) {
        Intrinsics.checkNotNullParameter(parentCache, "parentCache");
        this.parentCache = parentCache;
        this.innerCache = new ResolutionResultsCacheImpl();
    }

    public void record(@NotNull Call call2, @NotNull OverloadResolutionResultsImpl<? extends CallableDescriptor> results, @NotNull BasicCallResolutionContext deferredComputation, @NotNull TracingStrategy tracing, @NotNull DelegatingBindingTrace resolutionTrace) {
        Intrinsics.checkNotNullParameter(call2, "call");
        Intrinsics.checkNotNullParameter(results, "results");
        Intrinsics.checkNotNullParameter(deferredComputation, "deferredComputation");
        Intrinsics.checkNotNullParameter(tracing, "tracing");
        Intrinsics.checkNotNullParameter(resolutionTrace, "resolutionTrace");
        this.innerCache.record(call2, results, deferredComputation, tracing, resolutionTrace);
    }

    @Override
    @Nullable
    public ResolutionResultsCache.CachedData get(@NotNull Call call2) {
        Intrinsics.checkNotNullParameter(call2, "call");
        ResolutionResultsCache.CachedData cachedData = this.innerCache.get(call2);
        if (cachedData == null) {
            cachedData = this.parentCache.get(call2);
        }
        return cachedData;
    }

    public final void commit() {
        ResolutionResultsCache resolutionResultsCache = this.parentCache;
        if (resolutionResultsCache instanceof ResolutionResultsCacheImpl) {
            ((ResolutionResultsCacheImpl)this.parentCache).addData(this.innerCache);
        } else if (resolutionResultsCache instanceof TemporaryResolutionResultsCache) {
            ((TemporaryResolutionResultsCache)this.parentCache).innerCache.addData(this.innerCache);
        }
    }
}

