/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallCompleter;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallCandidateResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ContextDependency;
import org.jetbrains.kotlin.resolve.calls.context.TemporaryTraceAndCache;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceData;
import org.jetbrains.kotlin.resolve.calls.inference.BuilderInferenceUtilKt;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.TypeTemplate;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.MutableDataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResultsImpl;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolveArgumentsMode;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DelegatedTypeSubstitution;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.ClassicTypeCheckerState;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeChecker;
import org.jetbrains.kotlin.types.checker.NewKotlinTypeCheckerImpl;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001<B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J9\u0010\u0013\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J)\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001a2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ5\u0010#\u001a\u00020\u00122\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030 2\u0018\u0010\"\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00120!H\u0002\u00a2\u0006\u0004\b#\u0010$J#\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020%2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030 H\u0002\u00a2\u0006\u0004\b(\u0010)R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010*\u001a\u0004\b+\u0010,R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010-\u001a\u0004\b.\u0010/R*\u00102\u001a\u0002002\u0006\u00101\u001a\u0002008\u0007@FX\u0087.\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\u0014\u0010;\u001a\u0002088BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u0010:"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceSupport;", "", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "argumentTypeResolver", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "expressionTypingServices", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;)V", "Lorg/jetbrains/kotlin/psi/KtFunction;", "functionLiteral", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "valueArgument", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;", "context", "Lorg/jetbrains/kotlin/types/KotlinType;", "lambdaExpectedType", "", "analyzeBuilderInferenceCall", "(Lorg/jetbrains/kotlin/psi/KtFunction;Lorg/jetbrains/kotlin/psi/ValueArgument;Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystem$Builder;Lorg/jetbrains/kotlin/resolve/calls/context/CallCandidateResolutionContext;Lorg/jetbrains/kotlin/types/KotlinType;)V", "expectedType", "", "checkExpectedTypeForArgument", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "tracingStrategy", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;", "overloadResults", "checkBuilderInferenceCalls", "(Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResultsImpl;)V", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "Lkotlin/Function2;", "callback", "forceInferenceForArguments", "(Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;Lkotlin/jvm/functions/Function2;)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "getArgumentTypeInfo", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;)Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "getArgumentTypeResolver", "()Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "getExpressionTypingServices", "()Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "value", "callCompleter", "Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "getCallCompleter", "()Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;", "setCallCompleter", "(Lorg/jetbrains/kotlin/resolve/calls/CallCompleter;)V", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "BuilderInferenceTypeCheckerState"})
public final class BuilderInferenceSupport {
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    public CallCompleter callCompleter;

    public BuilderInferenceSupport(@NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull ExpressionTypingServices expressionTypingServices) {
        Intrinsics.checkNotNullParameter(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkNotNullParameter(expressionTypingServices, "expressionTypingServices");
        this.argumentTypeResolver = argumentTypeResolver;
        this.expressionTypingServices = expressionTypingServices;
    }

    @NotNull
    public final ArgumentTypeResolver getArgumentTypeResolver() {
        return this.argumentTypeResolver;
    }

    @NotNull
    public final ExpressionTypingServices getExpressionTypingServices() {
        return this.expressionTypingServices;
    }

    @NotNull
    public final CallCompleter getCallCompleter() {
        CallCompleter callCompleter = this.callCompleter;
        if (callCompleter != null) {
            return callCompleter;
        }
        Intrinsics.throwUninitializedPropertyAccessException("callCompleter");
        return null;
    }

    public final void setCallCompleter(@NotNull CallCompleter callCompleter) {
        Intrinsics.checkNotNullParameter(callCompleter, "<set-?>");
        this.callCompleter = callCompleter;
    }

    private final LanguageVersionSettings getLanguageVersionSettings() {
        LanguageVersionSettings languageVersionSettings = this.expressionTypingServices.getLanguageVersionSettings();
        Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "getLanguageVersionSettings(...)");
        return languageVersionSettings;
    }

    /*
     * WARNING - void declaration
     */
    public final void analyzeBuilderInferenceCall(@NotNull KtFunction functionLiteral, @NotNull ValueArgument valueArgument, @NotNull ConstraintSystem.Builder csBuilder, @NotNull CallCandidateResolutionContext<?> context, @NotNull KotlinType lambdaExpectedType) {
        Collection<KotlinType> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(functionLiteral, "functionLiteral");
        Intrinsics.checkNotNullParameter(valueArgument, "valueArgument");
        Intrinsics.checkNotNullParameter(csBuilder, "csBuilder");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(lambdaExpectedType, "lambdaExpectedType");
        KtExpression ktExpression = valueArgument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        if (!this.checkExpectedTypeForArgument(lambdaExpectedType)) {
            return;
        }
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(lambdaExpectedType);
        if (kotlinType == null) {
            return;
        }
        KotlinType lambdaReceiverType = kotlinType;
        BuilderInferenceData inferenceData = new BuilderInferenceData();
        ConstraintSystem constraintSystem = csBuilder.build();
        TypeSubstitution typeSubstitution = constraintSystem.getCurrentSubstitutor().getSubstitution();
        DelegatedTypeSubstitution newSubstitution2 = new DelegatedTypeSubstitution(constraintSystem, inferenceData, typeSubstitution){
            final /* synthetic */ ConstraintSystem $constraintSystem;
            final /* synthetic */ BuilderInferenceData $inferenceData;
            {
                this.$constraintSystem = $constraintSystem;
                this.$inferenceData = $inferenceData;
                Intrinsics.checkNotNull($super_call_param$1);
                super($super_call_param$1);
            }

            public TypeProjection get(KotlinType key) {
                Object v1;
                TypeProjection substitutedType;
                block3: {
                    Intrinsics.checkNotNullParameter(key, "key");
                    TypeProjection typeProjection = substitutedType = super.get(key);
                    if (!Intrinsics.areEqual(typeProjection != null ? typeProjection.getType() : null, TypeUtils.DONT_CARE)) {
                        return substitutedType;
                    }
                    Iterable $this$firstOrNull$iv = this.$constraintSystem.getTypeVariables();
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        TypeVariable it = (TypeVariable)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getOriginalTypeParameter().getDefaultType(), key)) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                TypeVariable typeVariable = v1;
                if (typeVariable == null) {
                    return substitutedType;
                }
                TypeVariable typeVariable2 = typeVariable;
                return TypeUtilsKt.asTypeProjection(this.$inferenceData.getTypeTemplate(typeVariable2));
            }

            public boolean approximateContravariantCapturedTypes() {
                return true;
            }
        };
        KotlinType kotlinType2 = newSubstitution2.buildSubstitutor().substitute(lambdaReceiverType, Variance.INVARIANT);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType newReceiverType = kotlinType2;
        TypeSubstitution typeSubstitution2 = constraintSystem.getCurrentSubstitutor().getSubstitution();
        DelegatedTypeSubstitution approximationSubstitutor2 = new DelegatedTypeSubstitution(typeSubstitution2){
            {
                Intrinsics.checkNotNull($super_call_param$1);
                super($super_call_param$1);
            }

            public boolean approximateContravariantCapturedTypes() {
                return true;
            }
        };
        KotlinType kotlinType3 = approximationSubstitutor2.buildSubstitutor().substitute(lambdaExpectedType, Variance.IN_VARIANCE);
        if (kotlinType3 == null) {
            return;
        }
        KotlinType approximatedLambdaType = kotlinType3;
        Iterable iterable = FunctionTypesKt.getValueParameterTypesFromFunctionType(approximatedLambdaType);
        List list = CollectionsKt.emptyList();
        KotlinType kotlinType4 = newReceiverType;
        Annotations annotations2 = approximatedLambdaType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = TypeUtilsKt.getBuiltIns(newReceiverType);
        boolean $i$f$map = false;
        void var17_21 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getType());
        }
        collection = (List)destination$iv$iv;
        SimpleType newExpectedType = FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType4, list, (List<? extends KotlinType>)collection, null, FunctionTypesKt.getReturnTypeFromFunctionType(approximatedLambdaType), true);
        if (CallResolverUtilKt.hasUnknownFunctionParameter(newExpectedType)) {
            return;
        }
        inferenceData.initSystem();
        TemporaryTraceAndCache temporaryForBuilderInference = TemporaryTraceAndCache.create(context, "trace to infer a type argument using the builder inference", functionLiteral);
        Object Context2 = ((CallCandidateResolutionContext)((CallCandidateResolutionContext)((CallCandidateResolutionContext)context.replaceExpectedType(newExpectedType)).replaceDataFlowInfo(context.candidateCall.getDataFlowInfoForArguments().getInfo(valueArgument))).replaceContextDependency(ContextDependency.INDEPENDENT)).replaceTraceAndCache(temporaryForBuilderInference);
        Intrinsics.checkNotNullExpressionValue(Context2, "replaceTraceAndCache(...)");
        CallCandidateResolutionContext newContext = (CallCandidateResolutionContext)Context2;
        this.argumentTypeResolver.getFunctionLiteralTypeInfo(argumentExpression, functionLiteral, newContext, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, true);
        inferenceData.reportInferenceResult(csBuilder);
    }

    private final boolean checkExpectedTypeForArgument(KotlinType expectedType) {
        return this.getLanguageVersionSettings().supportsFeature(LanguageFeature.ExperimentalBuilderInference) ? FunctionTypesKt.isFunctionOrSuspendFunctionType(expectedType) : FunctionTypesKt.isSuspendFunctionType(expectedType);
    }

    public final void checkBuilderInferenceCalls(@NotNull BasicCallResolutionContext context, @NotNull TracingStrategy tracingStrategy, @NotNull OverloadResolutionResultsImpl<?> overloadResults) {
        block4: {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(tracingStrategy, "tracingStrategy");
            Intrinsics.checkNotNullParameter(overloadResults, "overloadResults");
            BuilderInferenceData builderInferenceData = BuilderInferenceUtilKt.access$getBuilderInferenceData(overloadResults);
            if (builderInferenceData == null) {
                return;
            }
            BuilderInferenceData inferenceData = builderInferenceData;
            ResolvedCall resolvedCall2 = overloadResults.getResultingCall();
            Intrinsics.checkNotNullExpressionValue(resolvedCall2, "getResultingCall(...)");
            ResolvedCall resultingCall = resolvedCall2;
            this.forceInferenceForArguments(context, BuilderInferenceSupport::checkBuilderInferenceCalls$lambda$0);
            this.getCallCompleter().completeCall(context, overloadResults, tracingStrategy);
            if (!ArgumentMappingKt.isReallySuccess(resultingCall)) {
                return;
            }
            Object d = resultingCall.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(d, "getResultingDescriptor(...)");
            Object resultingDescriptor = d;
            if (!BuilderInferenceUtilKt.isApplicableCallForBuilderInference(resultingDescriptor, this.getLanguageVersionSettings())) {
                inferenceData.badCallHappened();
            }
            this.forceInferenceForArguments(context, (arg_0, arg_1) -> BuilderInferenceSupport.checkBuilderInferenceCalls$lambda$2((MutableResolvedCall)resultingCall, context, arg_0, arg_1));
            ReceiverParameterDescriptor receiverParameterDescriptor = resultingDescriptor.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                return;
            }
            ReceiverParameterDescriptor extensionReceiver = receiverParameterDescriptor;
            boolean allowOnlyTrivialConstraintsForReceiver = this.getLanguageVersionSettings().supportsFeature(LanguageFeature.ExperimentalBuilderInference) ? !AnnotationsForResolveUtilsKt.hasBuilderInferenceAnnotation(resultingDescriptor) : false;
            ReceiverValue receiverValue = resultingCall.getExtensionReceiver();
            if (receiverValue == null) break block4;
            ReceiverValue actualReceiver = receiverValue;
            boolean bl = false;
            NewKotlinTypeCheckerImpl $this$checkBuilderInferenceCalls_u24lambda_u244_u24lambda_u243 = NewKotlinTypeChecker.Companion.getDefault();
            boolean bl2 = false;
            $this$checkBuilderInferenceCalls_u24lambda_u244_u24lambda_u243.isSubtypeOf(new BuilderInferenceTypeCheckerState(allowOnlyTrivialConstraintsForReceiver), actualReceiver.getType().unwrap(), extensionReceiver.getValue().getType().unwrap());
        }
    }

    private final void forceInferenceForArguments(CallResolutionContext<?> context, Function2<? super ValueArgument, ? super KotlinType, Unit> callback) {
        MutableDataFlowInfoForArguments mutableDataFlowInfoForArguments = context.dataFlowInfoForArguments;
        Intrinsics.checkNotNullExpressionValue(mutableDataFlowInfoForArguments, "dataFlowInfoForArguments");
        MutableDataFlowInfoForArguments infoForArguments = mutableDataFlowInfoForArguments;
        Call call2 = context.call;
        Intrinsics.checkNotNullExpressionValue(call2, "call");
        Call call3 = call2;
        Object Context2 = ((CallResolutionContext)context.replaceContextDependency(ContextDependency.INDEPENDENT)).replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        Intrinsics.checkNotNullExpressionValue(Context2, "replaceExpectedType(...)");
        CallResolutionContext baseContext = (CallResolutionContext)Context2;
        for (ValueArgument valueArgument : call3.getValueArguments()) {
            KotlinType it;
            KtExpression expression;
            if (valueArgument.getArgumentExpression() == null) continue;
            Object Context3 = baseContext.replaceDataFlowInfo(infoForArguments.getInfo(valueArgument));
            Intrinsics.checkNotNullExpressionValue(Context3, "replaceDataFlowInfo(...)");
            KotlinTypeInfo typeInfoForCall = this.getArgumentTypeInfo(expression, (CallResolutionContext)Context3);
            if (typeInfoForCall.getType() == null) continue;
            boolean bl = false;
            Intrinsics.checkNotNull(valueArgument);
            callback.invoke(valueArgument, it);
        }
    }

    private final KotlinTypeInfo getArgumentTypeInfo(KtExpression expression, CallResolutionContext<?> context) {
        KtFunction ktFunction = ArgumentTypeResolver.getFunctionLiteralArgumentIfAny(expression, context);
        if (ktFunction != null) {
            KtFunction it = ktFunction;
            boolean bl = false;
            KotlinTypeInfo kotlinTypeInfo = this.argumentTypeResolver.getFunctionLiteralTypeInfo(expression, it, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS, false);
            Intrinsics.checkNotNullExpressionValue(kotlinTypeInfo, "getFunctionLiteralTypeInfo(...)");
            return kotlinTypeInfo;
        }
        KtCallableReferenceExpression ktCallableReferenceExpression = ArgumentTypeResolver.getCallableReferenceExpressionIfAny(expression, context);
        if (ktCallableReferenceExpression != null) {
            KtCallableReferenceExpression it = ktCallableReferenceExpression;
            boolean bl = false;
            KotlinTypeInfo kotlinTypeInfo = this.argumentTypeResolver.getCallableReferenceTypeInfo(expression, it, context, ResolveArgumentsMode.RESOLVE_FUNCTION_ARGUMENTS);
            Intrinsics.checkNotNullExpressionValue(kotlinTypeInfo, "getCallableReferenceTypeInfo(...)");
            return kotlinTypeInfo;
        }
        KotlinTypeInfo kotlinTypeInfo = this.expressionTypingServices.getTypeInfo(expression, context);
        Intrinsics.checkNotNullExpressionValue(kotlinTypeInfo, "getTypeInfo(...)");
        return kotlinTypeInfo;
    }

    private static final Unit checkBuilderInferenceCalls$lambda$0(ValueArgument valueArgument, KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter(valueArgument, "<unused var>");
        Intrinsics.checkNotNullParameter(kotlinType, "<unused var>");
        return Unit.INSTANCE;
    }

    private static final Unit checkBuilderInferenceCalls$lambda$2(MutableResolvedCall $resultingCall, BasicCallResolutionContext $context, ValueArgument valueArgument, KotlinType kotlinType) {
        Intrinsics.checkNotNullParameter(valueArgument, "valueArgument");
        Intrinsics.checkNotNullParameter(kotlinType, "kotlinType");
        ArgumentMapping argumentMapping2 = $resultingCall.getArgumentMapping(valueArgument);
        ArgumentMatch argumentMatch = argumentMapping2 instanceof ArgumentMatch ? (ArgumentMatch)argumentMapping2 : null;
        if (argumentMatch == null) {
            return Unit.INSTANCE;
        }
        ArgumentMatch argumentMatch2 = argumentMatch;
        NewKotlinTypeCheckerImpl $this$checkBuilderInferenceCalls_u24lambda_u242_u24lambda_u241 = NewKotlinTypeChecker.Companion.getDefault();
        boolean bl = false;
        KotlinType parameterType = CallResolverUtilKt.getEffectiveExpectedType(argumentMatch2.getValueParameter(), valueArgument, $context);
        $this$checkBuilderInferenceCalls_u24lambda_u242_u24lambda_u241.isSubtypeOf(new BuilderInferenceTypeCheckerState(false), kotlinType.unwrap(), parameterType.unwrap());
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/BuilderInferenceSupport$BuilderInferenceTypeCheckerState;", "Lorg/jetbrains/kotlin/types/checker/ClassicTypeCheckerState;", "", "allowOnlyTrivialConstraints", "<init>", "(Z)V", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "subType", "superType", "isFromNullabilityConstraint", "addSubtypeConstraint", "(Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Z)Ljava/lang/Boolean;", "Z"})
    private static final class BuilderInferenceTypeCheckerState
    extends ClassicTypeCheckerState {
        private final boolean allowOnlyTrivialConstraints;

        public BuilderInferenceTypeCheckerState(boolean allowOnlyTrivialConstraints) {
            super(true, false, null, null, null, 30, null);
            this.allowOnlyTrivialConstraints = allowOnlyTrivialConstraints;
        }

        @Override
        @Nullable
        public Boolean addSubtypeConstraint(@NotNull KotlinTypeMarker subType, @NotNull KotlinTypeMarker superType, boolean isFromNullabilityConstraint) {
            block3: {
                TypeTemplate typeTemplate;
                Object object;
                Intrinsics.checkNotNullParameter(subType, "subType");
                Intrinsics.checkNotNullParameter(superType, "superType");
                if (!(subType instanceof UnwrappedType)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                if (!(superType instanceof UnwrappedType)) {
                    String string3 = "Failed requirement.";
                    throw new IllegalArgumentException(string3.toString());
                }
                KotlinTypeMarker kotlinTypeMarker = subType;
                TypeTemplate typeTemplate2 = kotlinTypeMarker instanceof TypeTemplate ? (TypeTemplate)kotlinTypeMarker : null;
                if (typeTemplate2 == null) {
                    kotlinTypeMarker = superType;
                    typeTemplate2 = kotlinTypeMarker instanceof TypeTemplate ? (TypeTemplate)kotlinTypeMarker : null;
                }
                if ((object = (typeTemplate = typeTemplate2)) == null || (object = ((TypeTemplate)object).getBuilderInferenceData()) == null) break block3;
                ((BuilderInferenceData)object).addConstraint$frontend((KotlinType)subType, (KotlinType)superType, this.allowOnlyTrivialConstraints);
            }
            return null;
        }
    }
}

