/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPosition;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001:\u0002\u0011\u0012R\u0014\u0010\u0005\u001a\u00020\u00028'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u000b8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00068'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds;", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "getTypeVariable", "()Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "typeVariable", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "getBounds", "()Ljava/util/Collection;", "bounds", "Lorg/jetbrains/kotlin/types/KotlinType;", "getValue", "()Lorg/jetbrains/kotlin/types/KotlinType;", "value", "getValues", "values", "BoundKind", "Bound"})
public interface TypeBounds {
    @NotNull
    public TypeVariable getTypeVariable();

    @NotNull
    public Collection<Bound> getBounds();

    @Nullable
    default public KotlinType getValue() {
        return this.getValues().size() == 1 ? (KotlinType)CollectionsKt.first((Iterable)this.getValues()) : null;
    }

    @NotNull
    public Collection<KotlinType> getValues();

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0011\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0017\u001a\u00020\u0016H\u0017\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001f\u001a\u0004\b \u0010!R\u001a\u0010\t\u001a\u00020\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\"\u001a\u0004\b#\u0010$R\u001a\u0010\u000b\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010%\u001a\u0004\b\u000b\u0010&R \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\f8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\r\u0010'\u001a\u0004\b(\u0010)"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "typeVariable", "Lorg/jetbrains/kotlin/types/KotlinType;", "constrainingType", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$BoundKind;", "kind", "Lorg/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;", "position", "", "isProper", "", "derivedFrom", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$BoundKind;Lorg/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;ZLjava/util/Set;)V", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "getTypeVariable", "()Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getConstrainingType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$BoundKind;", "getKind", "()Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$BoundKind;", "Lorg/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;", "getPosition", "()Lorg/jetbrains/kotlin/resolve/calls/inference/constraintPosition/ConstraintPosition;", "Z", "()Z", "Ljava/util/Set;", "getDerivedFrom", "()Ljava/util/Set;"})
    public static final class Bound {
        @NotNull
        private final TypeVariable typeVariable;
        @NotNull
        private final KotlinType constrainingType;
        @NotNull
        private final BoundKind kind;
        @NotNull
        private final ConstraintPosition position;
        private final boolean isProper;
        @NotNull
        private final Set<TypeVariable> derivedFrom;

        public Bound(@NotNull TypeVariable typeVariable, @NotNull KotlinType constrainingType, @NotNull BoundKind kind, @NotNull ConstraintPosition position, boolean isProper, @NotNull Set<TypeVariable> derivedFrom) {
            Intrinsics.checkNotNullParameter(typeVariable, "typeVariable");
            Intrinsics.checkNotNullParameter(constrainingType, "constrainingType");
            Intrinsics.checkNotNullParameter((Object)kind, "kind");
            Intrinsics.checkNotNullParameter(position, "position");
            Intrinsics.checkNotNullParameter(derivedFrom, "derivedFrom");
            this.typeVariable = typeVariable;
            this.constrainingType = constrainingType;
            this.kind = kind;
            this.position = position;
            this.isProper = isProper;
            this.derivedFrom = derivedFrom;
        }

        @NotNull
        public final TypeVariable getTypeVariable() {
            return this.typeVariable;
        }

        @NotNull
        public final KotlinType getConstrainingType() {
            return this.constrainingType;
        }

        @NotNull
        public final BoundKind getKind() {
            return this.kind;
        }

        @NotNull
        public final ConstraintPosition getPosition() {
            return this.position;
        }

        public final boolean isProper() {
            return this.isProper;
        }

        @NotNull
        public final Set<TypeVariable> getDerivedFrom() {
            return this.derivedFrom;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
                return false;
            }
            Bound bound = (Bound)other;
            if (!Intrinsics.areEqual(this.typeVariable, bound.typeVariable)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.constrainingType, bound.constrainingType)) {
                return false;
            }
            if (this.kind != bound.kind) {
                return false;
            }
            return this.position.isStrong() == bound.position.isStrong();
        }

        public int hashCode() {
            int result2 = this.typeVariable.hashCode();
            result2 = 31 * result2 + this.constrainingType.hashCode();
            result2 = 31 * result2 + this.kind.hashCode();
            result2 = 31 * result2 + (this.position.isStrong() ? 1 : 0);
            return result2;
        }

        @NotNull
        public String toString() {
            return "Bound(" + this.constrainingType + ", " + (Object)((Object)this.kind) + ", " + this.position + ", isProper = " + this.isProper + ')';
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$BoundKind;", "", "<init>", "(Ljava/lang/String;I)V", "LOWER_BOUND", "EXACT_BOUND", "UPPER_BOUND"})
    public static final class BoundKind
    extends Enum<BoundKind> {
        public static final /* enum */ BoundKind LOWER_BOUND = new BoundKind();
        public static final /* enum */ BoundKind EXACT_BOUND = new BoundKind();
        public static final /* enum */ BoundKind UPPER_BOUND = new BoundKind();
        private static final /* synthetic */ BoundKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static BoundKind[] values() {
            return (BoundKind[])$VALUES.clone();
        }

        public static BoundKind valueOf(String value2) {
            return Enum.valueOf(BoundKind.class, value2);
        }

        @NotNull
        public static EnumEntries<BoundKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = boundKindArray = new BoundKind[]{BoundKind.LOWER_BOUND, BoundKind.EXACT_BOUND, BoundKind.UPPER_BOUND};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

