/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0005\u001a\u00020\u00048\u0001X\u0081\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0010\u001a\u0004\b\u0013\u0010\u0012R\u001a\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u0014\u001a\u0004\b\b\u0010\fR\u0011\u0010\u0018\u001a\u00020\u00158G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u001c\u001a\u00020\u00198G\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/TypeVariable;", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/CallHandle;", "call", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "freshTypeParameter", "originalTypeParameter", "", "isExternal", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/inference/CallHandle;Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;Z)V", "hasOnlyInputTypesAnnotation", "()Z", "Lorg/jetbrains/kotlin/resolve/calls/inference/CallHandle;", "getCall", "()Lorg/jetbrains/kotlin/resolve/calls/inference/CallHandle;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getFreshTypeParameter$frontend", "()Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getOriginalTypeParameter", "Z", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "name", "Lorg/jetbrains/kotlin/types/KotlinType;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "type"})
public final class TypeVariable {
    @NotNull
    private final CallHandle call;
    @NotNull
    private final TypeParameterDescriptor freshTypeParameter;
    @NotNull
    private final TypeParameterDescriptor originalTypeParameter;
    private final boolean isExternal;

    public TypeVariable(@NotNull CallHandle call2, @NotNull TypeParameterDescriptor freshTypeParameter, @NotNull TypeParameterDescriptor originalTypeParameter, boolean isExternal) {
        Intrinsics.checkNotNullParameter(call2, "call");
        Intrinsics.checkNotNullParameter(freshTypeParameter, "freshTypeParameter");
        Intrinsics.checkNotNullParameter(originalTypeParameter, "originalTypeParameter");
        this.call = call2;
        this.freshTypeParameter = freshTypeParameter;
        this.originalTypeParameter = originalTypeParameter;
        this.isExternal = isExternal;
    }

    @NotNull
    public final CallHandle getCall() {
        return this.call;
    }

    @NotNull
    public final TypeParameterDescriptor getFreshTypeParameter$frontend() {
        return this.freshTypeParameter;
    }

    @NotNull
    public final TypeParameterDescriptor getOriginalTypeParameter() {
        return this.originalTypeParameter;
    }

    public final boolean isExternal() {
        return this.isExternal;
    }

    @NotNull
    public final Name getName() {
        Name name = this.originalTypeParameter.getName();
        Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
        return name;
    }

    @NotNull
    public final KotlinType getType() {
        SimpleType simpleType2 = this.freshTypeParameter.getDefaultType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
        return simpleType2;
    }

    public final boolean hasOnlyInputTypesAnnotation() {
        return AnnotationsForResolveUtilsKt.hasOnlyInputTypesAnnotation(this.originalTypeParameter);
    }
}

