/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.components.ClassicTypeSystemContextForCS;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.DescriptorRelatedInferenceUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintInjector;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableFromCallableDescriptor;
import org.jetbrains.kotlin.resolve.calls.results.SimpleConstraintSystem;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.checker.KotlinTypeRefiner;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemContextKt;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0010\u001a\u00020\u000f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\u00020\u001b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010!\u001a\u00020 8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u0014\u0010&\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u001aR\u0014\u0010*\u001a\u00020'8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/SimpleConstraintSystemImpl;", "Lorg/jetbrains/kotlin/resolve/calls/results/SimpleConstraintSystem;", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector;", "constraintInjector", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "builtIns", "Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;", "kotlinTypeRefiner", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintInjector;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/types/checker/KotlinTypeRefiner;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "", "Lorg/jetbrains/kotlin/types/model/TypeParameterMarker;", "typeParameters", "Lorg/jetbrains/kotlin/types/model/TypeSubstitutorMarker;", "registerTypeVariables", "(Ljava/util/Collection;)Lorg/jetbrains/kotlin/types/model/TypeSubstitutorMarker;", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "subType", "superType", "", "addSubtypeConstraint", "(Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;)V", "", "hasContradiction", "()Z", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/NewConstraintSystemImpl;", "system", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/NewConstraintSystemImpl;", "getSystem", "()Lorg/jetbrains/kotlin/resolve/calls/inference/model/NewConstraintSystemImpl;", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "getCsBuilder", "()Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "getCaptureFromArgument", "captureFromArgument", "Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;", "getContext", "()Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContext;", "context"})
public final class SimpleConstraintSystemImpl
implements SimpleConstraintSystem {
    @NotNull
    private final NewConstraintSystemImpl system;
    @NotNull
    private final ConstraintSystemBuilder csBuilder;

    public SimpleConstraintSystemImpl(@NotNull ConstraintInjector constraintInjector, @NotNull KotlinBuiltIns builtIns, @NotNull KotlinTypeRefiner kotlinTypeRefiner, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(constraintInjector, "constraintInjector");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(kotlinTypeRefiner, "kotlinTypeRefiner");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.system = new NewConstraintSystemImpl(constraintInjector, new ClassicTypeSystemContextForCS(builtIns, kotlinTypeRefiner), languageVersionSettings);
        this.csBuilder = this.system.getBuilder();
    }

    @NotNull
    public final NewConstraintSystemImpl getSystem() {
        return this.system;
    }

    @NotNull
    public final ConstraintSystemBuilder getCsBuilder() {
        return this.csBuilder;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public TypeSubstitutorMarker registerTypeVariables(@NotNull Collection<? extends TypeParameterMarker> typeParameters2) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(typeParameters2, "typeParameters");
        Iterable $this$associate$iv = typeParameters2;
        boolean $i$f$associate = false;
        int n = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(n);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            TypeParameterMarker it = (TypeParameterMarker)element$iv$iv;
            boolean bl = false;
            TypeSystemContextKt.requireOrDescribe(it instanceof TypeParameterDescriptor, it);
            TypeVariableFromCallableDescriptor variable = new TypeVariableFromCallableDescriptor((TypeParameterDescriptor)it);
            this.csBuilder.registerVariable(variable);
            Pair<TypeConstructor, TypeProjection> pair = TuplesKt.to(((TypeParameterDescriptor)it).getDefaultType().getConstructor(), TypeUtilsKt.asTypeProjection(variable.getDefaultType()));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map substitutionMap = destination$iv$iv;
        TypeSubstitutor substitutor2 = TypeConstructorSubstitution.Companion.createByConstructorsMap$default(TypeConstructorSubstitution.Companion, substitutionMap, false, 2, null).buildSubstitutor();
        for (TypeParameterMarker typeParameterMarker : typeParameters2) {
            TypeSystemContextKt.requireOrDescribe(typeParameterMarker instanceof TypeParameterDescriptor, typeParameterMarker);
            for (KotlinType upperBound : ((TypeParameterDescriptor)typeParameterMarker).getUpperBounds()) {
                SimpleType simpleType2 = ((TypeParameterDescriptor)typeParameterMarker).getDefaultType();
                Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
                this.addSubtypeConstraint(DescriptorRelatedInferenceUtilsKt.substitute(substitutor2, simpleType2), DescriptorRelatedInferenceUtilsKt.substitute(substitutor2, upperBound.unwrap()));
            }
        }
        return substitutor2;
    }

    @Override
    public void addSubtypeConstraint(@NotNull KotlinTypeMarker subType, @NotNull KotlinTypeMarker superType) {
        Intrinsics.checkNotNullParameter(subType, "subType");
        Intrinsics.checkNotNullParameter(superType, "superType");
        this.csBuilder.addSubtypeConstraint(subType, superType, SimpleConstraintSystemConstraintPosition.INSTANCE);
    }

    @Override
    public boolean hasContradiction() {
        return this.csBuilder.getHasContradiction();
    }

    @Override
    public boolean getCaptureFromArgument() {
        return true;
    }

    @Override
    @NotNull
    public TypeSystemInferenceExtensionContext getContext() {
        return this.system;
    }
}

