/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.resolve.calls.inference.NewConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConeNoInferSubtyping;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintSystemError;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintError;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintMismatch;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintWarning;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnosticsKt;
import org.jetbrains.kotlin.resolve.calls.model.KotlinConstraintSystemDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b6\u0018\u00002\u00020\u0001B)\b\u0004\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001d\u0010\r\u001a\u00020\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H\u0004\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0010\u001a\u00020\u000fH\u0007\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\b\u001a\u00020\u00078\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001f\u001a\u0004\u0018\u00010\u001c8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u0082\u0001\u0002 !"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/model/CallResolutionResult;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;", "resultCallAtom", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/calls/inference/NewConstraintSystem;", "constraintSystem", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;Ljava/util/List;Lorg/jetbrains/kotlin/resolve/calls/inference/NewConstraintSystem;)V", "subResolvedAtoms", "", "setAnalyzedResults", "(Ljava/util/List;)V", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/NewTypeSubstitutor;", "substitutor", "completedDiagnostic", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/NewTypeSubstitutor;)Ljava/util/List;", "", "toString", "()Ljava/lang/String;", "Ljava/util/List;", "getDiagnostics", "()Ljava/util/List;", "Lorg/jetbrains/kotlin/resolve/calls/inference/NewConstraintSystem;", "getConstraintSystem", "()Lorg/jetbrains/kotlin/resolve/calls/inference/NewConstraintSystem;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolutionAtom;", "getAtom", "()Lorg/jetbrains/kotlin/resolve/calls/model/ResolutionAtom;", "atom", "Lorg/jetbrains/kotlin/resolve/calls/model/AllCandidatesResolutionResult;", "Lorg/jetbrains/kotlin/resolve/calls/model/SingleCallResolutionResult;"})
public abstract class CallResolutionResult
extends ResolvedAtom {
    @NotNull
    private final List<KotlinCallDiagnostic> diagnostics;
    @NotNull
    private final NewConstraintSystem constraintSystem;

    private CallResolutionResult(ResolvedCallAtom resultCallAtom, List<? extends KotlinCallDiagnostic> diagnostics, NewConstraintSystem constraintSystem) {
        super(null);
        this.diagnostics = diagnostics;
        this.constraintSystem = constraintSystem;
        this.setAnalyzedResults(CollectionsKt.listOfNotNull(resultCallAtom));
    }

    @NotNull
    public final List<KotlinCallDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final NewConstraintSystem getConstraintSystem() {
        return this.constraintSystem;
    }

    @Override
    protected final void setAnalyzedResults(@NotNull List<? extends ResolvedAtom> subResolvedAtoms) {
        Intrinsics.checkNotNullParameter(subResolvedAtoms, "subResolvedAtoms");
        super.setAnalyzedResults(subResolvedAtoms);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KotlinCallDiagnostic> completedDiagnostic(@NotNull NewTypeSubstitutor substitutor2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(substitutor2, "substitutor");
        Iterable $this$map$iv = this.diagnostics;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ConstraintSystemError error;
            KotlinCallDiagnostic kotlinCallDiagnostic;
            void it;
            KotlinCallDiagnostic kotlinCallDiagnostic2 = (KotlinCallDiagnostic)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (KotlinCallDiagnosticsKt.getConstraintSystemError((KotlinCallDiagnostic)it) == null) {
                kotlinCallDiagnostic = it;
            } else if (!(error instanceof NewConstraintMismatch)) {
                kotlinCallDiagnostic = it;
            } else {
                Object object = ((NewConstraintMismatch)((Object)error)).getLowerType();
                KotlinType kotlinType = object instanceof KotlinType ? (KotlinType)object : null;
                if (kotlinType == null || (kotlinType = kotlinType.unwrap()) == null) {
                    kotlinCallDiagnostic = it;
                } else {
                    KotlinConstraintSystemDiagnostic kotlinConstraintSystemDiagnostic;
                    KotlinType lowerType = kotlinType;
                    UnwrappedType newLowerType = substitutor2.safeSubstitute(TypeUtilsKt.unCapture((UnwrappedType)lowerType));
                    object = error;
                    if (object instanceof NewConstraintError) {
                        kotlinConstraintSystemDiagnostic = KotlinCallDiagnosticsKt.asDiagnostic(new NewConstraintError(newLowerType, ((NewConstraintError)error).getUpperType(), ((NewConstraintError)error).getPosition()));
                    } else if (object instanceof NewConstraintWarning) {
                        kotlinConstraintSystemDiagnostic = KotlinCallDiagnosticsKt.asDiagnostic(new NewConstraintWarning(newLowerType, ((NewConstraintWarning)error).getUpperType(), ((NewConstraintWarning)error).getPosition()));
                    } else {
                        if (object instanceof ConeNoInferSubtyping) {
                            throw new IllegalStateException("ConeNoInferSubtyping shouldn't be encountered in K1".toString());
                        }
                        throw new NoWhenBranchMatchedException();
                    }
                    kotlinCallDiagnostic = kotlinConstraintSystemDiagnostic;
                }
            }
            collection.add(kotlinCallDiagnostic);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public ResolutionAtom getAtom() {
        return null;
    }

    @NotNull
    public String toString() {
        return "diagnostics: (" + CollectionsKt.joinToString$default(this.diagnostics, null, null, null, 0, null, null, 63, null) + ')';
    }

    public /* synthetic */ CallResolutionResult(ResolvedCallAtom resultCallAtom, List diagnostics, NewConstraintSystem constraintSystem, DefaultConstructorMarker $constructor_marker) {
        this(resultCallAtom, diagnostics, constraintSystem);
    }
}

