/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.components.ClassicTypeSystemContextForCSKt;
import org.jetbrains.kotlin.resolve.calls.components.InferenceSession;
import org.jetbrains.kotlin.resolve.calls.components.KotlinResolutionCallbacks;
import org.jetbrains.kotlin.resolve.calls.components.candidate.SimpleErrorResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.components.candidate.SimpleResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.inference.DescriptorRelatedInferenceUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintStorage;
import org.jetbrains.kotlin.resolve.calls.inference.model.LowerPriorityToPreserveCompatibility;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewConstraintSystemImpl;
import org.jetbrains.kotlin.resolve.calls.model.GivenCandidate;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCall;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnosticsKt;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallKind;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.ReceiverExpressionKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.ReceiverKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SimpleCandidateFactoryKt;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateFactory;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateWithBoundDispatchReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.HiddenDescriptor;
import org.jetbrains.kotlin.resolve.calls.tower.HiddenExtensionRelatedToDynamicTypes;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.error.ErrorScope;
import org.jetbrains.kotlin.types.error.ErrorScopeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001d\u0010\u0016\u001a\u0004\u0018\u00010\r*\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001d\u0010\u0018\u001a\u0004\u0018\u00010\r*\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0017J\u0017\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ)\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u001f\u001a\u0004\u0018\u00010\u000fH\u0017\u00a2\u0006\u0004\b\u001b\u0010 J-\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u00142\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0!H\u0017\u00a2\u0006\u0004\b\u001b\u0010#J[\u0010\u001b\u001a\u00020\u00022\u0006\u0010%\u001a\u00020$2\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010&\u001a\u0004\u0018\u00010\u00112\b\u0010'\u001a\u0004\u0018\u00010\u00112\u000e\u0010(\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010!2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0)2\b\u0010-\u001a\u0004\u0018\u00010,H\u0002\u00a2\u0006\u0004\b\u001b\u0010.J\u000f\u0010/\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b/\u00100R\u001a\u0010\u0004\u001a\u00020\u00038\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u00101\u001a\u0004\b2\u00103R\u001a\u0010\u0006\u001a\u00020\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u00104\u001a\u0004\b5\u00106R\u001a\u0010\b\u001a\u00020\u00078\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u00107\u001a\u0004\b8\u00109R\u001a\u0010\n\u001a\u00020\t8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\n\u0010:\u001a\u0004\b;\u0010<R\u001a\u0010>\u001a\u00020=8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b>\u0010?\u001a\u0004\b@\u0010AR\u001a\u0010C\u001a\u00020B8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\bC\u0010D\u001a\u0004\bE\u0010F"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/model/SimpleCandidateFactory;", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateFactory;", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/SimpleResolutionCandidate;", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "callComponents", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "kotlinCall", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "resolutionCallbacks", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;)V", "Lorg/jetbrains/kotlin/resolve/calls/model/ReceiverKotlinCallArgument;", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "fromResolution", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "createReceiverArgument", "(Lorg/jetbrains/kotlin/resolve/calls/model/ReceiverKotlinCallArgument;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;)Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;", "explicitReceiverKind", "getExplicitDispatchReceiver", "(Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;)Lorg/jetbrains/kotlin/resolve/calls/model/ReceiverKotlinCallArgument;", "getExplicitExtensionReceiver", "Lorg/jetbrains/kotlin/resolve/calls/model/GivenCandidate;", "givenCandidate", "createCandidate", "(Lorg/jetbrains/kotlin/resolve/calls/model/GivenCandidate;)Lorg/jetbrains/kotlin/resolve/calls/components/candidate/SimpleResolutionCandidate;", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;", "towerCandidate", "extensionReceiver", "(Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;)Lorg/jetbrains/kotlin/resolve/calls/components/candidate/SimpleResolutionCandidate;", "", "extensionReceiverCandidates", "(Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;Ljava/util/List;)Lorg/jetbrains/kotlin/resolve/calls/components/candidate/SimpleResolutionCandidate;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "descriptor", "dispatchArgumentReceiver", "extensionArgumentReceiver", "extensionArgumentReceiverCandidates", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "initialDiagnostics", "Lorg/jetbrains/kotlin/types/TypeSubstitutor;", "knownSubstitutor", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;Ljava/util/List;Ljava/util/Collection;Lorg/jetbrains/kotlin/types/TypeSubstitutor;)Lorg/jetbrains/kotlin/resolve/calls/components/candidate/SimpleResolutionCandidate;", "createErrorCandidate", "()Lorg/jetbrains/kotlin/resolve/calls/components/candidate/SimpleResolutionCandidate;", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "getCallComponents", "()Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "getScopeTower", "()Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "getKotlinCall", "()Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCall;", "Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "getResolutionCallbacks", "()Lorg/jetbrains/kotlin/resolve/calls/components/KotlinResolutionCallbacks;", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "inferenceSession", "Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "getInferenceSession", "()Lorg/jetbrains/kotlin/resolve/calls/components/InferenceSession;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;", "baseSystem", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;", "getBaseSystem", "()Lorg/jetbrains/kotlin/resolve/calls/inference/model/ConstraintStorage;"})
public final class SimpleCandidateFactory
implements CandidateFactory<SimpleResolutionCandidate> {
    @NotNull
    private final KotlinCallComponents callComponents;
    @NotNull
    private final ImplicitScopeTower scopeTower;
    @NotNull
    private final KotlinCall kotlinCall;
    @NotNull
    private final KotlinResolutionCallbacks resolutionCallbacks;
    @NotNull
    private final InferenceSession inferenceSession;
    @NotNull
    private final ConstraintStorage baseSystem;

    public SimpleCandidateFactory(@NotNull KotlinCallComponents callComponents, @NotNull ImplicitScopeTower scopeTower, @NotNull KotlinCall kotlinCall, @NotNull KotlinResolutionCallbacks resolutionCallbacks) {
        Intrinsics.checkNotNullParameter(callComponents, "callComponents");
        Intrinsics.checkNotNullParameter(scopeTower, "scopeTower");
        Intrinsics.checkNotNullParameter(kotlinCall, "kotlinCall");
        Intrinsics.checkNotNullParameter(resolutionCallbacks, "resolutionCallbacks");
        this.callComponents = callComponents;
        this.scopeTower = scopeTower;
        this.kotlinCall = kotlinCall;
        this.resolutionCallbacks = resolutionCallbacks;
        this.inferenceSession = this.resolutionCallbacks.getInferenceSession();
        NewConstraintSystemImpl baseSystem = ClassicTypeSystemContextForCSKt.NewConstraintSystemImpl(this.callComponents.getConstraintInjector(), this.callComponents.getBuiltIns(), this.callComponents.getKotlinTypeRefiner(), this.callComponents.getLanguageVersionSettings());
        if (!this.inferenceSession.resolveReceiverIndependently()) {
            DescriptorRelatedInferenceUtilsKt.addSubsystemFromArgument(baseSystem, this.kotlinCall.getExplicitReceiver());
            DescriptorRelatedInferenceUtilsKt.addSubsystemFromArgument(baseSystem, this.kotlinCall.getDispatchReceiverForInvokeExtension());
        }
        for (KotlinCallArgument argument : this.kotlinCall.getArgumentsInParenthesis()) {
            DescriptorRelatedInferenceUtilsKt.addSubsystemFromArgument(baseSystem, argument);
        }
        DescriptorRelatedInferenceUtilsKt.addSubsystemFromArgument(baseSystem, this.kotlinCall.getExternalArgument());
        baseSystem.addOtherSystem(this.inferenceSession.currentConstraintSystem());
        this.baseSystem = baseSystem.asReadOnlyStorage();
    }

    @NotNull
    public final KotlinCallComponents getCallComponents() {
        return this.callComponents;
    }

    @NotNull
    public final ImplicitScopeTower getScopeTower() {
        return this.scopeTower;
    }

    @NotNull
    public final KotlinCall getKotlinCall() {
        return this.kotlinCall;
    }

    @NotNull
    public final KotlinResolutionCallbacks getResolutionCallbacks() {
        return this.resolutionCallbacks;
    }

    @NotNull
    public final InferenceSession getInferenceSession() {
        return this.inferenceSession;
    }

    @NotNull
    public final ConstraintStorage getBaseSystem() {
        return this.baseSystem;
    }

    private final SimpleKotlinCallArgument createReceiverArgument(ReceiverKotlinCallArgument explicitReceiver, ReceiverValueWithSmartCastInfo fromResolution) {
        SimpleKotlinCallArgument simpleKotlinCallArgument = explicitReceiver instanceof SimpleKotlinCallArgument ? (SimpleKotlinCallArgument)explicitReceiver : null;
        if (simpleKotlinCallArgument == null) {
            ReceiverExpressionKotlinCallArgument receiverExpressionKotlinCallArgument;
            ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo = fromResolution;
            if (receiverValueWithSmartCastInfo != null) {
                ReceiverValueWithSmartCastInfo it = receiverValueWithSmartCastInfo;
                boolean bl = false;
                receiverExpressionKotlinCallArgument = ReceiverExpressionKotlinCallArgument.Companion.invoke(it, false, this.kotlinCall.isForImplicitInvoke());
            } else {
                receiverExpressionKotlinCallArgument = null;
            }
            simpleKotlinCallArgument = receiverExpressionKotlinCallArgument;
        }
        return simpleKotlinCallArgument;
    }

    private final ReceiverKotlinCallArgument getExplicitDispatchReceiver(KotlinCall $this$getExplicitDispatchReceiver, ExplicitReceiverKind explicitReceiverKind) {
        ReceiverKotlinCallArgument receiverKotlinCallArgument;
        switch (WhenMappings.$EnumSwitchMapping$0[explicitReceiverKind.ordinal()]) {
            case 1: {
                receiverKotlinCallArgument = $this$getExplicitDispatchReceiver.getExplicitReceiver();
                break;
            }
            case 2: {
                receiverKotlinCallArgument = $this$getExplicitDispatchReceiver.getDispatchReceiverForInvokeExtension();
                break;
            }
            default: {
                receiverKotlinCallArgument = null;
            }
        }
        return receiverKotlinCallArgument;
    }

    private final ReceiverKotlinCallArgument getExplicitExtensionReceiver(KotlinCall $this$getExplicitExtensionReceiver, ExplicitReceiverKind explicitReceiverKind) {
        ReceiverKotlinCallArgument receiverKotlinCallArgument;
        switch (WhenMappings.$EnumSwitchMapping$0[explicitReceiverKind.ordinal()]) {
            case 2: 
            case 3: {
                receiverKotlinCallArgument = $this$getExplicitExtensionReceiver.getExplicitReceiver();
                break;
            }
            default: {
                receiverKotlinCallArgument = null;
            }
        }
        return receiverKotlinCallArgument;
    }

    @NotNull
    public final SimpleResolutionCandidate createCandidate(@NotNull GivenCandidate givenCandidate) {
        ReceiverExpressionKotlinCallArgument receiverExpressionKotlinCallArgument;
        Intrinsics.checkNotNullParameter(givenCandidate, "givenCandidate");
        ReceiverKotlinCallArgument receiverKotlinCallArgument = this.kotlinCall.getExplicitReceiver();
        SimpleKotlinCallArgument simpleKotlinCallArgument = receiverKotlinCallArgument instanceof SimpleKotlinCallArgument ? (SimpleKotlinCallArgument)receiverKotlinCallArgument : null;
        boolean isSafeCall = simpleKotlinCallArgument != null ? simpleKotlinCallArgument.isSafeCall() : false;
        ExplicitReceiverKind explicitReceiverKind = givenCandidate.getDispatchReceiver() == null ? ExplicitReceiverKind.NO_EXPLICIT_RECEIVER : ExplicitReceiverKind.DISPATCH_RECEIVER;
        ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo = givenCandidate.getDispatchReceiver();
        if (receiverValueWithSmartCastInfo != null) {
            ReceiverValueWithSmartCastInfo it = receiverValueWithSmartCastInfo;
            boolean bl = false;
            receiverExpressionKotlinCallArgument = ReceiverExpressionKotlinCallArgument.Companion.invoke$default(ReceiverExpressionKotlinCallArgument.Companion, it, isSafeCall, false, 4, null);
        } else {
            receiverExpressionKotlinCallArgument = null;
        }
        ReceiverExpressionKotlinCallArgument dispatchArgumentReceiver = receiverExpressionKotlinCallArgument;
        return this.createCandidate(givenCandidate.getDescriptor(), explicitReceiverKind, dispatchArgumentReceiver, null, null, CollectionsKt.emptyList(), givenCandidate.getKnownTypeParametersResultingSubstitutor());
    }

    @Override
    @NotNull
    public SimpleResolutionCandidate createCandidate(@NotNull CandidateWithBoundDispatchReceiver towerCandidate, @NotNull ExplicitReceiverKind explicitReceiverKind, @Nullable ReceiverValueWithSmartCastInfo extensionReceiver) {
        Intrinsics.checkNotNullParameter(towerCandidate, "towerCandidate");
        Intrinsics.checkNotNullParameter((Object)explicitReceiverKind, "explicitReceiverKind");
        SimpleKotlinCallArgument dispatchArgumentReceiver = this.createReceiverArgument(this.getExplicitDispatchReceiver(this.kotlinCall, explicitReceiverKind), towerCandidate.getDispatchReceiver());
        SimpleKotlinCallArgument extensionArgumentReceiver = this.createReceiverArgument(this.getExplicitExtensionReceiver(this.kotlinCall, explicitReceiverKind), extensionReceiver);
        CallableDescriptor descriptor2 = towerCandidate.getDescriptor();
        List<KotlinCallDiagnostic> diagnostics = towerCandidate.getDiagnostics();
        if (descriptor2 instanceof PropertyDescriptor && SimpleCandidateFactoryKt.isSyntheticEnumEntries((PropertyDescriptor)descriptor2)) {
            diagnostics = CollectionsKt.plus((Collection)diagnostics, KotlinCallDiagnosticsKt.asDiagnostic(new LowerPriorityToPreserveCompatibility(false)));
        }
        return this.createCandidate(descriptor2, explicitReceiverKind, dispatchArgumentReceiver, extensionArgumentReceiver, null, (Collection<? extends KotlinCallDiagnostic>)diagnostics, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public SimpleResolutionCandidate createCandidate(@NotNull CandidateWithBoundDispatchReceiver towerCandidate, @NotNull ExplicitReceiverKind explicitReceiverKind, @NotNull List<ReceiverValueWithSmartCastInfo> extensionReceiverCandidates) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(towerCandidate, "towerCandidate");
        Intrinsics.checkNotNullParameter((Object)explicitReceiverKind, "explicitReceiverKind");
        Intrinsics.checkNotNullParameter(extensionReceiverCandidates, "extensionReceiverCandidates");
        SimpleKotlinCallArgument dispatchArgumentReceiver = this.createReceiverArgument(this.getExplicitDispatchReceiver(this.kotlinCall, explicitReceiverKind), towerCandidate.getDispatchReceiver());
        Iterable $this$mapNotNull$iv = extensionReceiverCandidates;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            SimpleKotlinCallArgument it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ReceiverValueWithSmartCastInfo it = (ReceiverValueWithSmartCastInfo)element$iv$iv;
            boolean bl2 = false;
            if (this.createReceiverArgument(this.getExplicitExtensionReceiver(this.kotlinCall, explicitReceiverKind), it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List extensionArgumentReceiverCandidates = (List)destination$iv$iv;
        return this.createCandidate(towerCandidate.getDescriptor(), explicitReceiverKind, dispatchArgumentReceiver, null, extensionArgumentReceiverCandidates, (Collection<? extends KotlinCallDiagnostic>)towerCandidate.getDiagnostics(), null);
    }

    private final SimpleResolutionCandidate createCandidate(CallableDescriptor descriptor2, ExplicitReceiverKind explicitReceiverKind, SimpleKotlinCallArgument dispatchArgumentReceiver, SimpleKotlinCallArgument extensionArgumentReceiver, List<? extends SimpleKotlinCallArgument> extensionArgumentReceiverCandidates, Collection<? extends KotlinCallDiagnostic> initialDiagnostics, TypeSubstitutor knownSubstitutor) {
        MutableResolvedCallAtom resolvedKtCall = new MutableResolvedCallAtom(this.kotlinCall, descriptor2, explicitReceiverKind, dispatchArgumentReceiver, extensionArgumentReceiver, extensionArgumentReceiverCandidates, null, null, 192, null);
        if (ErrorUtils.isError(descriptor2)) {
            return new SimpleErrorResolutionCandidate(this.callComponents, this.resolutionCallbacks, this.scopeTower, this.baseSystem, resolvedKtCall);
        }
        SimpleResolutionCandidate candidate = new SimpleResolutionCandidate(this.callComponents, this.resolutionCallbacks, this.scopeTower, this.baseSystem, resolvedKtCall, knownSubstitutor);
        Iterable $this$forEach$iv = initialDiagnostics;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KotlinCallDiagnostic p0 = (KotlinCallDiagnostic)element$iv;
            boolean bl = false;
            candidate.addDiagnostic(p0);
        }
        if (this.callComponents.getStatelessCallbacks().isHiddenInResolution((DeclarationDescriptor)descriptor2, this.kotlinCall, this.resolutionCallbacks)) {
            candidate.addDiagnostic(HiddenDescriptor.INSTANCE);
        }
        if (extensionArgumentReceiver != null) {
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
            Intrinsics.checkNotNull(receiverParameterDescriptor);
            KotlinType kotlinType = receiverParameterDescriptor.getValue().getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            boolean parameterIsDynamic = DynamicTypesKt.isDynamic(kotlinType);
            KotlinType kotlinType2 = extensionArgumentReceiver.getReceiver().getReceiverValue().getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
            boolean argumentIsDynamic = DynamicTypesKt.isDynamic(kotlinType2);
            if (parameterIsDynamic != argumentIsDynamic || parameterIsDynamic && !AnnotationsForResolveUtilsKt.hasDynamicExtensionAnnotation(descriptor2)) {
                candidate.addDiagnostic(HiddenExtensionRelatedToDynamicTypes.INSTANCE);
            }
        }
        return candidate;
    }

    @Override
    @NotNull
    public SimpleResolutionCandidate createErrorCandidate() {
        String[] stringArray = new String[]{this.kotlinCall.toString()};
        ErrorScope errorScope = ErrorUtils.createErrorScope(ErrorScopeKind.SCOPE_FOR_ERROR_RESOLUTION_CANDIDATE, stringArray);
        CallableMemberDescriptor errorDescriptor = (CallableMemberDescriptor)CollectionsKt.first(this.kotlinCall.getCallKind() == KotlinCallKind.VARIABLE ? errorScope.getContributedVariables(this.kotlinCall.getName(), this.scopeTower.getLocation()) : errorScope.getContributedFunctions(this.kotlinCall.getName(), this.scopeTower.getLocation()));
        SimpleKotlinCallArgument dispatchReceiver = this.createReceiverArgument(this.kotlinCall.getExplicitReceiver(), null);
        ExplicitReceiverKind explicitReceiverKind = dispatchReceiver == null ? ExplicitReceiverKind.NO_EXPLICIT_RECEIVER : ExplicitReceiverKind.DISPATCH_RECEIVER;
        return this.createCandidate(errorDescriptor, explicitReceiverKind, dispatchReceiver, null, null, CollectionsKt.emptyList(), null);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ExplicitReceiverKind.values().length];
            try {
                nArray[ExplicitReceiverKind.DISPATCH_RECEIVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.BOTH_RECEIVERS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.EXTENSION_RECEIVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

