/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.results;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.AbstractOverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.OverloadResolutionResults;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0015\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0004\u0018\u00010\bH\u0017\u00a2\u0006\u0004\b\t\u0010\nJ\u001b\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00040\bH\u0017\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0015\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004H\u0017\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00028\u0000H\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0013\u001a\u0004\b\u0014\u0010\r"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/results/SingleOverloadResolutionResult;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "D", "Lorg/jetbrains/kotlin/resolve/calls/results/AbstractOverloadResolutionResults;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "result", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;)V", "", "getAllCandidates", "()Ljava/util/Collection;", "getResultingCalls", "getResultingCall", "()Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getResultingDescriptor", "()Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults$Code;", "getResultCode", "()Lorg/jetbrains/kotlin/resolve/calls/results/OverloadResolutionResults$Code;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "getResult"})
public final class SingleOverloadResolutionResult<D extends CallableDescriptor>
extends AbstractOverloadResolutionResults<D> {
    @NotNull
    private final ResolvedCall<D> result;

    public SingleOverloadResolutionResult(@NotNull ResolvedCall<D> result2) {
        Intrinsics.checkNotNullParameter(result2, "result");
        this.result = result2;
    }

    @NotNull
    public final ResolvedCall<D> getResult() {
        return this.result;
    }

    @Override
    @Nullable
    public Collection<ResolvedCall<D>> getAllCandidates() {
        return null;
    }

    @Override
    @NotNull
    public Collection<ResolvedCall<D>> getResultingCalls() {
        return CollectionsKt.listOf(this.result);
    }

    @Override
    @NotNull
    public ResolvedCall<D> getResultingCall() {
        return this.result;
    }

    @Override
    @NotNull
    public D getResultingDescriptor() {
        D d = this.result.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(d, "getResultingDescriptor(...)");
        return d;
    }

    @Override
    @NotNull
    public OverloadResolutionResults.Code getResultCode() {
        OverloadResolutionResults.Code code;
        switch (WhenMappings.$EnumSwitchMapping$0[this.result.getStatus().ordinal()]) {
            case 1: {
                code = OverloadResolutionResults.Code.SUCCESS;
                break;
            }
            case 2: {
                code = OverloadResolutionResults.Code.CANDIDATES_WITH_WRONG_RECEIVER;
                break;
            }
            case 3: {
                code = OverloadResolutionResults.Code.INCOMPLETE_TYPE_INFERENCE;
                break;
            }
            default: {
                code = OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH;
            }
        }
        return code;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ResolutionStatus.values().length];
            try {
                nArray[ResolutionStatus.SUCCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResolutionStatus.RECEIVER_TYPE_ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ResolutionStatus.INCOMPLETE_TYPE_INFERENCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

