/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.IdentifierInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 '2\u00020\u0001:\u0002('B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010 \u001a\u00020\u001d8G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010!\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b!\u0010#R\u0011\u0010%\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010#R\u0016\u0010\u0012\u001a\u00020\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010&"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/IdentifierInfo;", "identifierInfo", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/Nullability;", "immanentNullability", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/smartcasts/IdentifierInfo;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/Nullability;)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "toString", "()Ljava/lang/String;", "", "hashCode", "()I", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/IdentifierInfo;", "getIdentifierInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/IdentifierInfo;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/Nullability;", "getImmanentNullability", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/Nullability;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue$Kind;", "getKind", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue$Kind;", "kind", "isStable", "Z", "()Z", "getCanBeBound", "canBeBound", "I", "Companion", "Kind"})
public final class DataFlowValue {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IdentifierInfo identifierInfo;
    @NotNull
    private final KotlinType type;
    @NotNull
    private final Nullability immanentNullability;
    private final boolean isStable;
    private int hashCode;
    @NotNull
    public static final DataFlowValue ERROR = new DataFlowValue(IdentifierInfo.ERROR.INSTANCE, ErrorUtils.createErrorType(ErrorTypeKind.ERROR_DATA_FLOW_TYPE, new String[0]), Nullability.IMPOSSIBLE);

    public DataFlowValue(@NotNull IdentifierInfo identifierInfo, @NotNull KotlinType type2, @NotNull Nullability immanentNullability) {
        Intrinsics.checkNotNullParameter(identifierInfo, "identifierInfo");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter((Object)immanentNullability, "immanentNullability");
        this.identifierInfo = identifierInfo;
        this.type = type2;
        this.immanentNullability = immanentNullability;
        this.isStable = this.getKind() == Kind.STABLE_VALUE || this.getKind() == Kind.STABLE_VARIABLE || this.getKind() == Kind.STABLE_COMPLEX_EXPRESSION || this.getKind() == Kind.LEGACY_STABLE_LOCAL_DELEGATED_PROPERTY || this.getKind() == Kind.LEGACY_ALIEN_BASE_PROPERTY || this.getKind() == Kind.LEGACY_ALIEN_BASE_PROPERTY_INHERITED_IN_INVISIBLE_CLASS;
    }

    public /* synthetic */ DataFlowValue(IdentifierInfo identifierInfo, KotlinType kotlinType, Nullability nullability, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            nullability = DataFlowValueKt.access$getImmanentNullability(kotlinType);
        }
        this(identifierInfo, kotlinType, nullability);
    }

    @NotNull
    public final IdentifierInfo getIdentifierInfo() {
        return this.identifierInfo;
    }

    @NotNull
    public final KotlinType getType() {
        return this.type;
    }

    @NotNull
    public final Nullability getImmanentNullability() {
        return this.immanentNullability;
    }

    @NotNull
    public final Kind getKind() {
        return this.identifierInfo.getKind();
    }

    public final boolean isStable() {
        return this.isStable;
    }

    public final boolean getCanBeBound() {
        return this.identifierInfo.getCanBeBound();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DataFlowValue)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.identifierInfo, ((DataFlowValue)other).identifierInfo)) {
            return false;
        }
        return Intrinsics.areEqual(this.type, ((DataFlowValue)other).type);
    }

    @NotNull
    public String toString() {
        return "" + (Object)((Object)this.getKind()) + ' ' + this.identifierInfo + ' ' + (Object)((Object)this.immanentNullability);
    }

    public int hashCode() {
        int hashCode2 = this.hashCode;
        if (hashCode2 == 0) {
            this.hashCode = hashCode2 = this.type.hashCode() + 31 * this.identifierInfo.hashCode();
        }
        return hashCode2;
    }

    @NotNull
    public static final DataFlowValue nullValue(@NotNull KotlinBuiltIns builtIns) {
        return Companion.nullValue(builtIns);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\n"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "builtIns", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "nullValue", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "ERROR", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataFlowValue nullValue(@NotNull KotlinBuiltIns builtIns) {
            Intrinsics.checkNotNullParameter(builtIns, "builtIns");
            IdentifierInfo identifierInfo = IdentifierInfo.NULL.INSTANCE;
            SimpleType simpleType2 = builtIns.getNullableNothingType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "getNullableNothingType(...)");
            return new DataFlowValue(identifierInfo, simpleType2, Nullability.NULL);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\tR\u001a\u0010\u0004\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\t\u001a\u0004\b\n\u0010\bj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue$Kind;", "", "", "str", "description", "<init>", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getDescription", "STABLE_VALUE", "STABLE_COMPLEX_EXPRESSION", "LEGACY_STABLE_LOCAL_DELEGATED_PROPERTY", "PROPERTY_WITH_GETTER", "LEGACY_ALIEN_BASE_PROPERTY", "LEGACY_ALIEN_BASE_PROPERTY_INHERITED_IN_INVISIBLE_CLASS", "ALIEN_PUBLIC_PROPERTY", "STABLE_VARIABLE", "CAPTURED_VARIABLE", "MUTABLE_PROPERTY", "OTHER"})
    public static final class Kind
    extends Enum<Kind> {
        @NotNull
        private final String str;
        @NotNull
        private final String description;
        public static final /* enum */ Kind STABLE_VALUE = new Kind("STABLE_VALUE", 0, "stable val", null, 2, null);
        public static final /* enum */ Kind STABLE_COMPLEX_EXPRESSION = new Kind("complex expression", "");
        public static final /* enum */ Kind LEGACY_STABLE_LOCAL_DELEGATED_PROPERTY = new Kind("LEGACY_STABLE_LOCAL_DELEGATED_PROPERTY", 2, "local delegated property", null, 2, null);
        public static final /* enum */ Kind PROPERTY_WITH_GETTER = new Kind("custom getter", "property that has open or custom getter");
        public static final /* enum */ Kind LEGACY_ALIEN_BASE_PROPERTY = new Kind("alien derived", "property declared in base class from different module");
        public static final /* enum */ Kind LEGACY_ALIEN_BASE_PROPERTY_INHERITED_IN_INVISIBLE_CLASS = new Kind("alien inherited in invisible", "property declared in base class from different module inherited in non-public API class");
        public static final /* enum */ Kind ALIEN_PUBLIC_PROPERTY = new Kind("alien public", "public API property declared in different module");
        public static final /* enum */ Kind STABLE_VARIABLE = new Kind("stable var", "local variable that can be changed since the check in a loop");
        public static final /* enum */ Kind CAPTURED_VARIABLE = new Kind("captured var", "local variable that is captured by a changing closure");
        public static final /* enum */ Kind MUTABLE_PROPERTY = new Kind("member", "mutable property that could have been changed by this time");
        public static final /* enum */ Kind OTHER = new Kind("other", "complex expression");
        private static final /* synthetic */ Kind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Kind(String str, String description2) {
            this.str = str;
            this.description = description2;
        }

        /* synthetic */ Kind(String string2, int n, String string3, String string4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                string4 = string3;
            }
            this(string3, string4);
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public String toString() {
            return this.str;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value2) {
            return Enum.valueOf(Kind.class, value2);
        }

        @NotNull
        public static EnumEntries<Kind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = kindArray = new Kind[]{Kind.STABLE_VALUE, Kind.STABLE_COMPLEX_EXPRESSION, Kind.LEGACY_STABLE_LOCAL_DELEGATED_PROPERTY, Kind.PROPERTY_WITH_GETTER, Kind.LEGACY_ALIEN_BASE_PROPERTY, Kind.LEGACY_ALIEN_BASE_PROPERTY_INHERITED_IN_INVISIBLE_CLASS, Kind.ALIEN_PUBLIC_PROPERTY, Kind.STABLE_VARIABLE, Kind.CAPTURED_VARIABLE, Kind.MUTABLE_PROPERTY, Kind.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

