/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueKindUtilsKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.IdentifierInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.IdentifierInfoKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\bH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0017\u00a2\u0006\u0004\b\u000b\u0010\u0011J\u0017\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\u0013\u0010\u0014J1\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019H\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001cJ+\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001f2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\bH\u0017\u00a2\u0006\u0004\b\u000b\u0010!J/\u0010\u000b\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000fH\u0017\u00a2\u0006\u0004\b\u000b\u0010\"J\u0017\u0010$\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b$\u0010%R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010&"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactoryImpl;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "receiverValue", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "resolutionContext", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "createDataFlowValue", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;)Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "bindingContext", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "containingDeclarationOrModule", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "receiver", "createDataFlowValueForStableReceiver", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;)Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "usageContainingModule", "createDataFlowValueForProperty", "(Lorg/jetbrains/kotlin/psi/KtProperty;Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;)Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "", "isComplexExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Z", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;"})
public final class DataFlowValueFactoryImpl
implements DataFlowValueFactory {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public DataFlowValueFactoryImpl(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull ResolutionContext<?> resolutionContext) {
        Intrinsics.checkNotNullParameter(receiverValue, "receiverValue");
        Intrinsics.checkNotNullParameter(resolutionContext, "resolutionContext");
        BindingContext bindingContext = resolutionContext.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        return this.createDataFlowValue(receiverValue, bindingContext, resolutionContext.scope.getOwnerDescriptor());
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        DataFlowValue dataFlowValue;
        Intrinsics.checkNotNullParameter(receiverValue, "receiverValue");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Intrinsics.checkNotNullParameter(containingDeclarationOrModule, "containingDeclarationOrModule");
        ReceiverValue receiverValue2 = receiverValue;
        if (receiverValue2 instanceof TransientReceiver || receiverValue2 instanceof ImplicitReceiver) {
            dataFlowValue = this.createDataFlowValueForStableReceiver(receiverValue);
        } else if (receiverValue2 instanceof ExpressionReceiver) {
            KtExpression ktExpression = ((ExpressionReceiver)receiverValue).getExpression();
            KotlinType kotlinType = receiverValue.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            dataFlowValue = this.createDataFlowValue(ktExpression, kotlinType, bindingContext, containingDeclarationOrModule);
        } else {
            throw new UnsupportedOperationException("Unsupported receiver value: " + receiverValue.getClass().getName());
        }
        return dataFlowValue;
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValueForStableReceiver(@NotNull ReceiverValue receiver) {
        Intrinsics.checkNotNullParameter(receiver, "receiver");
        IdentifierInfo identifierInfo = new IdentifierInfo.Receiver(receiver);
        KotlinType kotlinType = receiver.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        return new DataFlowValue(identifierInfo, kotlinType, null, 4, null);
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValueForProperty(@NotNull KtProperty property, @NotNull VariableDescriptor variableDescriptor, @NotNull BindingContext bindingContext, @Nullable ModuleDescriptor usageContainingModule) {
        Intrinsics.checkNotNullParameter(property, "property");
        Intrinsics.checkNotNullParameter(variableDescriptor, "variableDescriptor");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        IdentifierInfo.Variable identifierInfo = new IdentifierInfo.Variable(variableDescriptor, DataFlowValueKindUtilsKt.variableKind(variableDescriptor, usageContainingModule, bindingContext, property, this.languageVersionSettings), (DataFlowValue)bindingContext.get(BindingContext.BOUND_INITIALIZER_VALUE, variableDescriptor));
        IdentifierInfo identifierInfo2 = identifierInfo;
        KotlinType kotlinType = variableDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        return new DataFlowValue(identifierInfo2, kotlinType, null, 4, null);
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull KtExpression expression, @NotNull KotlinType type2, @NotNull ResolutionContext<?> resolutionContext) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(resolutionContext, "resolutionContext");
        BindingContext bindingContext = resolutionContext.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        return this.createDataFlowValue(expression, type2, bindingContext, resolutionContext.scope.getOwnerDescriptor());
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull KtExpression expression, @NotNull KotlinType type2, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        IdentifierInfo result2;
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
        Intrinsics.checkNotNullParameter(containingDeclarationOrModule, "containingDeclarationOrModule");
        return expression instanceof KtConstantExpression && ((KtConstantExpression)expression).getNode().getElementType() == KtNodeTypes.NULL ? DataFlowValue.Companion.nullValue(DescriptorUtilsKt.getBuiltIns(containingDeclarationOrModule)) : (KotlinTypeKt.isError(type2) ? DataFlowValue.ERROR : (KotlinBuiltIns.isNullableNothing(type2) ? DataFlowValue.Companion.nullValue(DescriptorUtilsKt.getBuiltIns(containingDeclarationOrModule)) : (ExpressionTypingUtils.isExclExclExpression(KtPsiUtil.deparenthesize(expression)) ? new DataFlowValue(new IdentifierInfo.Expression(expression, false, 2, null), type2, Nullability.NOT_NULL) : (this.isComplexExpression(expression) ? new DataFlowValue(new IdentifierInfo.Expression(expression, true), type2, null, 4, null) : new DataFlowValue((result2 = IdentifierInfoKt.getIdForStableIdentifier(expression, bindingContext, containingDeclarationOrModule, this.languageVersionSettings)) == IdentifierInfo.NO.INSTANCE ? (IdentifierInfo)new IdentifierInfo.Expression(expression, false, 2, null) : result2, type2, null, 4, null)))));
    }

    private final boolean isComplexExpression(KtExpression expression) {
        KtExpression deparenthesized;
        KtExpression ktExpression = expression;
        boolean bl = ktExpression instanceof KtBlockExpression || ktExpression instanceof KtIfExpression || ktExpression instanceof KtWhenExpression ? true : (ktExpression instanceof KtBinaryExpression ? ((KtBinaryExpression)expression).getOperationToken() == KtTokens.ELVIS : (ktExpression instanceof KtParenthesizedExpression ? (deparenthesized = KtPsiUtil.deparenthesize(expression)) != null && this.isComplexExpression(deparenthesized) : false));
        return bl;
    }
}

