/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tasks;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtConstructorDelegationReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.inference.InferenceErrorData;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.AbstractTracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0011\u001a\u00020\n\"\b\b\u0000\u0010\u000e*\u00020\r2\u0006\u0010\t\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J/\u0010\u0013\u001a\u00020\n\"\b\b\u0000\u0010\u000e*\u00020\r2\u0006\u0010\t\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J5\u0010\u0018\u001a\u00020\n\"\b\b\u0000\u0010\u000e*\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001c\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001aH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ9\u0010 \u001a\u00020\n\"\n\b\u0000\u0010\u000e*\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\b2\u0014\u0010\u001f\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u001eH\u0016\u00a2\u0006\u0004\b \u0010\u0019J9\u0010\"\u001a\u00020\n\"\n\b\u0000\u0010\u000e*\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\b2\u0014\u0010!\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u001eH\u0016\u00a2\u0006\u0004\b\"\u0010\u0019J\u001f\u0010%\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010$\u001a\u00020#H\u0016\u00a2\u0006\u0004\b%\u0010&J\u0017\u0010'\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b'\u0010\u0015J9\u0010(\u001a\u00020\n\"\n\b\u0000\u0010\u000e*\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\b2\u0014\u0010!\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00028\u00000\u000f0\u001eH\u0016\u00a2\u0006\u0004\b(\u0010\u0019J\u0017\u0010)\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b)\u0010\u0015J\u0017\u0010*\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b*\u0010\u0015J'\u0010/\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010,\u001a\u00020+2\u0006\u0010.\u001a\u00020-H\u0016\u00a2\u0006\u0004\b/\u00100J'\u00105\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u00102\u001a\u0002012\u0006\u00104\u001a\u000203H\u0016\u00a2\u0006\u0004\b5\u00106J\u001f\u00109\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u00108\u001a\u000207H\u0016\u00a2\u0006\u0004\b9\u0010:J3\u0010@\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010;\u001a\u0002072\u0006\u0010=\u001a\u00020<2\n\u0010?\u001a\u0006\u0012\u0002\b\u00030>H\u0016\u00a2\u0006\u0004\b@\u0010AJ\u0017\u0010B\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\bB\u0010\u0015J'\u0010E\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010D\u001a\u00020C2\u0006\u0010$\u001a\u00020\rH\u0016\u00a2\u0006\u0004\bE\u0010FJ#\u0010J\u001a\u00020\n2\n\u0010G\u001a\u0006\u0012\u0002\b\u00030>2\u0006\u0010I\u001a\u00020HH\u0016\u00a2\u0006\u0004\bJ\u0010KJ\u0017\u0010M\u001a\u00020\n2\u0006\u00102\u001a\u00020LH\u0002\u00a2\u0006\u0004\bM\u0010NR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010O\u001a\u0004\bP\u0010QR\u001c\u0010S\u001a\u0004\u0018\u00010R8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\bS\u0010T\u001a\u0004\bU\u0010V"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategyForImplicitConstructorDelegationCall;", "Lorg/jetbrains/kotlin/resolve/calls/tasks/AbstractTracingStrategy;", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "delegationCall", "Lorg/jetbrains/kotlin/psi/Call;", "call", "<init>", "(Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;Lorg/jetbrains/kotlin/psi/Call;)V", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "", "bindCall", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/psi/Call;)V", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "D", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "bindReference", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;)V", "bindResolvedCall", "unresolvedReference", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "", "candidates", "unresolvedReferenceWrongReceiver", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Ljava/util/Collection;)V", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "valueParameter", "noValueForParameter", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)V", "", "resolvedCalls", "ambiguity", "descriptors", "noneApplicable", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "descriptor", "invisibleMember", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;)V", "reportError", "cannotCompleteResolve", "instantiationOfAbstractClass", "abstractSuperCall", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "classDescriptor", "Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;", "explicitReceiverKind", "nestedClassAccessViaInstanceReference", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/resolve/calls/tasks/ExplicitReceiverKind;)V", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "", "isCallForImplicitInvoke", "unsafeCall", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/types/KotlinType;Z)V", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "expectedReceiver", "missingReceiver", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;)V", "receiverParameter", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "c", "wrongReceiverType", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;)V", "noReceiverAllowed", "", "expectedTypeArgumentCount", "wrongNumberOfTypeArguments", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;ILorg/jetbrains/kotlin/descriptors/CallableDescriptor;)V", "context", "Lorg/jetbrains/kotlin/resolve/calls/inference/InferenceErrorData;", "data", "typeInferenceFailed", "(Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lorg/jetbrains/kotlin/resolve/calls/inference/InferenceErrorData;)V", "", "unexpectedError", "(Ljava/lang/String;)V", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "getDelegationCall", "()Lorg/jetbrains/kotlin/psi/KtConstructorDelegationCall;", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationReferenceExpression;", "calleeExpression", "Lorg/jetbrains/kotlin/psi/KtConstructorDelegationReferenceExpression;", "getCalleeExpression", "()Lorg/jetbrains/kotlin/psi/KtConstructorDelegationReferenceExpression;"})
public final class TracingStrategyForImplicitConstructorDelegationCall
extends AbstractTracingStrategy {
    @NotNull
    private final KtConstructorDelegationCall delegationCall;
    @Nullable
    private final KtConstructorDelegationReferenceExpression calleeExpression;

    public TracingStrategyForImplicitConstructorDelegationCall(@NotNull KtConstructorDelegationCall delegationCall, @NotNull Call call2) {
        Intrinsics.checkNotNullParameter(delegationCall, "delegationCall");
        Intrinsics.checkNotNullParameter(call2, "call");
        KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = delegationCall.getCalleeExpression();
        Intrinsics.checkNotNull(ktConstructorDelegationReferenceExpression);
        super(ktConstructorDelegationReferenceExpression, call2);
        this.delegationCall = delegationCall;
        this.calleeExpression = this.delegationCall.getCalleeExpression();
    }

    @NotNull
    public final KtConstructorDelegationCall getDelegationCall() {
        return this.delegationCall;
    }

    @Nullable
    public final KtConstructorDelegationReferenceExpression getCalleeExpression() {
        return this.calleeExpression;
    }

    @Override
    public void bindCall(@NotNull BindingTrace trace, @NotNull Call call2) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(call2, "call");
        trace.record(BindingContext.CALL, call2.getCalleeExpression(), call2);
    }

    @Override
    public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        D d = resolvedCall2.getCandidateDescriptor();
        Intrinsics.checkNotNullExpressionValue(d, "getCandidateDescriptor(...)");
        D descriptor2 = d;
        DeclarationDescriptor storedReference = (DeclarationDescriptor)trace.get(BindingContext.REFERENCE_TARGET, this.calleeExpression);
        if (storedReference == null || !ErrorUtils.isError((DeclarationDescriptor)descriptor2)) {
            trace.record(BindingContext.REFERENCE_TARGET, this.calleeExpression, descriptor2);
        }
    }

    @Override
    public <D extends CallableDescriptor> void bindResolvedCall(@NotNull BindingTrace trace, @NotNull ResolvedCall<D> resolvedCall2) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        trace.record(BindingContext.RESOLVED_CALL, this.call, resolvedCall2);
    }

    @Override
    public void unresolvedReference(@NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        KtConstructorDelegationReferenceExpression ktConstructorDelegationReferenceExpression = this.calleeExpression;
        Intrinsics.checkNotNull(ktConstructorDelegationReferenceExpression);
        trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)ktConstructorDelegationReferenceExpression), this.calleeExpression));
    }

    @Override
    public <D extends CallableDescriptor> void unresolvedReferenceWrongReceiver(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> candidates) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(candidates, "candidates");
        trace.report(Errors.UNRESOLVED_REFERENCE_WRONG_RECEIVER.on(this.reference, candidates));
    }

    @Override
    public void noValueForParameter(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter2) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(valueParameter2, "valueParameter");
        this.reportError(trace);
    }

    @Override
    public <D extends CallableDescriptor> void ambiguity(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> resolvedCalls) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(resolvedCalls, "resolvedCalls");
        this.reportError(trace);
    }

    @Override
    public <D extends CallableDescriptor> void noneApplicable(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(descriptors, "descriptors");
        this.reportError(trace);
    }

    @Override
    public void invisibleMember(@NotNull BindingTrace trace, @NotNull DeclarationDescriptorWithVisibility descriptor2) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.reportError(trace);
    }

    private final void reportError(BindingTrace trace) {
        boolean bl;
        PsiElement reportOn;
        block4: {
            reportOn = CallResolverUtilKt.reportOnElement(this.delegationCall);
            Iterable $this$any$iv = trace.getBindingContext().getDiagnostics().forElement(reportOn);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getFactory(), Errors.EXPLICIT_DELEGATION_CALL_REQUIRED)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (!bl) {
            trace.report(Errors.EXPLICIT_DELEGATION_CALL_REQUIRED.on(reportOn));
        }
    }

    @Override
    public <D extends CallableDescriptor> void cannotCompleteResolve(@NotNull BindingTrace trace, @NotNull Collection<? extends ResolvedCall<D>> descriptors) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(descriptors, "descriptors");
        this.unexpectedError("cannotCompleteResolve");
    }

    @Override
    public void instantiationOfAbstractClass(@NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        this.unexpectedError("instantiationOfAbstractClass");
    }

    @Override
    public void abstractSuperCall(@NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        this.unexpectedError("abstractSuperCall");
    }

    @Override
    public void nestedClassAccessViaInstanceReference(@NotNull BindingTrace trace, @NotNull ClassDescriptor classDescriptor, @NotNull ExplicitReceiverKind explicitReceiverKind) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(classDescriptor, "classDescriptor");
        Intrinsics.checkNotNullParameter((Object)explicitReceiverKind, "explicitReceiverKind");
        this.unexpectedError("nestedClassAccessViaInstanceReference");
    }

    @Override
    public void unsafeCall(@NotNull BindingTrace trace, @NotNull KotlinType type2, boolean isCallForImplicitInvoke) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(type2, "type");
        this.unexpectedError("unsafeCall");
    }

    @Override
    public void missingReceiver(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor expectedReceiver) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(expectedReceiver, "expectedReceiver");
        this.unexpectedError("missingReceiver");
    }

    @Override
    public void wrongReceiverType(@NotNull BindingTrace trace, @NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(receiverParameter, "receiverParameter");
        Intrinsics.checkNotNullParameter(receiverArgument, "receiverArgument");
        Intrinsics.checkNotNullParameter(c, "c");
        this.unexpectedError("wrongReceiverType");
    }

    @Override
    public void noReceiverAllowed(@NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        this.unexpectedError("noReceiverAllowed");
    }

    @Override
    public void wrongNumberOfTypeArguments(@NotNull BindingTrace trace, int expectedTypeArgumentCount, @NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.unexpectedError("wrongNumberOfTypeArguments");
    }

    @Override
    public void typeInferenceFailed(@NotNull ResolutionContext<?> context, @NotNull InferenceErrorData data2) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(data2, "data");
        this.unexpectedError("typeInferenceFailed");
    }

    private final void unexpectedError(String type2) {
        throw new AssertionError((Object)("Unexpected error type: " + type2));
    }
}

