/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tower.AbstractSimpleScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.Candidate;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateFactory;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateWithBoundDispatchReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.MemberScopeTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.TowerData;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003BK\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012$\u0010\u000f\u001a \u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nj\u0002`\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J%\u0010\u001a\u001a\u00020\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\f2\u0006\u0010\u0018\u001a\u00020\u0017H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\t\u001a\u00020\b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\u001f\u001a\u0004\b \u0010!R8\u0010\u000f\u001a \u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\nj\u0002`\u000e8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\"\u001a\u0004\b#\u0010$"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/ExplicitReceiverScopeTowerProcessor;", "Lorg/jetbrains/kotlin/resolve/calls/tower/Candidate;", "C", "Lorg/jetbrains/kotlin/resolve/calls/tower/AbstractSimpleScopeTowerProcessor;", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateFactory;", "context", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "explicitReceiver", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerLevel;", "", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateWithBoundDispatchReceiver;", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidatesCollector;", "collectCandidates", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateFactory;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;Lkotlin/jvm/functions/Function2;)V", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerData;", "data", "simpleProcess", "(Lorg/jetbrains/kotlin/resolve/calls/tower/TowerData;)Ljava/util/Collection;", "skippedData", "Lorg/jetbrains/kotlin/name/Name;", "name", "", "recordLookups", "(Ljava/util/Collection;Lorg/jetbrains/kotlin/name/Name;)V", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "getScopeTower", "()Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "getExplicitReceiver", "()Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "Lkotlin/jvm/functions/Function2;", "getCollectCandidates", "()Lkotlin/jvm/functions/Function2;"})
public final class ExplicitReceiverScopeTowerProcessor<C extends Candidate>
extends AbstractSimpleScopeTowerProcessor<C> {
    @NotNull
    private final ImplicitScopeTower scopeTower;
    @NotNull
    private final ReceiverValueWithSmartCastInfo explicitReceiver;
    @NotNull
    private final Function2<ScopeTowerLevel, ReceiverValueWithSmartCastInfo, Collection<CandidateWithBoundDispatchReceiver>> collectCandidates;

    public ExplicitReceiverScopeTowerProcessor(@NotNull ImplicitScopeTower scopeTower, @NotNull CandidateFactory<? extends C> context, @NotNull ReceiverValueWithSmartCastInfo explicitReceiver, @NotNull Function2<? super ScopeTowerLevel, ? super ReceiverValueWithSmartCastInfo, ? extends Collection<CandidateWithBoundDispatchReceiver>> collectCandidates) {
        Intrinsics.checkNotNullParameter(scopeTower, "scopeTower");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(explicitReceiver, "explicitReceiver");
        Intrinsics.checkNotNullParameter(collectCandidates, "collectCandidates");
        super(context);
        this.scopeTower = scopeTower;
        this.explicitReceiver = explicitReceiver;
        this.collectCandidates = collectCandidates;
    }

    @NotNull
    public final ImplicitScopeTower getScopeTower() {
        return this.scopeTower;
    }

    @NotNull
    public final ReceiverValueWithSmartCastInfo getExplicitReceiver() {
        return this.explicitReceiver;
    }

    @NotNull
    public final Function2<ScopeTowerLevel, ReceiverValueWithSmartCastInfo, Collection<CandidateWithBoundDispatchReceiver>> getCollectCandidates() {
        return this.collectCandidates;
    }

    @Override
    @NotNull
    public Collection<C> simpleProcess(@NotNull TowerData data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        TowerData towerData = data2;
        return Intrinsics.areEqual(towerData, TowerData.Empty.INSTANCE) ? this.createCandidates(this.collectCandidates.invoke(new MemberScopeTowerLevel(this.scopeTower, this.explicitReceiver), null), ExplicitReceiverKind.DISPATCH_RECEIVER, null) : (towerData instanceof TowerData.TowerLevel ? this.createCandidates(this.collectCandidates.invoke(((TowerData.TowerLevel)data2).getLevel(), this.explicitReceiver), ExplicitReceiverKind.EXTENSION_RECEIVER, this.explicitReceiver) : (Collection)CollectionsKt.emptyList());
    }

    @Override
    public void recordLookups(@NotNull Collection<? extends TowerData> skippedData, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(skippedData, "skippedData");
        Intrinsics.checkNotNullParameter(name, "name");
        for (TowerData towerData : skippedData) {
            if (!(towerData instanceof TowerData.TowerLevel)) continue;
            ((TowerData.TowerLevel)towerData).getLevel().recordLookup(name);
        }
    }
}

