/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.calls.tower.AbstractInvokeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.Candidate;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateFactory;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateFactoryProviderForInvoke;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateWithBoundDispatchReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.InvokeExtensionScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.InvokeProcessorsKt;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessorsKt;
import org.jetbrains.kotlin.resolve.calls.tower.TowerData;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B/\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0010\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u000f2\u0006\u0010\u000e\u001a\u00028\u0000H\u0015\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J%\u0010\u001a\u001a\u00020\u00192\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00120\u00172\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001f\u001a\u0004\b \u0010!R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\n8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\""}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/InvokeExtensionTowerProcessor;", "Lorg/jetbrains/kotlin/resolve/calls/tower/Candidate;", "C", "Lorg/jetbrains/kotlin/resolve/calls/tower/AbstractInvokeTowerProcessor;", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "scopeTower", "Lorg/jetbrains/kotlin/name/Name;", "name", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateFactoryProviderForInvoke;", "factoryProviderForInvoke", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "explicitReceiver", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;Lorg/jetbrains/kotlin/name/Name;Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateFactoryProviderForInvoke;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;)V", "variableCandidate", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerProcessor;", "createInvokeProcessor", "(Lorg/jetbrains/kotlin/resolve/calls/tower/Candidate;)Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerProcessor;", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerData;", "data", "", "mayDataBeApplicable", "(Lorg/jetbrains/kotlin/resolve/calls/tower/TowerData;)Z", "", "skippedData", "", "recordLookups", "(Ljava/util/Collection;Lorg/jetbrains/kotlin/name/Name;)V", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "getScopeTower", "()Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;"})
public final class InvokeExtensionTowerProcessor<C extends Candidate>
extends AbstractInvokeTowerProcessor<C> {
    @NotNull
    private final ImplicitScopeTower scopeTower;
    @NotNull
    private final Name name;
    @Nullable
    private final ReceiverValueWithSmartCastInfo explicitReceiver;

    public InvokeExtensionTowerProcessor(@NotNull ImplicitScopeTower scopeTower, @NotNull Name name, @NotNull CandidateFactoryProviderForInvoke<C> factoryProviderForInvoke, @Nullable ReceiverValueWithSmartCastInfo explicitReceiver) {
        Intrinsics.checkNotNullParameter(scopeTower, "scopeTower");
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(factoryProviderForInvoke, "factoryProviderForInvoke");
        super(factoryProviderForInvoke, ScopeTowerProcessorsKt.createVariableAndObjectProcessor$default(scopeTower, name, factoryProviderForInvoke.factoryForVariable(true), null, false, 16, null));
        this.scopeTower = scopeTower;
        this.name = name;
        this.explicitReceiver = explicitReceiver;
    }

    @NotNull
    public final ImplicitScopeTower getScopeTower() {
        return this.scopeTower;
    }

    @NotNull
    public final Name getName() {
        return this.name;
    }

    @Override
    @Nullable
    protected ScopeTowerProcessor<C> createInvokeProcessor(@NotNull C variableCandidate) {
        Intrinsics.checkNotNullParameter(variableCandidate, "variableCandidate");
        Pair pair = this.getFactoryProviderForInvoke().factoryForInvoke(variableCandidate, true);
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        ReceiverValueWithSmartCastInfo variableReceiver = pair2.component1();
        CandidateFactory invokeContext = pair2.component2();
        CandidateWithBoundDispatchReceiver candidateWithBoundDispatchReceiver = InvokeProcessorsKt.access$getExtensionInvokeCandidateDescriptor(this.scopeTower, variableReceiver);
        if (candidateWithBoundDispatchReceiver == null) {
            return null;
        }
        CandidateWithBoundDispatchReceiver invokeDescriptor = candidateWithBoundDispatchReceiver;
        return new InvokeExtensionScopeTowerProcessor(invokeContext, invokeDescriptor, this.explicitReceiver);
    }

    @Override
    protected boolean mayDataBeApplicable(@NotNull TowerData data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        return Intrinsics.areEqual(data2, TowerData.Empty.INSTANCE) || data2 instanceof TowerData.OnlyImplicitReceiver;
    }

    @Override
    public void recordLookups(@NotNull Collection<? extends TowerData> skippedData, @NotNull Name name) {
        Intrinsics.checkNotNullParameter(skippedData, "skippedData");
        Intrinsics.checkNotNullParameter(name, "name");
        this.getVariableProcessor().recordLookups(skippedData, name);
    }
}

