/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.extensions.internal.CandidateInterceptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtAnnotatedExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSafeQualifiedExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.ImplicitIntegerCoercion;
import org.jetbrains.kotlin.resolve.MissingSupertypesResolver;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.StatementFilterKt;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.DiagnosticReporterByTrackingStrategy;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.components.AdditionalDiagnosticReporter;
import org.jetbrains.kotlin.resolve.calls.context.BasicCallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.CallPosition;
import org.jetbrains.kotlin.resolve.calls.inference.DescriptorRelatedInferenceUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.components.NewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.model.AllCandidatesResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.CallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.CompletedCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.ErrorCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallComponents;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallKind;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.PartialCallContainer;
import org.jetbrains.kotlin.resolve.calls.model.PartialCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallableReferenceAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallableReferenceCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.SingleCallResolutionResult;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastManager;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;
import org.jetbrains.kotlin.resolve.calls.tower.NewAbstractResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tower.NewCallableReferenceResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolutionOldInferenceKt;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.tower.NewVariableAsFunctionResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.tower.PSICompletedCallInfo;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCall;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallForInvoke;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallImpl;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallsKt;
import org.jetbrains.kotlin.resolve.calls.tower.PSIPartialCallInfo;
import org.jetbrains.kotlin.resolve.calls.tower.ResolutionDiagnostic;
import org.jetbrains.kotlin.resolve.calls.tower.ResolvedAtomCompleter;
import org.jetbrains.kotlin.resolve.calls.tower.ResolvedUsingDeprecatedVisibility;
import org.jetbrains.kotlin.resolve.calls.tower.TrackingBindingTrace;
import org.jetbrains.kotlin.resolve.calls.tower.VisibilityError;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationResolver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeApproximator;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.error.ErrorScopeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.expressions.DataFlowAnalyzer;
import org.jetbrains.kotlin.types.expressions.DoubleColonExpressionResolver;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContextDelegate;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009c\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u0000 \u0099\u00012\u00020\u0001:\u0002\u0099\u0001B\u00a3\u0001\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0002\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u000f\u0012\u0006\u0010\u0012\u001a\u00020\u0011\u0012\u0006\u0010\u0014\u001a\u00020\u0013\u0012\u0006\u0010\u0016\u001a\u00020\u0015\u0012\u0006\u0010\u0018\u001a\u00020\u0017\u0012\u0006\u0010\u001a\u001a\u00020\u0019\u0012\u0006\u0010\u001c\u001a\u00020\u001b\u0012\u0006\u0010\u001e\u001a\u00020\u001d\u0012\u0006\u0010 \u001a\u00020\u001f\u0012\u0006\u0010\"\u001a\u00020!\u0012\u0006\u0010$\u001a\u00020#\u0012\u0006\u0010&\u001a\u00020%\u00a2\u0006\u0004\b'\u0010(J5\u00101\u001a\b\u0012\u0004\u0012\u00028\u000000\"\b\b\u0000\u0010**\u00020)2\u0006\u0010,\u001a\u00020+2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-H\u0007\u00a2\u0006\u0004\b1\u00102J7\u00109\u001a\b\u0012\u0004\u0012\u00028\u000000\"\b\b\u0000\u0010**\u00020)2\u0006\u00104\u001a\u0002032\u0006\u00106\u001a\u0002052\u0006\u00108\u001a\u000207H\u0007\u00a2\u0006\u0004\b9\u0010:J3\u0010=\u001a\u00020<2\u0006\u00104\u001a\u0002032\u0006\u00106\u001a\u0002052\n\u0010;\u001a\u0006\u0012\u0002\b\u0003002\u0006\u00108\u001a\u000207H\u0002\u00a2\u0006\u0004\b=\u0010>JG\u0010D\u001a\b\u0012\u0004\u0012\u00028\u000000\"\b\b\u0000\u0010**\u00020)2\u0006\u0010?\u001a\u00020+2\u0006\u0010A\u001a\u00020@2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-2\b\u0010C\u001a\u0004\u0018\u00010BH\u0007\u00a2\u0006\u0004\bD\u0010EJK\u0010H\u001a\b\u0012\u0004\u0012\u00028\u000000\"\b\b\u0000\u0010**\u00020)2\u0006\u0010F\u001a\u00020+2\b\u0010A\u001a\u0004\u0018\u00010@2\n\b\u0002\u0010G\u001a\u0004\u0018\u00010B2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-H\u0007\u00a2\u0006\u0004\bH\u0010IJI\u0010K\u001a\b\u0012\u0004\u0012\u00028\u000000\"\b\b\u0000\u0010**\u00020)2\u0006\u0010J\u001a\u00020+2\b\u0010A\u001a\u0004\u0018\u00010@2\b\u0010G\u001a\u0004\u0018\u00010B2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-H\u0002\u00a2\u0006\u0004\bK\u0010IJ!\u0010O\u001a\u00020<2\n\u0010;\u001a\u0006\u0012\u0002\b\u00030L2\u0006\u0010N\u001a\u00020M\u00a2\u0006\u0004\bO\u0010PJ!\u0010Q\u001a\u00020<2\n\u0010;\u001a\u0006\u0012\u0002\b\u00030L2\u0006\u00106\u001a\u000205\u00a2\u0006\u0004\bQ\u0010RJC\u0010Z\u001a\u00020<*\u0002052\n\u0010;\u001a\u0006\u0012\u0002\b\u00030L2\b\u0010T\u001a\u0004\u0018\u00010S2\b\u0010V\u001a\u0004\u0018\u00010U2\u0006\u0010X\u001a\u00020W2\u0006\u0010Y\u001a\u00020WH\u0002\u00a2\u0006\u0004\bZ\u0010[J!\u0010\\\u001a\u00020<2\u0006\u00106\u001a\u0002052\n\u0010;\u001a\u0006\u0012\u0002\b\u000300\u00a2\u0006\u0004\b\\\u0010]J=\u0010f\u001a\u0004\u0018\u00010e2\u0006\u0010_\u001a\u00020^2\b\u0010a\u001a\u0004\u0018\u00010`2\u0006\u00106\u001a\u0002052\b\u0010c\u001a\u0004\u0018\u00010b2\u0006\u0010d\u001a\u00020WH\u0007\u00a2\u0006\u0004\bf\u0010gJ\u001d\u0010k\u001a\u0004\u0018\u00010j2\n\u0010i\u001a\u0006\u0012\u0002\b\u00030hH\u0002\u00a2\u0006\u0004\bk\u0010lJ%\u0010m\u001a\b\u0012\u0002\b\u0003\u0018\u0001002\u0006\u0010_\u001a\u00020^2\u0006\u00106\u001a\u000205H\u0007\u00a2\u0006\u0004\bm\u0010nJ?\u0010s\u001a\u0004\u0018\u00010e2\b\u0010o\u001a\u0004\u0018\u00010e2\b\u0010p\u001a\u0004\u0018\u00010e2\b\u0010q\u001a\u0004\u0018\u00010e2\u0006\u0010r\u001a\u00020^2\u0006\u00106\u001a\u000205H\u0002\u00a2\u0006\u0004\bs\u0010tJ!\u0010w\u001a\u0004\u0018\u00010^2\u0006\u0010_\u001a\u00020^2\u0006\u0010v\u001a\u00020uH\u0002\u00a2\u0006\u0004\bw\u0010xJ\u001f\u0010y\u001a\u00020W2\u0006\u0010_\u001a\u00020^2\u0006\u0010A\u001a\u00020@H\u0002\u00a2\u0006\u0004\by\u0010zJ#\u0010}\u001a\u00020<2\u0006\u0010A\u001a\u00020@2\n\u0010;\u001a\u0006\u0012\u0002\b\u00030LH\u0000\u00a2\u0006\u0004\b{\u0010|J7\u0010~\u001a\u00020<2\u0006\u00106\u001a\u0002052\u0006\u0010A\u001a\u00020@2\n\u0010;\u001a\u0006\u0012\u0002\b\u0003002\f\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-\u00a2\u0006\u0004\b~\u0010\u007fJ%\u0010}\u001a\u00020<2\u0006\u0010A\u001a\u00020@2\u000b\u0010\u0080\u0001\u001a\u0006\u0012\u0002\b\u000300H\u0002\u00a2\u0006\u0005\b}\u0010\u0081\u0001J\"\u0010}\u001a\u00020<2\u0006\u0010A\u001a\u00020@2\b\u0010\u0083\u0001\u001a\u00030\u0082\u0001H\u0002\u00a2\u0006\u0005\b}\u0010\u0084\u0001JC\u0010\u0086\u0001\u001a\u00020<2\u0006\u00106\u001a\u0002052\u0006\u0010A\u001a\u00020@2\n\u0010;\u001a\u0006\u0012\u0002\b\u0003002\u0007\u0010\u0085\u0001\u001a\u00020)2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-\u00a2\u0006\u0006\b\u0086\u0001\u0010\u0087\u0001R\u001b\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u0004\u0010\u0088\u0001R\u001b\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00028\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u0006\u0010\u0088\u0001R\u0015\u0010\b\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\b\u0010\u0089\u0001R\u0015\u0010\n\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\n\u0010\u008a\u0001R\u0015\u0010\f\u001a\u00020\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\f\u0010\u008b\u0001R\u0015\u0010\u000e\u001a\u00020\r8\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u000e\u0010\u008c\u0001R\u0015\u0010\u0010\u001a\u00020\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u0010\u0010\u008d\u0001R\u0015\u0010\u0012\u001a\u00020\u00118\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u0012\u0010\u008e\u0001R\u0015\u0010\u0014\u001a\u00020\u00138\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u0014\u0010\u008f\u0001R\u0015\u0010\u0016\u001a\u00020\u00158\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u0016\u0010\u0090\u0001R\u0015\u0010\u0018\u001a\u00020\u00178\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u0018\u0010\u0091\u0001R\u0015\u0010\u001a\u001a\u00020\u00198\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u001a\u0010\u0092\u0001R\u0015\u0010\u001c\u001a\u00020\u001b8\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u001c\u0010\u0093\u0001R\u0015\u0010\u001e\u001a\u00020\u001d8\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u001e\u0010\u0094\u0001R\u0015\u0010 \u001a\u00020\u001f8\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b \u0010\u0095\u0001R\u0015\u0010\"\u001a\u00020!8\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\"\u0010\u0096\u0001R\u0015\u0010$\u001a\u00020#8\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b$\u0010\u0097\u0001R\u0015\u0010&\u001a\u00020%8\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b&\u0010\u0098\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/KotlinToResolvedCallTransformer;", "", "", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "callCheckers", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "additionalTypeCheckers", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "dataFlowAnalyzer", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "argumentTypeResolver", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "deprecationResolver", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/DoubleColonExpressionResolver;", "doubleColonExpressionResolver", "Lorg/jetbrains/kotlin/resolve/calls/components/AdditionalDiagnosticReporter;", "additionalDiagnosticReporter", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleDescriptor", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "builtIns", "Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContextDelegate;", "typeSystemContext", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager;", "smartCastManager", "Lorg/jetbrains/kotlin/types/TypeApproximator;", "typeApproximator", "Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;", "missingSupertypesResolver", "Lorg/jetbrains/kotlin/extensions/internal/CandidateInterceptor;", "candidateInterceptor", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "callComponents", "<init>", "(Ljava/lang/Iterable;Ljava/lang/Iterable;Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/types/expressions/DoubleColonExpressionResolver;Lorg/jetbrains/kotlin/resolve/calls/components/AdditionalDiagnosticReporter;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContextDelegate;Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager;Lorg/jetbrains/kotlin/types/TypeApproximator;Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;Lorg/jetbrains/kotlin/extensions/internal/CandidateInterceptor;Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;)V", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "D", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;", "resolvedCallAtom", "", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "diagnostics", "Lorg/jetbrains/kotlin/resolve/calls/tower/NewAbstractResolvedCall;", "onlyTransform", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;Ljava/util/Collection;)Lorg/jetbrains/kotlin/resolve/calls/tower/NewAbstractResolvedCall;", "Lorg/jetbrains/kotlin/resolve/calls/model/CallResolutionResult;", "baseResolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;", "context", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "tracingStrategy", "transformAndReport", "(Lorg/jetbrains/kotlin/resolve/calls/model/CallResolutionResult;Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;)Lorg/jetbrains/kotlin/resolve/calls/tower/NewAbstractResolvedCall;", "resolvedCall", "", "forwardCallToInferenceSession", "(Lorg/jetbrains/kotlin/resolve/calls/model/CallResolutionResult;Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;Lorg/jetbrains/kotlin/resolve/calls/tower/NewAbstractResolvedCall;Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;)V", "candidate", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/NewTypeSubstitutor;", "substitutor", "createStubResolvedCallAndWriteItToTrace", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;Lorg/jetbrains/kotlin/resolve/BindingTrace;Ljava/util/Collection;Lorg/jetbrains/kotlin/resolve/calls/inference/components/NewTypeSubstitutor;)Lorg/jetbrains/kotlin/resolve/calls/tower/NewAbstractResolvedCall;", "completedCallAtom", "resultSubstitutor", "transformToResolvedCall", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/calls/inference/components/NewTypeSubstitutor;Ljava/util/Collection;)Lorg/jetbrains/kotlin/resolve/calls/tower/NewAbstractResolvedCall;", "completedSimpleAtom", "createOrGet", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "callCheckerContext", "runCallCheckers", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "runAdditionalReceiversCheckers", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;)V", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverParameter", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "receiverArgument", "", "isExplicitReceiver", "implicitInvokeCheck", "checkReceiver", "(Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;ZZ)V", "runArgumentsChecks", "(Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;Lorg/jetbrains/kotlin/resolve/calls/tower/NewAbstractResolvedCall;)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameter", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "convertedArgumentType", "reportErrorForTypeMismatch", "Lorg/jetbrains/kotlin/types/KotlinType;", "updateRecordedType", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;Lorg/jetbrains/kotlin/types/UnwrappedType;Z)Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "constant", "Lorg/jetbrains/kotlin/types/SimpleType;", "createTypeForConvertableConstant", "(Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;)Lorg/jetbrains/kotlin/types/SimpleType;", "getResolvedCallForArgumentExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;)Lorg/jetbrains/kotlin/resolve/calls/tower/NewAbstractResolvedCall;", "updatedType", "recordedType", "recordedTypeForParenthesized", "argumentExpression", "updateRecordedTypeForArgument", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;)Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "statementFilter", "deparenthesizeOrGetSelector", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/StatementFilter;)Lorg/jetbrains/kotlin/psi/KtExpression;", "hasNecessarySafeCall", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;)Z", "bind$frontend", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;)V", "bind", "reportDiagnostics", "(Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/calls/tower/NewAbstractResolvedCall;Ljava/util/Collection;)V", "simpleResolvedCall", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/calls/tower/NewAbstractResolvedCall;)V", "Lorg/jetbrains/kotlin/resolve/calls/tower/NewVariableAsFunctionResolvedCallImpl;", "variableAsFunction", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/calls/tower/NewVariableAsFunctionResolvedCallImpl;)V", "resultingDescriptor", "reportCallDiagnostic", "(Lorg/jetbrains/kotlin/resolve/calls/context/BasicCallResolutionContext;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/calls/tower/NewAbstractResolvedCall;Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Ljava/util/Collection;)V", "Ljava/lang/Iterable;", "Lorg/jetbrains/kotlin/types/expressions/DataFlowAnalyzer;", "Lorg/jetbrains/kotlin/resolve/calls/ArgumentTypeResolver;", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationResolver;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "Lorg/jetbrains/kotlin/types/expressions/DoubleColonExpressionResolver;", "Lorg/jetbrains/kotlin/resolve/calls/components/AdditionalDiagnosticReporter;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "Lorg/jetbrains/kotlin/types/model/TypeSystemInferenceExtensionContextDelegate;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager;", "Lorg/jetbrains/kotlin/types/TypeApproximator;", "Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;", "Lorg/jetbrains/kotlin/extensions/internal/CandidateInterceptor;", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallComponents;", "Companion"})
public final class KotlinToResolvedCallTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Iterable<CallChecker> callCheckers;
    @NotNull
    private final Iterable<AdditionalTypeChecker> additionalTypeCheckers;
    @NotNull
    private final DataFlowAnalyzer dataFlowAnalyzer;
    @NotNull
    private final ArgumentTypeResolver argumentTypeResolver;
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final DeprecationResolver deprecationResolver;
    @NotNull
    private final ExpressionTypingServices expressionTypingServices;
    @NotNull
    private final DoubleColonExpressionResolver doubleColonExpressionResolver;
    @NotNull
    private final AdditionalDiagnosticReporter additionalDiagnosticReporter;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final DataFlowValueFactory dataFlowValueFactory;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @NotNull
    private final TypeSystemInferenceExtensionContextDelegate typeSystemContext;
    @NotNull
    private final SmartCastManager smartCastManager;
    @NotNull
    private final TypeApproximator typeApproximator;
    @NotNull
    private final MissingSupertypesResolver missingSupertypesResolver;
    @NotNull
    private final CandidateInterceptor candidateInterceptor;
    @NotNull
    private final KotlinCallComponents callComponents;

    public KotlinToResolvedCallTransformer(@NotNull Iterable<? extends CallChecker> callCheckers, @NotNull Iterable<? extends AdditionalTypeChecker> additionalTypeCheckers, @NotNull DataFlowAnalyzer dataFlowAnalyzer2, @NotNull ArgumentTypeResolver argumentTypeResolver, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull DeprecationResolver deprecationResolver, @NotNull ExpressionTypingServices expressionTypingServices, @NotNull DoubleColonExpressionResolver doubleColonExpressionResolver, @NotNull AdditionalDiagnosticReporter additionalDiagnosticReporter, @NotNull ModuleDescriptor moduleDescriptor, @NotNull DataFlowValueFactory dataFlowValueFactory, @NotNull KotlinBuiltIns builtIns, @NotNull TypeSystemInferenceExtensionContextDelegate typeSystemContext2, @NotNull SmartCastManager smartCastManager, @NotNull TypeApproximator typeApproximator, @NotNull MissingSupertypesResolver missingSupertypesResolver, @NotNull CandidateInterceptor candidateInterceptor, @NotNull KotlinCallComponents callComponents) {
        Intrinsics.checkNotNullParameter(callCheckers, "callCheckers");
        Intrinsics.checkNotNullParameter(additionalTypeCheckers, "additionalTypeCheckers");
        Intrinsics.checkNotNullParameter(dataFlowAnalyzer2, "dataFlowAnalyzer");
        Intrinsics.checkNotNullParameter(argumentTypeResolver, "argumentTypeResolver");
        Intrinsics.checkNotNullParameter(constantExpressionEvaluator, "constantExpressionEvaluator");
        Intrinsics.checkNotNullParameter(deprecationResolver, "deprecationResolver");
        Intrinsics.checkNotNullParameter(expressionTypingServices, "expressionTypingServices");
        Intrinsics.checkNotNullParameter(doubleColonExpressionResolver, "doubleColonExpressionResolver");
        Intrinsics.checkNotNullParameter(additionalDiagnosticReporter, "additionalDiagnosticReporter");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(dataFlowValueFactory, "dataFlowValueFactory");
        Intrinsics.checkNotNullParameter(builtIns, "builtIns");
        Intrinsics.checkNotNullParameter(typeSystemContext2, "typeSystemContext");
        Intrinsics.checkNotNullParameter(smartCastManager, "smartCastManager");
        Intrinsics.checkNotNullParameter(typeApproximator, "typeApproximator");
        Intrinsics.checkNotNullParameter(missingSupertypesResolver, "missingSupertypesResolver");
        Intrinsics.checkNotNullParameter(candidateInterceptor, "candidateInterceptor");
        Intrinsics.checkNotNullParameter(callComponents, "callComponents");
        this.callCheckers = callCheckers;
        this.additionalTypeCheckers = additionalTypeCheckers;
        this.dataFlowAnalyzer = dataFlowAnalyzer2;
        this.argumentTypeResolver = argumentTypeResolver;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.deprecationResolver = deprecationResolver;
        this.expressionTypingServices = expressionTypingServices;
        this.doubleColonExpressionResolver = doubleColonExpressionResolver;
        this.additionalDiagnosticReporter = additionalDiagnosticReporter;
        this.moduleDescriptor = moduleDescriptor;
        this.dataFlowValueFactory = dataFlowValueFactory;
        this.builtIns = builtIns;
        this.typeSystemContext = typeSystemContext2;
        this.smartCastManager = smartCastManager;
        this.typeApproximator = typeApproximator;
        this.missingSupertypesResolver = missingSupertypesResolver;
        this.candidateInterceptor = candidateInterceptor;
        this.callComponents = callComponents;
    }

    @NotNull
    public final <D extends CallableDescriptor> NewAbstractResolvedCall<D> onlyTransform(@NotNull ResolvedCallAtom resolvedCallAtom, @NotNull Collection<? extends KotlinCallDiagnostic> diagnostics) {
        Intrinsics.checkNotNullParameter(resolvedCallAtom, "resolvedCallAtom");
        Intrinsics.checkNotNullParameter(diagnostics, "diagnostics");
        return this.transformToResolvedCall(resolvedCallAtom, null, null, diagnostics);
    }

    @NotNull
    public final <D extends CallableDescriptor> NewAbstractResolvedCall<D> transformAndReport(@NotNull CallResolutionResult baseResolvedCall, @NotNull BasicCallResolutionContext context, @NotNull TracingStrategy tracingStrategy) {
        NewAbstractResolvedCall<Object> newAbstractResolvedCall;
        Intrinsics.checkNotNullParameter(baseResolvedCall, "baseResolvedCall");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(tracingStrategy, "tracingStrategy");
        CallResolutionResult callResolutionResult = baseResolvedCall;
        if (callResolutionResult instanceof PartialCallResolutionResult) {
            ResolvedCallAtom candidate = ((PartialCallResolutionResult)baseResolvedCall).getResultCallAtom();
            Call psiCall = Companion.keyForPartiallyResolvedCall(candidate);
            context.trace.record(BindingContext.ONLY_RESOLVED_CALL, psiCall, new PartialCallContainer((PartialCallResolutionResult)baseResolvedCall));
            context.trace.record(BindingContext.PARTIAL_CALL_RESOLUTION_CONTEXT, psiCall, context);
            if (((PartialCallResolutionResult)baseResolvedCall).getForwardToInferenceSession()) {
                context.inferenceSession.addPartialCallInfo(new PSIPartialCallInfo((PartialCallResolutionResult)baseResolvedCall, context, tracingStrategy));
            }
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
            newAbstractResolvedCall = this.createStubResolvedCallAndWriteItToTrace(candidate, bindingTrace, (Collection<? extends KotlinCallDiagnostic>)baseResolvedCall.getDiagnostics(), null);
        } else if (callResolutionResult instanceof CompletedCallResolutionResult || callResolutionResult instanceof ErrorCallResolutionResult) {
            ResolvedCallAtom candidate = ((SingleCallResolutionResult)baseResolvedCall).getResultCallAtom();
            NewTypeSubstitutor resultSubstitutor = DescriptorRelatedInferenceUtilsKt.buildResultingSubstitutor$default(baseResolvedCall.getConstraintSystem().getBuilder().currentStorage(), this.typeSystemContext, false, 2, null);
            if (context.inferenceSession.writeOnlyStubs((SingleCallResolutionResult)baseResolvedCall)) {
                BindingTrace bindingTrace = context.trace;
                Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
                NewAbstractResolvedCall<D> stub2 = this.createStubResolvedCallAndWriteItToTrace(candidate, bindingTrace, (Collection<? extends KotlinCallDiagnostic>)baseResolvedCall.getDiagnostics(), resultSubstitutor);
                this.forwardCallToInferenceSession(baseResolvedCall, context, stub2, tracingStrategy);
                Intrinsics.checkNotNull(stub2, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.tower.NewAbstractResolvedCall<D of org.jetbrains.kotlin.resolve.calls.tower.KotlinToResolvedCallTransformer.transformAndReport>");
                return stub2;
            }
            ResolvedAtomCompleter ktPrimitiveCompleter = new ResolvedAtomCompleter(resultSubstitutor, context, this, this.expressionTypingServices, this.argumentTypeResolver, this.doubleColonExpressionResolver, this.builtIns, this.deprecationResolver, this.moduleDescriptor, this.dataFlowValueFactory, this.typeApproximator, this.missingSupertypesResolver, this.callComponents);
            if (context.inferenceSession.shouldCompleteResolvedSubAtomsOf(candidate)) {
                List<ResolvedAtom> list = candidate.getSubResolvedAtoms();
                if (list != null) {
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ResolvedAtom subKtPrimitive = (ResolvedAtom)element$iv;
                        boolean bl = false;
                        ktPrimitiveCompleter.completeAll(subKtPrimitive);
                    }
                }
            }
            NewAbstractResolvedCall<?> newAbstractResolvedCall2 = ktPrimitiveCompleter.completeResolvedCall(candidate, (Collection<? extends KotlinCallDiagnostic>)baseResolvedCall.completedDiagnostic(resultSubstitutor));
            Intrinsics.checkNotNull(newAbstractResolvedCall2, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.tower.NewAbstractResolvedCall<D of org.jetbrains.kotlin.resolve.calls.tower.KotlinToResolvedCallTransformer.transformAndReport>");
            NewAbstractResolvedCall<?> resolvedCall2 = newAbstractResolvedCall2;
            this.forwardCallToInferenceSession(baseResolvedCall, context, resolvedCall2, tracingStrategy);
            newAbstractResolvedCall = resolvedCall2;
        } else {
            if (callResolutionResult instanceof SingleCallResolutionResult) {
                throw new IllegalStateException(("Call resolution result for one candidate didn't transformed: " + baseResolvedCall).toString());
            }
            if (callResolutionResult instanceof AllCandidatesResolutionResult) {
                throw new IllegalStateException("Cannot transform result for ALL_CANDIDATES mode".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return newAbstractResolvedCall;
    }

    private final void forwardCallToInferenceSession(CallResolutionResult baseResolvedCall, BasicCallResolutionContext context, NewAbstractResolvedCall<?> resolvedCall2, TracingStrategy tracingStrategy) {
        if (baseResolvedCall instanceof CompletedCallResolutionResult) {
            context.inferenceSession.addCompletedCallInfo(new PSICompletedCallInfo((CompletedCallResolutionResult)baseResolvedCall, context, resolvedCall2, tracingStrategy));
        }
    }

    @NotNull
    public final <D extends CallableDescriptor> NewAbstractResolvedCall<D> createStubResolvedCallAndWriteItToTrace(@NotNull ResolvedCallAtom candidate, @NotNull BindingTrace trace, @NotNull Collection<? extends KotlinCallDiagnostic> diagnostics, @Nullable NewTypeSubstitutor substitutor2) {
        Intrinsics.checkNotNullParameter(candidate, "candidate");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(diagnostics, "diagnostics");
        NewAbstractResolvedCall<D> result2 = this.transformToResolvedCall(candidate, trace, substitutor2, diagnostics);
        PSIKotlinCall psiKotlinCall = PSIKotlinCallsKt.getPsiKotlinCall(candidate.getAtom());
        Object object = psiKotlinCall instanceof PSIKotlinCallForInvoke ? (PSIKotlinCallForInvoke)psiKotlinCall : null;
        if (object == null || (object = ((PSIKotlinCallForInvoke)object).getBaseCall()) == null || (object = ((PSIKotlinCallImpl)object).getTracingStrategy()) == null) {
            object = psiKotlinCall.getTracingStrategy();
        }
        Object tracing = object;
        tracing.bindReference(trace, result2);
        tracing.bindResolvedCall(trace, result2);
        return result2;
    }

    @NotNull
    public final <D extends CallableDescriptor> NewAbstractResolvedCall<D> transformToResolvedCall(@NotNull ResolvedCallAtom completedCallAtom, @Nullable BindingTrace trace, @Nullable NewTypeSubstitutor resultSubstitutor, @NotNull Collection<? extends KotlinCallDiagnostic> diagnostics) {
        NewAbstractResolvedCall newAbstractResolvedCall;
        Intrinsics.checkNotNullParameter(completedCallAtom, "completedCallAtom");
        Intrinsics.checkNotNullParameter(diagnostics, "diagnostics");
        PSIKotlinCall psiKotlinCall = PSIKotlinCallsKt.getPsiKotlinCall(completedCallAtom.getAtom());
        completedCallAtom.setCandidateDescriptor(this.candidateInterceptor.interceptResolvedCallAtomCandidate(completedCallAtom.getCandidateDescriptor(), completedCallAtom, trace, resultSubstitutor, diagnostics));
        if (psiKotlinCall instanceof PSIKotlinCallForInvoke) {
            Collection diagnosticsForVariableCall = completedCallAtom.getCandidateDescriptor() instanceof FunctionDescriptor ? (Collection)CollectionsKt.emptyList() : diagnostics;
            Collection diagnosticsForFunctionCall = completedCallAtom.getCandidateDescriptor() instanceof FunctionDescriptor ? diagnostics : (Collection)CollectionsKt.emptyList();
            newAbstractResolvedCall = new NewVariableAsFunctionResolvedCallImpl(this.createOrGet(((PSIKotlinCallForInvoke)psiKotlinCall).getVariableCall().getResolvedCall(), trace, resultSubstitutor, diagnosticsForVariableCall), this.createOrGet(completedCallAtom, trace, resultSubstitutor, diagnosticsForFunctionCall));
        } else {
            newAbstractResolvedCall = this.createOrGet(completedCallAtom, trace, resultSubstitutor, diagnostics);
        }
        return newAbstractResolvedCall;
    }

    public static /* synthetic */ NewAbstractResolvedCall transformToResolvedCall$default(KotlinToResolvedCallTransformer kotlinToResolvedCallTransformer, ResolvedCallAtom resolvedCallAtom, BindingTrace bindingTrace, NewTypeSubstitutor newTypeSubstitutor, Collection collection, int n, Object object) {
        if ((n & 4) != 0) {
            newTypeSubstitutor = null;
        }
        return kotlinToResolvedCallTransformer.transformToResolvedCall(resolvedCallAtom, bindingTrace, newTypeSubstitutor, collection);
    }

    private final <D extends CallableDescriptor> NewAbstractResolvedCall<D> createOrGet(ResolvedCallAtom completedSimpleAtom, BindingTrace trace, NewTypeSubstitutor resultSubstitutor, Collection<? extends KotlinCallDiagnostic> diagnostics) {
        NewAbstractResolvedCall newAbstractResolvedCall;
        NewResolvedCallImpl storedResolvedCall;
        if (trace != null && (storedResolvedCall = PSIKotlinCallsKt.getResolvedPsiKotlinCall(PSIKotlinCallsKt.getPsiKotlinCall(completedSimpleAtom.getAtom()), trace)) != null) {
            storedResolvedCall.setResultingSubstitutor(resultSubstitutor);
            storedResolvedCall.updateDiagnostics(diagnostics);
            return storedResolvedCall;
        }
        if (completedSimpleAtom.getAtom().getCallKind() == KotlinCallKind.CALLABLE_REFERENCE) {
            Intrinsics.checkNotNull(completedSimpleAtom, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.ResolvedCallableReferenceCallAtom");
            ResolvedCallableReferenceAtom resolvedCallableReferenceAtom = (ResolvedCallableReferenceCallAtom)completedSimpleAtom;
            LanguageVersionSettings languageVersionSettings = this.expressionTypingServices.getLanguageVersionSettings();
            Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "getLanguageVersionSettings(...)");
            newAbstractResolvedCall = new NewCallableReferenceResolvedCall(resolvedCallableReferenceAtom, this.typeApproximator, languageVersionSettings, resultSubstitutor);
        } else {
            LanguageVersionSettings languageVersionSettings = this.expressionTypingServices.getLanguageVersionSettings();
            Intrinsics.checkNotNullExpressionValue(languageVersionSettings, "getLanguageVersionSettings(...)");
            newAbstractResolvedCall = new NewResolvedCallImpl(completedSimpleAtom, resultSubstitutor, diagnostics, this.typeApproximator, languageVersionSettings);
        }
        return newAbstractResolvedCall;
    }

    public final void runCallCheckers(@NotNull ResolvedCall<?> resolvedCall2, @NotNull CallCheckerContext callCheckerContext) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(callCheckerContext, "callCheckerContext");
        KtExpression calleeExpression = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? ((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall().getCall().getCalleeExpression() : resolvedCall2.getCall().getCalleeExpression();
        KtElement ktElement = calleeExpression != null && !CallUtilKt.isFakeElement(calleeExpression) ? (KtElement)calleeExpression : resolvedCall2.getCall().getCallElement();
        Intrinsics.checkNotNull(ktElement);
        KtElement reportOn = ktElement;
        for (CallChecker callChecker : this.callCheckers) {
            callChecker.check(resolvedCall2, reportOn, callCheckerContext);
            if (!(resolvedCall2 instanceof VariableAsFunctionResolvedCall)) continue;
            callChecker.check(((VariableAsFunctionResolvedCall)((Object)resolvedCall2)).getVariableCall(), reportOn, callCheckerContext);
        }
    }

    public final void runAdditionalReceiversCheckers(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BasicCallResolutionContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(context, "context");
        this.checkReceiver(context, resolvedCall2, resolvedCall2.getResultingDescriptor().getExtensionReceiverParameter(), resolvedCall2.getExtensionReceiver(), resolvedCall2.getExplicitReceiverKind().isExtensionReceiver(), false);
        this.checkReceiver(context, resolvedCall2, resolvedCall2.getResultingDescriptor().getDispatchReceiverParameter(), resolvedCall2.getDispatchReceiver(), resolvedCall2.getExplicitReceiverKind().isDispatchReceiver(), context.call instanceof CallTransformer.CallForImplicitInvoke);
    }

    private final void checkReceiver(BasicCallResolutionContext $this$checkReceiver, ResolvedCall<?> resolvedCall2, ReceiverParameterDescriptor receiverParameter, ReceiverValue receiverArgument, boolean isExplicitReceiver, boolean implicitInvokeCheck) {
        if (receiverParameter == null || receiverArgument == null) {
            return;
        }
        boolean safeAccess = isExplicitReceiver && !implicitInvokeCheck && resolvedCall2.getCall().isSemanticallyEquivalentToSafeCall();
        Iterable<AdditionalTypeChecker> $this$forEach$iv = this.additionalTypeCheckers;
        boolean $i$f$forEach = false;
        Iterator<AdditionalTypeChecker> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            AdditionalTypeChecker element$iv;
            AdditionalTypeChecker it = element$iv = iterator2.next();
            boolean bl = false;
            it.checkReceiver(receiverParameter, receiverArgument, safeAccess, $this$checkReceiver);
        }
    }

    public final void runArgumentsChecks(@NotNull BasicCallResolutionContext context, @NotNull NewAbstractResolvedCall<?> resolvedCall2) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        if (!(resolvedCall2 instanceof NewResolvedCallImpl)) {
            return;
        }
        for (ValueArgument valueArgument : ((NewResolvedCallImpl)resolvedCall2).getCall().getValueArguments()) {
            KtExpression argumentExpression;
            Pair<KotlinType, CallPosition.ValueArgumentPosition> pair;
            NewResolvedCallImpl newResolvedCallImpl = (NewResolvedCallImpl)resolvedCall2;
            ValueArgument valueArgument2 = valueArgument;
            Intrinsics.checkNotNull(valueArgument2);
            ArgumentMapping argumentMapping2 = newResolvedCallImpl.getArgumentMapping(valueArgument2);
            ValueParameterDescriptor parameter = null;
            if (argumentMapping2 instanceof ArgumentMatch) {
                KotlinType kotlinType;
                parameter = ((ArgumentMatch)argumentMapping2).getValueParameter();
                UnwrappedType unwrappedType = ((NewResolvedCallImpl)resolvedCall2).getExpectedTypeForUnitConvertedArgument(valueArgument);
                if (unwrappedType != null) {
                    kotlinType = unwrappedType;
                } else {
                    UnwrappedType unwrappedType2 = ((NewResolvedCallImpl)resolvedCall2).getExpectedTypeForSuspendConvertedArgument(valueArgument);
                    if (unwrappedType2 != null) {
                        kotlinType = unwrappedType2;
                    } else {
                        UnwrappedType unwrappedType3 = ((NewResolvedCallImpl)resolvedCall2).getExpectedTypeForSamConvertedArgument(valueArgument);
                        kotlinType = unwrappedType3 != null ? (KotlinType)unwrappedType3 : CallResolverUtilKt.getEffectiveExpectedType(((ArgumentMatch)argumentMapping2).getValueParameter(), valueArgument, context);
                    }
                }
                KotlinType expectedType = kotlinType;
                pair = new Pair<KotlinType, CallPosition.ValueArgumentPosition>(expectedType, new CallPosition.ValueArgumentPosition((ResolvedCall)resolvedCall2, ((ArgumentMatch)argumentMapping2).getValueParameter(), valueArgument));
            } else {
                parameter = null;
                pair = new Pair<KotlinType, CallPosition.ValueArgumentPosition>(TypeUtils.NO_EXPECTED_TYPE, (CallPosition.ValueArgumentPosition)((Object)CallPosition.Unknown.INSTANCE));
            }
            Pair<KotlinType, CallPosition.ValueArgumentPosition> pair2 = pair;
            KotlinType expectedType = pair2.component1();
            CallPosition callPosition = pair2.component2();
            Object Context2 = ((BasicCallResolutionContext)((BasicCallResolutionContext)context.replaceDataFlowInfo(((NewResolvedCallImpl)resolvedCall2).getDataFlowInfoForArguments().getInfo(valueArgument))).replaceExpectedType(expectedType)).replaceCallPosition(callPosition);
            Intrinsics.checkNotNullExpressionValue(Context2, "replaceCallPosition(...)");
            BasicCallResolutionContext newContext = (BasicCallResolutionContext)Context2;
            IntegerValueTypeConstant constantConvertedArgument = ((NewResolvedCallImpl)resolvedCall2).getArgumentTypeForConstantConvertedArgument(valueArgument);
            if (valueArgument.getArgumentExpression() == null) continue;
            if (constantConvertedArgument != null) {
                context.trace.record(BindingContext.COMPILE_TIME_VALUE, argumentExpression, constantConvertedArgument);
                BindingContextUtils.updateRecordedType(constantConvertedArgument.getUnknownIntegerType(), argumentExpression, context.trace, false);
            }
            if (valueArgument.isExternal()) continue;
            Object object = constantConvertedArgument;
            this.updateRecordedType(argumentExpression, parameter, newContext, object != null && (object = ((IntegerValueTypeConstant)object).getUnknownIntegerType()) != null ? ((UnwrappedType)object).unwrap() : null, ArgumentMappingKt.isReallySuccess((ResolvedCall)resolvedCall2));
        }
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final KotlinType updateRecordedType(@NotNull KtExpression expression, @Nullable ValueParameterDescriptor parameter, @NotNull BasicCallResolutionContext context, @Nullable UnwrappedType convertedArgumentType, boolean reportErrorForTypeMismatch) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        it = expression;
        $i$a$-let-KotlinToResolvedCallTransformer$updateRecordedType$deparenthesized$1 = false;
        v0 = KtPsiUtil.getLastElementDeparenthesized(it, context.statementFilter);
        if (v0 == null) {
            return null;
        }
        deparenthesized = v0;
        recordedType = context.trace.getType(deparenthesized);
        recordedTypeForParenthesized = context.trace.getType(expression);
        v1 = convertedArgumentType;
        if (v1 != null) {
            v2 = v1;
        } else {
            v3 = this.getResolvedCallForArgumentExpression(deparenthesized, context);
            if (v3 != null) {
                $this$updateRecordedType_u24lambda_u243 = v3;
                $i$a$-run-KotlinToResolvedCallTransformer$updateRecordedType$updatedType$1 = false;
                v4 = ResolvedCallUtilKt.makeNullableTypeIfSafeReceiver((ResolvedCall)$this$updateRecordedType_u24lambda_u243, $this$updateRecordedType_u24lambda_u243.getResultingDescriptor().getReturnType(), context);
            } else {
                v4 = v2 = null;
            }
            if (v4 == null) {
                v2 = updatedType = recordedType;
            }
        }
        if (recordedType != null && !recordedType.getConstructor().isDenotable()) {
            v5 = this.argumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context, deparenthesized);
            if (v5 == null) {
                v5 = updatedType;
            }
            updatedType = v5;
        }
        reportErrorDuringTypeCheck = reportErrorForTypeMismatch;
        if (parameter == null) ** GOTO lbl-1000
        v6 = parameter;
        v7 = context.languageVersionSettings;
        Intrinsics.checkNotNullExpressionValue(v7, "languageVersionSettings");
        if (ImplicitIntegerCoercion.INSTANCE.isEnabledFor(v6, v7)) {
            argumentCompileTimeValue = (CompileTimeConstant)context.trace.get(BindingContext.COMPILE_TIME_VALUE, deparenthesized);
            if (argumentCompileTimeValue != null && argumentCompileTimeValue.getParameters().isConvertableConstVal() && (generalNumberType = this.createTypeForConvertableConstant(argumentCompileTimeValue)) != null) {
                updatedType = this.argumentTypeResolver.updateResultArgumentTypeIfNotDenotable(context.trace, context.statementFilter, context.expectedType, generalNumberType, expression);
                reportErrorDuringTypeCheck = true;
            }
        } else if (convertedArgumentType != null) {
            context.trace.report(Errors.SIGNED_CONSTANT_CONVERTED_TO_UNSIGNED.on((KtExpression)((PsiElement)deparenthesized)));
        }
        updatedType = this.updateRecordedTypeForArgument(updatedType, recordedType, recordedTypeForParenthesized, expression, context);
        this.dataFlowAnalyzer.checkType(updatedType, deparenthesized, context, reportErrorDuringTypeCheck);
        return updatedType;
    }

    private final SimpleType createTypeForConvertableConstant(CompileTimeConstant<?> constant) {
        SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
        Intrinsics.checkNotNullExpressionValue(simpleType2, "NO_EXPECTED_TYPE");
        Object object = constant.getValue(simpleType2);
        Number number = object instanceof Number ? (Number)((Number)object) : (Number)null;
        if (number == null) {
            return null;
        }
        long value2 = number.longValue();
        IntegerLiteralTypeConstructor typeConstructor2 = new IntegerLiteralTypeConstructor(value2, this.moduleDescriptor, constant.getParameters());
        object = new String[]{typeConstructor2.toString()};
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(TypeAttributes.Companion.getEmpty(), typeConstructor2, CollectionsKt.emptyList(), false, ErrorUtils.createErrorScope(ErrorScopeKind.INTEGER_LITERAL_TYPE_SCOPE, true, object));
    }

    @Nullable
    public final NewAbstractResolvedCall<?> getResolvedCallForArgumentExpression(@NotNull KtExpression expression, @NotNull BasicCallResolutionContext context) {
        NewAbstractResolvedCall newAbstractResolvedCall;
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!ExpressionTypingUtils.dependsOnExpectedType(expression)) {
            newAbstractResolvedCall = null;
        } else {
            KtElement ktElement = expression;
            BindingContext bindingContext = context.trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
            newAbstractResolvedCall = resolvedCall2 instanceof NewAbstractResolvedCall ? (NewAbstractResolvedCall)resolvedCall2 : null;
        }
        return newAbstractResolvedCall;
    }

    private final KotlinType updateRecordedTypeForArgument(KotlinType updatedType, KotlinType recordedType, KotlinType recordedTypeForParenthesized, KtExpression argumentExpression, BasicCallResolutionContext context) {
        ArrayList<KtExpression> arrayList;
        if (!ErrorUtils.INSTANCE.containsErrorType(recordedType) && Intrinsics.areEqual(recordedType, updatedType) && Intrinsics.areEqual(recordedType, recordedTypeForParenthesized) || updatedType == null) {
            return updatedType;
        }
        ArrayList<KtExpression> expressions = arrayList = new ArrayList<KtExpression>();
        boolean bl = false;
        KtExpression expression = argumentExpression;
        while (expression != null) {
            expressions.add(expression);
            StatementFilter statementFilter = context.statementFilter;
            Intrinsics.checkNotNullExpressionValue(statementFilter, "statementFilter");
            expression = this.deparenthesizeOrGetSelector(expression, statementFilter);
        }
        CollectionsKt.reverse((List)expressions);
        ArrayList<KtExpression> expressions2 = arrayList;
        boolean shouldBeMadeNullable = false;
        Iterator iterator2 = expressions2.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, "iterator(...)");
        Iterator iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, "next(...)");
            KtExpression expression2 = (KtExpression)e;
            if (!(expression2 instanceof KtParenthesizedExpression || expression2 instanceof KtLabeledExpression || expression2 instanceof KtAnnotatedExpression)) {
                BindingTrace bindingTrace = context.trace;
                Intrinsics.checkNotNullExpressionValue(bindingTrace, "trace");
                shouldBeMadeNullable = this.hasNecessarySafeCall(expression2, bindingTrace);
            }
            BindingContextUtils.updateRecordedType(updatedType, expression2, context.trace, shouldBeMadeNullable);
        }
        return context.trace.getType(argumentExpression);
    }

    private final KtExpression deparenthesizeOrGetSelector(KtExpression expression, StatementFilter statementFilter) {
        KtExpression deparenthesized = KtPsiUtil.deparenthesizeOnce(expression);
        if (!Intrinsics.areEqual(deparenthesized, expression)) {
            return deparenthesized;
        }
        KtExpression ktExpression = expression;
        return ktExpression instanceof KtBlockExpression ? StatementFilterKt.getLastStatementInABlock(statementFilter, (KtBlockExpression)expression) : (ktExpression instanceof KtQualifiedExpression ? ((KtQualifiedExpression)expression).getSelectorExpression() : null);
    }

    private final boolean hasNecessarySafeCall(KtExpression expression, BindingTrace trace) {
        if (!(expression instanceof KtSafeQualifiedExpression)) {
            return false;
        }
        KotlinType expressionType = trace.getType(((KtSafeQualifiedExpression)expression).getReceiverExpression());
        return expressionType != null && TypeUtils.isNullableType(expressionType);
    }

    public final void bind$frontend(@NotNull BindingTrace trace, @NotNull ResolvedCall<?> resolvedCall2) {
        block1: {
            NewAbstractResolvedCall it;
            Intrinsics.checkNotNullParameter(trace, "trace");
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            NewAbstractResolvedCall newAbstractResolvedCall = resolvedCall2 instanceof NewAbstractResolvedCall ? (NewAbstractResolvedCall)resolvedCall2 : null;
            if (newAbstractResolvedCall != null) {
                it = newAbstractResolvedCall;
                boolean bl = false;
                this.bind(trace, it);
            }
            NewVariableAsFunctionResolvedCallImpl newVariableAsFunctionResolvedCallImpl = resolvedCall2 instanceof NewVariableAsFunctionResolvedCallImpl ? (NewVariableAsFunctionResolvedCallImpl)resolvedCall2 : null;
            if (newVariableAsFunctionResolvedCallImpl == null) break block1;
            it = newVariableAsFunctionResolvedCallImpl;
            boolean bl = false;
            this.bind(trace, (NewVariableAsFunctionResolvedCallImpl)it);
        }
    }

    public final void reportDiagnostics(@NotNull BasicCallResolutionContext context, @NotNull BindingTrace trace, @NotNull NewAbstractResolvedCall<?> resolvedCall2, @NotNull Collection<? extends KotlinCallDiagnostic> diagnostics) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(diagnostics, "diagnostics");
        if (resolvedCall2 instanceof NewVariableAsFunctionResolvedCallImpl) {
            ResolvedCall variableCall = ((NewVariableAsFunctionResolvedCallImpl)resolvedCall2).getVariableCall();
            ResolvedCall functionCall = ((NewVariableAsFunctionResolvedCallImpl)resolvedCall2).getFunctionCall();
            Object d = variableCall.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(d, "getResultingDescriptor(...)");
            this.reportCallDiagnostic(context, trace, (NewAbstractResolvedCall<?>)variableCall, (CallableDescriptor)d, diagnostics);
            Object d2 = functionCall.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(d2, "getResultingDescriptor(...)");
            this.reportCallDiagnostic(context, trace, (NewAbstractResolvedCall<?>)functionCall, (CallableDescriptor)d2, CollectionsKt.emptyList());
        } else {
            ResolvedCallAtom resolvedCallAtom = resolvedCall2.getResolvedCallAtom();
            if (resolvedCallAtom != null) {
                Object d = resolvedCall2.getResultingDescriptor();
                Intrinsics.checkNotNullExpressionValue(d, "getResultingDescriptor(...)");
                this.reportCallDiagnostic(context, trace, resolvedCall2, (CallableDescriptor)d, diagnostics);
            }
        }
    }

    private final void bind(BindingTrace trace, NewAbstractResolvedCall<?> simpleResolvedCall) {
        TracingStrategy tracing = simpleResolvedCall.getPsiKotlinCall().getTracingStrategy();
        tracing.bindReference(trace, simpleResolvedCall);
        tracing.bindResolvedCall(trace, simpleResolvedCall);
    }

    private final void bind(BindingTrace trace, NewVariableAsFunctionResolvedCallImpl variableAsFunction) {
        TracingStrategy outerTracingStrategy = variableAsFunction.getBaseCall().getTracingStrategy();
        ResolvedCall variableCall = variableAsFunction.getVariableCall();
        ResolvedCall functionCall = variableAsFunction.getFunctionCall();
        outerTracingStrategy.bindReference(trace, variableCall);
        outerTracingStrategy.bindResolvedCall(trace, variableAsFunction);
        ((NewAbstractResolvedCall)functionCall).getPsiKotlinCall().getTracingStrategy().bindReference(trace, functionCall);
    }

    public final void reportCallDiagnostic(@NotNull BasicCallResolutionContext context, @NotNull BindingTrace trace, @NotNull NewAbstractResolvedCall<?> resolvedCall2, @NotNull CallableDescriptor resultingDescriptor, @NotNull Collection<? extends KotlinCallDiagnostic> diagnostics) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(resultingDescriptor, "resultingDescriptor");
        Intrinsics.checkNotNullParameter(diagnostics, "diagnostics");
        TrackingBindingTrace trackingTrace = new TrackingBindingTrace(trace);
        Object Context2 = context.replaceBindingTrace(trackingTrace);
        Intrinsics.checkNotNullExpressionValue(Context2, "replaceBindingTrace(...)");
        BasicCallResolutionContext newContext = (BasicCallResolutionContext)Context2;
        KotlinDiagnosticsHolder.SimpleHolder diagnosticHolder = new KotlinDiagnosticsHolder.SimpleHolder();
        ResolvedCallAtom resolvedCallAtom = resolvedCall2.getResolvedCallAtom();
        if (resolvedCallAtom != null) {
            this.additionalDiagnosticReporter.reportAdditionalDiagnostics(resolvedCallAtom, resultingDescriptor, diagnosticHolder, diagnostics);
        }
        List<? extends KotlinCallDiagnostic> allDiagnostics = CollectionsKt.plus(diagnostics, (Iterable)diagnosticHolder.getDiagnostics());
        PSIKotlinCall pSIKotlinCall = resolvedCall2.getPsiKotlinCall();
        DataFlowValueFactory dataFlowValueFactory = context.dataFlowValueFactory;
        Intrinsics.checkNotNullExpressionValue(dataFlowValueFactory, "dataFlowValueFactory");
        DiagnosticReporterByTrackingStrategy diagnosticReporter = new DiagnosticReporterByTrackingStrategy(this.constantExpressionEvaluator, newContext, pSIKotlinCall, dataFlowValueFactory, allDiagnostics, this.smartCastManager, this.typeSystemContext);
        for (KotlinCallDiagnostic kotlinCallDiagnostic : allDiagnostics) {
            trackingTrace.setReported(false);
            kotlinCallDiagnostic.report(diagnosticReporter);
            if (kotlinCallDiagnostic instanceof ResolvedUsingDeprecatedVisibility) {
                Call call2 = resolvedCall2.getPsiKotlinCall().getPsiCall();
                Object d = resolvedCall2.getCandidateDescriptor();
                Intrinsics.checkNotNullExpressionValue(d, "getCandidateDescriptor(...)");
                NewResolutionOldInferenceKt.reportResolvedUsingDeprecatedVisibility(call2, d, resultingDescriptor, (ResolvedUsingDeprecatedVisibility)kotlinCallDiagnostic, trace);
            }
            boolean dontRecordToTraceAsIs = kotlinCallDiagnostic instanceof ResolutionDiagnostic && !(kotlinCallDiagnostic instanceof VisibilityError);
            boolean shouldReportMissingDiagnostic = !trackingTrace.getReported() && !dontRecordToTraceAsIs;
            if (!shouldReportMissingDiagnostic || !KotlinToResolvedCallTransformer.Companion.getREPORT_MISSING_NEW_INFERENCE_DIAGNOSTIC()) continue;
            DiagnosticFactory1<PsiElement, String> factory2 = CandidateApplicabilityKt.isSuccess(kotlinCallDiagnostic.getCandidateApplicability()) ? Errors.NEW_INFERENCE_DIAGNOSTIC : Errors.NEW_INFERENCE_ERROR;
            trace.report(factory2.on(diagnosticReporter.getPsiKotlinCall().getPsiCall().getCallElement(), "Missing diagnostic: " + kotlinCallDiagnostic));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\f\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/KotlinToResolvedCallTransformer$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;", "resolvedCallAtom", "Lorg/jetbrains/kotlin/psi/Call;", "keyForPartiallyResolvedCall", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCallAtom;)Lorg/jetbrains/kotlin/psi/Call;", "", "getREPORT_MISSING_NEW_INFERENCE_DIAGNOSTIC", "()Z", "REPORT_MISSING_NEW_INFERENCE_DIAGNOSTIC"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean getREPORT_MISSING_NEW_INFERENCE_DIAGNOSTIC() {
            return false;
        }

        @NotNull
        public final Call keyForPartiallyResolvedCall(@NotNull ResolvedCallAtom resolvedCallAtom) {
            Intrinsics.checkNotNullParameter(resolvedCallAtom, "resolvedCallAtom");
            PSIKotlinCall psiKotlinCall = PSIKotlinCallsKt.getPsiKotlinCall(resolvedCallAtom.getAtom());
            return psiKotlinCall instanceof PSIKotlinCallForInvoke ? ((PSIKotlinCallForInvoke)psiKotlinCall).getBaseCall().getPsiCall() : psiKotlinCall.getPsiCall();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

