/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.calls.CallTransformer;
import org.jetbrains.kotlin.resolve.calls.components.candidate.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.DataFlowInfoForArguments;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallKind;
import org.jetbrains.kotlin.resolve.calls.model.ReceiverKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.TypeArgument;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategy;
import org.jetbrains.kotlin.resolve.calls.tasks.TracingStrategyForInvoke;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCall;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallImpl;
import org.jetbrains.kotlin.resolve.calls.tower.PSIKotlinCallsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.Receiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\f\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\u00068\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\t\u001a\u0004\u0018\u00010\b8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001b\u001a\u00020\u00188WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001f\u001a\u00020\u001c8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010$\u001a\b\u0012\u0004\u0012\u00020!0 8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020%0 8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010#R\u0016\u0010*\u001a\u0004\u0018\u00010%8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010.\u001a\u00020+8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u0014\u00100\u001a\u00020+8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010-R\u0014\u00104\u001a\u0002018WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u001a\u00106\u001a\u0002058\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b6\u00107\u001a\u0004\b8\u00109R\u001a\u0010;\u001a\u00020:8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>R\u001a\u0010@\u001a\u00020?8\u0016X\u0097D\u00a2\u0006\f\n\u0004\b@\u0010A\u001a\u0004\b@\u0010B"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/PSIKotlinCallForInvoke;", "Lorg/jetbrains/kotlin/resolve/calls/tower/PSIKotlinCall;", "Lorg/jetbrains/kotlin/resolve/calls/tower/PSIKotlinCallImpl;", "baseCall", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;", "variableCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ReceiverKotlinCallArgument;", "explicitReceiver", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "dispatchReceiverForInvokeExtension", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/tower/PSIKotlinCallImpl;Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;Lorg/jetbrains/kotlin/resolve/calls/model/ReceiverKotlinCallArgument;Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;)V", "Lorg/jetbrains/kotlin/resolve/calls/tower/PSIKotlinCallImpl;", "getBaseCall", "()Lorg/jetbrains/kotlin/resolve/calls/tower/PSIKotlinCallImpl;", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;", "getVariableCall", "()Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;", "Lorg/jetbrains/kotlin/resolve/calls/model/ReceiverKotlinCallArgument;", "getExplicitReceiver", "()Lorg/jetbrains/kotlin/resolve/calls/model/ReceiverKotlinCallArgument;", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "getDispatchReceiverForInvokeExtension", "()Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallKind;", "getCallKind", "()Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallKind;", "callKind", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "name", "", "Lorg/jetbrains/kotlin/resolve/calls/model/TypeArgument;", "getTypeArguments", "()Ljava/util/List;", "typeArguments", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "getArgumentsInParenthesis", "argumentsInParenthesis", "getExternalArgument", "()Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "externalArgument", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getStartingDataFlowInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "startingDataFlowInfo", "getResultDataFlowInfo", "resultDataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArguments;", "getDataFlowInfoForArguments", "()Lorg/jetbrains/kotlin/resolve/calls/model/DataFlowInfoForArguments;", "dataFlowInfoForArguments", "Lorg/jetbrains/kotlin/psi/Call;", "psiCall", "Lorg/jetbrains/kotlin/psi/Call;", "getPsiCall", "()Lorg/jetbrains/kotlin/psi/Call;", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "tracingStrategy", "Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "getTracingStrategy", "()Lorg/jetbrains/kotlin/resolve/calls/tasks/TracingStrategy;", "", "isForImplicitInvoke", "Z", "()Z"})
public final class PSIKotlinCallForInvoke
extends PSIKotlinCall {
    @NotNull
    private final PSIKotlinCallImpl baseCall;
    @NotNull
    private final ResolutionCandidate variableCall;
    @NotNull
    private final ReceiverKotlinCallArgument explicitReceiver;
    @Nullable
    private final SimpleKotlinCallArgument dispatchReceiverForInvokeExtension;
    @NotNull
    private final Call psiCall;
    @NotNull
    private final TracingStrategy tracingStrategy;
    private final boolean isForImplicitInvoke;

    public PSIKotlinCallForInvoke(@NotNull PSIKotlinCallImpl baseCall, @NotNull ResolutionCandidate variableCall, @NotNull ReceiverKotlinCallArgument explicitReceiver, @Nullable SimpleKotlinCallArgument dispatchReceiverForInvokeExtension) {
        Intrinsics.checkNotNullParameter(baseCall, "baseCall");
        Intrinsics.checkNotNullParameter(variableCall, "variableCall");
        Intrinsics.checkNotNullParameter(explicitReceiver, "explicitReceiver");
        this.baseCall = baseCall;
        this.variableCall = variableCall;
        this.explicitReceiver = explicitReceiver;
        this.dispatchReceiverForInvokeExtension = dispatchReceiverForInvokeExtension;
        this.isForImplicitInvoke = true;
        SimpleKotlinCallArgument simpleKotlinCallArgument = this.getDispatchReceiverForInvokeExtension();
        ReceiverKotlinCallArgument variableReceiver = simpleKotlinCallArgument != null ? (ReceiverKotlinCallArgument)simpleKotlinCallArgument : this.getExplicitReceiver();
        ReceiverKotlinCallArgument explicitExtensionReceiver = this.getDispatchReceiverForInvokeExtension() == null ? null : this.getExplicitReceiver();
        KtExpression ktExpression = this.baseCall.getPsiCall().getCalleeExpression();
        Intrinsics.checkNotNull(ktExpression);
        KtExpression calleeExpression = ktExpression;
        ReceiverKotlinCallArgument receiverKotlinCallArgument = explicitExtensionReceiver;
        Receiver receiver = receiverKotlinCallArgument != null ? PSIKotlinCallsKt.getReceiverValue(receiverKotlinCallArgument) : null;
        ReceiverValue receiverValue = PSIKotlinCallsKt.getReceiverValue(variableReceiver);
        Intrinsics.checkNotNull(receiverValue, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver");
        this.psiCall = new CallTransformer.CallForImplicitInvoke(receiver, (ExpressionReceiver)receiverValue, this.baseCall.getPsiCall(), true);
        Call call2 = this.getPsiCall();
        ReceiverValue receiverValue2 = PSIKotlinCallsKt.getReceiverValue(variableReceiver);
        Intrinsics.checkNotNull(receiverValue2);
        this.tracingStrategy = new TracingStrategyForInvoke(calleeExpression, call2, receiverValue2.getType());
    }

    @NotNull
    public final PSIKotlinCallImpl getBaseCall() {
        return this.baseCall;
    }

    @NotNull
    public final ResolutionCandidate getVariableCall() {
        return this.variableCall;
    }

    @Override
    @NotNull
    public ReceiverKotlinCallArgument getExplicitReceiver() {
        return this.explicitReceiver;
    }

    @Override
    @Nullable
    public SimpleKotlinCallArgument getDispatchReceiverForInvokeExtension() {
        return this.dispatchReceiverForInvokeExtension;
    }

    @Override
    @NotNull
    public KotlinCallKind getCallKind() {
        return KotlinCallKind.FUNCTION;
    }

    @Override
    @NotNull
    public Name getName() {
        return OperatorNameConventions.INVOKE;
    }

    @Override
    @NotNull
    public List<TypeArgument> getTypeArguments() {
        return this.baseCall.getTypeArguments();
    }

    @Override
    @NotNull
    public List<KotlinCallArgument> getArgumentsInParenthesis() {
        return this.baseCall.getArgumentsInParenthesis();
    }

    @Override
    @Nullable
    public KotlinCallArgument getExternalArgument() {
        return this.baseCall.getExternalArgument();
    }

    @Override
    @NotNull
    public DataFlowInfo getStartingDataFlowInfo() {
        return this.baseCall.getStartingDataFlowInfo();
    }

    @Override
    @NotNull
    public DataFlowInfo getResultDataFlowInfo() {
        return this.baseCall.getResultDataFlowInfo();
    }

    @Override
    @NotNull
    public DataFlowInfoForArguments getDataFlowInfoForArguments() {
        return this.baseCall.getDataFlowInfoForArguments();
    }

    @Override
    @NotNull
    public Call getPsiCall() {
        return this.psiCall;
    }

    @Override
    @NotNull
    public TracingStrategy getTracingStrategy() {
        return this.tracingStrategy;
    }

    @Override
    public boolean isForImplicitInvoke() {
        return this.isForImplicitInvoke;
    }
}

