/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a+\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00022\u0006\u0010\u0001\u001a\u00020\u00002\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a\u0015\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "functionDescriptor", "", "Lorg/jetbrains/kotlin/types/TypeProjection;", "parameterTypes", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "createValueParametersForInvokeInFunctionType", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Ljava/util/List;)Ljava/util/List;", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "", "getValueParametersCountFromFunctionType", "(Lorg/jetbrains/kotlin/types/KotlinType;)I"})
public final class FunctionTypeResolveUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValueParameterDescriptor> createValueParametersForInvokeInFunctionType(@NotNull FunctionDescriptor functionDescriptor, @NotNull List<? extends TypeProjection> parameterTypes) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter(functionDescriptor, "functionDescriptor");
        Intrinsics.checkNotNullParameter(parameterTypes, "parameterTypes");
        Iterable $this$mapIndexed$iv = parameterTypes;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void typeProjection;
            void i;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CallableDescriptor callableDescriptor = functionDescriptor;
            Annotations annotations2 = Annotations.Companion.getEMPTY();
            Name name = Name.identifier("" + 'p' + (int)(i + true));
            Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
            KotlinType kotlinType = typeProjection.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue(sourceElement, "NO_SOURCE");
            collection.add(new ValueParameterDescriptorImpl(callableDescriptor, null, (int)i, annotations2, name, kotlinType, false, false, false, null, sourceElement));
        }
        return (List)destination$iv$iv;
    }

    public static final int getValueParametersCountFromFunctionType(@NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(type2, "type");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType(type2);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Not a function type: " + type2;
            throw new AssertionError((Object)string2);
        }
        return type2.getArguments().size() - (FunctionTypesKt.isBuiltinExtensionFunctionalType(type2) ? 1 : 0) - 1;
    }
}

