/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.util;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastUtilKt;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;
import org.jetbrains.kotlin.resolve.calls.tower.NewAbstractResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.DefinitelyNotNullType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.StubTypeForBuilderInference;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.checker.NewCapturedType;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001d\u0010\u0004\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0019\u0010\u0007\u001a\u0004\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u0000H\u0007\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u0019\u0010\n\u001a\u0004\u0018\u00010\t*\u0006\u0012\u0002\b\u00030\u0000H\u0007\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u001d\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\f*\u0006\u0012\u0002\b\u00030\u0000H\u0007\u00a2\u0006\u0004\b\r\u0010\u000e\u001a#\u0010\u0010\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u00002\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a/\u0010\u0014\u001a\u0004\u0018\u00010\u0012*\u0006\u0012\u0002\b\u00030\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u00122\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a\u0015\u0010\u0016\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u0000\u00a2\u0006\u0004\b\u0016\u0010\u0017\u001a\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u0006*\u0006\u0012\u0002\b\u00030\u0000H\u0007\u00a2\u0006\u0004\b\u0018\u0010\b\u001a)\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c*\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001a\u0011\u0010!\u001a\u00020\u0003*\u00020 \u00a2\u0006\u0004\b!\u0010\"\u001a\u0015\u0010#\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u0000\u00a2\u0006\u0004\b#\u0010\u0017\u001a\u0015\u0010$\u001a\u00020\u0003*\u0006\u0012\u0002\b\u00030\u0000\u00a2\u0006\u0004\b$\u0010\u0017\u001a\u0013\u0010'\u001a\u00020&*\u00020%H\u0007\u00a2\u0006\u0004\b'\u0010("}, d2={"Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "context", "", "hasThisOrNoDispatchReceiver", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/resolve/BindingContext;)Z", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "getExplicitReceiverValue", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;)Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitReceiver;", "getImplicitReceiverValue", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;)Lorg/jetbrains/kotlin/resolve/scopes/receivers/ImplicitReceiver;", "", "getImplicitReceivers", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;)Ljava/util/Collection;", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "hasSafeNullableReceiver", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;)Z", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "makeNullableTypeIfSafeReceiver", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;)Lorg/jetbrains/kotlin/types/KotlinType;", "hasBothReceivers", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;)Z", "getDispatchReceiverWithSmartCast", "Lorg/jetbrains/kotlin/psi/KtCallElement;", "", "index", "", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "getArgumentByParameterIndex", "(Lorg/jetbrains/kotlin/psi/KtCallElement;ILorg/jetbrains/kotlin/resolve/BindingContext;)Ljava/util/List;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isNotSimpleCall", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;)Z", "isNewNotCompleted", "hasInferredReturnType", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "toResolutionStatus", "(Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;)Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;"})
public final class ResolvedCallUtilKt {
    public static final boolean hasThisOrNoDispatchReceiver(@NotNull ResolvedCall<?> $this$hasThisOrNoDispatchReceiver, @NotNull BindingContext context) {
        KtExpression expression;
        Intrinsics.checkNotNullParameter($this$hasThisOrNoDispatchReceiver, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        ReceiverValue dispatchReceiverValue = $this$hasThisOrNoDispatchReceiver.getDispatchReceiver();
        if ($this$hasThisOrNoDispatchReceiver.getResultingDescriptor().getDispatchReceiverParameter() == null || dispatchReceiverValue == null) {
            return true;
        }
        DeclarationDescriptor dispatchReceiverDescriptor = null;
        ReceiverValue receiverValue = dispatchReceiverValue;
        if (receiverValue instanceof ImplicitReceiver) {
            dispatchReceiverDescriptor = ((ImplicitReceiver)dispatchReceiverValue).getDeclarationDescriptor();
        } else if (receiverValue instanceof ClassValueReceiver) {
            dispatchReceiverDescriptor = ((ClassValueReceiver)dispatchReceiverValue).getClassQualifier().getDescriptor();
        } else if (receiverValue instanceof ExpressionReceiver && (expression = KtPsiUtil.deparenthesize(((ExpressionReceiver)dispatchReceiverValue).getExpression())) instanceof KtThisExpression) {
            dispatchReceiverDescriptor = (DeclarationDescriptor)context.get(BindingContext.REFERENCE_TARGET, ((KtThisExpression)expression).getInstanceReference());
        }
        Object obj = $this$hasThisOrNoDispatchReceiver.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(obj, "getResultingDescriptor(...)");
        return Intrinsics.areEqual(dispatchReceiverDescriptor, DescriptorUtilsKt.getOwnerForEffectiveDispatchReceiverParameter(obj));
    }

    @Nullable
    public static final ReceiverValue getExplicitReceiverValue(@NotNull ResolvedCall<?> $this$getExplicitReceiverValue) {
        ReceiverValue receiverValue;
        Intrinsics.checkNotNullParameter($this$getExplicitReceiverValue, "<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getExplicitReceiverValue.getExplicitReceiverKind().ordinal()]) {
            case 1: {
                ReceiverValue receiverValue2 = $this$getExplicitReceiverValue.getDispatchReceiver();
                receiverValue = receiverValue2;
                Intrinsics.checkNotNull(receiverValue2);
                break;
            }
            case 2: 
            case 3: {
                ReceiverValue receiverValue3 = $this$getExplicitReceiverValue.getExtensionReceiver();
                receiverValue = receiverValue3;
                Intrinsics.checkNotNull(receiverValue3);
                break;
            }
            default: {
                receiverValue = null;
            }
        }
        return receiverValue;
    }

    @Nullable
    public static final ImplicitReceiver getImplicitReceiverValue(@NotNull ResolvedCall<?> $this$getImplicitReceiverValue) {
        Intrinsics.checkNotNullParameter($this$getImplicitReceiverValue, "<this>");
        Object t = CollectionsKt.firstOrNull((Iterable)ResolvedCallUtilKt.getImplicitReceivers($this$getImplicitReceiverValue));
        return t instanceof ImplicitReceiver ? (ImplicitReceiver)t : null;
    }

    @NotNull
    public static final Collection<ReceiverValue> getImplicitReceivers(@NotNull ResolvedCall<?> $this$getImplicitReceivers) {
        Collection collection;
        Intrinsics.checkNotNullParameter($this$getImplicitReceivers, "<this>");
        switch (WhenMappings.$EnumSwitchMapping$0[$this$getImplicitReceivers.getExplicitReceiverKind().ordinal()]) {
            case 4: {
                ReceiverValue[] receiverValueArray = new ReceiverValue[]{$this$getImplicitReceivers.getExtensionReceiver(), $this$getImplicitReceivers.getDispatchReceiver()};
                collection = CollectionsKt.listOfNotNull(receiverValueArray);
                break;
            }
            case 1: {
                collection = CollectionsKt.listOfNotNull($this$getImplicitReceivers.getExtensionReceiver());
                break;
            }
            case 2: {
                collection = CollectionsKt.listOfNotNull($this$getImplicitReceivers.getDispatchReceiver());
                break;
            }
            case 3: {
                collection = CollectionsKt.emptyList();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return collection;
    }

    private static final boolean hasSafeNullableReceiver(ResolvedCall<?> $this$hasSafeNullableReceiver, CallResolutionContext<?> context) {
        Object object;
        block5: {
            block4: {
                Call call2 = $this$hasSafeNullableReceiver.getCall();
                Intrinsics.checkNotNullExpressionValue(call2, "getCall(...)");
                if (!CallUtilKt.isSafeCall(call2)) {
                    return false;
                }
                object = ResolvedCallUtilKt.getExplicitReceiverValue($this$hasSafeNullableReceiver);
                if (object == null) break block4;
                ReceiverValue it = object;
                boolean bl = false;
                DataFlowValue dataFlowValue = context.dataFlowValueFactory.createDataFlowValue(it, (ResolutionContext)context);
                object = dataFlowValue;
                if (dataFlowValue != null) break block5;
            }
            return false;
        }
        Object receiverValue = object;
        return context.dataFlowInfo.getStableNullability((DataFlowValue)receiverValue).canBeNull();
    }

    @Nullable
    public static final KotlinType makeNullableTypeIfSafeReceiver(@NotNull ResolvedCall<?> $this$makeNullableTypeIfSafeReceiver, @Nullable KotlinType type2, @NotNull CallResolutionContext<?> context) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter($this$makeNullableTypeIfSafeReceiver, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        KotlinType kotlinType2 = type2;
        if (kotlinType2 != null) {
            KotlinType it = kotlinType2;
            boolean bl = false;
            kotlinType = TypeUtils.makeNullableIfNeeded(type2, ResolvedCallUtilKt.hasSafeNullableReceiver($this$makeNullableTypeIfSafeReceiver, context));
        } else {
            kotlinType = null;
        }
        return kotlinType;
    }

    public static final boolean hasBothReceivers(@NotNull ResolvedCall<?> $this$hasBothReceivers) {
        Intrinsics.checkNotNullParameter($this$hasBothReceivers, "<this>");
        return $this$hasBothReceivers.getDispatchReceiver() != null && $this$hasBothReceivers.getExtensionReceiver() != null;
    }

    @Nullable
    public static final ReceiverValue getDispatchReceiverWithSmartCast(@NotNull ResolvedCall<?> $this$getDispatchReceiverWithSmartCast) {
        Intrinsics.checkNotNullParameter($this$getDispatchReceiverWithSmartCast, "<this>");
        return SmartCastUtilKt.getReceiverValueWithSmartCast($this$getDispatchReceiverWithSmartCast.getDispatchReceiver(), $this$getDispatchReceiverWithSmartCast.getSmartCastDispatchReceiverType());
    }

    @NotNull
    public static final List<ValueArgument> getArgumentByParameterIndex(@NotNull KtCallElement $this$getArgumentByParameterIndex, int index2, @NotNull BindingContext context) {
        Intrinsics.checkNotNullParameter($this$getArgumentByParameterIndex, "<this>");
        Intrinsics.checkNotNullParameter(context, "context");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall($this$getArgumentByParameterIndex, context);
        if (resolvedCall2 == null) {
            return CollectionsKt.emptyList();
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        List<ValueParameterDescriptor> list = resolvedCall3.getResultingDescriptor().getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        ValueParameterDescriptor valueParameterDescriptor = CollectionsKt.getOrNull(list, index2);
        if (valueParameterDescriptor == null) {
            return CollectionsKt.emptyList();
        }
        ValueParameterDescriptor parameterToProcess = valueParameterDescriptor;
        Object object = resolvedCall3.getValueArguments().get(parameterToProcess);
        if (object == null || (object = object.getArguments()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isNotSimpleCall(@NotNull CallableDescriptor $this$isNotSimpleCall) {
        Intrinsics.checkNotNullParameter($this$isNotSimpleCall, "<this>");
        List<TypeParameterDescriptor> list = $this$isNotSimpleCall.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getTypeParameters(...)");
        if (!((Collection)list).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        KotlinType kotlinType = $this$isNotSimpleCall.getReturnType();
        if (kotlinType == null) return false;
        KotlinType type2 = kotlinType;
        boolean bl2 = false;
        boolean bl3 = TypeUtilsKt.contains(type2, ResolvedCallUtilKt::isNotSimpleCall$lambda$3$lambda$2);
        if (!bl3) return false;
        return true;
    }

    public static final boolean isNewNotCompleted(@NotNull ResolvedCall<?> $this$isNewNotCompleted) {
        Intrinsics.checkNotNullParameter($this$isNewNotCompleted, "<this>");
        return $this$isNewNotCompleted instanceof NewAbstractResolvedCall ? !((NewAbstractResolvedCall)$this$isNewNotCompleted).isCompleted() : false;
    }

    public static final boolean hasInferredReturnType(@NotNull ResolvedCall<?> $this$hasInferredReturnType) {
        Intrinsics.checkNotNullParameter($this$hasInferredReturnType, "<this>");
        if (ResolvedCallUtilKt.isNewNotCompleted($this$hasInferredReturnType)) {
            return false;
        }
        KotlinType kotlinType = $this$hasInferredReturnType.getResultingDescriptor().getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType returnType = kotlinType;
        return !TypeUtilsKt.contains(returnType, ResolvedCallUtilKt::hasInferredReturnType$lambda$4);
    }

    @NotNull
    public static final ResolutionStatus toResolutionStatus(@NotNull CandidateApplicability $this$toResolutionStatus) {
        ResolutionStatus resolutionStatus;
        Intrinsics.checkNotNullParameter((Object)$this$toResolutionStatus, "<this>");
        switch (WhenMappings.$EnumSwitchMapping$1[$this$toResolutionStatus.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                resolutionStatus = ResolutionStatus.SUCCESS;
                break;
            }
            case 5: {
                resolutionStatus = ResolutionStatus.RECEIVER_TYPE_ERROR;
                break;
            }
            case 6: {
                resolutionStatus = ResolutionStatus.UNSAFE_CALL_ERROR;
                break;
            }
            default: {
                resolutionStatus = ResolutionStatus.OTHER_ERROR;
            }
        }
        return resolutionStatus;
    }

    private static final boolean isNotSimpleCall$lambda$3$lambda$2(UnwrappedType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it instanceof NewCapturedType || it.getConstructor() instanceof IntegerLiteralTypeConstructor || it instanceof DefinitelyNotNullType || it instanceof StubTypeForBuilderInference;
    }

    private static final boolean hasInferredReturnType$lambda$4(UnwrappedType it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ErrorUtils.isUninferredTypeVariable(it);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ExplicitReceiverKind.values().length];
            try {
                nArray[ExplicitReceiverKind.DISPATCH_RECEIVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.EXTENSION_RECEIVER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.BOTH_RECEIVERS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ExplicitReceiverKind.NO_EXPLICIT_RECEIVER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[CandidateApplicability.values().length];
            try {
                nArray[CandidateApplicability.RESOLVED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CandidateApplicability.RESOLVED_LOW_PRIORITY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CandidateApplicability.RESOLVED_WITH_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CandidateApplicability.RESOLVED_NEED_PRESERVE_COMPATIBILITY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CandidateApplicability.INAPPLICABLE_WRONG_RECEIVER.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CandidateApplicability.UNSAFE_CALL.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

