/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.KotlinRetention;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000e*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/AnnotationClassTargetAndRetentionChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lcom/intellij/psi/PsiElement;", "getPsi", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;)Lcom/intellij/psi/PsiElement;", "psi"})
public final class AnnotationClassTargetAndRetentionChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        KotlinRetention retention;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        if (!(declaration instanceof KtClassOrObject)) {
            return;
        }
        if (!DescriptorUtils.isAnnotationClass(descriptor2)) {
            return;
        }
        Set<KotlinTarget> set = AnnotationChecker.Companion.applicableTargetSetFromTargetAnnotationOrNull((ClassDescriptor)descriptor2);
        if (set == null) {
            return;
        }
        Set<KotlinTarget> targets = set;
        KotlinRetention kotlinRetention = DescriptorUtilsKt.getAnnotationRetention(descriptor2);
        if (kotlinRetention == null) {
            kotlinRetention = retention = KotlinRetention.RUNTIME;
        }
        if (targets.contains((Object)KotlinTarget.EXPRESSION) && retention != KotlinRetention.SOURCE) {
            AnnotationDescriptor retentionAnnotation = descriptor2.getAnnotations().findAnnotation(StandardNames.FqNames.retention);
            AnnotationDescriptor targetAnnotation = descriptor2.getAnnotations().findAnnotation(StandardNames.FqNames.target);
            BindingTrace bindingTrace = context.getTrace();
            LanguageVersionSettings languageVersionSettings = context.getLanguageVersionSettings();
            Object object = retentionAnnotation;
            if (object == null || (object = this.getPsi((AnnotationDescriptor)object)) == null) {
                AnnotationDescriptor annotationDescriptor = targetAnnotation;
                object = annotationDescriptor != null ? this.getPsi(annotationDescriptor) : null;
                if (object == null) {
                    object = declaration;
                }
            }
            bindingTrace.report(Errors.RESTRICTED_RETENTION_FOR_EXPRESSION_ANNOTATION.on(languageVersionSettings, (PsiElement)object));
        }
    }

    private final PsiElement getPsi(AnnotationDescriptor $this$psi) {
        return DescriptorToSourceUtils.getSourceFromAnnotation($this$psi);
    }
}

