/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstUtilKt;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.resolve.checkers.ConstApplicability;
import org.jetbrains.kotlin.resolve.checkers.ConstModifierCheckerKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ConstModifierChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V", "Lcom/intellij/psi/PsiElement;", "constModifierPsiElement", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "", "canBeConst", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;)Z", "Lorg/jetbrains/kotlin/resolve/checkers/ConstApplicability;", "checkCanBeConst", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;)Lorg/jetbrains/kotlin/resolve/checkers/ConstApplicability;"})
public final class ConstModifierChecker
implements DeclarationChecker {
    @NotNull
    public static final ConstModifierChecker INSTANCE = new ConstModifierChecker();

    private ConstModifierChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(descriptor2 instanceof VariableDescriptor) || !declaration.hasModifier(KtTokens.CONST_KEYWORD)) {
            return;
        }
        KtModifierList ktModifierList = declaration.getModifierList();
        Intrinsics.checkNotNull(ktModifierList);
        PsiElement psiElement = ktModifierList.getModifier(KtTokens.CONST_KEYWORD);
        Intrinsics.checkNotNull(psiElement);
        PsiElement constModifierPsiElement = psiElement;
        Diagnostic diagnostic = this.checkCanBeConst(declaration, constModifierPsiElement, (VariableDescriptor)descriptor2).getDiagnostic();
        if (diagnostic != null) {
            context.getTrace().report(diagnostic);
        }
    }

    public final boolean canBeConst(@NotNull KtDeclaration declaration, @NotNull PsiElement constModifierPsiElement, @NotNull VariableDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(constModifierPsiElement, "constModifierPsiElement");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        return this.checkCanBeConst(declaration, constModifierPsiElement, descriptor2).getCanBeConst();
    }

    private final ConstApplicability checkCanBeConst(KtDeclaration declaration, PsiElement constModifierPsiElement, VariableDescriptor descriptor2) {
        if (descriptor2.isVar()) {
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.WRONG_MODIFIER_TARGET.on(constModifierPsiElement, KtTokens.CONST_KEYWORD, "vars");
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
            return ConstModifierCheckerKt.access$nonApplicable(parametrizedDiagnostic);
        }
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        DeclarationDescriptor containingDeclaration = declarationDescriptor;
        if (containingDeclaration instanceof ClassDescriptor && ((ClassDescriptor)containingDeclaration).getKind() != ClassKind.OBJECT) {
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.CONST_VAL_NOT_TOP_LEVEL_OR_OBJECT.on(constModifierPsiElement);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, "on(...)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        if (!(declaration instanceof KtProperty) || !(descriptor2 instanceof PropertyDescriptor)) {
            return new ConstApplicability.NonApplicable(null, 1, null);
        }
        if (((KtProperty)declaration).hasDelegate()) {
            KtPropertyDelegate ktPropertyDelegate = ((KtProperty)declaration).getDelegate();
            Intrinsics.checkNotNull(ktPropertyDelegate);
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.CONST_VAL_WITH_DELEGATE.on(ktPropertyDelegate);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, "on(...)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        KtPropertyAccessor getter = ((KtProperty)declaration).getGetter();
        PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)descriptor2).getGetter();
        Intrinsics.checkNotNull(propertyGetterDescriptor);
        if (!propertyGetterDescriptor.isDefault() && getter != null) {
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.CONST_VAL_WITH_GETTER.on(getter);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, "on(...)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        KotlinType kotlinType = ((PropertyDescriptor)descriptor2).getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        if (KotlinTypeKt.isError(kotlinType)) {
            return new ConstApplicability.NonApplicable(null, 1, null);
        }
        KotlinType kotlinType2 = ((PropertyDescriptor)descriptor2).getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
        if (!ConstUtilKt.canBeUsedForConstVal(kotlinType2)) {
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.TYPE_CANT_BE_USED_FOR_CONST_VAL.on(constModifierPsiElement, ((PropertyDescriptor)descriptor2).getType());
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
            return ConstModifierCheckerKt.access$nonApplicable(parametrizedDiagnostic);
        }
        if (((KtProperty)declaration).getInitializer() == null) {
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.CONST_VAL_WITHOUT_INITIALIZER.on(constModifierPsiElement);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, "on(...)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        if (((PropertyDescriptor)descriptor2).getCompileTimeInitializer() == null) {
            KtExpression ktExpression = ((KtProperty)declaration).getInitializer();
            Intrinsics.checkNotNull(ktExpression);
            SimpleDiagnostic<KtExpression> simpleDiagnostic = Errors.CONST_VAL_WITH_NON_CONST_INITIALIZER.on((KtExpression)((PsiElement)ktExpression));
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, "on(...)");
            return ConstModifierCheckerKt.access$nonApplicable(simpleDiagnostic);
        }
        return ConstApplicability.Applicable.INSTANCE;
    }
}

