/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DelegationResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.OverridingUtil;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ/\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DelegationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classDeclaration", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "delegatedDescriptor", "delegatedToDescriptor", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "diagnosticHolder", "checkDescriptor", "(Lorg/jetbrains/kotlin/psi/KtClassOrObject;Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;)V"})
public final class DelegationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        if (!(declaration instanceof KtClassOrObject)) {
            return;
        }
        for (KtSuperTypeListEntry specifier : ((KtClassOrObject)declaration).getSuperTypeListEntries()) {
            ClassDescriptor superTypeDescriptor;
            Object superType;
            ClassifierDescriptor classifierDescriptor;
            if (!(specifier instanceof KtDelegatedSuperTypeEntry)) continue;
            Object object = ((KtDelegatedSuperTypeEntry)specifier).getTypeReference();
            if (object == null) continue;
            KtTypeReference it = object;
            boolean bl = false;
            KotlinType kotlinType = (KotlinType)context.getTrace().get(BindingContext.TYPE, it);
            object = kotlinType;
            if (kotlinType == null || ((classifierDescriptor = ((KotlinType)(superType = object)).getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor ? (ClassDescriptor)classifierDescriptor : null) == null) continue;
            superTypeDescriptor = superTypeDescriptor;
            for (Map.Entry entry : DelegationResolver.Companion.getDelegates$default(DelegationResolver.Companion, (ClassDescriptor)descriptor2, superTypeDescriptor, null, 4, null).entrySet()) {
                CallableMemberDescriptor delegated = (CallableMemberDescriptor)entry.getKey();
                CallableMemberDescriptor delegatedTo = (CallableMemberDescriptor)entry.getValue();
                this.checkDescriptor((KtClassOrObject)declaration, delegated, delegatedTo, context.getTrace());
            }
        }
    }

    private final void checkDescriptor(KtClassOrObject classDeclaration, CallableMemberDescriptor delegatedDescriptor, CallableMemberDescriptor delegatedToDescriptor, DiagnosticSink diagnosticHolder) {
        CallableMemberDescriptor it;
        Iterable $this$filterTo$iv$iv;
        Set<CallableDescriptor> set = DescriptorUtils.getAllOverriddenDescriptors((CallableDescriptor)delegatedDescriptor);
        Intrinsics.checkNotNullExpressionValue(set, "getAllOverriddenDescriptors(...)");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CallableMemberDescriptor)element$iv$iv;
            boolean bl = false;
            if (!it.getKind().isReal()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set set2 = OverridingUtil.filterOutOverridden(CollectionsKt.toSet((List)destination$iv$iv));
        Intrinsics.checkNotNullExpressionValue(set2, "filterOutOverridden(...)");
        Set<CallableMemberDescriptor> reachableFromDelegated = SetsKt.minus(set2, DescriptorUtils.unwrapFakeOverride(delegatedToDescriptor).getOriginal());
        $this$filter$iv = reachableFromDelegated;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CallableMemberDescriptor)element$iv$iv;
            boolean bl = false;
            if (!(it.getModality() == Modality.OPEN)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List nonAbstractReachable = (List)destination$iv$iv;
        if (!((Collection)nonAbstractReachable).isEmpty()) {
            diagnosticHolder.report(Errors.DELEGATED_MEMBER_HIDES_SUPERTYPE_OVERRIDE.on((KtClassOrObject)((PsiElement)classDeclaration), delegatedDescriptor, nonAbstractReachable));
        }
    }
}

