/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.RequireKotlinConstants;
import org.jetbrains.kotlin.resolve.annotations.UtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ5\u0010\u0014\u001a\u00020\n*\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J#\u0010\u0019\u001a\u00020\u00182\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/DeprecatedSinceKotlinAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/config/ApiVersion;", "parsedVersion", "", "name", "Lcom/intellij/psi/PsiElement;", "reportOn", "checkVersion", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;Lorg/jetbrains/kotlin/config/ApiVersion;Ljava/lang/String;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;Lcom/intellij/psi/PsiElement;)V", "a", "b", "", "lessOrNull", "(Lorg/jetbrains/kotlin/config/ApiVersion;Lorg/jetbrains/kotlin/config/ApiVersion;)Z"})
public final class DeprecatedSinceKotlinAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final DeprecatedSinceKotlinAnnotationChecker INSTANCE = new DeprecatedSinceKotlinAnnotationChecker();

    private DeprecatedSinceKotlinAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(StandardNames.FqNames.deprecatedSinceKotlin);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor deprecatedSinceAnnotation = annotationDescriptor;
        PsiElement psiElement = PsiSourceElementKt.getPsi(deprecatedSinceAnnotation.getSource());
        KtAnnotationEntry ktAnnotationEntry = psiElement instanceof KtAnnotationEntry ? (KtAnnotationEntry)psiElement : null;
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry deprecatedSinceAnnotationPsi = ktAnnotationEntry;
        AnnotationDescriptor deprecatedAnnotation = descriptor2.getAnnotations().findAnnotation(StandardNames.FqNames.deprecated);
        KtTypeReference ktTypeReference = deprecatedSinceAnnotationPsi.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference deprecatedSinceAnnotationName = ktTypeReference;
        FqName fqName2 = DescriptorUtilsKt.fqNameOrNull(descriptor2);
        boolean bl = fqName2 != null ? !FqNamesUtilKt.isSubpackageOf(fqName2, StandardNames.BUILT_INS_PACKAGE_FQ_NAME) : false;
        if (bl) {
            context.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_OUTSIDE_KOTLIN_SUBPACKAGE.on(deprecatedSinceAnnotationName));
            return;
        }
        if (deprecatedAnnotation == null) {
            context.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_WITHOUT_DEPRECATED.on(deprecatedSinceAnnotationName));
            return;
        }
        if (UtilsKt.argumentValue(deprecatedAnnotation, "level") != null) {
            context.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_WITH_DEPRECATED_LEVEL.on(deprecatedSinceAnnotationName));
            return;
        }
        if (deprecatedSinceAnnotation.getAllValueArguments().isEmpty()) {
            context.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_WITHOUT_ARGUMENTS.on(deprecatedSinceAnnotationName));
            return;
        }
        ApiVersion warningSince = DeprecatedSinceKotlinAnnotationChecker.check$getCheckedSinceVersion(deprecatedSinceAnnotation, context, deprecatedSinceAnnotationName, "warningSince");
        ApiVersion errorSince = DeprecatedSinceKotlinAnnotationChecker.check$getCheckedSinceVersion(deprecatedSinceAnnotation, context, deprecatedSinceAnnotationName, "errorSince");
        ApiVersion hiddenSince = DeprecatedSinceKotlinAnnotationChecker.check$getCheckedSinceVersion(deprecatedSinceAnnotation, context, deprecatedSinceAnnotationName, "hiddenSince");
        if (!(this.lessOrNull(warningSince, errorSince) && this.lessOrNull(errorSince, hiddenSince) && this.lessOrNull(warningSince, hiddenSince))) {
            context.getTrace().report(Errors.DEPRECATED_SINCE_KOTLIN_WITH_UNORDERED_VERSIONS.on(deprecatedSinceAnnotationName));
            return;
        }
    }

    private final void checkVersion(AnnotationDescriptor $this$checkVersion, ApiVersion parsedVersion, String name, DeclarationCheckerContext context, PsiElement reportOn) {
        block4: {
            block5: {
                String argumentValue;
                ConstantValue<?> constantValue = UtilsKt.argumentValue($this$checkVersion, name);
                StringValue stringValue = constantValue instanceof StringValue ? (StringValue)constantValue : null;
                String string2 = argumentValue = stringValue != null ? (String)stringValue.getValue() : null;
                if (argumentValue == null) break block4;
                if (parsedVersion == null) break block5;
                CharSequence charSequence = argumentValue;
                if (RequireKotlinConstants.INSTANCE.getVERSION_REGEX().matches(charSequence)) break block4;
            }
            BindingTrace bindingTrace = context.getTrace();
            FqName fqName2 = $this$checkVersion.getFqName();
            if (fqName2 == null) {
                return;
            }
            ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = Errors.ILLEGAL_KOTLIN_VERSION_STRING_VALUE.on(reportOn, fqName2);
            Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, parametrizedDiagnostic);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean lessOrNull(ApiVersion a, ApiVersion b) {
        if (a == null) return true;
        ApiVersion apiVersion = b;
        if (apiVersion == null) {
            return true;
        }
        if (a.compareTo(apiVersion) > 0) return false;
        return true;
    }

    private static final ApiVersion check$getCheckedSinceVersion(AnnotationDescriptor $this$check_u24getCheckedSinceVersion, DeclarationCheckerContext $context, KtTypeReference deprecatedSinceAnnotationName, String name) {
        ApiVersion apiVersion;
        ApiVersion it = apiVersion = DeprecationUtilKt.getSinceVersion($this$check_u24getCheckedSinceVersion, name);
        boolean bl = false;
        INSTANCE.checkVersion($this$check_u24getCheckedSinceVersion, it, name, $context, deprecatedSinceAnnotationName);
        return apiVersion;
    }
}

