/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.PsiElementBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtInitializerList;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.scopes.receivers.ClassValueReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitClassReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0006*\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/EnumCompanionInEnumConstructorCallChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "getResolvedDescriptor", "(Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;)Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "resolvedDescriptor", "Visitor"})
public final class EnumCompanionInEnumConstructorCallChecker
implements DeclarationChecker {
    @NotNull
    public static final EnumCompanionInEnumConstructorCallChecker INSTANCE = new EnumCompanionInEnumConstructorCallChecker();

    private EnumCompanionInEnumConstructorCallChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Object object;
        ClassDescriptor enumCompanion;
        ClassDescriptor enumDescriptor;
        block10: {
            block9: {
                Object v3;
                block8: {
                    Intrinsics.checkNotNullParameter(declaration, "declaration");
                    Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
                    Intrinsics.checkNotNullParameter(context, "context");
                    if (!(declaration instanceof KtEnumEntry) || !(descriptor2 instanceof ClassDescriptor)) {
                        return;
                    }
                    if (((ClassDescriptor)descriptor2).getKind() != ClassKind.ENUM_ENTRY) {
                        return;
                    }
                    DeclarationDescriptor declarationDescriptor = ((ClassDescriptor)descriptor2).getContainingDeclaration();
                    ClassDescriptor classDescriptor = declarationDescriptor instanceof ClassDescriptor ? (ClassDescriptor)declarationDescriptor : null;
                    if (classDescriptor == null) {
                        return;
                    }
                    enumDescriptor = classDescriptor;
                    ClassDescriptor classDescriptor2 = enumDescriptor.getCompanionObjectDescriptor();
                    if (classDescriptor2 == null) {
                        return;
                    }
                    enumCompanion = classDescriptor2;
                    object = ((KtEnumEntry)declaration).getInitializerList();
                    if (object == null || (object = ((KtInitializerList)object).getInitializers()) == null) break block9;
                    Iterable $this$firstIsInstanceOrNull$iv = (Iterable)object;
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof KtSuperTypeCallEntry)) continue;
                        v3 = element$iv;
                        break block8;
                    }
                    v3 = null;
                }
                if ((object = (KtSuperTypeCallEntry)v3) != null) break block10;
            }
            return;
        }
        Object initializer = object;
        BindingTrace bindingTrace = context.getTrace();
        BindingContext bindingContext = bindingTrace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        Visitor visitor2 = new Visitor(enumDescriptor, enumCompanion, bindingContext, bindingTrace, context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitAccessToEnumCompanionMembersInEnumConstructorCall));
        ((PsiElementBase)initializer).acceptChildren(visitor2);
    }

    private final DeclarationDescriptor getResolvedDescriptor(ReceiverValue $this$resolvedDescriptor) {
        if (!($this$resolvedDescriptor instanceof ClassValueReceiver) && !($this$resolvedDescriptor instanceof ImplicitClassReceiver)) {
            return null;
        }
        return $this$resolvedDescriptor.getType().unwrap().getConstructor().getDeclarationDescriptor();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0004\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0018\u001a\u0004\b\u001b\u0010\u001aR\u001a\u0010\u0006\u001a\u00020\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\b\u001a\u00020\u00078\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u001f\u001a\u0004\b \u0010!R\u001a\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\n\u0010\"\u001a\u0004\b#\u0010$"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/EnumCompanionInEnumConstructorCallChecker$Visitor;", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "enumDescriptor", "companionDescriptor", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "reporter", "", "reportError", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;Z)V", "Lcom/intellij/psi/PsiElement;", "element", "", "visitElement", "(Lcom/intellij/psi/PsiElement;)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "visitExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;)V", "analyzeExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Z", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getEnumDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "getCompanionDescriptor", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "Z", "getReportError", "()Z"})
    private static final class Visitor
    extends KtVisitorVoid {
        @NotNull
        private final ClassDescriptor enumDescriptor;
        @NotNull
        private final ClassDescriptor companionDescriptor;
        @NotNull
        private final BindingContext context;
        @NotNull
        private final DiagnosticSink reporter;
        private final boolean reportError;

        public Visitor(@NotNull ClassDescriptor enumDescriptor, @NotNull ClassDescriptor companionDescriptor, @NotNull BindingContext context, @NotNull DiagnosticSink reporter, boolean reportError) {
            Intrinsics.checkNotNullParameter(enumDescriptor, "enumDescriptor");
            Intrinsics.checkNotNullParameter(companionDescriptor, "companionDescriptor");
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(reporter, "reporter");
            this.enumDescriptor = enumDescriptor;
            this.companionDescriptor = companionDescriptor;
            this.context = context;
            this.reporter = reporter;
            this.reportError = reportError;
        }

        @NotNull
        public final ClassDescriptor getEnumDescriptor() {
            return this.enumDescriptor;
        }

        @NotNull
        public final ClassDescriptor getCompanionDescriptor() {
            return this.companionDescriptor;
        }

        @NotNull
        public final BindingContext getContext() {
            return this.context;
        }

        @NotNull
        public final DiagnosticSink getReporter() {
            return this.reporter;
        }

        public final boolean getReportError() {
            return this.reportError;
        }

        @Override
        public void visitElement(@NotNull PsiElement element) {
            Intrinsics.checkNotNullParameter(element, "element");
            element.acceptChildren(this);
        }

        @Override
        public void visitExpression(@NotNull KtExpression expression) {
            block2: {
                block1: {
                    Intrinsics.checkNotNullParameter(expression, "expression");
                    boolean needAnalyzeReceiver = this.analyzeExpression(expression);
                    if (!needAnalyzeReceiver) break block1;
                    expression.acceptChildren(this);
                    break block2;
                }
                if (!(expression instanceof KtCallExpression)) break block2;
                KtValueArgumentList ktValueArgumentList = ((KtCallExpression)expression).getValueArgumentList();
                if (ktValueArgumentList != null) {
                    ktValueArgumentList.acceptChildren(this);
                }
            }
        }

        private final boolean analyzeExpression(KtExpression expression) {
            if (expression.getParent() instanceof KtCallExpression) {
                return true;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(expression, this.context);
            if (resolvedCall2 == null) {
                return true;
            }
            ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
            DeclarationDescriptor dispatchDescriptor = INSTANCE.getResolvedDescriptor(resolvedCall3.getDispatchReceiver());
            DeclarationDescriptor extensionDescriptor = INSTANCE.getResolvedDescriptor(resolvedCall3.getExtensionReceiver());
            boolean dispatchIsCompanion = Intrinsics.areEqual(dispatchDescriptor, this.companionDescriptor);
            boolean extensionIsCompanion = Intrinsics.areEqual(extensionDescriptor, this.companionDescriptor);
            if (dispatchIsCompanion || extensionIsCompanion) {
                KtExpression ktExpression;
                KtExpression receiverExpression;
                KtQualifiedExpression ktQualifiedExpression = expression instanceof KtQualifiedExpression ? (KtQualifiedExpression)expression : null;
                KtExpression ktExpression2 = receiverExpression = ktQualifiedExpression != null ? ktQualifiedExpression.getReceiverExpression() : null;
                if ((receiverExpression instanceof KtSimpleNameExpression ? receiverExpression : (ktExpression = receiverExpression instanceof KtQualifiedExpression ? ((KtQualifiedExpression)receiverExpression).getSelectorExpression() : null)) == null) {
                    ktExpression = expression;
                }
                KtExpression reportOn = ktExpression;
                DiagnosticFactory1<KtExpression, ClassDescriptor> factory2 = this.reportError ? Errors.UNINITIALIZED_ENUM_COMPANION : Errors.UNINITIALIZED_ENUM_COMPANION_WARNING;
                this.reporter.report(factory2.on((KtExpression)((PsiElement)reportOn), this.enumDescriptor));
                return false;
            }
            return true;
        }
    }
}

