/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/FunInterfaceDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "abstractMember", "Lcom/intellij/psi/PsiElement;", "funInterfaceKeyword", "checkSingleAbstractMember", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V"})
public final class FunInterfaceDeclarationChecker
implements DeclarationChecker {
    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        void $this$filterIsInstanceTo$iv$iv;
        Object reportOn;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(declaration instanceof KtClass)) {
            return;
        }
        if (!(descriptor2 instanceof ClassDescriptor) || !((ClassDescriptor)descriptor2).isFun()) {
            return;
        }
        PsiElement psiElement = ((KtClass)declaration).getFunKeyword();
        if (psiElement == null) {
            return;
        }
        PsiElement funKeyword = psiElement;
        List<CallableMemberDescriptor> abstractMembers = SamConversionResolverImplKt.getAbstractMembers((ClassDescriptor)descriptor2);
        for (CallableMemberDescriptor abstractMember : abstractMembers) {
            PsiElement psiElement2;
            if (!(abstractMember instanceof PropertyDescriptor)) continue;
            boolean reportOnProperty = Intrinsics.areEqual(((PropertyDescriptor)abstractMember).getContainingDeclaration(), descriptor2);
            if (reportOnProperty) {
                SourceElement sourceElement = ((PropertyDescriptor)abstractMember).getSource();
                Intrinsics.checkNotNullExpressionValue(sourceElement, "getSource(...)");
                PsiElement psiElement3 = PsiSourceElementKt.getPsi(sourceElement);
                psiElement2 = psiElement3 instanceof KtProperty ? (KtProperty)psiElement3 : null;
                if (psiElement2 == null || (psiElement2 = ((KtProperty)psiElement2).getValOrVarKeyword()) == null) {
                    psiElement2 = funKeyword;
                }
            } else {
                psiElement2 = funKeyword;
            }
            reportOn = psiElement2;
            context.getTrace().report(Errors.FUN_INTERFACE_CANNOT_HAVE_ABSTRACT_PROPERTIES.on((PsiElement)reportOn));
            if (reportOnProperty) continue;
            return;
        }
        Iterable $this$filterIsInstance$iv = abstractMembers;
        boolean $i$f$filterIsInstance = false;
        reportOn = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FunctionDescriptor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        FunctionDescriptor abstractMember = (FunctionDescriptor)CollectionsKt.singleOrNull((List)destination$iv$iv);
        if (abstractMember == null) {
            context.getTrace().report(Errors.FUN_INTERFACE_WRONG_COUNT_OF_ABSTRACT_MEMBERS.on(funKeyword));
            return;
        }
        this.checkSingleAbstractMember(abstractMember, funKeyword, context);
    }

    private final void checkSingleAbstractMember(FunctionDescriptor abstractMember, PsiElement funInterfaceKeyword, DeclarationCheckerContext context) {
        SourceElement sourceElement = abstractMember.getSource();
        Intrinsics.checkNotNullExpressionValue(sourceElement, "getSource(...)");
        PsiElement psiElement = PsiSourceElementKt.getPsi(sourceElement);
        KtNamedFunction ktFunction = psiElement instanceof KtNamedFunction ? (KtNamedFunction)psiElement : null;
        List<TypeParameterDescriptor> list = abstractMember.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getTypeParameters(...)");
        if (!((Collection)list).isEmpty()) {
            PsiElement psiElement2;
            KtElementImplStub ktElementImplStub = ktFunction;
            if (ktElementImplStub != null && (ktElementImplStub = ktElementImplStub.getTypeParameterList()) != null) {
                psiElement2 = ktElementImplStub;
            } else {
                KtNamedFunction ktNamedFunction = ktFunction;
                psiElement2 = ktNamedFunction != null ? ktNamedFunction.getFunKeyword() : null;
                if (psiElement2 == null) {
                    psiElement2 = funInterfaceKeyword;
                }
            }
            PsiElement reportOn = psiElement2;
            context.getTrace().report(Errors.FUN_INTERFACE_ABSTRACT_METHOD_WITH_TYPE_PARAMETERS.on(reportOn));
            return;
        }
        for (ValueParameterDescriptor parameter : abstractMember.getValueParameters()) {
            Intrinsics.checkNotNull(parameter);
            if (!ArgumentsUtilsKt.hasDefaultValue(parameter)) continue;
            SourceElement sourceElement2 = parameter.getSource();
            Intrinsics.checkNotNullExpressionValue(sourceElement2, "getSource(...)");
            PsiElement psiElement3 = PsiSourceElementKt.getPsi(sourceElement2);
            if (psiElement3 == null) {
                KtNamedFunction ktNamedFunction = ktFunction;
                psiElement3 = ktNamedFunction != null ? ktNamedFunction.getFunKeyword() : null;
                if (psiElement3 == null) {
                    psiElement3 = funInterfaceKeyword;
                }
            }
            PsiElement reportOn = psiElement3;
            context.getTrace().report(Errors.FUN_INTERFACE_ABSTRACT_METHOD_WITH_DEFAULT_VALUE.on(reportOn));
            return;
        }
    }
}

