/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.MissingSupertypesResolver;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForObject;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ/\u0010\r\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MissingDependencySupertypeChecker;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/types/KotlinType;", "classifierType", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;", "missingSupertypesResolver", "", "checkSupertypes", "(Lorg/jetbrains/kotlin/types/KotlinType;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;)Z", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "declaration", "(Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/resolve/MissingSupertypesResolver;)Z", "ForDeclarations", "ForCalls"})
public final class MissingDependencySupertypeChecker {
    @NotNull
    public static final MissingDependencySupertypeChecker INSTANCE = new MissingDependencySupertypeChecker();

    private MissingDependencySupertypeChecker() {
    }

    public final boolean checkSupertypes(@NotNull KotlinType classifierType, @NotNull PsiElement reportOn, @NotNull BindingTrace trace, @NotNull MissingSupertypesResolver missingSupertypesResolver) {
        Intrinsics.checkNotNullParameter(classifierType, "classifierType");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(missingSupertypesResolver, "missingSupertypesResolver");
        return this.checkSupertypes(classifierType.getConstructor().getDeclarationDescriptor(), reportOn, trace, missingSupertypesResolver);
    }

    public final boolean checkSupertypes(@Nullable DeclarationDescriptor declaration, @NotNull PsiElement reportOn, @NotNull BindingTrace trace, @NotNull MissingSupertypesResolver missingSupertypesResolver) {
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(missingSupertypesResolver, "missingSupertypesResolver");
        if (!(declaration instanceof ClassifierDescriptor)) {
            return false;
        }
        Set<ClassifierDescriptor> missingSupertypes = missingSupertypesResolver.getMissingSuperClassifiers((ClassifierDescriptor)declaration);
        for (ClassifierDescriptor missingClassifier : missingSupertypes) {
            trace.report(Errors.MISSING_DEPENDENCY_SUPERCLASS.on(reportOn, DescriptorUtilsKt.getFqNameSafe(missingClassifier), DescriptorUtilsKt.getFqNameSafe(declaration)));
        }
        return !((Collection)missingSupertypes).isEmpty();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u000e*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MissingDependencySupertypeChecker$ForCalls;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "getDeclaration", "(Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;)Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "declaration"})
    public static final class ForCalls
    implements CallChecker {
        @NotNull
        public static final ForCalls INSTANCE = new ForCalls();

        private ForCalls() {
        }

        @Override
        public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
            boolean unresolvedLazySupertypesByDefault;
            Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
            Intrinsics.checkNotNullParameter(reportOn, "reportOn");
            Intrinsics.checkNotNullParameter(context, "context");
            Object obj = resolvedCall2.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(obj, "getResultingDescriptor(...)");
            Object descriptor2 = obj;
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getDispatchReceiverParameter();
            boolean errorReported = INSTANCE.checkSupertypes(receiverParameterDescriptor != null ? this.getDeclaration(receiverParameterDescriptor) : null, reportOn, context.getTrace(), context.getMissingSupertypesResolver());
            boolean eagerChecksAllowed = context.getLanguageVersionSettings().getFlag(AnalysisFlags.getExtendedCompilerChecks());
            boolean bl = unresolvedLazySupertypesByDefault = descriptor2 instanceof ConstructorDescriptor || descriptor2 instanceof FakeCallableDescriptorForObject;
            if (eagerChecksAllowed || !unresolvedLazySupertypesByDefault && !errorReported) {
                INSTANCE.checkSupertypes(descriptor2.getContainingDeclaration(), reportOn, context.getTrace(), context.getMissingSupertypesResolver());
                ReceiverParameterDescriptor receiverParameterDescriptor2 = descriptor2.getExtensionReceiverParameter();
                INSTANCE.checkSupertypes(receiverParameterDescriptor2 != null ? this.getDeclaration(receiverParameterDescriptor2) : null, reportOn, context.getTrace(), context.getMissingSupertypesResolver());
            }
        }

        private final ClassifierDescriptor getDeclaration(ReceiverParameterDescriptor $this$declaration) {
            return $this$declaration.getValue().getType().getConstructor().getDeclarationDescriptor();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MissingDependencySupertypeChecker$ForDeclarations;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V"})
    public static final class ForDeclarations
    implements DeclarationChecker {
        @NotNull
        public static final ForDeclarations INSTANCE = new ForDeclarations();

        private ForDeclarations() {
        }

        @Override
        public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(context, "context");
            BindingTrace trace = context.getTrace();
            if (descriptor2 instanceof ClassDescriptor) {
                INSTANCE.checkSupertypes(descriptor2, (PsiElement)declaration, trace, context.getMissingSupertypesResolver());
            }
            if (declaration instanceof KtTypeParameterListOwner) {
                for (KtTypeParameter ktTypeParameter : ((KtTypeParameterListOwner)declaration).getTypeParameters()) {
                    TypeParameterDescriptor typeParameterDescriptor;
                    if ((TypeParameterDescriptor)trace.getBindingContext().get(BindingContext.TYPE_PARAMETER, ktTypeParameter) == null) continue;
                    for (KotlinType upperBound : typeParameterDescriptor.getUpperBounds()) {
                        Intrinsics.checkNotNull(upperBound);
                        Intrinsics.checkNotNull(ktTypeParameter);
                        INSTANCE.checkSupertypes(upperBound, (PsiElement)ktTypeParameter, trace, context.getMissingSupertypesResolver());
                    }
                }
            }
        }
    }
}

