/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.source.PsiSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\r\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ'\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/MultiFieldValueClassAnnotationsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "name", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "annotationEntry", "", "report", "(Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;Ljava/lang/String;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;)V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V"})
public final class MultiFieldValueClassAnnotationsChecker
implements DeclarationChecker {
    @NotNull
    public static final MultiFieldValueClassAnnotationsChecker INSTANCE = new MultiFieldValueClassAnnotationsChecker();

    private MultiFieldValueClassAnnotationsChecker() {
    }

    private final void report(DeclarationCheckerContext context, String name, KotlinType type2, KtAnnotationEntry annotationEntry2) {
        if (!InlineClassesUtilsKt.needsMfvcFlattening(type2)) {
            return;
        }
        context.getTrace().report(Errors.ANNOTATION_ON_ILLEGAL_MULTI_FIELD_VALUE_CLASS_TYPED_TARGET.on((KtAnnotationEntry)((PsiElement)annotationEntry2), name));
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        block15: {
            ParameterDescriptor it;
            DeclarationDescriptor declarationDescriptor;
            block16: {
                block14: {
                    Object it2;
                    Object object;
                    KotlinType kotlinType;
                    KtExpression ktExpression;
                    Intrinsics.checkNotNullParameter(declaration, "declaration");
                    Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
                    Intrinsics.checkNotNullParameter(context, "context");
                    declarationDescriptor = descriptor2;
                    if (!(declarationDescriptor instanceof PropertyDescriptor)) break block14;
                    FieldDescriptor fieldDescriptor = ((PropertyDescriptor)descriptor2).getBackingField();
                    if (fieldDescriptor != null) {
                        FieldDescriptor it3 = fieldDescriptor;
                        boolean bl = false;
                        KotlinType kotlinType2 = ((PropertyDescriptor)descriptor2).getType();
                        Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
                        MultiFieldValueClassAnnotationsChecker.check$report(context, "fields", kotlinType2, it3.getAnnotations());
                    }
                    if ((ktExpression = declaration instanceof KtProperty ? (KtProperty)declaration : null) != null && (ktExpression = ktExpression.getDelegateExpression()) != null) {
                        BindingContext bindingContext = context.getTrace().getBindingContext();
                        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                        kotlinType = CallUtilKt.getType(ktExpression, bindingContext);
                    } else {
                        kotlinType = null;
                    }
                    KotlinType delegateType = kotlinType;
                    FieldDescriptor fieldDescriptor2 = ((PropertyDescriptor)descriptor2).getDelegateField();
                    if (fieldDescriptor2 != null) {
                        FieldDescriptor it4 = fieldDescriptor2;
                        boolean bl = false;
                        if (delegateType != null) {
                            MultiFieldValueClassAnnotationsChecker.check$report(context, "delegate fields", delegateType, it4.getAnnotations());
                        }
                    }
                    PropertyGetterDescriptor propertyGetterDescriptor = ((PropertyDescriptor)descriptor2).getGetter();
                    if (propertyGetterDescriptor != null) {
                        PropertyGetterDescriptor getterDescriptor = propertyGetterDescriptor;
                        boolean bl = false;
                        List<ReceiverParameterDescriptor> list = getterDescriptor.getContextReceiverParameters();
                        Intrinsics.checkNotNullExpressionValue(list, "getContextReceiverParameters(...)");
                        if (!(!((Collection)list).isEmpty()) && getterDescriptor.getExtensionReceiverParameter() == null) {
                            KotlinType kotlinType3 = getterDescriptor.getReturnType();
                            if (kotlinType3 != null) {
                                KotlinType type2 = kotlinType3;
                                MultiFieldValueClassAnnotationsChecker.check$report(context, "getters", type2, getterDescriptor.getAnnotations());
                            }
                        }
                    }
                    if ((object = ((PropertyDescriptor)descriptor2).getSetter()) != null && (object = object.getValueParameters()) != null && (object = (ValueParameterDescriptor)CollectionsKt.single(object)) != null) {
                        it2 = object;
                        boolean bl = false;
                        KotlinType kotlinType4 = it2.getType();
                        Intrinsics.checkNotNullExpressionValue(kotlinType4, "getType(...)");
                        MultiFieldValueClassAnnotationsChecker.check$report(context, "parameters", kotlinType4, it2.getAnnotations());
                    }
                    ReceiverParameterDescriptor receiverParameterDescriptor = ((PropertyDescriptor)descriptor2).getExtensionReceiverParameter();
                    if (receiverParameterDescriptor != null) {
                        ReceiverParameterDescriptor it5 = receiverParameterDescriptor;
                        boolean bl = false;
                        KotlinType kotlinType5 = it5.getType();
                        Intrinsics.checkNotNullExpressionValue(kotlinType5, "getType(...)");
                        MultiFieldValueClassAnnotationsChecker.check$report(context, "receivers", kotlinType5, it5.getAnnotations());
                    }
                    List<ReceiverParameterDescriptor> list = ((PropertyDescriptor)descriptor2).getContextReceiverParameters();
                    Intrinsics.checkNotNullExpressionValue(list, "getContextReceiverParameters(...)");
                    Iterable $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it2 = (ReceiverParameterDescriptor)element$iv;
                        boolean bl = false;
                        KotlinType kotlinType6 = it2.getType();
                        Intrinsics.checkNotNullExpressionValue(kotlinType6, "getType(...)");
                        MultiFieldValueClassAnnotationsChecker.check$report(context, "receivers", kotlinType6, it2.getAnnotations());
                    }
                    break block15;
                }
                if (declarationDescriptor instanceof PropertyAccessorDescriptor) break block15;
                if (!(declarationDescriptor instanceof LocalVariableDescriptor)) break block16;
                KotlinType kotlinType = ((LocalVariableDescriptor)descriptor2).getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                Annotations annotations2 = ((LocalVariableDescriptor)descriptor2).getAnnotations();
                Intrinsics.checkNotNullExpressionValue(annotations2, "<get-annotations>(...)");
                MultiFieldValueClassAnnotationsChecker.check$report(context, "variables", kotlinType, annotations2);
                break block15;
            }
            if (!(declarationDescriptor instanceof CallableDescriptor)) break block15;
            ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)descriptor2).getExtensionReceiverParameter();
            if (receiverParameterDescriptor != null) {
                ReceiverParameterDescriptor it6 = receiverParameterDescriptor;
                boolean bl = false;
                KotlinType kotlinType = it6.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                MultiFieldValueClassAnnotationsChecker.check$report(context, "receivers", kotlinType, it6.getAnnotations());
            }
            List<ReceiverParameterDescriptor> list = ((CallableDescriptor)descriptor2).getContextReceiverParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getContextReceiverParameters(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ReceiverParameterDescriptor)element$iv;
                boolean bl = false;
                KotlinType kotlinType = it.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                MultiFieldValueClassAnnotationsChecker.check$report(context, "receivers", kotlinType, it.getAnnotations());
            }
            List<ValueParameterDescriptor> list2 = ((CallableDescriptor)descriptor2).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
            $this$forEach$iv = list2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (ValueParameterDescriptor)element$iv;
                boolean bl = false;
                KotlinType kotlinType = it.getType();
                Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
                MultiFieldValueClassAnnotationsChecker.check$report(context, "parameters", kotlinType, it.getAnnotations());
            }
        }
    }

    private static final void check$report(DeclarationCheckerContext $context, String name, KotlinType type2, Annotations annotations2) {
        for (AnnotationDescriptor annotationDescriptor : annotations2) {
            PsiElement psiElement = PsiSourceElementKt.getPsi(annotationDescriptor.getSource());
            Intrinsics.checkNotNull(psiElement, "null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
            INSTANCE.report($context, name, type2, (KtAnnotationEntry)psiElement);
        }
    }
}

