/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.checkers.PrimitiveNumericComparisonInfo;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u000b\u001a\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ9\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0014\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0018\u001a\u00020\u0017*\u0006\u0012\u0002\b\u00030\u0004H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0013\u0010\u001e\u001a\u00020\u0010*\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ!\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\b2\u0006\u0010 \u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b!\u0010\"J\u001b\u0010#\u001a\u0004\u0018\u00010\u0010*\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010%\u001a\u0004\u0018\u00010\u0010*\u00020\u0010H\u0002\u00a2\u0006\u0004\b%\u0010\u001fR\u001e\u0010(\u001a\f\u0012\b\u0012\u0006*\u00020'0'0&8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b(\u0010)"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/PrimitiveNumericComparisonCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "Lcom/intellij/psi/PsiElement;", "reportOn", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;)V", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "leftTypes", "rightTypes", "Lorg/jetbrains/kotlin/psi/KtExpression;", "comparison", "inferPrimitiveNumericComparisonType", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Ljava/util/List;Ljava/util/List;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "", "isStandardComparison", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;)Z", "t1", "t2", "leastCommonPrimitiveNumericType", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/types/KotlinType;", "promoteIntegerTypeToIntIfRequired", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/types/KotlinType;", "expression", "getStableTypesForExpression", "(Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;Lorg/jetbrains/kotlin/psi/KtExpression;)Ljava/util/List;", "findPrimitiveOrNullablePrimitiveType", "(Ljava/util/List;)Lorg/jetbrains/kotlin/types/KotlinType;", "getPrimitiveTypeOrSupertype", "", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "comparisonOperatorTokens", "Ljava/util/Set;"})
public final class PrimitiveNumericComparisonCallChecker
implements CallChecker {
    @NotNull
    public static final PrimitiveNumericComparisonCallChecker INSTANCE = new PrimitiveNumericComparisonCallChecker();
    @NotNull
    private static final Set<KtSingleValueToken> comparisonOperatorTokens;

    private PrimitiveNumericComparisonCallChecker() {
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context, "context");
        KtElement ktElement = resolvedCall2.getCall().getCallElement();
        KtBinaryExpression ktBinaryExpression = ktElement instanceof KtBinaryExpression ? (KtBinaryExpression)ktElement : null;
        if (ktBinaryExpression == null) {
            return;
        }
        KtBinaryExpression binaryExpression = ktBinaryExpression;
        if (!CollectionsKt.contains((Iterable)comparisonOperatorTokens, binaryExpression.getOperationReference().getReferencedNameElementType())) {
            return;
        }
        if (!this.isStandardComparison(resolvedCall2)) {
            return;
        }
        KtExpression ktExpression = binaryExpression.getLeft();
        if (ktExpression == null) {
            return;
        }
        KtExpression leftExpr = ktExpression;
        KtExpression ktExpression2 = binaryExpression.getRight();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression rightExpr = ktExpression2;
        List<KotlinType> leftTypes = this.getStableTypesForExpression(context, leftExpr);
        List<KotlinType> rightTypes = this.getStableTypesForExpression(context, rightExpr);
        this.inferPrimitiveNumericComparisonType(context.getTrace(), leftTypes, rightTypes, binaryExpression);
    }

    public final void inferPrimitiveNumericComparisonType(@NotNull BindingTrace trace, @NotNull List<? extends KotlinType> leftTypes, @NotNull List<? extends KotlinType> rightTypes, @NotNull KtExpression comparison) {
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(leftTypes, "leftTypes");
        Intrinsics.checkNotNullParameter(rightTypes, "rightTypes");
        Intrinsics.checkNotNullParameter(comparison, "comparison");
        KotlinType kotlinType = this.findPrimitiveOrNullablePrimitiveType(leftTypes);
        if (kotlinType == null) {
            return;
        }
        KotlinType leftPrimitiveOrNullableType = kotlinType;
        KotlinType kotlinType2 = this.findPrimitiveOrNullablePrimitiveType(rightTypes);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType rightPrimitiveOrNullableType = kotlinType2;
        KotlinType leftPrimitiveType = TypeUtilsKt.makeNotNullable(leftPrimitiveOrNullableType);
        KotlinType rightPrimitiveType = TypeUtilsKt.makeNotNullable(rightPrimitiveOrNullableType);
        KotlinType leastCommonType = this.leastCommonPrimitiveNumericType(leftPrimitiveType, rightPrimitiveType);
        trace.record(BindingContext.PRIMITIVE_NUMERIC_COMPARISON_INFO, comparison, new PrimitiveNumericComparisonInfo(leastCommonType, leftPrimitiveType, rightPrimitiveType, leftPrimitiveOrNullableType, rightPrimitiveOrNullableType));
    }

    private final boolean isStandardComparison(ResolvedCall<?> $this$isStandardComparison) {
        return $this$isStandardComparison.getExtensionReceiver() == null && $this$isStandardComparison.getDispatchReceiver() != null && KotlinBuiltIns.isUnderKotlinPackage((DeclarationDescriptor)$this$isStandardComparison.getResultingDescriptor());
    }

    private final KotlinType leastCommonPrimitiveNumericType(KotlinType t1, KotlinType t2) {
        KotlinType kotlinType;
        KotlinType pt1 = this.promoteIntegerTypeToIntIfRequired(t1);
        KotlinType pt2 = this.promoteIntegerTypeToIntIfRequired(t2);
        if (TypeUtilsKt.isDouble(pt1) || TypeUtilsKt.isDouble(pt2)) {
            SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(t1).getDoubleType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "getDoubleType(...)");
            kotlinType = simpleType2;
        } else if (TypeUtilsKt.isFloat(pt1) || TypeUtilsKt.isFloat(pt2)) {
            SimpleType simpleType3 = TypeUtilsKt.getBuiltIns(t1).getFloatType();
            Intrinsics.checkNotNullExpressionValue(simpleType3, "getFloatType(...)");
            kotlinType = simpleType3;
        } else if (TypeUtilsKt.isLong(pt1) || TypeUtilsKt.isLong(pt2)) {
            SimpleType simpleType4 = TypeUtilsKt.getBuiltIns(t1).getLongType();
            Intrinsics.checkNotNullExpressionValue(simpleType4, "getLongType(...)");
            kotlinType = simpleType4;
        } else if (TypeUtilsKt.isInt(pt1) || TypeUtilsKt.isInt(pt2)) {
            SimpleType simpleType5 = TypeUtilsKt.getBuiltIns(t1).getIntType();
            Intrinsics.checkNotNullExpressionValue(simpleType5, "getIntType(...)");
            kotlinType = simpleType5;
        } else {
            throw new AssertionError((Object)("Unexpected types: t1=" + t1 + ", t2=" + t2));
        }
        return kotlinType;
    }

    private final KotlinType promoteIntegerTypeToIntIfRequired(KotlinType $this$promoteIntegerTypeToIntIfRequired) {
        KotlinType kotlinType;
        if (!TypeUtilsKt.isPrimitiveNumberType($this$promoteIntegerTypeToIntIfRequired)) {
            throw new AssertionError((Object)("Primitive number type expected: " + $this$promoteIntegerTypeToIntIfRequired));
        }
        if (TypeUtilsKt.isByte($this$promoteIntegerTypeToIntIfRequired) || TypeUtilsKt.isShort($this$promoteIntegerTypeToIntIfRequired)) {
            SimpleType simpleType2 = TypeUtilsKt.getBuiltIns($this$promoteIntegerTypeToIntIfRequired).getIntType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "getIntType(...)");
            kotlinType = simpleType2;
        } else {
            kotlinType = $this$promoteIntegerTypeToIntIfRequired;
        }
        return kotlinType;
    }

    private final List<KotlinType> getStableTypesForExpression(CallCheckerContext $this$getStableTypesForExpression, KtExpression expression) {
        KotlinType kotlinType = $this$getStableTypesForExpression.getTrace().getBindingContext().getType(expression);
        if (kotlinType == null) {
            return CollectionsKt.emptyList();
        }
        KotlinType type2 = kotlinType;
        DataFlowValueFactory dataFlowValueFactory = $this$getStableTypesForExpression.getDataFlowValueFactory();
        BindingContext bindingContext = $this$getStableTypesForExpression.getTrace().getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        DataFlowValue dataFlowValue = dataFlowValueFactory.createDataFlowValue(expression, type2, bindingContext, $this$getStableTypesForExpression.getResolutionContext().scope.getOwnerDescriptor());
        Object object = (KotlinTypeInfo)$this$getStableTypesForExpression.getTrace().get(BindingContext.EXPRESSION_TYPE_INFO, expression);
        if (object == null || (object = ((KotlinTypeInfo)object).getDataFlowInfo()) == null) {
            return CollectionsKt.emptyList();
        }
        Object dataFlowInfo = object;
        Set<KotlinType> stableTypes = dataFlowInfo.getStableTypes(dataFlowValue, $this$getStableTypesForExpression.getLanguageVersionSettings());
        return CollectionsKt.plus((Collection)CollectionsKt.listOf(type2), (Iterable)stableTypes);
    }

    private final KotlinType findPrimitiveOrNullablePrimitiveType(List<? extends KotlinType> $this$findPrimitiveOrNullablePrimitiveType) {
        KotlinType kotlinType;
        block1: {
            for (KotlinType it : (Iterable)$this$findPrimitiveOrNullablePrimitiveType) {
                boolean bl = false;
                KotlinType kotlinType2 = INSTANCE.getPrimitiveTypeOrSupertype(it);
                if (kotlinType2 == null) continue;
                kotlinType = kotlinType2;
                break block1;
            }
            kotlinType = null;
        }
        return kotlinType;
    }

    private final KotlinType getPrimitiveTypeOrSupertype(KotlinType $this$getPrimitiveTypeOrSupertype) {
        KotlinType kotlinType;
        block3: {
            if ($this$getPrimitiveTypeOrSupertype.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                for (KotlinType it : (Iterable)TypeUtilsKt.immediateSupertypes($this$getPrimitiveTypeOrSupertype)) {
                    boolean bl = false;
                    KotlinType kotlinType2 = INSTANCE.getPrimitiveTypeOrSupertype(it);
                    if (kotlinType2 == null) continue;
                    kotlinType = kotlinType2;
                    break block3;
                }
                kotlinType = null;
            } else {
                kotlinType = TypeUtilsKt.isPrimitiveNumberOrNullableType($this$getPrimitiveTypeOrSupertype) ? $this$getPrimitiveTypeOrSupertype : null;
            }
        }
        return kotlinType;
    }

    static {
        KtSingleValueToken[] ktSingleValueTokenArray = new KtSingleValueToken[]{KtTokens.EQEQ, KtTokens.EXCLEQ, KtTokens.LT, KtTokens.LTEQ, KtTokens.GT, KtTokens.GTEQ};
        comparisonOperatorTokens = SetsKt.setOf(ktSingleValueTokenArray);
    }
}

