/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/PrivateInlineFunctionsReturningAnonymousObjectsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "Lcom/intellij/psi/PsiElement;", "reportOn", "checkTypeAndArguments", "(Lorg/jetbrains/kotlin/types/KotlinType;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V", "checkType"})
public final class PrivateInlineFunctionsReturningAnonymousObjectsChecker
implements DeclarationChecker {
    @NotNull
    public static final PrivateInlineFunctionsReturningAnonymousObjectsChecker INSTANCE = new PrivateInlineFunctionsReturningAnonymousObjectsChecker();

    private PrivateInlineFunctionsReturningAnonymousObjectsChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(descriptor2 instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)descriptor2).isInline() && DescriptorVisibilities.isPrivate(((SimpleFunctionDescriptor)descriptor2).getVisibility()) && declaration instanceof KtNamedFunction)) {
            return;
        }
        PsiElement psiElement = ((KtNamedFunction)declaration).getNameIdentifier();
        if (psiElement == null) {
            return;
        }
        PsiElement nameIdentifier = psiElement;
        KotlinType kotlinType = ((SimpleFunctionDescriptor)descriptor2).getReturnType();
        if (kotlinType == null) {
            return;
        }
        KotlinType returnType = kotlinType;
        this.checkTypeAndArguments(returnType, nameIdentifier, context);
    }

    private final void checkTypeAndArguments(KotlinType type2, PsiElement reportOn, DeclarationCheckerContext context) {
        this.checkType(type2, reportOn, context);
        for (TypeProjection argument : type2.getArguments()) {
            if (argument.isStarProjection()) continue;
            KotlinType kotlinType = argument.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            this.checkTypeAndArguments(kotlinType, reportOn, context);
        }
    }

    private final void checkType(KotlinType type2, PsiElement reportOn, DeclarationCheckerContext context) {
        TypeConstructor returnTypeConstructor = type2.getConstructor();
        ClassifierDescriptor classifierDescriptor = returnTypeConstructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return;
        }
        ClassifierDescriptor returnTypeDeclarationDescriptor = classifierDescriptor;
        if (DescriptorUtils.isAnonymousObject(returnTypeDeclarationDescriptor)) {
            context.getTrace().report(Errors.PRIVATE_INLINE_FUNCTIONS_RETURNING_ANONYMOUS_OBJECTS.on(reportOn));
        }
    }
}

