/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.ResultClassInReturnTypeCheckerKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/ResultClassInReturnTypeChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V", "Lorg/jetbrains/kotlin/types/KotlinType;", "returnType", "declarationDescriptor", "", "isForbiddenReturnType", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;)Z"})
public final class ResultClassInReturnTypeChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        LanguageVersionSettings languageVersionSettings = context.getLanguageVersionSettings();
        if (languageVersionSettings.supportsFeature(LanguageFeature.AllowNullOperatorsForResultAndResultReturnTypeByDefault)) {
            return;
        }
        if (!(declaration instanceof KtCallableDeclaration) || !(descriptor2 instanceof CallableMemberDescriptor)) {
            return;
        }
        KotlinType kotlinType = ((CallableMemberDescriptor)descriptor2).getReturnType();
        if (kotlinType == null) {
            return;
        }
        KotlinType returnType = kotlinType;
        if (this.isForbiddenReturnType(returnType, declaration, descriptor2)) {
            PsiElement psiElement;
            KtTypeReference ktTypeReference = ((KtCallableDeclaration)declaration).getTypeReference();
            if (ktTypeReference != null) {
                psiElement = ktTypeReference;
            } else {
                psiElement = ((KtCallableDeclaration)declaration).getNameIdentifier();
                if (psiElement == null) {
                    return;
                }
            }
            PsiElement typeReferenceOrDeclarationName = psiElement;
            BindingTrace bindingTrace = context.getTrace();
            SimpleDiagnostic<PsiElement> simpleDiagnostic = Errors.RESULT_CLASS_IN_RETURN_TYPE.on(typeReferenceOrDeclarationName);
            Intrinsics.checkNotNullExpressionValue(simpleDiagnostic, "on(...)");
            DiagnosticUtilsKt.reportDiagnosticOnce(bindingTrace, simpleDiagnostic);
        }
    }

    private final boolean isForbiddenReturnType(KotlinType returnType, KtDeclaration declaration, DeclarationDescriptor declarationDescriptor) {
        if (!ResultClassInReturnTypeCheckerKt.isResultType(returnType)) {
            return false;
        }
        if (declarationDescriptor instanceof PropertyDescriptor || declarationDescriptor instanceof PropertyGetterDescriptor) {
            if (declaration instanceof KtProperty) {
                KtPropertyAccessor ktPropertyAccessor = ((KtProperty)declaration).getGetter();
                boolean bl = ktPropertyAccessor != null ? ktPropertyAccessor.hasBody() : false;
                if (bl) {
                    return true;
                }
            }
            DescriptorVisibility descriptorVisibility = ((DeclarationDescriptorWithVisibility)declarationDescriptor).getVisibility();
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "getVisibility(...)");
            DescriptorVisibility visibility = descriptorVisibility;
            return !DescriptorVisibilities.isPrivate(visibility) && !Intrinsics.areEqual(visibility, DescriptorVisibilities.LOCAL);
        }
        return true;
    }
}

