/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.SuspendLimitationsCheckerKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/SuspendLimitationsChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V", "", "Lorg/jetbrains/kotlin/name/Name;", "UNSUPPORTED_OPERATOR_NAMES", "Ljava/util/Set;"})
public final class SuspendLimitationsChecker
implements DeclarationChecker {
    @NotNull
    public static final SuspendLimitationsChecker INSTANCE = new SuspendLimitationsChecker();
    @NotNull
    private static final Set<Name> UNSUPPORTED_OPERATOR_NAMES;

    private SuspendLimitationsChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        block8: {
            boolean bl;
            PsiElement it;
            block7: {
                Intrinsics.checkNotNullParameter(declaration, "declaration");
                Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
                Intrinsics.checkNotNullParameter(context, "context");
                if (!(descriptor2 instanceof FunctionDescriptor) || !((FunctionDescriptor)descriptor2).isSuspend()) {
                    return;
                }
                if (((FunctionDescriptor)descriptor2).isOperator() && UNSUPPORTED_OPERATOR_NAMES.contains(((FunctionDescriptor)descriptor2).getName())) {
                    PsiElement psiElement = declaration.getModifierList();
                    if (psiElement != null && (psiElement = psiElement.getModifier(KtTokens.OPERATOR_KEYWORD)) != null) {
                        it = psiElement;
                        boolean bl2 = false;
                        context.getTrace().report(Errors.UNSUPPORTED.on(it, "suspend operator \"" + ((FunctionDescriptor)descriptor2).getName() + '\"'));
                    }
                }
                Iterable $this$any$iv = descriptor2.getAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AnnotationDescriptor p0 = (AnnotationDescriptor)element$iv;
                        boolean bl3 = false;
                        if (!SuspendLimitationsCheckerKt.access$isKotlinTestAnnotation(p0)) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (!bl) break block8;
            PsiElement psiElement = declaration.getModifierList();
            if (psiElement != null && (psiElement = psiElement.getModifier(KtTokens.SUSPEND_KEYWORD)) != null) {
                it = psiElement;
                boolean bl4 = false;
                context.getTrace().report(Errors.UNSUPPORTED_SUSPEND_TEST.on(it));
            }
        }
    }

    static {
        Name[] nameArray = new Name[]{OperatorNameConventions.CONTAINS, OperatorNameConventions.GET, OperatorNameConventions.SET, OperatorNameConventions.PROVIDE_DELEGATE, OperatorNameConventions.GET_VALUE, OperatorNameConventions.SET_VALUE};
        UNSUPPORTED_OPERATOR_NAMES = SetsKt.setOf(nameArray);
    }
}

