/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.TrailingCommaChecker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/TrailingCommaDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V"})
public final class TrailingCommaDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final TrailingCommaDeclarationChecker INSTANCE = new TrailingCommaDeclarationChecker();

    private TrailingCommaDeclarationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        KtDeclaration ktDeclaration = declaration;
        if (ktDeclaration instanceof KtClass) {
            KtTypeParameterList ktTypeParameterList = ((KtClass)declaration).getTypeParameterList();
            TrailingCommaChecker.INSTANCE.check(ktTypeParameterList != null ? ktTypeParameterList.getTrailingComma() : null, context.getTrace(), context.getLanguageVersionSettings());
        } else if (ktDeclaration instanceof KtCallableDeclaration) {
            KtParameterList ktParameterList = ((KtCallableDeclaration)declaration).getValueParameterList();
            TrailingCommaChecker.INSTANCE.check(ktParameterList != null ? ktParameterList.getTrailingComma() : null, context.getTrace(), context.getLanguageVersionSettings());
            KtTypeParameterList ktTypeParameterList = ((KtCallableDeclaration)declaration).getTypeParameterList();
            TrailingCommaChecker.INSTANCE.check(ktTypeParameterList != null ? ktTypeParameterList.getTrailingComma() : null, context.getTrace(), context.getLanguageVersionSettings());
            if (declaration instanceof KtProperty && ((KtProperty)declaration).getSetter() != null) {
                KtElementImplStub ktElementImplStub = ((KtProperty)declaration).getSetter();
                TrailingCommaChecker.INSTANCE.check(ktElementImplStub != null && (ktElementImplStub = ((KtPropertyAccessor)ktElementImplStub).getParameterList()) != null ? ((KtParameterList)ktElementImplStub).getTrailingComma() : null, context.getTrace(), context.getLanguageVersionSettings());
            }
        } else if (ktDeclaration instanceof KtDestructuringDeclaration) {
            TrailingCommaChecker.INSTANCE.check(((KtDestructuringDeclaration)declaration).getTrailingComma(), context.getTrace(), context.getLanguageVersionSettings());
        } else if (ktDeclaration instanceof KtTypeAlias) {
            KtTypeParameterList ktTypeParameterList = ((KtTypeAlias)declaration).getTypeParameterList();
            TrailingCommaChecker.INSTANCE.check(ktTypeParameterList != null ? ktTypeParameterList.getTrailingComma() : null, context.getTrace(), context.getLanguageVersionSettings());
        }
    }
}

