/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.FunctionExpressionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J1\u0010\r\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eJ/\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0016H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/UnderscoreChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lcom/intellij/psi/PsiElement;", "identifier", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "diagnosticHolder", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "", "allowSingleUnderscore", "", "checkIdentifier", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Z)V", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "declaration", "checkNamed", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Z)V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V"})
public final class UnderscoreChecker
implements DeclarationChecker {
    @NotNull
    public static final UnderscoreChecker INSTANCE = new UnderscoreChecker();

    private UnderscoreChecker() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void checkIdentifier(@Nullable PsiElement identifier, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings, boolean allowSingleUnderscore) {
        boolean isValidSingleUnderscore;
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        if (identifier == null) return;
        String string2 = identifier.getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        if (((CharSequence)string2).length() == 0) {
            return;
        }
        boolean bl = false;
        if (bl) {
            return;
        }
        boolean bl2 = isValidSingleUnderscore = allowSingleUnderscore && Intrinsics.areEqual(identifier.getText(), "_");
        if (!isValidSingleUnderscore) {
            boolean bl3;
            block5: {
                String string3 = identifier.getText();
                Intrinsics.checkNotNullExpressionValue(string3, "getText(...)");
                CharSequence $this$all$iv = string3;
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(i);
                    boolean bl4 = false;
                    if (it == '_') continue;
                    bl3 = false;
                    break block5;
                }
                bl3 = true;
            }
            if (bl3) {
                diagnosticHolder.report(Errors.UNDERSCORE_IS_RESERVED.on(identifier));
                return;
            }
        }
        if (!isValidSingleUnderscore) return;
        if (languageVersionSettings.supportsFeature(LanguageFeature.SingleUnderscoreForParameterName)) return;
        diagnosticHolder.report(Errors.UNSUPPORTED_FEATURE.on(identifier, TuplesKt.to(LanguageFeature.SingleUnderscoreForParameterName, languageVersionSettings)));
    }

    public static /* synthetic */ void checkIdentifier$default(UnderscoreChecker underscoreChecker, PsiElement psiElement, DiagnosticSink diagnosticSink, LanguageVersionSettings languageVersionSettings, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        underscoreChecker.checkIdentifier(psiElement, diagnosticSink, languageVersionSettings, bl);
    }

    public final void checkNamed(@NotNull KtNamedDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings, boolean allowSingleUnderscore) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.checkIdentifier(declaration.getNameIdentifier(), diagnosticHolder, languageVersionSettings, allowSingleUnderscore);
    }

    public static /* synthetic */ void checkNamed$default(UnderscoreChecker underscoreChecker, KtNamedDeclaration ktNamedDeclaration, DiagnosticSink diagnosticSink, LanguageVersionSettings languageVersionSettings, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        underscoreChecker.checkNamed(ktNamedDeclaration, diagnosticSink, languageVersionSettings, bl);
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (declaration instanceof KtProperty && !(descriptor2 instanceof VariableDescriptor)) {
            return;
        }
        if (declaration instanceof KtCallableDeclaration) {
            for (KtParameter parameter : ((KtCallableDeclaration)declaration).getValueParameters()) {
                Intrinsics.checkNotNull(parameter);
                this.checkNamed(parameter, context.getTrace(), context.getLanguageVersionSettings(), descriptor2 instanceof FunctionExpressionDescriptor);
            }
        }
        if (declaration instanceof KtTypeParameterListOwner) {
            for (KtTypeParameter typeParameter : ((KtTypeParameterListOwner)declaration).getTypeParameters()) {
                Intrinsics.checkNotNull(typeParameter);
                UnderscoreChecker.checkNamed$default(this, typeParameter, context.getTrace(), context.getLanguageVersionSettings(), false, 8, null);
            }
        }
        if (!(declaration instanceof KtNamedDeclaration)) {
            return;
        }
        UnderscoreChecker.checkNamed$default(this, (KtNamedDeclaration)declaration, context.getTrace(), context.getLanguageVersionSettings(), false, 8, null);
    }

    public final void checkIdentifier(@Nullable PsiElement identifier, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        UnderscoreChecker.checkIdentifier$default(this, identifier, diagnosticHolder, languageVersionSettings, false, 8, null);
    }

    public final void checkNamed(@NotNull KtNamedDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        UnderscoreChecker.checkNamed$default(this, declaration, diagnosticHolder, languageVersionSettings, false, 8, null);
    }
}

