/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FieldDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0015\u0010\u000f\u001a\u0004\u0018\u00010\u000e*\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0012\u001a\u00020\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/VolatileAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V", "Lorg/jetbrains/kotlin/descriptors/FieldDescriptor;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "findVolatileAnnotation", "(Lorg/jetbrains/kotlin/descriptors/FieldDescriptor;)Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/name/FqName;", "JVM_VOLATILE_ANNOTATION_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "CONCURRENT_VOLATILE_ANNOTATION_FQ_NAME"})
public final class VolatileAnnotationChecker
implements DeclarationChecker {
    @NotNull
    public static final VolatileAnnotationChecker INSTANCE = new VolatileAnnotationChecker();
    @NotNull
    private static final FqName JVM_VOLATILE_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Volatile");
    @NotNull
    private static final FqName CONCURRENT_VOLATILE_ANNOTATION_FQ_NAME = new FqName("kotlin.concurrent.Volatile");

    private VolatileAnnotationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        AnnotationDescriptor delegateAnnotation;
        AnnotationDescriptor fieldAnnotation;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return;
        }
        FieldDescriptor fieldDescriptor = ((PropertyDescriptor)descriptor2).getBackingField();
        AnnotationDescriptor annotationDescriptor = fieldAnnotation = fieldDescriptor != null ? this.findVolatileAnnotation(fieldDescriptor) : null;
        if (fieldAnnotation != null && !((PropertyDescriptor)descriptor2).isVar()) {
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(fieldAnnotation);
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
            context.getTrace().report(Errors.VOLATILE_ON_VALUE.on((KtAnnotationEntry)((PsiElement)annotationEntry2)));
        }
        FieldDescriptor fieldDescriptor2 = ((PropertyDescriptor)descriptor2).getDelegateField();
        AnnotationDescriptor annotationDescriptor2 = delegateAnnotation = fieldDescriptor2 != null ? this.findVolatileAnnotation(fieldDescriptor2) : null;
        if (delegateAnnotation != null) {
            KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(delegateAnnotation);
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry3 = ktAnnotationEntry;
            context.getTrace().report(Errors.VOLATILE_ON_DELEGATE.on((KtAnnotationEntry)((PsiElement)annotationEntry3)));
        }
    }

    private final AnnotationDescriptor findVolatileAnnotation(FieldDescriptor $this$findVolatileAnnotation) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$findVolatileAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                AnnotationDescriptor it = (AnnotationDescriptor)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(it.getFqName(), JVM_VOLATILE_ANNOTATION_FQ_NAME) || Intrinsics.areEqual(it.getFqName(), CONCURRENT_VOLATILE_ANNOTATION_FQ_NAME))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

