/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u00020\u0001B-\u0012\u0010\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00010\u0002\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0005H\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ;\u0010\u0012\u001a\u0006*\u00028\u00008\u0000\"\u0004\b\u0000\u0010\r\"\u0004\b\u0001\u0010\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u000f2\u0006\u0010\u0011\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R \u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/ArrayValue;", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "", "value", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/types/KotlinType;", "computeType", "<init>", "(Ljava/util/List;Lkotlin/jvm/functions/Function1;)V", "module", "getType", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/types/KotlinType;", "R", "D", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;", "visitor", "data", "accept", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "Lkotlin/jvm/functions/Function1;"})
public class ArrayValue
extends ConstantValue<List<? extends ConstantValue<?>>> {
    @NotNull
    private final Function1<ModuleDescriptor, KotlinType> computeType;

    public ArrayValue(@NotNull List<? extends ConstantValue<?>> value2, @NotNull Function1<? super ModuleDescriptor, ? extends KotlinType> computeType) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(computeType, "computeType");
        super(value2);
        this.computeType = computeType;
    }

    @Override
    @NotNull
    public KotlinType getType(@NotNull ModuleDescriptor module2) {
        boolean bl;
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(module2, "module");
        KotlinType type2 = kotlinType = this.computeType.invoke(module2);
        boolean bl2 = false;
        boolean bl3 = bl = KotlinBuiltIns.isArray(type2) || KotlinBuiltIns.isPrimitiveArray(type2) || KotlinBuiltIns.isUnsignedArrayType(type2);
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string2 = "Type should be an array, but was " + type2 + ": " + this.getValue();
            throw new AssertionError((Object)string2);
        }
        return kotlinType;
    }

    @Override
    public <R, D> R accept(@NotNull AnnotationArgumentVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitArrayValue(this, data2);
    }
}

