/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0017\u00a2\u0006\u0004\b\t\u0010\nJ;\u0010\u0010\u001a\u0006*\u00028\u00008\u0000\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\r2\u0006\u0010\u000f\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0017\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/CharValue;", "Lorg/jetbrains/kotlin/resolve/constants/IntegerValueConstant;", "", "value", "<init>", "(C)V", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "module", "Lorg/jetbrains/kotlin/types/SimpleType;", "getType", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/types/SimpleType;", "R", "D", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;", "visitor", "data", "accept", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "", "toString", "()Ljava/lang/String;", "c", "getPrintablePart", "(C)Ljava/lang/String;", "", "isPrintableUnicode", "(C)Z"})
public final class CharValue
extends IntegerValueConstant<Character> {
    public CharValue(char value2) {
        super(Character.valueOf(value2));
    }

    @Override
    @NotNull
    public SimpleType getType(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkNotNullParameter(module2, "module");
        SimpleType simpleType2 = module2.getBuiltIns().getCharType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getCharType(...)");
        return simpleType2;
    }

    @Override
    public <R, D> R accept(@NotNull AnnotationArgumentVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitCharValue(this, data2);
    }

    @Override
    @NotNull
    public String toString() {
        String string2 = "\\u%04X ('%s')";
        Object[] objectArray = new Object[]{(int)((Character)this.getValue()).charValue(), this.getPrintablePart(((Character)this.getValue()).charValue())};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string3, "format(...)");
        return string3;
    }

    private final String getPrintablePart(char c) {
        String string2;
        switch (c) {
            case '\b': {
                string2 = "\\b";
                break;
            }
            case '\t': {
                string2 = "\\t";
                break;
            }
            case '\n': {
                string2 = "\\n";
                break;
            }
            case '\f': {
                string2 = "\\f";
                break;
            }
            case '\r': {
                string2 = "\\r";
                break;
            }
            default: {
                string2 = this.isPrintableUnicode(c) ? String.valueOf(c) : "?";
            }
        }
        return string2;
    }

    private final boolean isPrintableUnicode(char c) {
        byte t = (byte)Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }
}

