/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactoryKt;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.TypedArrayValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.resolve.constants.UnsignedValueConstant;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\n\u001a\u00020\t2\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ+\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\fH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J-\u0010\n\u001a\u00020\t2\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00042\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\n\u0010\u0016J-\u0010\u001b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0019H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/ConstantValueFactory;", "", "<init>", "()V", "", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "value", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "Lorg/jetbrains/kotlin/resolve/constants/ArrayValue;", "createArrayValue", "(Ljava/util/List;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/ArrayValue;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "module", "createConstantValue", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "constantValue", "Lorg/jetbrains/kotlin/resolve/constants/UnsignedValueConstant;", "createUnsignedValue", "(Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;)Lorg/jetbrains/kotlin/resolve/constants/UnsignedValueConstant;", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "componentType", "(Ljava/util/List;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/builtins/PrimitiveType;)Lorg/jetbrains/kotlin/resolve/constants/ArrayValue;", "", "expectedType", "", "isUnsigned", "createIntegerConstantValue", "(JLorg/jetbrains/kotlin/types/KotlinType;Z)Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;"})
public final class ConstantValueFactory {
    @NotNull
    public static final ConstantValueFactory INSTANCE = new ConstantValueFactory();

    private ConstantValueFactory() {
    }

    @NotNull
    public final ArrayValue createArrayValue(@NotNull List<? extends ConstantValue<?>> value2, @NotNull KotlinType type2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(type2, "type");
        return new TypedArrayValue(value2, type2);
    }

    @Nullable
    public final ConstantValue<?> createConstantValue(@Nullable Object value2, @Nullable ModuleDescriptor module2) {
        Object object = value2;
        return object instanceof Byte ? (ConstantValue)new ByteValue(((Number)value2).byteValue()) : (object instanceof Short ? (ConstantValue)new ShortValue(((Number)value2).shortValue()) : (object instanceof Integer ? (ConstantValue)new IntValue(((Number)value2).intValue()) : (object instanceof Long ? (ConstantValue)new LongValue(((Number)value2).longValue()) : (object instanceof Character ? (ConstantValue)new CharValue(((Character)value2).charValue()) : (object instanceof Float ? (ConstantValue)new FloatValue(((Number)value2).floatValue()) : (object instanceof Double ? (ConstantValue)new DoubleValue(((Number)value2).doubleValue()) : (object instanceof Boolean ? (ConstantValue)new BooleanValue((Boolean)value2) : (object instanceof String ? (ConstantValue)new StringValue((String)value2) : (object instanceof byte[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((byte[])value2), module2, PrimitiveType.BYTE) : (object instanceof short[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((short[])value2), module2, PrimitiveType.SHORT) : (object instanceof int[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((int[])value2), module2, PrimitiveType.INT) : (object instanceof long[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((long[])value2), module2, PrimitiveType.LONG) : (object instanceof char[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((char[])value2), module2, PrimitiveType.CHAR) : (object instanceof float[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((float[])value2), module2, PrimitiveType.FLOAT) : (object instanceof double[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((double[])value2), module2, PrimitiveType.DOUBLE) : (object instanceof boolean[] ? (ConstantValue)this.createArrayValue(ArraysKt.toList((boolean[])value2), module2, PrimitiveType.BOOLEAN) : (object == null ? (ConstantValue)new NullValue() : null)))))))))))))))));
    }

    public static /* synthetic */ ConstantValue createConstantValue$default(ConstantValueFactory constantValueFactory, Object object, ModuleDescriptor moduleDescriptor, int n, Object object2) {
        if ((n & 2) != 0) {
            moduleDescriptor = null;
        }
        return constantValueFactory.createConstantValue(object, moduleDescriptor);
    }

    @Nullable
    public final UnsignedValueConstant<?> createUnsignedValue(@NotNull ConstantValue<?> constantValue) {
        Intrinsics.checkNotNullParameter(constantValue, "constantValue");
        ConstantValue<?> constantValue2 = constantValue;
        return constantValue2 instanceof ByteValue ? (UnsignedValueConstant)new UByteValue(((Number)((ByteValue)constantValue).getValue()).byteValue()) : (constantValue2 instanceof ShortValue ? (UnsignedValueConstant)new UShortValue(((Number)((ShortValue)constantValue).getValue()).shortValue()) : (constantValue2 instanceof IntValue ? (UnsignedValueConstant)new UIntValue(((Number)((IntValue)constantValue).getValue()).intValue()) : (constantValue2 instanceof LongValue ? (UnsignedValueConstant)new ULongValue(((Number)((LongValue)constantValue).getValue()).longValue()) : null)));
    }

    /*
     * WARNING - void declaration
     */
    private final ArrayValue createArrayValue(List<?> value2, ModuleDescriptor module2, PrimitiveType componentType) {
        ArrayValue arrayValue;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionsKt.toList((Iterable)value2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConstantValue it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            Object p0 = element$iv$iv;
            boolean bl2 = false;
            if (ConstantValueFactory.createConstantValue$default(this, p0, null, 2, null) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List elements = (List)destination$iv$iv;
        if (module2 != null) {
            SimpleType simpleType2 = module2.getBuiltIns().getPrimitiveArrayKotlinType(componentType);
            Intrinsics.checkNotNullExpressionValue(simpleType2, "getPrimitiveArrayKotlinType(...)");
            arrayValue = new TypedArrayValue(elements, simpleType2);
        } else {
            arrayValue = new ArrayValue(elements, arg_0 -> ConstantValueFactory.createArrayValue$lambda$0(componentType, arg_0));
        }
        return arrayValue;
    }

    @Nullable
    public final ConstantValue<?> createIntegerConstantValue(long value2, @NotNull KotlinType expectedType, boolean isUnsigned) {
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        KotlinType kotlinType = TypeUtils.makeNotNullable(expectedType);
        Intrinsics.checkNotNullExpressionValue(kotlinType, "makeNotNullable(...)");
        KotlinType notNullExpected = kotlinType;
        return isUnsigned ? (ConstantValue)(KotlinBuiltIns.isUByte(notNullExpected) && value2 == ConstantValueFactoryKt.fromUByteToLong((byte)value2) ? (UnsignedValueConstant)new UByteValue((byte)value2) : (KotlinBuiltIns.isUShort(notNullExpected) && value2 == ConstantValueFactoryKt.fromUShortToLong((short)value2) ? (UnsignedValueConstant)new UShortValue((short)value2) : (KotlinBuiltIns.isUInt(notNullExpected) && value2 == ConstantValueFactoryKt.fromUIntToLong((int)value2) ? (UnsignedValueConstant)new UIntValue((int)value2) : (KotlinBuiltIns.isULong(notNullExpected) ? (UnsignedValueConstant)new ULongValue(value2) : null)))) : (ConstantValue)(KotlinBuiltIns.isLong(notNullExpected) ? (IntegerValueConstant)new LongValue(value2) : (KotlinBuiltIns.isInt(notNullExpected) && value2 == (long)((int)value2) ? (IntegerValueConstant)new IntValue((int)value2) : (KotlinBuiltIns.isShort(notNullExpected) && value2 == (long)((short)value2) ? (IntegerValueConstant)new ShortValue((short)value2) : (KotlinBuiltIns.isByte(notNullExpected) && value2 == (long)((byte)value2) ? (IntegerValueConstant)new ByteValue((byte)value2) : (KotlinBuiltIns.isChar(notNullExpected) ? (IntegerValueConstant)new IntValue((int)value2) : null)))));
    }

    private static final KotlinType createArrayValue$lambda$0(PrimitiveType $componentType, ModuleDescriptor it) {
        Intrinsics.checkNotNullParameter(it, "it");
        SimpleType simpleType2 = it.getBuiltIns().getPrimitiveArrayKotlinType($componentType);
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getPrimitiveArrayKotlinType(...)");
        return simpleType2;
    }
}

