/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.error.ErrorTypeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00020\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0017\u00a2\u0006\u0004\b\f\u0010\rJ;\u0010\u0013\u001a\u0006*\u00028\u00008\u0000\"\u0004\b\u0000\u0010\u000e\"\u0004\b\u0001\u0010\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00102\u0006\u0010\u0012\u001a\u00028\u0001H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0005\u001a\u00020\u00038\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0006\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001b\u001a\u0004\b\u001c\u0010\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/EnumValue;", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/name/Name;", "enumClassId", "enumEntryName", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/name/Name;)V", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "module", "Lorg/jetbrains/kotlin/types/KotlinType;", "getType", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/types/KotlinType;", "R", "D", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;", "visitor", "data", "accept", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationArgumentVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/name/ClassId;", "getEnumClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/name/Name;", "getEnumEntryName", "()Lorg/jetbrains/kotlin/name/Name;"})
public final class EnumValue
extends ConstantValue<Pair<? extends ClassId, ? extends Name>> {
    @NotNull
    private final ClassId enumClassId;
    @NotNull
    private final Name enumEntryName;

    public EnumValue(@NotNull ClassId enumClassId, @NotNull Name enumEntryName) {
        Intrinsics.checkNotNullParameter(enumClassId, "enumClassId");
        Intrinsics.checkNotNullParameter(enumEntryName, "enumEntryName");
        super(TuplesKt.to(enumClassId, enumEntryName));
        this.enumClassId = enumClassId;
        this.enumEntryName = enumEntryName;
    }

    @NotNull
    public final ClassId getEnumClassId() {
        return this.enumClassId;
    }

    @NotNull
    public final Name getEnumEntryName() {
        return this.enumEntryName;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public KotlinType getType(@NotNull ModuleDescriptor module2) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(module2, "module");
        Annotated annotated = FindClassInModuleKt.findClassAcrossModuleDependencies(module2, this.enumClassId);
        if (annotated != null) {
            ClassDescriptor classDescriptor = annotated;
            DeclarationDescriptor p0 = classDescriptor;
            boolean bl = false;
            annotated = DescriptorUtils.isEnumClass(p0) ? classDescriptor : null;
            if (annotated != null && (annotated = annotated.getDefaultType()) != null) {
                kotlinType = (KotlinType)annotated;
                return kotlinType;
            }
        }
        String[] stringArray = new String[]{this.enumClassId.toString(), this.enumEntryName.toString()};
        kotlinType = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_ENUM_TYPE, stringArray);
        return kotlinType;
    }

    @Override
    public <R, D> R accept(@NotNull AnnotationArgumentVisitor<R, D> visitor2, D data2) {
        Intrinsics.checkNotNullParameter(visitor2, "visitor");
        return visitor2.visitEnumValue(this, data2);
    }

    @Override
    @NotNull
    public String toString() {
        return "" + this.enumClassId.getShortClassName() + '.' + this.enumEntryName;
    }
}

