/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.UByteValue;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UShortValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeAttributes;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.error.ErrorScopeKind;
import org.jetbrains.kotlin.types.error.ErrorUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 22\b\u0012\u0004\u0012\u00020\u00020\u0001:\u00012B1\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001a\u0010\u0019\u001a\u00020\b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0096\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001eR\u001a\u0010\u0005\u001a\u00020\u00048\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010!R\u001a\u0010\u0007\u001a\u00020\u00068\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\"\u001a\u0004\b#\u0010$R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010%R\u001a\u0010\n\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\n\u0010%\u001a\u0004\b&\u0010'R\u0014\u0010)\u001a\u00020(8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u001a\u0010,\u001a\u00020+8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b.\u0010/R\u0014\u00101\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010'"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstant;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "", "value", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "moduleDescriptor", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "parameters", "", "newInferenceEnabled", "convertedFromSigned", "<init>", "(Ljava/lang/Number;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;ZZ)V", "Lorg/jetbrains/kotlin/types/KotlinType;", "expectedType", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "toConstantValue", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "getType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/types/KotlinType;", "", "toString", "()Ljava/lang/String;", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Ljava/lang/Number;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getModuleDescriptor", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "getParameters", "()Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "Z", "getConvertedFromSigned", "()Z", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "Lorg/jetbrains/kotlin/types/SimpleType;", "unknownIntegerType", "Lorg/jetbrains/kotlin/types/SimpleType;", "getUnknownIntegerType", "()Lorg/jetbrains/kotlin/types/SimpleType;", "getHasIntegerLiteralType", "hasIntegerLiteralType", "Companion"})
public final class IntegerValueTypeConstant
implements CompileTimeConstant<Number> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Number value;
    @NotNull
    private final ModuleDescriptor moduleDescriptor;
    @NotNull
    private final CompileTimeConstant.Parameters parameters;
    private final boolean newInferenceEnabled;
    private final boolean convertedFromSigned;
    @NotNull
    private final TypeConstructor typeConstructor;
    @NotNull
    private final SimpleType unknownIntegerType;

    public IntegerValueTypeConstant(@NotNull Number value2, @NotNull ModuleDescriptor moduleDescriptor, @NotNull CompileTimeConstant.Parameters parameters2, boolean newInferenceEnabled, boolean convertedFromSigned) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(moduleDescriptor, "moduleDescriptor");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        this.value = value2;
        this.moduleDescriptor = moduleDescriptor;
        this.parameters = parameters2;
        this.newInferenceEnabled = newInferenceEnabled;
        this.convertedFromSigned = convertedFromSigned;
        this.typeConstructor = this.newInferenceEnabled ? (TypeConstructor)new IntegerLiteralTypeConstructor(this.value.longValue(), this.getModuleDescriptor(), this.getParameters()) : (TypeConstructor)new IntegerValueTypeConstructor(this.value.longValue(), this.getModuleDescriptor(), this.getParameters());
        String[] stringArray = new String[]{this.typeConstructor.toString()};
        this.unknownIntegerType = KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(TypeAttributes.Companion.getEmpty(), this.typeConstructor, CollectionsKt.emptyList(), false, ErrorUtils.createErrorScope(ErrorScopeKind.INTEGER_LITERAL_TYPE_SCOPE, true, stringArray));
    }

    public /* synthetic */ IntegerValueTypeConstant(Number number, ModuleDescriptor moduleDescriptor, CompileTimeConstant.Parameters parameters2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(number, moduleDescriptor, parameters2, bl, bl2);
    }

    @Override
    @NotNull
    public ModuleDescriptor getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @Override
    @NotNull
    public CompileTimeConstant.Parameters getParameters() {
        return this.parameters;
    }

    public final boolean getConvertedFromSigned() {
        return this.convertedFromSigned;
    }

    @Override
    @NotNull
    public ConstantValue<Number> toConstantValue(@NotNull KotlinType expectedType) {
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        KotlinType type2 = this.getType(expectedType);
        return KotlinBuiltIns.isInt(type2) ? (ConstantValue)new IntValue(this.value.intValue()) : (KotlinBuiltIns.isByte(type2) ? (ConstantValue)new ByteValue(this.value.byteValue()) : (KotlinBuiltIns.isShort(type2) ? (ConstantValue)new ShortValue(this.value.shortValue()) : (KotlinBuiltIns.isLong(type2) ? (ConstantValue)new LongValue(this.value.longValue()) : (KotlinBuiltIns.isUInt(type2) ? (ConstantValue)new UIntValue(this.value.intValue()) : (KotlinBuiltIns.isUByte(type2) ? (ConstantValue)new UByteValue(this.value.byteValue()) : (KotlinBuiltIns.isUShort(type2) ? (ConstantValue)new UShortValue(this.value.shortValue()) : (KotlinBuiltIns.isULong(type2) ? (ConstantValue)new ULongValue(this.value.longValue()) : (ConstantValue)new LongValue(this.value.longValue()))))))));
    }

    @NotNull
    public final SimpleType getUnknownIntegerType() {
        return this.unknownIntegerType;
    }

    @NotNull
    public final KotlinType getType(@NotNull KotlinType expectedType) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        if (this.newInferenceEnabled) {
            TypeConstructor typeConstructor2 = this.typeConstructor;
            Intrinsics.checkNotNull(typeConstructor2, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.constants.IntegerLiteralTypeConstructor");
            KotlinType kotlinType2 = TypeUtils.getPrimitiveNumberType((IntegerLiteralTypeConstructor)typeConstructor2, expectedType);
            Intrinsics.checkNotNull(kotlinType2);
            kotlinType = kotlinType2;
        } else {
            TypeConstructor typeConstructor3 = this.typeConstructor;
            Intrinsics.checkNotNull(typeConstructor3, "null cannot be cast to non-null type org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor");
            KotlinType kotlinType3 = TypeUtils.getPrimitiveNumberType((IntegerValueTypeConstructor)typeConstructor3, expectedType);
            Intrinsics.checkNotNull(kotlinType3);
            kotlinType = kotlinType3;
        }
        return kotlinType;
    }

    @NotNull
    public String toString() {
        return this.typeConstructor.toString();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other instanceof IntegerValueTypeConstant && Intrinsics.areEqual(this.value, ((IntegerValueTypeConstant)other).value) && Intrinsics.areEqual(this.getParameters(), ((IntegerValueTypeConstant)other).getParameters());
    }

    @Override
    public int hashCode() {
        return 31 * this.value.hashCode() + this.getParameters().hashCode();
    }

    @Override
    public boolean getHasIntegerLiteralType() {
        return true;
    }

    @Override
    public boolean isError() {
        return CompileTimeConstant.DefaultImpls.isError(this);
    }

    @Override
    @NotNull
    public Number getValue(@NotNull KotlinType expectedType) {
        return CompileTimeConstant.DefaultImpls.getValue(this, expectedType);
    }

    @Override
    public boolean getCanBeUsedInAnnotations() {
        return CompileTimeConstant.DefaultImpls.getCanBeUsedInAnnotations(this);
    }

    @Override
    public boolean getUsesVariableAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesVariableAsConstant(this);
    }

    @Override
    public boolean getUsesNonConstValAsConstant() {
        return CompileTimeConstant.DefaultImpls.getUsesNonConstValAsConstant(this);
    }

    @Override
    public boolean isPure() {
        return CompileTimeConstant.DefaultImpls.isPure(this);
    }

    @Override
    public boolean isUnsignedNumberLiteral() {
        return CompileTimeConstant.DefaultImpls.isUnsignedNumberLiteral(this);
    }

    @NotNull
    public static final IntegerValueTypeConstant convertToUnsignedConstant(@NotNull IntegerValueTypeConstant $this$convertToUnsignedConstant, @NotNull ModuleDescriptor module2) {
        return Companion.convertToUnsignedConstant($this$convertToUnsignedConstant, module2);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001b\u0010\t\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\t\u0010\b"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstant$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstant;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "module", "convertToUnsignedConstant", "(Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstant;Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/resolve/constants/IntegerValueTypeConstant;", "convertToSignedConstant"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntegerValueTypeConstant convertToUnsignedConstant(@NotNull IntegerValueTypeConstant $this$convertToUnsignedConstant, @NotNull ModuleDescriptor module2) {
            Intrinsics.checkNotNullParameter($this$convertToUnsignedConstant, "<this>");
            Intrinsics.checkNotNullParameter(module2, "module");
            CompileTimeConstant.Parameters newParameters = new CompileTimeConstant.Parameters($this$convertToUnsignedConstant.getParameters().getCanBeUsedInAnnotation(), $this$convertToUnsignedConstant.getParameters().isPure(), true, $this$convertToUnsignedConstant.getParameters().isUnsignedLongNumberLiteral(), $this$convertToUnsignedConstant.getParameters().getUsesVariableAsConstant(), $this$convertToUnsignedConstant.getParameters().getUsesNonConstValAsConstant(), $this$convertToUnsignedConstant.getParameters().isConvertableConstVal());
            return new IntegerValueTypeConstant($this$convertToUnsignedConstant.value, module2, newParameters, $this$convertToUnsignedConstant.newInferenceEnabled, true);
        }

        @NotNull
        public final IntegerValueTypeConstant convertToSignedConstant(@NotNull IntegerValueTypeConstant $this$convertToSignedConstant, @NotNull ModuleDescriptor module2) {
            Intrinsics.checkNotNullParameter($this$convertToSignedConstant, "<this>");
            Intrinsics.checkNotNullParameter(module2, "module");
            CompileTimeConstant.Parameters newParameters = new CompileTimeConstant.Parameters($this$convertToSignedConstant.getParameters().getCanBeUsedInAnnotation(), $this$convertToSignedConstant.getParameters().isPure(), false, $this$convertToSignedConstant.getParameters().isUnsignedLongNumberLiteral(), $this$convertToSignedConstant.getParameters().getUsesVariableAsConstant(), $this$convertToSignedConstant.getParameters().getUsesNonConstValAsConstant(), $this$convertToSignedConstant.getParameters().isConvertableConstVal());
            return new IntegerValueTypeConstant($this$convertToSignedConstant.value, module2, newParameters, $this$convertToSignedConstant.newInferenceEnabled, true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

