/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u001e\n\u0002\b\u0005\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a\u0013\u0010\u0004\u001a\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0003\u001a\u001b\u0010\t\u001a\u00020\b*\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0006H\u0001\u00a2\u0006\u0004\b\t\u0010\n\"\u0018\u0010\r\u001a\u00020\b*\u00020\u00058AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0018\u0010\u000f\u001a\u00020\b*\u00020\u00058AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\"\u0018\u0010\u0011\u001a\u00020\b*\u00020\u00058AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\f\"\u0018\u0010\u0013\u001a\u00020\b*\u00020\u00058AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\f\"\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00000\u0014*\u00020\u00058AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\"\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\u0014*\u00020\u00058AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016"}, d2={"Lorg/jetbrains/kotlin/types/KotlinType;", "", "minValue", "(Lorg/jetbrains/kotlin/types/KotlinType;)J", "maxValue", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/types/SimpleType;", "unsignedType", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/types/SimpleType;", "getUIntType", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Lorg/jetbrains/kotlin/types/SimpleType;", "uIntType", "getULongType", "uLongType", "getUByteType", "uByteType", "getUShortType", "uShortType", "", "getAllSignedLiteralTypes", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;)Ljava/util/Collection;", "allSignedLiteralTypes", "getAllUnsignedLiteralTypes", "allUnsignedLiteralTypes"})
public final class PrimitiveTypeUtilKt {
    public static final long minValue(@NotNull KotlinType $this$minValue) {
        long l;
        Intrinsics.checkNotNullParameter($this$minValue, "<this>");
        if (UnsignedTypes.isUnsignedType($this$minValue)) {
            return 0L;
        }
        if (KotlinBuiltIns.isByte($this$minValue)) {
            l = -128L;
        } else if (KotlinBuiltIns.isShort($this$minValue)) {
            l = -32768L;
        } else if (KotlinBuiltIns.isInt($this$minValue)) {
            l = Integer.MIN_VALUE;
        } else {
            throw new IllegalStateException(("Can't get min value for type: " + $this$minValue).toString());
        }
        return l;
    }

    public static final long maxValue(@NotNull KotlinType $this$maxValue) {
        long l;
        Intrinsics.checkNotNullParameter($this$maxValue, "<this>");
        if (KotlinBuiltIns.isByte($this$maxValue)) {
            l = 127L;
        } else if (KotlinBuiltIns.isShort($this$maxValue)) {
            l = 32767L;
        } else if (KotlinBuiltIns.isInt($this$maxValue)) {
            l = Integer.MAX_VALUE;
        } else if (KotlinBuiltIns.isUByte($this$maxValue)) {
            l = (long)-1 & 0xFFL;
        } else if (KotlinBuiltIns.isUShort($this$maxValue)) {
            l = (long)-1 & 0xFFFFL;
        } else if (KotlinBuiltIns.isUInt($this$maxValue)) {
            l = (long)-1 & 0xFFFFFFFFL;
        } else {
            throw new IllegalStateException(("Can't get max value for type: " + $this$maxValue).toString());
        }
        return l;
    }

    @NotNull
    public static final SimpleType unsignedType(@NotNull ModuleDescriptor $this$unsignedType, @NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter($this$unsignedType, "<this>");
        Intrinsics.checkNotNullParameter(classId, "classId");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies($this$unsignedType, classId);
        Intrinsics.checkNotNull(classDescriptor);
        SimpleType simpleType2 = classDescriptor.getDefaultType();
        Intrinsics.checkNotNullExpressionValue(simpleType2, "getDefaultType(...)");
        return simpleType2;
    }

    @NotNull
    public static final SimpleType getUIntType(@NotNull ModuleDescriptor $this$uIntType) {
        Intrinsics.checkNotNullParameter($this$uIntType, "<this>");
        return PrimitiveTypeUtilKt.unsignedType($this$uIntType, StandardNames.FqNames.uInt);
    }

    @NotNull
    public static final SimpleType getULongType(@NotNull ModuleDescriptor $this$uLongType) {
        Intrinsics.checkNotNullParameter($this$uLongType, "<this>");
        return PrimitiveTypeUtilKt.unsignedType($this$uLongType, StandardNames.FqNames.uLong);
    }

    @NotNull
    public static final SimpleType getUByteType(@NotNull ModuleDescriptor $this$uByteType) {
        Intrinsics.checkNotNullParameter($this$uByteType, "<this>");
        return PrimitiveTypeUtilKt.unsignedType($this$uByteType, StandardNames.FqNames.uByte);
    }

    @NotNull
    public static final SimpleType getUShortType(@NotNull ModuleDescriptor $this$uShortType) {
        Intrinsics.checkNotNullParameter($this$uShortType, "<this>");
        return PrimitiveTypeUtilKt.unsignedType($this$uShortType, StandardNames.FqNames.uShort);
    }

    @NotNull
    public static final Collection<KotlinType> getAllSignedLiteralTypes(@NotNull ModuleDescriptor $this$allSignedLiteralTypes) {
        Intrinsics.checkNotNullParameter($this$allSignedLiteralTypes, "<this>");
        SimpleType[] simpleTypeArray = new SimpleType[]{$this$allSignedLiteralTypes.getBuiltIns().getIntType(), $this$allSignedLiteralTypes.getBuiltIns().getLongType(), $this$allSignedLiteralTypes.getBuiltIns().getByteType(), $this$allSignedLiteralTypes.getBuiltIns().getShortType()};
        return CollectionsKt.listOf(simpleTypeArray);
    }

    @NotNull
    public static final Collection<KotlinType> getAllUnsignedLiteralTypes(@NotNull ModuleDescriptor $this$allUnsignedLiteralTypes) {
        Collection collection;
        Intrinsics.checkNotNullParameter($this$allUnsignedLiteralTypes, "<this>");
        if (CompileTimeConstantKt.hasUnsignedTypesInModuleDependencies($this$allUnsignedLiteralTypes)) {
            SimpleType[] simpleTypeArray = new SimpleType[]{PrimitiveTypeUtilKt.unsignedType($this$allUnsignedLiteralTypes, StandardNames.FqNames.uInt), PrimitiveTypeUtilKt.unsignedType($this$allUnsignedLiteralTypes, StandardNames.FqNames.uLong), PrimitiveTypeUtilKt.unsignedType($this$allUnsignedLiteralTypes, StandardNames.FqNames.uByte), PrimitiveTypeUtilKt.unsignedType($this$allUnsignedLiteralTypes, StandardNames.FqNames.uShort)};
            collection = CollectionsKt.listOf(simpleTypeArray);
        } else {
            collection = CollectionsKt.emptyList();
        }
        return collection;
    }
}

