/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtilsKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.ParametrizedDiagnostic;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.StatementFilter;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallResolverUtilKt;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.checkers.ExperimentalUnsignedLiteralsDiagnosticMessageProvider;
import org.jetbrains.kotlin.resolve.checkers.OptInUsageChecker;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001c\u0018\u0000 R2\u00020\u0001:\u0001RB!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ/\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0013\u0010\u0014J3\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00190\u00172\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0011\u001a\u00020\u0010H\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ-\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00192\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001fH\u0007\u00a2\u0006\u0004\b!\u0010\"J-\u0010&\u001a\u00020%2\u0014\u0010$\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00190#2\u0006\u0010 \u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b&\u0010'J/\u0010+\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010*\u001a\u00020%H\u0002\u00a2\u0006\u0004\b+\u0010,J3\u0010/\u001a\u00020\u00122\n\u0010.\u001a\u0006\u0012\u0002\b\u00030-2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010(\u001a\u00020\f2\u0006\u0010*\u001a\u00020%H\u0002\u00a2\u0006\u0004\b/\u00100J\u001f\u00101\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b1\u00102J'\u00104\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010#2\u0006\u0010\r\u001a\u0002032\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b4\u00105J'\u00107\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010#2\u0006\u0010\r\u001a\u0002062\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b7\u00108J#\u00109\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010#2\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002\u00a2\u0006\u0004\b9\u0010:J\u0017\u0010<\u001a\u00020%2\u0006\u0010;\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b<\u0010=J9\u0010A\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030-0#2\u0006\u0010>\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020\n2\u0006\u0010@\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\bA\u0010BJ1\u0010C\u001a\b\u0012\u0002\b\u0003\u0018\u00010-2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00102\n\b\u0002\u0010@\u001a\u0004\u0018\u00010\nH\u0007\u00a2\u0006\u0004\bC\u0010DJ-\u0010E\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00192\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010@\u001a\u00020\nH\u0007\u00a2\u0006\u0004\bE\u0010FJ5\u0010G\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\f2\n\u0010.\u001a\u0006\u0012\u0002\b\u00030-2\b\u0010@\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\bG\u0010HR\u001a\u0010\u0003\u001a\u00020\u00028\u0001X\u0081\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010I\u001a\u0004\bJ\u0010KR\u001a\u0010\u0005\u001a\u00020\u00048\u0001X\u0081\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010L\u001a\u0004\bM\u0010NR\u001a\u0010\u0007\u001a\u00020\u00068\u0001X\u0081\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010O\u001a\u0004\bP\u0010Q"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "module", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "inlineConstTracker", "<init>", "(Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;)V", "Lorg/jetbrains/kotlin/types/KotlinType;", "numberType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lorg/jetbrains/kotlin/resolve/StatementFilter;", "statementFilter", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "", "updateNumberType", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/StatementFilter;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "resolvedCall", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "resolveAnnotationArguments$frontend", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/resolve/BindingTrace;)Ljava/util/Map;", "resolveAnnotationArguments", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameterDescriptor", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "resolvedArgument", "getAnnotationArgumentValue", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;)Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "", "constants", "", "isArrayPassedInNamedForm", "(Ljava/util/List;Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;)Z", "argumentExpression", "expressionType", "useDeprecationWarning", "checkCompileTimeConstant", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingTrace;Z)V", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "constant", "checkInnerPartsOfCompileTimeConstant", "(Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/psi/KtExpression;Z)V", "reportDeprecationWarningOnNonConst", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "getArgumentExpressionsForArrayCall", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;)Ljava/util/List;", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "getArgumentExpressionsForCollectionLiteralCall", "(Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;)Ljava/util/List;", "getArgumentExpressionsForArrayLikeCall", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;)Ljava/util/List;", "argument", "hasSpread", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;)Z", "resolvedValueArgument", "deprecatedExpectedType", "expectedType", "resolveAnnotationValueArguments", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingTrace;)Ljava/util/List;", "evaluateExpression", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "evaluateToConstantValue", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "checkExperimentalityOfConstantLiteral", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getModule$frontend", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings$frontend", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "getInlineConstTracker$frontend", "()Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "Companion"})
public final class ConstantExpressionEvaluator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ModuleDescriptor module;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final InlineConstTracker inlineConstTracker;
    @NotNull
    private static final OptInUsageChecker.OptInReporterMultiplexer EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS;

    public ConstantExpressionEvaluator(@NotNull ModuleDescriptor module2, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull InlineConstTracker inlineConstTracker) {
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkNotNullParameter(inlineConstTracker, "inlineConstTracker");
        this.module = module2;
        this.languageVersionSettings = languageVersionSettings;
        this.inlineConstTracker = inlineConstTracker;
    }

    public /* synthetic */ ConstantExpressionEvaluator(ModuleDescriptor moduleDescriptor, LanguageVersionSettings languageVersionSettings, InlineConstTracker inlineConstTracker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            inlineConstTracker = InlineConstTracker.DoNothing.INSTANCE;
        }
        this(moduleDescriptor, languageVersionSettings, inlineConstTracker);
    }

    @NotNull
    public final ModuleDescriptor getModule$frontend() {
        return this.module;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings$frontend() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final InlineConstTracker getInlineConstTracker$frontend() {
        return this.inlineConstTracker;
    }

    public final void updateNumberType(@NotNull KotlinType numberType, @Nullable KtExpression expression, @NotNull StatementFilter statementFilter, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(numberType, "numberType");
        Intrinsics.checkNotNullParameter(statementFilter, "statementFilter");
        Intrinsics.checkNotNullParameter(trace, "trace");
        if (expression == null) {
            return;
        }
        BindingContextUtils.updateRecordedType(numberType, expression, trace, false);
        if (!(expression instanceof KtConstantExpression)) {
            KtExpression deparenthesized = KtPsiUtil.getLastElementDeparenthesized(expression, statementFilter);
            if (deparenthesized != expression) {
                this.updateNumberType(numberType, deparenthesized, statementFilter, trace);
            }
            return;
        }
        this.evaluateExpression(expression, trace, numberType);
    }

    @NotNull
    public final Map<Name, ConstantValue<?>> resolveAnnotationArguments$frontend(@NotNull ResolvedCall<?> resolvedCall2, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(trace, "trace");
        HashMap arguments2 = new HashMap();
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : resolvedCall2.getValueArguments().entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument resolvedArgument = entry.getValue();
            Intrinsics.checkNotNull(parameterDescriptor);
            Intrinsics.checkNotNull(resolvedArgument);
            ConstantValue<?> value2 = this.getAnnotationArgumentValue(trace, parameterDescriptor, resolvedArgument);
            if (value2 == null) continue;
            ((Map)arguments2).put(parameterDescriptor.getName(), value2);
        }
        return arguments2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ConstantValue<?> getAnnotationArgumentValue(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor parameterDescriptor, @NotNull ResolvedValueArgument resolvedArgument) {
        void $this$mapTo$iv$iv;
        KotlinType kotlinType;
        boolean argumentsAsVararg;
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(parameterDescriptor, "parameterDescriptor");
        Intrinsics.checkNotNullParameter(resolvedArgument, "resolvedArgument");
        KotlinType varargElementType = parameterDescriptor.getVarargElementType();
        boolean bl = argumentsAsVararg = varargElementType != null && !this.hasSpread(resolvedArgument);
        if (argumentsAsVararg) {
            kotlinType = varargElementType;
        } else {
            KotlinType kotlinType2 = parameterDescriptor.getType();
            kotlinType = kotlinType2;
            Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
        }
        KotlinType constantType = kotlinType;
        KotlinType expectedType = CallResolverUtilKt.getEffectiveExpectedType(parameterDescriptor, resolvedArgument, this.languageVersionSettings, trace);
        KotlinType kotlinType3 = constantType;
        Intrinsics.checkNotNull(kotlinType3);
        List<CompileTimeConstant<?>> compileTimeConstants = this.resolveAnnotationValueArguments(resolvedArgument, kotlinType3, expectedType, trace);
        Iterable $this$map$iv = compileTimeConstants;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CompileTimeConstant compileTimeConstant = (CompileTimeConstant)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.toConstantValue(expectedType));
        }
        List constants = (List)destination$iv$iv;
        if (argumentsAsVararg) {
            if (this.isArrayPassedInNamedForm(constants, resolvedArgument)) {
                return (ConstantValue)CollectionsKt.single(constants);
            }
            if (parameterDescriptor.declaresDefaultValue() && compileTimeConstants.isEmpty()) {
                return null;
            }
            KotlinType kotlinType4 = parameterDescriptor.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType4, "getType(...)");
            return ConstantValueFactory.INSTANCE.createArrayValue(constants, kotlinType4);
        }
        return (ConstantValue)CollectionsKt.lastOrNull(constants);
    }

    private final boolean isArrayPassedInNamedForm(List<? extends ConstantValue<? extends Object>> constants, ResolvedValueArgument resolvedArgument) {
        ConstantValue<? extends Object> constantValue = CollectionsKt.singleOrNull(constants);
        if (constantValue == null) {
            return false;
        }
        ConstantValue<? extends Object> constant = constantValue;
        List<ValueArgument> list = resolvedArgument.getArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
        ValueArgument valueArgument = CollectionsKt.singleOrNull(list);
        if (valueArgument == null) {
            return false;
        }
        ValueArgument argument = valueArgument;
        return constant instanceof ArrayValue && argument.isNamed();
    }

    private final void checkCompileTimeConstant(KtExpression argumentExpression, KotlinType expressionType, BindingTrace trace, boolean useDeprecationWarning) {
        DiagnosticFactory0<KtExpression> diagnosticFactory;
        DiagnosticFactory0<KtExpression> diagnosticFactory0;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        CompileTimeConstant<?> constant = Companion.getConstant(argumentExpression, bindingContext);
        if (constant != null && constant.getCanBeUsedInAnnotations()) {
            this.checkInnerPartsOfCompileTimeConstant(constant, trace, argumentExpression, useDeprecationWarning);
            return;
        }
        ClassifierDescriptor descriptor2 = expressionType.getConstructor().getDeclarationDescriptor();
        if (DescriptorUtils.isEnumClass(descriptor2)) {
            diagnosticFactory0 = Errors.ANNOTATION_ARGUMENT_MUST_BE_ENUM_CONST;
        } else if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
            TypeProjection typeProjection = CollectionsKt.singleOrNull(expressionType.getArguments());
            diagnosticFactory0 = Companion.isTypeParameterOrArrayOfTypeParameter$frontend(typeProjection != null ? typeProjection.getType() : null) ? Errors.ANNOTATION_ARGUMENT_KCLASS_LITERAL_OF_TYPE_PARAMETER_ERROR : Errors.ANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL;
        } else {
            diagnosticFactory0 = diagnosticFactory = Errors.ANNOTATION_ARGUMENT_MUST_BE_CONST;
        }
        if (useDeprecationWarning) {
            this.reportDeprecationWarningOnNonConst(argumentExpression, trace);
        } else {
            trace.report(diagnosticFactory.on((KtExpression)((PsiElement)argumentExpression)));
        }
    }

    private final void checkInnerPartsOfCompileTimeConstant(CompileTimeConstant<?> constant, BindingTrace trace, KtExpression argumentExpression, boolean useDeprecationWarning) {
        KtExpression lhsExpression;
        List<KtExpression> callArguments;
        KtExpression ktExpression = argumentExpression;
        List<KtExpression> list = ktExpression instanceof KtCallExpression ? this.getArgumentExpressionsForArrayCall((KtCallExpression)argumentExpression, trace) : (callArguments = ktExpression instanceof KtCollectionLiteralExpression ? this.getArgumentExpressionsForCollectionLiteralCall((KtCollectionLiteralExpression)argumentExpression, trace) : null);
        if (callArguments != null) {
            for (KtExpression argument : callArguments) {
                KotlinType type2;
                if (trace.getType(argument) == null) continue;
                this.checkCompileTimeConstant(argument, type2, trace, useDeprecationWarning);
            }
        }
        if (constant.getUsesNonConstValAsConstant()) {
            if (useDeprecationWarning) {
                this.reportDeprecationWarningOnNonConst(argumentExpression, trace);
            } else {
                trace.report(Errors.NON_CONST_VAL_USED_IN_CONSTANT_EXPRESSION.on((KtExpression)((PsiElement)argumentExpression)));
            }
        }
        if (argumentExpression instanceof KtClassLiteralExpression && (lhsExpression = ((KtClassLiteralExpression)argumentExpression).getReceiverExpression()) != null) {
            DoubleColonLHS doubleColonLhs = (DoubleColonLHS)trace.getBindingContext().get(BindingContext.DOUBLE_COLON_LHS, lhsExpression);
            if (doubleColonLhs instanceof DoubleColonLHS.Expression && !((DoubleColonLHS.Expression)doubleColonLhs).isObjectQualifier()) {
                if (useDeprecationWarning) {
                    this.reportDeprecationWarningOnNonConst(argumentExpression, trace);
                } else {
                    trace.report(Errors.ANNOTATION_ARGUMENT_MUST_BE_KCLASS_LITERAL.on((KtExpression)((PsiElement)argumentExpression)));
                }
            } else if (doubleColonLhs instanceof DoubleColonLHS.Type && Companion.isTypeParameterOrArrayOfTypeParameter$frontend(((DoubleColonLHS.Type)doubleColonLhs).getType())) {
                trace.report(Errors.ANNOTATION_ARGUMENT_KCLASS_LITERAL_OF_TYPE_PARAMETER.on((KtExpression)((PsiElement)argumentExpression)));
            }
        }
    }

    private final void reportDeprecationWarningOnNonConst(KtExpression expression, BindingTrace trace) {
        trace.report(Errors.ANNOTATION_ARGUMENT_IS_NON_CONST.on((KtExpression)((PsiElement)expression)));
    }

    private final List<KtExpression> getArgumentExpressionsForArrayCall(KtCallExpression expression, BindingTrace trace) {
        KtElement ktElement = expression;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        return this.getArgumentExpressionsForArrayLikeCall(resolvedCall3);
    }

    private final List<KtExpression> getArgumentExpressionsForCollectionLiteralCall(KtCollectionLiteralExpression expression, BindingTrace trace) {
        ResolvedCall resolvedCall2 = (ResolvedCall)trace.get(BindingContext.COLLECTION_LITERAL_CALL, expression);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        return this.getArgumentExpressionsForArrayLikeCall(resolvedCall3);
    }

    private final List<KtExpression> getArgumentExpressionsForArrayLikeCall(ResolvedCall<?> resolvedCall2) {
        if (!CompileTimeConstantUtils.isArrayFunctionCall(resolvedCall2)) {
            return null;
        }
        ArrayList<KtExpression> result2 = new ArrayList<KtExpression>();
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = resolvedCall2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map2, "getValueArguments(...)");
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            ResolvedValueArgument resolvedValueArgument = iterator2.next().getValue();
            for (ValueArgument valueArgument : resolvedValueArgument.getArguments()) {
                KtExpression valueArgumentExpression = valueArgument.getArgumentExpression();
                if (valueArgumentExpression == null) continue;
                result2.add(valueArgumentExpression);
            }
        }
        return result2;
    }

    private final boolean hasSpread(ResolvedValueArgument argument) {
        List<ValueArgument> list = argument.getArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
        List<ValueArgument> arguments2 = list;
        return arguments2.size() == 1 && arguments2.get(0).getSpreadElement() != null;
    }

    private final List<CompileTimeConstant<?>> resolveAnnotationValueArguments(ResolvedValueArgument resolvedValueArgument, KotlinType deprecatedExpectedType, KotlinType expectedType, BindingTrace trace) {
        ArrayList constants = new ArrayList();
        for (ValueArgument argument : resolvedValueArgument.getArguments()) {
            KotlinType expressionType;
            KtExpression argumentExpression;
            if (argument.getArgumentExpression() == null) continue;
            CompileTimeConstant<?> constant = this.evaluateExpression(argumentExpression, trace, expectedType);
            if (constant instanceof IntegerValueTypeConstant) {
                KotlinType defaultType2 = ((IntegerValueTypeConstant)constant).getType(expectedType);
                this.updateNumberType(defaultType2, argumentExpression, StatementFilter.NONE, trace);
            }
            if (constant != null) {
                constants.add(constant);
            }
            if (trace.getType(argumentExpression) == null) continue;
            if (!this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitNonConstValuesAsVarargsInAnnotations) && !KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, deprecatedExpectedType)) {
                if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(expressionType, expectedType)) continue;
                this.checkCompileTimeConstant(argumentExpression, expressionType, trace, true);
                continue;
            }
            this.checkCompileTimeConstant(argumentExpression, expressionType, trace, false);
        }
        return constants;
    }

    @Nullable
    public final CompileTimeConstant<?> evaluateExpression(@NotNull KtExpression expression, @NotNull BindingTrace trace, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(trace, "trace");
        ConstantExpressionEvaluatorVisitor visitor2 = new ConstantExpressionEvaluatorVisitor(this, trace);
        CompileTimeConstant<?> compileTimeConstant = visitor2.evaluate(expression, expectedType);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant<?> constant = compileTimeConstant;
        this.checkExperimentalityOfConstantLiteral(expression, constant, expectedType, trace);
        return !constant.isError() ? constant : null;
    }

    public static /* synthetic */ CompileTimeConstant evaluateExpression$default(ConstantExpressionEvaluator constantExpressionEvaluator, KtExpression ktExpression, BindingTrace bindingTrace, KotlinType kotlinType, int n, Object object) {
        if ((n & 4) != 0) {
            kotlinType = TypeUtils.NO_EXPECTED_TYPE;
        }
        return constantExpressionEvaluator.evaluateExpression(ktExpression, bindingTrace, kotlinType);
    }

    @Nullable
    public final ConstantValue<?> evaluateToConstantValue(@NotNull KtExpression expression, @NotNull BindingTrace trace, @NotNull KotlinType expectedType) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        Intrinsics.checkNotNullParameter(trace, "trace");
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        CompileTimeConstant<?> compileTimeConstant = this.evaluateExpression(expression, trace, expectedType);
        return compileTimeConstant != null ? compileTimeConstant.toConstantValue(expectedType) : null;
    }

    private final void checkExperimentalityOfConstantLiteral(KtExpression expression, CompileTimeConstant<?> constant, KotlinType expectedType, BindingTrace trace) {
        KotlinType kotlinType;
        if (constant.isError()) {
            return;
        }
        if (!constant.getParameters().isUnsignedNumberLiteral() && !constant.getParameters().isUnsignedLongNumberLiteral()) {
            return;
        }
        if (constant instanceof TypedCompileTimeConstant) {
            kotlinType = ((TypedCompileTimeConstant)constant).getType();
        } else {
            KotlinType kotlinType2 = expectedType;
            if (kotlinType2 != null) {
                kotlinType = constant.toConstantValue(kotlinType2).getType(this.module);
            } else {
                return;
            }
        }
        KotlinType constantType = kotlinType;
        if (!UnsignedTypes.isUnsignedType(constantType)) {
            return;
        }
        OptInUsageChecker.Companion $this$checkExperimentalityOfConstantLiteral_u24lambda_u241 = OptInUsageChecker.Companion;
        boolean bl = false;
        ClassifierDescriptor classifierDescriptor = constantType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            return;
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        DeclarationDescriptor declarationDescriptor = descriptor2;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        Set optInDescriptions = OptInUsageChecker.Companion.loadOptIns$default($this$checkExperimentalityOfConstantLiteral_u24lambda_u241, declarationDescriptor, bindingContext, this.languageVersionSettings, null, false, false, false, 60, null);
        $this$checkExperimentalityOfConstantLiteral_u24lambda_u241.reportNotAllowedOptIns(optInDescriptions, expression, this.languageVersionSettings, trace, EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS);
    }

    private static final OptInUsageChecker.OptInDiagnosticReporter EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS$lambda$2(boolean it) {
        DiagnosticFactory1<PsiElement, String> diagnosticFactory1 = Errors.EXPERIMENTAL_UNSIGNED_LITERALS;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory1, "EXPERIMENTAL_UNSIGNED_LITERALS");
        return new Companion.ExperimentalityDiagnostic1(diagnosticFactory1, "should");
    }

    private static final OptInUsageChecker.OptInDiagnosticReporter EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS$lambda$3(boolean it) {
        DiagnosticFactory1<PsiElement, String> diagnosticFactory1 = Errors.EXPERIMENTAL_UNSIGNED_LITERALS_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory1, "EXPERIMENTAL_UNSIGNED_LITERALS_ERROR");
        return new Companion.ExperimentalityDiagnostic1(diagnosticFactory1, "must");
    }

    @Nullable
    public static final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression, @NotNull BindingContext bindingContext) {
        return Companion.getConstant(expression, bindingContext);
    }

    @Nullable
    public static final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression, @NotNull BindingContext bindingContext) {
        return Companion.getPossiblyErrorConstant(expression, bindingContext);
    }

    static {
        Function1<Boolean, OptInUsageChecker.OptInDiagnosticReporter> function1 = ConstantExpressionEvaluator::EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS$lambda$2;
        Function1<Boolean, OptInUsageChecker.OptInDiagnosticReporter> function12 = ConstantExpressionEvaluator::EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS$lambda$3;
        DiagnosticFactory1<PsiElement, String> diagnosticFactory1 = Errors.EXPERIMENTAL_UNSIGNED_LITERALS_ERROR;
        Intrinsics.checkNotNullExpressionValue(diagnosticFactory1, "EXPERIMENTAL_UNSIGNED_LITERALS_ERROR");
        EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS = new OptInUsageChecker.OptInReporterMultiplexer(function1, function12, new Companion.ExperimentalityDiagnostic1(diagnosticFactory1, "must"));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0018B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0019\u0010\u0011\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00042\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "getConstant", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/BindingContext;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "getPossiblyErrorConstant", "Lorg/jetbrains/kotlin/types/KotlinType;", "type", "", "isTypeParameterOrArrayOfTypeParameter$frontend", "(Lorg/jetbrains/kotlin/types/KotlinType;)Z", "isTypeParameterOrArrayOfTypeParameter", "constant", "isComplexBooleanConstant", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;)Z", "Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInReporterMultiplexer;", "EXPERIMENTAL_UNSIGNED_LITERALS_DIAGNOSTICS", "Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInReporterMultiplexer;", "ExperimentalityDiagnostic1"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CompileTimeConstant<?> getConstant(@NotNull KtExpression expression, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter(expression, "expression");
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            CompileTimeConstant<?> compileTimeConstant = this.getPossiblyErrorConstant(expression, bindingContext);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant<?> constant = compileTimeConstant;
            return !constant.isError() ? constant : null;
        }

        @Nullable
        public final CompileTimeConstant<?> getPossiblyErrorConstant(@NotNull KtExpression expression, @NotNull BindingContext bindingContext) {
            Intrinsics.checkNotNullParameter(expression, "expression");
            Intrinsics.checkNotNullParameter(bindingContext, "bindingContext");
            return (CompileTimeConstant)bindingContext.get(BindingContext.COMPILE_TIME_VALUE, expression);
        }

        public final boolean isTypeParameterOrArrayOfTypeParameter$frontend(@Nullable KotlinType type2) {
            boolean bl;
            if (type2 == null) {
                bl = false;
            } else if (KotlinBuiltIns.isArray(type2)) {
                TypeProjection typeProjection = CollectionsKt.singleOrNull(type2.getArguments());
                bl = this.isTypeParameterOrArrayOfTypeParameter$frontend(typeProjection != null ? typeProjection.getType() : null);
            } else {
                bl = type2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor;
            }
            return bl;
        }

        public final boolean isComplexBooleanConstant(@NotNull KtExpression expression, @NotNull CompileTimeConstant<?> constant) {
            Intrinsics.checkNotNullParameter(expression, "expression");
            Intrinsics.checkNotNullParameter(constant, "constant");
            if (constant.isError()) {
                return false;
            }
            SimpleType simpleType2 = constant.getModuleDescriptor().getBuiltIns().getBooleanType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "getBooleanType(...)");
            ConstantValue<?> constantValue = constant.toConstantValue(simpleType2);
            if (!TypeUtilsKt.isBoolean(constantValue.getType(constant.getModuleDescriptor()))) {
                return false;
            }
            return !(expression instanceof KtConstantExpression) && !constant.getParameters().getUsesVariableAsConstant();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ1\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R&\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0006\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator$Companion$ExperimentalityDiagnostic1;", "Lorg/jetbrains/kotlin/resolve/checkers/OptInUsageChecker$OptInDiagnosticReporter;", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Lcom/intellij/psi/PsiElement;", "", "factory", "verb", "<init>", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;Ljava/lang/String;)V", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "element", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "message", "", "report", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;)V", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "getFactory", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory1;", "Ljava/lang/String;", "getVerb", "()Ljava/lang/String;"})
        private static final class ExperimentalityDiagnostic1
        implements OptInUsageChecker.OptInDiagnosticReporter {
            @NotNull
            private final DiagnosticFactory1<PsiElement, String> factory;
            @NotNull
            private final String verb;

            public ExperimentalityDiagnostic1(@NotNull DiagnosticFactory1<PsiElement, String> factory2, @NotNull String verb) {
                Intrinsics.checkNotNullParameter(factory2, "factory");
                Intrinsics.checkNotNullParameter(verb, "verb");
                this.factory = factory2;
                this.verb = verb;
            }

            @NotNull
            public final DiagnosticFactory1<PsiElement, String> getFactory() {
                return this.factory;
            }

            @NotNull
            public final String getVerb() {
                return this.verb;
            }

            @Override
            public void report(@NotNull BindingTrace trace, @NotNull PsiElement element, @NotNull FqName fqName2, @Nullable String message) {
                Intrinsics.checkNotNullParameter(trace, "trace");
                Intrinsics.checkNotNullParameter(element, "element");
                Intrinsics.checkNotNullParameter(fqName2, "fqName");
                Function1<FqName, String> defaultMessage = OptInUsageChecker.Companion.getDefaultDiagnosticMessage$frontend(ExperimentalUnsignedLiteralsDiagnosticMessageProvider.INSTANCE, this.verb);
                ParametrizedDiagnostic<PsiElement> parametrizedDiagnostic = this.factory.on(element, defaultMessage.invoke(fqName2));
                Intrinsics.checkNotNullExpressionValue(parametrizedDiagnostic, "on(...)");
                DiagnosticUtilsKt.reportDiagnosticOnce(trace, parametrizedDiagnostic);
            }
        }
    }
}

