/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.google.common.collect.ImmutableBiMap;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstUtilKt;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorUtilKt;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.InlineConstTracker;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.parsing.ParseUtilsKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassLiteralExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEscapeStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntryWithExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompileTimeConstantUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImplicitIntegerCoercion;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.SinceKotlinAccessibility;
import org.jetbrains.kotlin.resolve.SinceKotlinUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantChecker;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstantKt;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactory;
import org.jetbrains.kotlin.resolve.constants.ConstantValueFactoryKt;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.IntegerValueConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.KClassValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.constants.TypedCompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.UIntValue;
import org.jetbrains.kotlin.resolve.constants.ULongValue;
import org.jetbrains.kotlin.resolve.constants.UnsignedErrorValueTypeConstant;
import org.jetbrains.kotlin.resolve.constants.UnsignedValueConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.CompileTimeType;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorVisitor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00b0\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0002\u009f\u0001B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ'\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ#\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J'\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J'\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u00162\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b\u0017\u0010\u0018J'\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u00192\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ'\u0010\u001d\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u001c2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0017\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001f\u0010 J'\u0010\"\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020!2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b\"\u0010#J'\u0010%\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020$2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b%\u0010&J'\u0010(\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020'2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b(\u0010)J/\u0010,\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0004\b,\u0010-J\u0017\u0010.\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b.\u0010 J\u0017\u0010/\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b/\u0010 J\u0017\u00100\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b0\u0010 J\u0017\u00101\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b1\u0010 J)\u00107\u001a\u0004\u0018\u0001062\u0006\u00103\u001a\u0002022\u0006\u00105\u001a\u0002042\u0006\u0010*\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b7\u00108J1\u0010:\u001a\u0004\u0018\u0001062\u0006\u00103\u001a\u0002022\u0006\u00109\u001a\u0002022\u0006\u00105\u001a\u0002042\u0006\u0010*\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b:\u0010;J!\u0010<\u001a\u00020\u00102\u0006\u00105\u001a\u0002042\b\u00109\u001a\u0004\u0018\u000106H\u0002\u00a2\u0006\u0004\b<\u0010=J'\u0010?\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020>2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\b?\u0010@J'\u0010B\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020A2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bB\u0010CJ\u001f\u0010G\u001a\u00020F2\u0006\u0010\u000b\u001a\u00020A2\u0006\u0010E\u001a\u00020DH\u0002\u00a2\u0006\u0004\bG\u0010HJ\u0017\u0010J\u001a\u00020\u00102\u0006\u0010I\u001a\u00020DH\u0002\u00a2\u0006\u0004\bJ\u0010KJ'\u0010M\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020L2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bM\u0010NJ'\u0010P\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020O2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bP\u0010QJ7\u0010Z\u001a\b\u0012\u0002\b\u0003\u0018\u00010Y2\n\u0010S\u001a\u0006\u0012\u0002\b\u00030R2\u0006\u0010U\u001a\u00020T2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020W0VH\u0002\u00a2\u0006\u0004\bZ\u0010[J-\u0010^\u001a\u0014\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030]0\\\u0018\u00010Y2\n\u0010S\u001a\u0006\u0012\u0002\b\u00030RH\u0002\u00a2\u0006\u0004\b^\u0010_J'\u0010a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020`2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\ba\u0010bJ1\u0010e\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00020\\2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020c0\\2\u0006\u0010\f\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\be\u0010fJ'\u0010i\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\u0006\u0010h\u001a\u00020g2\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0017\u00a2\u0006\u0004\bi\u0010jJ%\u0010l\u001a\u0004\u0018\u0001022\n\u0010k\u001a\u0006\u0012\u0002\b\u00030R2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\bl\u0010mJ!\u0010q\u001a\u0004\u0018\u0001022\u0006\u0010o\u001a\u00020n2\u0006\u00109\u001a\u00020pH\u0002\u00a2\u0006\u0004\bq\u0010rJ\u0019\u0010u\u001a\u0004\u0018\u00010t2\u0006\u0010s\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\bu\u0010vJ)\u0010y\u001a\u0004\u0018\u0001022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010w\u001a\u00020\u00032\u0006\u0010x\u001a\u00020tH\u0002\u00a2\u0006\u0004\by\u0010zJ1\u0010~\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u0010{\u001a\u0004\u0018\u0001062\b\u0010\f\u001a\u0004\u0018\u00010\u00032\u0006\u0010}\u001a\u00020|H\u0002\u00a2\u0006\u0004\b~\u0010\u007fJ2\u0010\u0080\u0001\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\b\u0010{\u001a\u0004\u0018\u0001062\u0006\u0010}\u001a\u00020|2\u0006\u0010\f\u001a\u00020\u0003H\u0002\u00a2\u0006\u0006\b\u0080\u0001\u0010\u0081\u0001J/\u0010\u0083\u0001\u001a\u0006\u0012\u0002\b\u00030\u00022\u0007\u0010{\u001a\u00030\u0082\u00012\u0006\u0010}\u001a\u00020|2\u0006\u0010\f\u001a\u00020\u0003H\u0002\u00a2\u0006\u0006\b\u0083\u0001\u0010\u0084\u0001J#\u0010\u0085\u0001\u001a\u0006\u0012\u0002\b\u00030Y*\u00030\u0082\u00012\u0006\u0010}\u001a\u00020|H\u0002\u00a2\u0006\u0006\b\u0085\u0001\u0010\u0086\u0001J\u0012\u0010\u0087\u0001\u001a\u00020\u0010H\u0002\u00a2\u0006\u0006\b\u0087\u0001\u0010\u0088\u0001J1\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00028\u00000Y\"\u0005\b\u0000\u0010\u0089\u0001*\b\u0012\u0004\u0012\u00028\u00000]2\u0006\u0010}\u001a\u00020|H\u0002\u00a2\u0006\u0006\b\u008a\u0001\u0010\u008b\u0001Js\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00028\u00000Y\"\u0005\b\u0000\u0010\u0089\u0001*\b\u0012\u0004\u0012\u00028\u00000]2\b\b\u0002\u00100\u001a\u00020\u00102\t\b\u0002\u0010\u008c\u0001\u001a\u00020\u00102\t\b\u0002\u0010\u008d\u0001\u001a\u00020\u00102\t\b\u0002\u0010\u008e\u0001\u001a\u00020\u00102\b\b\u0002\u0010.\u001a\u00020\u00102\b\b\u0002\u0010/\u001a\u00020\u00102\t\b\u0002\u0010\u008f\u0001\u001a\u00020\u0010H\u0002\u00a2\u0006\u0006\b\u008a\u0001\u0010\u0090\u0001R\u0015\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u0005\u0010\u0091\u0001R\u0015\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u0007\u0010\u0092\u0001R\u0018\u0010\u0094\u0001\u001a\u00030\u0093\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0006\b\u0094\u0001\u0010\u0095\u0001R\u0018\u0010\u0097\u0001\u001a\u00030\u0096\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0006\b\u0097\u0001\u0010\u0098\u0001R\u001a\u0010\u009a\u0001\u001a\u0005\u0018\u00010\u0099\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0006\b\u009a\u0001\u0010\u009b\u0001R\u0018\u0010\u009d\u0001\u001a\u00030\u009c\u00018\u0002X\u0083\u0004\u00a2\u0006\b\n\u0006\b\u009d\u0001\u0010\u009e\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor;", "Lorg/jetbrains/kotlin/psi/KtVisitor;", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "<init>", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "expectedType", "evaluate", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "constant", "", "shouldSkipComplexBooleanValue", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;)Z", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "visitConstantExpression", "(Lorg/jetbrains/kotlin/psi/KtConstantExpression;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;", "visitParenthesizedExpression", "(Lorg/jetbrains/kotlin/psi/KtParenthesizedExpression;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/psi/KtLabeledExpression;", "visitLabeledExpression", "(Lorg/jetbrains/kotlin/psi/KtLabeledExpression;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "visitStringTemplateExpression", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "isStandaloneOnlyConstant", "(Lorg/jetbrains/kotlin/psi/KtExpression;)Z", "Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;", "visitBinaryWithTypeRHSExpression", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpressionWithTypeRHS;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "visitBinaryExpression", "(Lorg/jetbrains/kotlin/psi/KtBinaryExpression;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;", "visitCollectionLiteralExpression", "(Lorg/jetbrains/kotlin/psi/KtCollectionLiteralExpression;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "callExpression", "receiverExpression", "evaluateCall", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "usesVariableAsConstant", "usesNonConstValAsConstant", "canBeUsedInAnnotation", "isPureConstant", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "receiver", "", "name", "", "evaluateUnaryAndCheck", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtExpression;)Ljava/lang/Object;", "parameter", "evaluateBinaryAndCheck", "(Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtExpression;)Ljava/lang/Object;", "isDivisionByZero", "(Ljava/lang/String;Ljava/lang/Object;)Z", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "visitUnaryExpression", "(Lorg/jetbrains/kotlin/psi/KtUnaryExpression;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "visitSimpleNameExpression", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "variableDescriptor", "", "reportInlineConst", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;)V", "descriptor", "isPropertyCompileTimeConstant", "(Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;)Z", "Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;", "visitQualifiedExpression", "(Lorg/jetbrains/kotlin/psi/KtQualifiedExpression;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "visitCallExpression", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "call", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/InlineClassRepresentation;", "Lorg/jetbrains/kotlin/types/SimpleType;", "representation", "Lorg/jetbrains/kotlin/resolve/constants/TypedCompileTimeConstant;", "createConstantValueForUnsignedTypeConstructor", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;Lorg/jetbrains/kotlin/descriptors/InlineClassRepresentation;)Lorg/jetbrains/kotlin/resolve/constants/TypedCompileTimeConstant;", "", "Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;", "createConstantValueForArrayFunctionCall", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;)Lorg/jetbrains/kotlin/resolve/constants/TypedCompileTimeConstant;", "Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;", "visitClassLiteralExpression", "(Lorg/jetbrains/kotlin/psi/KtClassLiteralExpression;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "valueArguments", "resolveArguments", "(Ljava/util/List;Lorg/jetbrains/kotlin/types/KotlinType;)Ljava/util/List;", "Lorg/jetbrains/kotlin/psi/KtElement;", "element", "visitKtElement", "(Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "resolvedCall", "createOperationArgumentForReceiver", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;Lorg/jetbrains/kotlin/psi/KtExpression;)Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;", "argument", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "createOperationArgumentForFirstParameter", "(Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedValueArgument;Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;)Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "c", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "getCompileTimeType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "parameterType", "compileTimeType", "createOperationArgument", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;)Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "value", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;", "parameters", "createConstant", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "createCompileTimeConstant", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "", "createIntegerCompileTimeConstant", "(JLorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "createSimpleIntCompileTimeConst", "(JLorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;)Lorg/jetbrains/kotlin/resolve/constants/TypedCompileTimeConstant;", "checkAccessibilityOfUnsignedTypes", "()Z", "T", "wrap", "(Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant$Parameters;)Lorg/jetbrains/kotlin/resolve/constants/TypedCompileTimeConstant;", "isPure", "isUnsigned", "isUnsignedLong", "isConvertableConstVal", "(Lorg/jetbrains/kotlin/resolve/constants/ConstantValue;ZZZZZZZ)Lorg/jetbrains/kotlin/resolve/constants/TypedCompileTimeConstant;", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "inlineConstTracker", "Lorg/jetbrains/kotlin/incremental/components/InlineConstTracker;", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$stringExpressionEvaluator$1;", "stringExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$stringExpressionEvaluator$1;", "OperationArgument"})
final class ConstantExpressionEvaluatorVisitor
extends KtVisitor<CompileTimeConstant<?>, KotlinType> {
    @NotNull
    private final ConstantExpressionEvaluator constantExpressionEvaluator;
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final KotlinBuiltIns builtIns;
    @Nullable
    private final InlineConstTracker inlineConstTracker;
    @NotNull
    private final stringExpressionEvaluator.1 stringExpressionEvaluator;

    public ConstantExpressionEvaluatorVisitor(@NotNull ConstantExpressionEvaluator constantExpressionEvaluator, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(constantExpressionEvaluator, "constantExpressionEvaluator");
        Intrinsics.checkNotNullParameter(trace, "trace");
        this.constantExpressionEvaluator = constantExpressionEvaluator;
        this.trace = trace;
        this.languageVersionSettings = this.constantExpressionEvaluator.getLanguageVersionSettings$frontend();
        this.builtIns = this.constantExpressionEvaluator.getModule$frontend().getBuiltIns();
        this.inlineConstTracker = this.constantExpressionEvaluator.getInlineConstTracker$frontend() instanceof InlineConstTracker.DoNothing ? null : this.constantExpressionEvaluator.getInlineConstTracker$frontend();
        this.stringExpressionEvaluator = new KtVisitor(this){
            final /* synthetic */ ConstantExpressionEvaluatorVisitor this$0;
            {
                this.this$0 = $receiver;
            }

            private final TypedCompileTimeConstant<String> createStringConstant(CompileTimeConstant<?> compileTimeConstant) {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue(simpleType2, "NO_EXPECTED_TYPE");
                ConstantValue<?> constantValue = compileTimeConstant.toConstantValue(simpleType2);
                if (ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(constantValue)) {
                    return null;
                }
                ConstantValue<?> constantValue2 = constantValue;
                if (constantValue2 instanceof ErrorValue || constantValue2 instanceof EnumValue) {
                    return null;
                }
                return ConstantExpressionEvaluatorVisitor.access$wrap(this.this$0, constantValue2 instanceof NullValue ? new StringValue("null") : new StringValue(String.valueOf(constantValue.boxedValue())), compileTimeConstant.getParameters());
            }

            public final TypedCompileTimeConstant<String> evaluate(KtStringTemplateEntry entry) {
                Intrinsics.checkNotNullParameter(entry, "entry");
                return (TypedCompileTimeConstant)entry.accept(this, null);
            }

            public TypedCompileTimeConstant<String> visitStringTemplateEntryWithExpression(KtStringTemplateEntryWithExpression entry, Void data2) {
                TypedCompileTimeConstant<String> typedCompileTimeConstant;
                Intrinsics.checkNotNullParameter(entry, "entry");
                KtExpression ktExpression = entry.getExpression();
                if (ktExpression == null) {
                    return null;
                }
                KtExpression expression = ktExpression;
                CompileTimeConstant<?> compileTimeConstant = this.this$0.evaluate(expression, ConstantExpressionEvaluatorVisitor.access$getBuiltIns$p(this.this$0).getStringType());
                if (compileTimeConstant != null) {
                    CompileTimeConstant<?> it = compileTimeConstant;
                    boolean bl = false;
                    typedCompileTimeConstant = this.createStringConstant(it);
                } else {
                    typedCompileTimeConstant = null;
                }
                return typedCompileTimeConstant;
            }

            public TypedCompileTimeConstant<String> visitLiteralStringTemplateEntry(KtLiteralStringTemplateEntry entry, Void data2) {
                Intrinsics.checkNotNullParameter(entry, "entry");
                String string2 = entry.getText();
                Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
                return ConstantExpressionEvaluatorVisitor.wrap$default(this.this$0, new StringValue(string2), false, false, false, false, false, false, false, 127, null);
            }

            public TypedCompileTimeConstant<String> visitEscapeStringTemplateEntry(KtEscapeStringTemplateEntry entry, Void data2) {
                Intrinsics.checkNotNullParameter(entry, "entry");
                String string2 = entry.getUnescapedValue();
                Intrinsics.checkNotNullExpressionValue(string2, "getUnescapedValue(...)");
                return ConstantExpressionEvaluatorVisitor.wrap$default(this.this$0, new StringValue(string2), false, false, false, false, false, false, false, 127, null);
            }
        };
    }

    @Nullable
    public final CompileTimeConstant<?> evaluate(@NotNull KtExpression expression, @Nullable KotlinType expectedType) {
        CompileTimeConstant compileTimeConstant;
        Intrinsics.checkNotNullParameter(expression, "expression");
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        CompileTimeConstant<?> recordedCompileTimeConstant = ConstantExpressionEvaluator.Companion.getPossiblyErrorConstant(expression, bindingContext);
        if (recordedCompileTimeConstant != null) {
            return recordedCompileTimeConstant;
        }
        KtVisitor ktVisitor = this;
        KotlinType kotlinType = expectedType;
        if (kotlinType == null) {
            SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
            Intrinsics.checkNotNullExpressionValue(simpleType2, "NO_EXPECTED_TYPE");
            kotlinType = simpleType2;
        }
        if ((compileTimeConstant = (CompileTimeConstant)expression.accept(ktVisitor, kotlinType)) != null) {
            if (this.shouldSkipComplexBooleanValue(expression, compileTimeConstant)) {
                return null;
            }
            if (compileTimeConstant instanceof TypedCompileTimeConstant && TypeUtilsKt.isGenericArrayOfTypeParameter(((TypedCompileTimeConstant)compileTimeConstant).getType())) {
                return compileTimeConstant;
            }
            this.trace.record(BindingContext.COMPILE_TIME_VALUE, expression, compileTimeConstant);
            return compileTimeConstant;
        }
        return null;
    }

    private final boolean shouldSkipComplexBooleanValue(KtExpression expression, CompileTimeConstant<?> constant) {
        if (!ConstantExpressionEvaluator.Companion.isComplexBooleanConstant(expression, constant)) {
            return false;
        }
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitSimplificationOfNonTrivialConstBooleanExpressions)) {
            return true;
        }
        PsiElement parent2 = expression.getParent();
        while (parent2 instanceof KtParenthesizedExpression) {
            parent2 = ((KtParenthesizedExpression)parent2).getParent();
        }
        if (parent2 instanceof KtWhenConditionWithExpression || parent2 instanceof KtContainerNode && (((KtContainerNode)parent2).getParent() instanceof KtWhileExpression || ((KtContainerNode)parent2).getParent() instanceof KtDoWhileExpression)) {
            SimpleType simpleType2 = this.builtIns.getBooleanType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "getBooleanType(...)");
            ConstantValue<?> constantValue = constant.toConstantValue(simpleType2);
            PsiElement psiElement = expression;
            Object obj = constantValue.getValue();
            Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type kotlin.Boolean");
            this.trace.report(Errors.NON_TRIVIAL_BOOLEAN_CONSTANT.on((KtExpression)psiElement, (Boolean)obj));
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitConstantExpression(@NotNull KtConstantExpression expression, @Nullable KotlinType expectedType) {
        boolean isIntegerConstant;
        Serializable serializable;
        Intrinsics.checkNotNullParameter(expression, "expression");
        String string2 = expression.getText();
        if (string2 == null) {
            return null;
        }
        String text = string2;
        IElementType iElementType = expression.getNode().getElementType();
        Intrinsics.checkNotNullExpressionValue(iElementType, "getElementType(...)");
        IElementType nodeElementType = iElementType;
        if (Intrinsics.areEqual(nodeElementType, KtNodeTypes.NULL)) {
            return ConstantExpressionEvaluatorVisitor.wrap$default(this, new NullValue(), false, false, false, false, false, false, false, 127, null);
        }
        IElementType iElementType2 = nodeElementType;
        if (Intrinsics.areEqual(iElementType2, KtNodeTypes.INTEGER_CONSTANT) || Intrinsics.areEqual(iElementType2, KtNodeTypes.FLOAT_CONSTANT)) {
            serializable = ParseUtilsKt.parseNumericLiteral(text, nodeElementType);
        } else if (Intrinsics.areEqual(iElementType2, KtNodeTypes.BOOLEAN_CONSTANT)) {
            serializable = Boolean.valueOf(ParseUtilsKt.parseBoolean(text));
        } else if (Intrinsics.areEqual(iElementType2, KtNodeTypes.CHARACTER_CONSTANT)) {
            serializable = CompileTimeConstantChecker.parseChar(expression);
        } else {
            throw new IllegalArgumentException("Unsupported constant: " + expression);
        }
        if (serializable == null) {
            return null;
        }
        Serializable result2 = serializable;
        if (result2 instanceof Double) {
            if (Double.isInfinite(((Number)result2).doubleValue())) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_INFINITY.on((KtConstantExpression)((PsiElement)expression)));
            }
            if (((Number)result2).doubleValue() == 0.0 && !TypeConversionUtil.isFPZero(text)) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_ZERO.on((KtConstantExpression)((PsiElement)expression)));
            }
        }
        if (result2 instanceof Float) {
            if (Float.isInfinite(((Number)result2).floatValue())) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_INFINITY.on((KtConstantExpression)((PsiElement)expression)));
            }
            if (((Number)result2).floatValue() == 0.0f && !TypeConversionUtil.isFPZero(text)) {
                this.trace.report(Errors.FLOAT_LITERAL_CONFORMS_ZERO.on((KtConstantExpression)((PsiElement)expression)));
            }
        }
        boolean isUnsignedLong = (isIntegerConstant = Intrinsics.areEqual(nodeElementType, KtNodeTypes.INTEGER_CONSTANT)) && ParseUtilsKt.hasUnsignedLongSuffix(text);
        boolean isUnsigned = isUnsignedLong || ParseUtilsKt.hasUnsignedSuffix(text);
        boolean isTyped = isUnsigned || ParseUtilsKt.hasLongSuffix(text);
        return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(true, !isTyped, isUnsigned, isUnsignedLong, false, false, false));
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitParenthesizedExpression(@NotNull KtParenthesizedExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        KtExpression deparenthesizedExpression = KtPsiUtil.deparenthesize(expression);
        if (deparenthesizedExpression != null && !Intrinsics.areEqual(deparenthesizedExpression, expression)) {
            return this.evaluate(deparenthesizedExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitLabeledExpression(@NotNull KtLabeledExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        KtExpression baseExpression = expression.getBaseExpression();
        if (baseExpression != null) {
            return this.evaluate(baseExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitStringTemplateExpression(@NotNull KtStringTemplateExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        StringBuilder sb = new StringBuilder();
        boolean interupted = false;
        boolean canBeUsedInAnnotation = true;
        boolean usesVariableAsConstant = false;
        boolean usesNonConstantVariableAsConstant = false;
        for (KtStringTemplateEntry entry : expression.getEntries()) {
            Intrinsics.checkNotNull(entry);
            TypedCompileTimeConstant<String> constant = this.stringExpressionEvaluator.evaluate(entry);
            if (constant == null) {
                interupted = true;
                break;
            }
            if (!constant.getCanBeUsedInAnnotations()) {
                canBeUsedInAnnotation = false;
            }
            if (constant.getUsesVariableAsConstant()) {
                usesVariableAsConstant = true;
            }
            if (constant.getUsesNonConstValAsConstant()) {
                usesNonConstantVariableAsConstant = true;
            }
            sb.append(constant.getConstantValue().getValue());
        }
        return !interupted ? this.createConstant(sb.toString(), expectedType, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, false, false, false, usesVariableAsConstant, usesNonConstantVariableAsConstant, false)) : null;
    }

    private final boolean isStandaloneOnlyConstant(KtExpression expression) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext);
        if (compileTimeConstant == null) {
            return false;
        }
        return ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(compileTimeConstant);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryWithTypeRHSExpression(@NotNull KtBinaryExpressionWithTypeRHS expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        KtExpression ktExpression = expression.getLeft();
        Intrinsics.checkNotNullExpressionValue(ktExpression, "getLeft(...)");
        CompileTimeConstant<?> compileTimeConstant = this.evaluate(ktExpression, expectedType);
        if (compileTimeConstant != null && expectedType != null && !TypeUtils.noExpectedType(expectedType)) {
            KotlinType kotlinType;
            CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
            if (compileTimeConstant2 instanceof TypedCompileTimeConstant) {
                kotlinType = ((TypedCompileTimeConstant)compileTimeConstant).getType();
            } else if (compileTimeConstant2 instanceof IntegerValueTypeConstant) {
                kotlinType = ((IntegerValueTypeConstant)compileTimeConstant).getType(expectedType);
            } else {
                throw new IllegalStateException("Unexpected compileTimeConstant class: " + compileTimeConstant.getClass().getCanonicalName());
            }
            KotlinType constantType = kotlinType;
            if (!TypeUtilsKt.isSubtypeOf(constantType, expectedType)) {
                return null;
            }
        }
        return compileTimeConstant;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitBinaryExpression(@NotNull KtBinaryExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        KtExpression ktExpression = expression.getLeft();
        if (ktExpression == null) {
            return null;
        }
        KtExpression leftExpression = ktExpression;
        IElementType iElementType = expression.getOperationToken();
        Intrinsics.checkNotNullExpressionValue(iElementType, "getOperationToken(...)");
        IElementType operationToken = iElementType;
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.BOOLEAN_OPERATIONS;
        Intrinsics.checkNotNullExpressionValue(immutableBiMap, "BOOLEAN_OPERATIONS");
        if (((Map)immutableBiMap).containsKey(operationToken)) {
            boolean bl;
            SimpleType simpleType2 = this.builtIns.getBooleanType();
            Intrinsics.checkNotNullExpressionValue(simpleType2, "getBooleanType(...)");
            SimpleType booleanType = simpleType2;
            CompileTimeConstant<?> compileTimeConstant = this.evaluate(leftExpression, booleanType);
            if (compileTimeConstant == null) {
                return null;
            }
            CompileTimeConstant<?> leftConstant = compileTimeConstant;
            KtExpression ktExpression2 = expression.getRight();
            if (ktExpression2 == null) {
                return null;
            }
            KtExpression rightExpression = ktExpression2;
            CompileTimeConstant<?> compileTimeConstant2 = this.evaluate(rightExpression, booleanType);
            if (compileTimeConstant2 == null) {
                return null;
            }
            CompileTimeConstant<?> rightConstant = compileTimeConstant2;
            Object leftValue = leftConstant.getValue(booleanType);
            Object rightValue = rightConstant.getValue(booleanType);
            if (!(leftValue instanceof Boolean) || !(rightValue instanceof Boolean)) {
                return null;
            }
            IElementType iElementType2 = operationToken;
            if (Intrinsics.areEqual(iElementType2, KtTokens.ANDAND)) {
                bl = ((Boolean)leftValue).booleanValue() && ((Boolean)rightValue).booleanValue();
            } else if (Intrinsics.areEqual(iElementType2, KtTokens.OROR)) {
                bl = ((Boolean)leftValue).booleanValue() || ((Boolean)rightValue).booleanValue();
            } else {
                throw new IllegalArgumentException("Unknown boolean operation token " + operationToken);
            }
            boolean result2 = bl;
            return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(true, false, false, false, leftConstant.getUsesVariableAsConstant() || rightConstant.getUsesVariableAsConstant(), leftConstant.getUsesNonConstValAsConstant() || rightConstant.getUsesNonConstValAsConstant(), false));
        }
        KtOperationReferenceExpression ktOperationReferenceExpression = expression.getOperationReference();
        Intrinsics.checkNotNullExpressionValue(ktOperationReferenceExpression, "getOperationReference(...)");
        return this.evaluateCall(ktOperationReferenceExpression, leftExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitCollectionLiteralExpression(@NotNull KtCollectionLiteralExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        ResolvedCall resolvedCall2 = (ResolvedCall)this.trace.getBindingContext().get(BindingContext.COLLECTION_LITERAL_CALL, expression);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        return this.createConstantValueForArrayFunctionCall(resolvedCall3);
    }

    private final CompileTimeConstant<?> evaluateCall(KtExpression callExpression, KtExpression receiverExpression, KotlinType expectedType) {
        KtElement ktElement = callExpression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        if (!KotlinBuiltIns.isUnderKotlinPackage(resolvedCall3.getResultingDescriptor())) {
            return null;
        }
        Name name = ((Named)resolvedCall3.getResultingDescriptor()).getName();
        Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
        Name resultingDescriptorName = name;
        OperationArgument operationArgument = this.createOperationArgumentForReceiver(resolvedCall3, receiverExpression);
        if (operationArgument == null) {
            return null;
        }
        OperationArgument argumentForReceiver = operationArgument;
        if (this.isStandaloneOnlyConstant(argumentForReceiver.getExpression())) {
            return null;
        }
        Set<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> argumentsEntrySet = resolvedCall3.getValueArguments().entrySet();
        if (argumentsEntrySet.isEmpty()) {
            String string2 = resultingDescriptorName.asString();
            Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
            Object object = this.evaluateUnaryAndCheck(argumentForReceiver, string2, callExpression);
            if (object == null) {
                return null;
            }
            Object result2 = object;
            boolean isArgumentPure = this.isPureConstant(argumentForReceiver.getExpression());
            boolean canBeUsedInAnnotation = this.canBeUsedInAnnotation(argumentForReceiver.getExpression());
            boolean usesVariableAsConstant = this.usesVariableAsConstant(argumentForReceiver.getExpression());
            boolean usesNonConstValAsConstant = this.usesNonConstValAsConstant(argumentForReceiver.getExpression());
            boolean isNumberConversionMethod = OperatorConventions.NUMBER_CONVERSIONS.contains(resultingDescriptorName);
            boolean isCharCode = argumentForReceiver.getCtcType() == CompileTimeType.CHAR && Intrinsics.areEqual(resultingDescriptorName, StandardNames.CHAR_CODE);
            return this.createConstant(result2, expectedType, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, !isNumberConversionMethod && !isCharCode && isArgumentPure, false, false, usesVariableAsConstant, usesNonConstValAsConstant, false));
        }
        if (argumentsEntrySet.size() == 1) {
            CompileTimeConstant compileTimeConstant;
            Map.Entry entry = (Map.Entry)CollectionsKt.first((Iterable)argumentsEntrySet);
            ValueParameterDescriptor parameter = (ValueParameterDescriptor)entry.getKey();
            ResolvedValueArgument argument = (ResolvedValueArgument)entry.getValue();
            Intrinsics.checkNotNull(argument);
            Intrinsics.checkNotNull(parameter);
            OperationArgument operationArgument2 = this.createOperationArgumentForFirstParameter(argument, parameter);
            if (operationArgument2 == null) {
                return null;
            }
            OperationArgument argumentForParameter = operationArgument2;
            if (this.isStandaloneOnlyConstant(argumentForParameter.getExpression())) {
                return null;
            }
            String string3 = resultingDescriptorName.asString();
            Intrinsics.checkNotNullExpressionValue(string3, "asString(...)");
            if (this.isDivisionByZero(string3, argumentForParameter.getValue())) {
                KtExpression ktExpression = PsiTreeUtil.getParentOfType((PsiElement)receiverExpression, KtExpression.class);
                Intrinsics.checkNotNull(ktExpression);
                KtExpression parentExpression = ktExpression;
                this.trace.report(Errors.DIVISION_BY_ZERO.on((KtExpression)((PsiElement)parentExpression)));
                if (ConstantExpressionEvaluatorKt.isIntegerType(argumentForReceiver.getValue()) && ConstantExpressionEvaluatorKt.isIntegerType(argumentForParameter.getValue()) || !this.languageVersionSettings.supportsFeature(LanguageFeature.DivisionByZeroInConstantExpressions)) {
                    return ConstantExpressionEvaluatorVisitor.wrap$default(this, ErrorValue.Companion.create("Division by zero"), false, false, false, false, false, false, false, 127, null);
                }
            }
            String string4 = resultingDescriptorName.asString();
            Intrinsics.checkNotNullExpressionValue(string4, "asString(...)");
            Object object = this.evaluateBinaryAndCheck(argumentForReceiver, argumentForParameter, string4, callExpression);
            if (object == null) {
                return null;
            }
            Object result3 = object;
            boolean areArgumentsPure = this.isPureConstant(argumentForReceiver.getExpression()) && this.isPureConstant(argumentForParameter.getExpression());
            boolean canBeUsedInAnnotation = this.canBeUsedInAnnotation(argumentForReceiver.getExpression()) && this.canBeUsedInAnnotation(argumentForParameter.getExpression());
            boolean usesVariableAsConstant = this.usesVariableAsConstant(argumentForReceiver.getExpression()) || this.usesVariableAsConstant(argumentForParameter.getExpression());
            boolean usesNonConstValAsConstant = this.usesNonConstValAsConstant(argumentForReceiver.getExpression()) || this.usesNonConstValAsConstant(argumentForParameter.getExpression());
            CompileTimeConstant.Parameters parameters2 = new CompileTimeConstant.Parameters(canBeUsedInAnnotation, areArgumentsPure, false, false, usesVariableAsConstant, usesNonConstValAsConstant, false);
            Name name2 = resultingDescriptorName;
            if (Intrinsics.areEqual(name2, OperatorNameConventions.COMPARE_TO)) {
                ConstantValue constantValue = ConstantExpressionEvaluatorKt.access$createCompileTimeConstantForCompareTo(result3, callExpression);
                compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
            } else if (Intrinsics.areEqual(name2, OperatorNameConventions.EQUALS)) {
                ConstantValue constantValue = ConstantExpressionEvaluatorKt.access$createCompileTimeConstantForEquals(result3, callExpression);
                compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
            } else {
                compileTimeConstant = this.createConstant(result3, expectedType, parameters2);
            }
            return compileTimeConstant;
        }
        return null;
    }

    private final boolean usesVariableAsConstant(KtExpression expression) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getUsesVariableAsConstant() : false;
    }

    private final boolean usesNonConstValAsConstant(KtExpression expression) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getUsesNonConstValAsConstant() : false;
    }

    private final boolean canBeUsedInAnnotation(KtExpression expression) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.getCanBeUsedInAnnotations() : false;
    }

    private final boolean isPureConstant(KtExpression expression) {
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(expression, bindingContext);
        return compileTimeConstant != null ? compileTimeConstant.isPure() : false;
    }

    private final Object evaluateUnaryAndCheck(OperationArgument receiver, String name, KtExpression callExpression) {
        return ConstantExpressionEvaluatorKt.access$evaluateUnaryAndCheck(name, receiver.getCtcType(), receiver.getValue(), () -> ConstantExpressionEvaluatorVisitor.evaluateUnaryAndCheck$lambda$0(this, callExpression));
    }

    private final Object evaluateBinaryAndCheck(OperationArgument receiver, OperationArgument parameter, String name, KtExpression callExpression) {
        return ConstantExpressionEvaluatorKt.access$evaluateBinaryAndCheck(name, receiver.getCtcType(), receiver.getValue(), parameter.getCtcType(), parameter.getValue(), () -> ConstantExpressionEvaluatorVisitor.evaluateBinaryAndCheck$lambda$1(this, callExpression));
    }

    private final boolean isDivisionByZero(String name, Object parameter) {
        return ConstantExpressionEvaluatorKt.access$getDIVISION_OPERATION_NAMES$p().contains(name) && ConstantExpressionEvaluatorKt.access$isZero(parameter);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitUnaryExpression(@NotNull KtUnaryExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        KtExpression ktExpression = expression.getBaseExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression leftExpression = ktExpression;
        KtSimpleNameExpression ktSimpleNameExpression = expression.getOperationReference();
        Intrinsics.checkNotNullExpressionValue(ktSimpleNameExpression, "getOperationReference(...)");
        return this.evaluateCall(ktSimpleNameExpression, leftExpression, expectedType);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression, @Nullable KotlinType expectedType) {
        VariableDescriptor variableDescriptor;
        Intrinsics.checkNotNullParameter(expression, "expression");
        DeclarationDescriptor enumDescriptor = (DeclarationDescriptor)this.trace.getBindingContext().get(BindingContext.REFERENCE_TARGET, expression);
        if (enumDescriptor != null && DescriptorUtils.isEnumEntry(enumDescriptor)) {
            DeclarationDescriptor declarationDescriptor = enumDescriptor.getContainingDeclaration();
            Intrinsics.checkNotNull(declarationDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
            ClassId classId = DescriptorUtilsKt.getClassId((ClassifierDescriptor)((ClassDescriptor)declarationDescriptor));
            if (classId == null) {
                return null;
            }
            ClassId enumClassId = classId;
            Name name = enumDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue(name, "getName(...)");
            return ConstantExpressionEvaluatorVisitor.wrap$default(this, new EnumValue(enumClassId, name), false, false, false, false, false, false, false, 127, null);
        }
        VariableDescriptor variableDescriptor2 = variableDescriptor = enumDescriptor instanceof VariableDescriptor ? (VariableDescriptor)enumDescriptor : null;
        if (variableDescriptor != null && this.isPropertyCompileTimeConstant(variableDescriptor)) {
            DeclarationDescriptor declarationDescriptor = variableDescriptor.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
            if (!DescriptorUtilsKt.isCompanionObject(declarationDescriptor)) {
                this.reportInlineConst(expression, variableDescriptor);
            }
        }
        KtElement ktElement = expression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 != null) {
            CallableDescriptor callableDescriptor = resolvedCall2.getResultingDescriptor();
            Intrinsics.checkNotNullExpressionValue(callableDescriptor, "getResultingDescriptor(...)");
            CallableDescriptor callableDescriptor2 = callableDescriptor;
            if (callableDescriptor2 instanceof VariableDescriptor) {
                if (callableDescriptor2 instanceof PropertyDescriptor && ((PropertyDescriptor)callableDescriptor2).getModality() != Modality.FINAL) {
                    return null;
                }
                boolean isConvertableConstVal = ((VariableDescriptor)callableDescriptor2).isConst() && ImplicitIntegerCoercion.INSTANCE.isEnabledFor(callableDescriptor2, this.languageVersionSettings) && ((VariableDescriptor)callableDescriptor2).getCompileTimeInitializer() instanceof IntValue;
                ConstantValue<?> constantValue = ((VariableDescriptor)callableDescriptor2).getCompileTimeInitializer();
                return constantValue != null ? this.wrap(constantValue, new CompileTimeConstant.Parameters(this.isPropertyCompileTimeConstant((VariableDescriptor)callableDescriptor2), false, false, false, true, !((VariableDescriptor)callableDescriptor2).isConst(), isConvertableConstVal)) : null;
            }
        }
        return null;
    }

    private final void reportInlineConst(KtSimpleNameExpression expression, VariableDescriptor variableDescriptor) {
        String string2;
        if (this.inlineConstTracker == null) {
            return;
        }
        Object object = expression.getContainingFile().getVirtualFile();
        if (object == null || (object = ((VirtualFile)object).getPath()) == null) {
            return;
        }
        Object filePath = object;
        String name = expression.getReferencedName();
        String constType = variableDescriptor.getType().toString();
        Object object2 = DescriptorUtilKt.containingPackage(variableDescriptor);
        if (object2 == null || (object2 = ((FqName)object2).toString()) == null) {
            return;
        }
        Object containingPackage = object2;
        DeclarationDescriptor declarationDescriptor = variableDescriptor.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        String fqName2 = DescriptorUtilsKt.getFqNameSafe(declarationDescriptor).asString();
        if (StringsKt.startsWith$default(fqName2, (String)containingPackage + '.', false, 2, null)) {
            StringBuilder stringBuilder = new StringBuilder().append((String)containingPackage).append('.');
            String string3 = fqName2.substring(((String)containingPackage).length() + 1);
            Intrinsics.checkNotNullExpressionValue(string3, "substring(...)");
            string2 = stringBuilder.append(StringsKt.replace$default(string3, ".", "$", false, 4, null)).toString();
        } else {
            string2 = StringsKt.replace$default(fqName2, ".", "$", false, 4, null);
        }
        String owner = string2;
        this.inlineConstTracker.report((String)filePath, owner, name, constType);
    }

    private final boolean isPropertyCompileTimeConstant(VariableDescriptor descriptor2) {
        if (descriptor2.isVar()) {
            return false;
        }
        if (DescriptorUtils.isObject(descriptor2.getContainingDeclaration()) || DescriptorUtils.isStaticDeclaration(descriptor2)) {
            KotlinType kotlinType = descriptor2.getType();
            Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
            return ConstUtilKt.canBeUsedForConstVal(kotlinType);
        }
        return false;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitQualifiedExpression(@NotNull KtQualifiedExpression expression, @Nullable KotlinType expectedType) {
        CompileTimeConstant<?> result2;
        Intrinsics.checkNotNullParameter(expression, "expression");
        KtExpression selectorExpression = expression.getSelectorExpression();
        if (selectorExpression instanceof KtCallExpression) {
            CompileTimeConstant<?> qualifiedCallValue = this.evaluate(selectorExpression, expectedType);
            if (qualifiedCallValue != null) {
                return qualifiedCallValue;
            }
            KtExpression calleeExpression = ((KtCallExpression)selectorExpression).getCalleeExpression();
            if (!(calleeExpression instanceof KtSimpleNameExpression)) {
                return null;
            }
            KtExpression receiverExpression = expression.getReceiverExpression();
            return this.evaluateCall(calleeExpression, receiverExpression, expectedType);
        }
        if (selectorExpression instanceof KtSimpleNameExpression && (result2 = this.evaluateCall(selectorExpression, expression.getReceiverExpression(), expectedType)) != null) {
            return result2;
        }
        if (selectorExpression != null) {
            return this.evaluate(selectorExpression, expectedType);
        }
        return null;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitCallExpression(@NotNull KtCallExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        KtElement ktElement = expression;
        BindingContext bindingContext = this.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> call2 = resolvedCall2;
        CallableDescriptor callableDescriptor = call2.getResultingDescriptor();
        Intrinsics.checkNotNullExpressionValue(callableDescriptor, "getResultingDescriptor(...)");
        CallableDescriptor resultingDescriptor = callableDescriptor;
        if (CompileTimeConstantUtils.isArrayFunctionCall(call2)) {
            return this.createConstantValueForArrayFunctionCall(call2);
        }
        if (resultingDescriptor instanceof ConstructorDescriptor) {
            CompileTimeConstant compileTimeConstant;
            ClassDescriptor classDescriptor = ((ConstructorDescriptor)resultingDescriptor).getConstructedClass();
            Intrinsics.checkNotNullExpressionValue(classDescriptor, "getConstructedClass(...)");
            ClassDescriptor classDescriptor2 = classDescriptor;
            if (DescriptorUtils.isAnnotationClass(classDescriptor2)) {
                AnnotationDescriptorImpl descriptor2 = new AnnotationDescriptorImpl(classDescriptor2.getDefaultType(), this.constantExpressionEvaluator.resolveAnnotationArguments$frontend(call2, this.trace), SourceElement.NO_SOURCE);
                compileTimeConstant = ConstantExpressionEvaluatorVisitor.wrap$default(this, new AnnotationValue(descriptor2), false, false, false, false, false, false, false, 127, null);
            } else if (InlineClassesUtilsKt.isInlineClass(classDescriptor2) && UnsignedTypes.INSTANCE.isUnsignedClass(classDescriptor2)) {
                ConstructorDescriptor constructorDescriptor = (ConstructorDescriptor)resultingDescriptor;
                InlineClassRepresentation<SimpleType> inlineClassRepresentation2 = DescriptorUtilsKt.getInlineClassRepresentation(classDescriptor2);
                Intrinsics.checkNotNull(inlineClassRepresentation2);
                compileTimeConstant = this.createConstantValueForUnsignedTypeConstructor(call2, constructorDescriptor, inlineClassRepresentation2);
            } else {
                compileTimeConstant = null;
            }
            return compileTimeConstant;
        }
        return null;
    }

    private final TypedCompileTimeConstant<?> createConstantValueForUnsignedTypeConstructor(ResolvedCall<?> call2, ConstructorDescriptor constructorDescriptor, InlineClassRepresentation<SimpleType> representation) {
        if (!constructorDescriptor.isPrimary()) {
            return null;
        }
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = call2.getValueArguments();
        Intrinsics.checkNotNullExpressionValue(map2, "getValueArguments(...)");
        Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments = map2;
        if (valueArguments.size() > 1) {
            return null;
        }
        Object object = (ResolvedValueArgument)CollectionsKt.singleOrNull((Iterable)valueArguments.values());
        if (object == null || (object = object.getArguments()) == null || (object = (ValueArgument)CollectionsKt.singleOrNull(object)) == null) {
            return null;
        }
        Object argument = object;
        KtExpression ktExpression = argument.getArgumentExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression argumentExpression = ktExpression;
        SimpleType underlyingType = representation.getUnderlyingType();
        CompileTimeConstant<?> compileTimeConstant = this.evaluate(argumentExpression, underlyingType);
        CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
        if (compileTimeConstant2 == null || (compileTimeConstant2 = compileTimeConstant2.toConstantValue(underlyingType)) == null) {
            return null;
        }
        CompileTimeConstant<?> evaluatedArgument = compileTimeConstant2;
        UnsignedValueConstant<?> unsignedValueConstant = ConstantValueFactory.INSTANCE.createUnsignedValue((ConstantValue<?>)((Object)evaluatedArgument));
        if (unsignedValueConstant == null) {
            return null;
        }
        UnsignedValueConstant<?> unsignedValue = unsignedValueConstant;
        return this.wrap((ConstantValue)unsignedValue, compileTimeConstant.getParameters());
    }

    /*
     * WARNING - void declaration
     */
    private final TypedCompileTimeConstant<List<ConstantValue<?>>> createConstantValueForArrayFunctionCall(ResolvedCall<?> call2) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor;
        Object object;
        block10: {
            boolean bl7;
            Iterable $this$any$iv;
            boolean $i$f$any;
            List arguments2;
            block9: {
                Collection collection;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                void $this$flatMapTo$iv$iv;
                KotlinType kotlinType = call2.getResultingDescriptor().getReturnType();
                if (kotlinType == null) {
                    return null;
                }
                KotlinType returnType = kotlinType;
                KotlinType kotlinType2 = this.builtIns.getArrayElementType(returnType);
                Intrinsics.checkNotNullExpressionValue(kotlinType2, "getArrayElementType(...)");
                KotlinType componentType = kotlinType2;
                Iterable $this$flatMap$iv = call2.getValueArguments().values();
                boolean $i$f$flatMap22 = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    ResolvedValueArgument it = (ResolvedValueArgument)element$iv$iv;
                    boolean bl8 = false;
                    List<ValueArgument> list = it.getArguments();
                    Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
                    Iterable list$iv$iv = this.resolveArguments(list, componentType);
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                arguments2 = (List)destination$iv$iv;
                List evaluatedArguments = CollectionsKt.filterNotNull(arguments2);
                Iterable $i$f$flatMap22 = evaluatedArguments;
                object = ConstantValueFactory.INSTANCE;
                constantExpressionEvaluatorVisitor = this;
                boolean $i$f$map = false;
                destination$iv$iv = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    CompileTimeConstant bl8 = (CompileTimeConstant)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl9 = false;
                    collection.add(it.toConstantValue(componentType));
                }
                collection = (List)destination$iv$iv2;
                $this$map$iv = evaluatedArguments;
                bl6 = false;
                bl5 = false;
                bl4 = false;
                bl3 = false;
                object = ((ConstantValueFactory)object).createArrayValue((List<? extends ConstantValue<?>>)collection, returnType);
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl7 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        CompileTimeConstant it = (CompileTimeConstant)element$iv;
                        boolean bl10 = false;
                        if (!it.getUsesVariableAsConstant()) continue;
                        bl7 = true;
                        break block9;
                    }
                    bl7 = false;
                }
            }
            bl2 = bl7;
            $this$any$iv = arguments2;
            $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    CompileTimeConstant it = (CompileTimeConstant)element$iv;
                    boolean bl11 = false;
                    if (!(it == null || it.getUsesNonConstValAsConstant())) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        boolean bl12 = bl;
        return ConstantExpressionEvaluatorVisitor.wrap$default(constantExpressionEvaluatorVisitor, (ConstantValue)object, bl3, bl4, bl5, bl6, bl2, bl12, false, 79, null);
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitClassLiteralExpression(@NotNull KtClassLiteralExpression expression, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        KotlinType kotlinType = this.trace.getType(expression);
        if (kotlinType == null) {
            return null;
        }
        KotlinType kClassType = kotlinType;
        if (KotlinTypeKt.isError(kClassType)) {
            return null;
        }
        ClassifierDescriptor descriptor2 = kClassType.getConstructor().getDeclarationDescriptor();
        if (!(descriptor2 instanceof ClassDescriptor) || !KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
            return null;
        }
        Object object = CollectionsKt.singleOrNull(kClassType.getArguments());
        if (object == null || (object = object.getType()) == null) {
            return null;
        }
        Object type2 = object;
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitTypeParametersInClassLiteralsInAnnotationArguments) && ConstantExpressionEvaluator.Companion.isTypeParameterOrArrayOfTypeParameter$frontend((KotlinType)type2)) {
            return null;
        }
        ConstantValue<?> constantValue = KClassValue.Companion.create((KotlinType)type2);
        return constantValue != null ? ConstantExpressionEvaluatorVisitor.wrap$default(this, constantValue, false, false, false, false, false, false, false, 127, null) : null;
    }

    private final List<CompileTimeConstant<?>> resolveArguments(List<? extends ValueArgument> valueArguments, KotlinType expectedType) {
        ArrayList constants = new ArrayList();
        for (ValueArgument valueArgument : valueArguments) {
            KtExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null) continue;
            constants.add(this.evaluate(argumentExpression, expectedType));
        }
        return constants;
    }

    @Override
    @Nullable
    public CompileTimeConstant<?> visitKtElement(@NotNull KtElement element, @Nullable KotlinType expectedType) {
        Intrinsics.checkNotNullParameter(element, "element");
        return null;
    }

    private final OperationArgument createOperationArgumentForReceiver(ResolvedCall<?> resolvedCall2, KtExpression expression) {
        KotlinType kotlinType = ConstantExpressionEvaluatorKt.access$getReceiverExpressionType(resolvedCall2);
        if (kotlinType == null) {
            return null;
        }
        KotlinType receiverExpressionType = kotlinType;
        CompileTimeType compileTimeType = this.getCompileTimeType(receiverExpressionType);
        if (compileTimeType == null) {
            return null;
        }
        CompileTimeType receiverCompileTimeType = compileTimeType;
        return this.createOperationArgument(expression, receiverExpressionType, receiverCompileTimeType);
    }

    private final OperationArgument createOperationArgumentForFirstParameter(ResolvedValueArgument argument, ValueParameterDescriptor parameter) {
        KotlinType kotlinType = parameter.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType, "getType(...)");
        CompileTimeType compileTimeType = this.getCompileTimeType(kotlinType);
        if (compileTimeType == null) {
            return null;
        }
        CompileTimeType argumentCompileTimeType = compileTimeType;
        List<ValueArgument> list = argument.getArguments();
        Intrinsics.checkNotNullExpressionValue(list, "getArguments(...)");
        List<ValueArgument> arguments2 = list;
        if (arguments2.size() != 1) {
            return null;
        }
        KtExpression ktExpression = CollectionsKt.first(arguments2).getArgumentExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression argumentExpression = ktExpression;
        KotlinType kotlinType2 = parameter.getType();
        Intrinsics.checkNotNullExpressionValue(kotlinType2, "getType(...)");
        return this.createOperationArgument(argumentExpression, kotlinType2, argumentCompileTimeType);
    }

    private final CompileTimeType getCompileTimeType(KotlinType c) {
        KotlinType kotlinType = TypeUtils.makeNotNullable(c);
        return Intrinsics.areEqual(kotlinType, this.builtIns.getIntType()) ? CompileTimeType.INT : (Intrinsics.areEqual(kotlinType, this.builtIns.getByteType()) ? CompileTimeType.BYTE : (Intrinsics.areEqual(kotlinType, this.builtIns.getShortType()) ? CompileTimeType.SHORT : (Intrinsics.areEqual(kotlinType, this.builtIns.getLongType()) ? CompileTimeType.LONG : (Intrinsics.areEqual(kotlinType, this.builtIns.getDoubleType()) ? CompileTimeType.DOUBLE : (Intrinsics.areEqual(kotlinType, this.builtIns.getFloatType()) ? CompileTimeType.FLOAT : (Intrinsics.areEqual(kotlinType, this.builtIns.getCharType()) ? CompileTimeType.CHAR : (Intrinsics.areEqual(kotlinType, this.builtIns.getBooleanType()) ? CompileTimeType.BOOLEAN : (Intrinsics.areEqual(kotlinType, this.builtIns.getStringType()) ? CompileTimeType.STRING : (Intrinsics.areEqual(kotlinType, this.builtIns.getAnyType()) ? CompileTimeType.ANY : null)))))))));
    }

    private final OperationArgument createOperationArgument(KtExpression expression, KotlinType parameterType, CompileTimeType compileTimeType) {
        CompileTimeConstant<?> compileTimeConstant = this.constantExpressionEvaluator.evaluateExpression(expression, this.trace, parameterType);
        if (compileTimeConstant == null) {
            return null;
        }
        CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
        if (compileTimeConstant2 instanceof TypedCompileTimeConstant && !TypeUtilsKt.isSubtypeOf(((TypedCompileTimeConstant)compileTimeConstant2).getType(), parameterType)) {
            return null;
        }
        ConstantValue<?> constantValue = compileTimeConstant2.toConstantValue(parameterType);
        Object object = compileTimeType == CompileTimeType.ANY ? constantValue.boxedValue() : constantValue.getValue();
        if (object == null) {
            return null;
        }
        Object evaluationResult = object;
        return new OperationArgument(evaluationResult, compileTimeType, expression);
    }

    private final CompileTimeConstant<?> createConstant(Object value2, KotlinType expectedType, CompileTimeConstant.Parameters parameters2) {
        if (parameters2.isPure() || parameters2.isUnsignedNumberLiteral()) {
            KotlinType kotlinType = expectedType;
            if (kotlinType == null) {
                SimpleType simpleType2 = TypeUtils.NO_EXPECTED_TYPE;
                Intrinsics.checkNotNullExpressionValue(simpleType2, "NO_EXPECTED_TYPE");
                kotlinType = simpleType2;
            }
            return this.createCompileTimeConstant(value2, parameters2, kotlinType);
        }
        ConstantValue constantValue = ConstantValueFactory.createConstantValue$default(ConstantValueFactory.INSTANCE, value2, null, 2, null);
        return constantValue != null ? this.wrap(constantValue, parameters2) : null;
    }

    private final CompileTimeConstant<?> createCompileTimeConstant(Object value2, CompileTimeConstant.Parameters parameters2, KotlinType expectedType) {
        CompileTimeConstant compileTimeConstant;
        Object object = value2;
        if (object instanceof Byte || object instanceof Short || object instanceof Integer || object instanceof Long) {
            Intrinsics.checkNotNull(value2, "null cannot be cast to non-null type kotlin.Number");
            compileTimeConstant = this.createIntegerCompileTimeConstant(((Number)value2).longValue(), parameters2, expectedType);
        } else {
            ConstantValue constantValue = ConstantValueFactory.createConstantValue$default(ConstantValueFactory.INSTANCE, value2, null, 2, null);
            compileTimeConstant = constantValue != null ? this.wrap(constantValue, parameters2) : null;
        }
        return compileTimeConstant;
    }

    private final CompileTimeConstant<?> createIntegerCompileTimeConstant(long value2, CompileTimeConstant.Parameters parameters2, KotlinType expectedType) {
        if (parameters2.isUnsignedNumberLiteral() && !this.checkAccessibilityOfUnsignedTypes()) {
            return new UnsignedErrorValueTypeConstant(value2, this.constantExpressionEvaluator.getModule$frontend(), parameters2);
        }
        if (parameters2.isUnsignedLongNumberLiteral()) {
            return this.wrap(new ULongValue(value2), parameters2);
        }
        if (TypeUtils.noExpectedType(expectedType) || KotlinTypeKt.isError(expectedType)) {
            return CompileTimeConstantKt.createIntegerValueTypeConstant(value2, this.constantExpressionEvaluator.getModule$frontend(), parameters2, this.languageVersionSettings.supportsFeature(LanguageFeature.NewInference));
        }
        ConstantValue<?> integerValue = ConstantValueFactory.INSTANCE.createIntegerConstantValue(value2, expectedType, parameters2.isUnsignedNumberLiteral());
        if (integerValue != null) {
            return this.wrap(integerValue, parameters2);
        }
        return this.createSimpleIntCompileTimeConst(value2, parameters2);
    }

    private final TypedCompileTimeConstant<?> createSimpleIntCompileTimeConst(long $this$createSimpleIntCompileTimeConst, CompileTimeConstant.Parameters parameters2) {
        long value2 = $this$createSimpleIntCompileTimeConst;
        return this.wrap(parameters2.isUnsignedNumberLiteral() ? (ConstantValue)(value2 == ConstantValueFactoryKt.fromUIntToLong((int)value2) ? (UnsignedValueConstant)new UIntValue((int)value2) : (UnsignedValueConstant)new ULongValue(value2)) : (ConstantValue)(value2 == (long)((int)value2) ? (IntegerValueConstant)new IntValue((int)value2) : (IntegerValueConstant)new LongValue(value2)), parameters2);
    }

    private final boolean checkAccessibilityOfUnsignedTypes() {
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(this.constantExpressionEvaluator.getModule$frontend(), StandardNames.FqNames.uInt);
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor uInt = classDescriptor;
        SinceKotlinAccessibility accessibility = SinceKotlinUtilKt.checkSinceKotlinVersionAccessibility(uInt, this.languageVersionSettings);
        return !(accessibility instanceof SinceKotlinAccessibility.NotAccessible);
    }

    private final <T> TypedCompileTimeConstant<T> wrap(ConstantValue<? extends T> $this$wrap, CompileTimeConstant.Parameters parameters2) {
        return new TypedCompileTimeConstant<T>($this$wrap, this.constantExpressionEvaluator.getModule$frontend(), parameters2);
    }

    private final <T> TypedCompileTimeConstant<T> wrap(ConstantValue<? extends T> $this$wrap, boolean canBeUsedInAnnotation, boolean isPure, boolean isUnsigned, boolean isUnsignedLong, boolean usesVariableAsConstant, boolean usesNonConstValAsConstant, boolean isConvertableConstVal) {
        return this.wrap($this$wrap, new CompileTimeConstant.Parameters(canBeUsedInAnnotation, isPure, isUnsigned, isUnsignedLong, usesVariableAsConstant, usesNonConstValAsConstant, isConvertableConstVal));
    }

    static /* synthetic */ TypedCompileTimeConstant wrap$default(ConstantExpressionEvaluatorVisitor constantExpressionEvaluatorVisitor, ConstantValue constantValue, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, Object object) {
        if ((n & 1) != 0) {
            boolean bl8 = bl = !(constantValue instanceof NullValue);
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            bl4 = false;
        }
        if ((n & 0x10) != 0) {
            bl5 = false;
        }
        if ((n & 0x20) != 0) {
            bl6 = false;
        }
        if ((n & 0x40) != 0) {
            bl7 = false;
        }
        return constantExpressionEvaluatorVisitor.wrap(constantValue, bl, bl2, bl3, bl4, bl5, bl6, bl7);
    }

    private static final Unit evaluateUnaryAndCheck$lambda$0(ConstantExpressionEvaluatorVisitor this$0, KtExpression $callExpression) {
        BindingTrace bindingTrace = this$0.trace;
        PsiElement $this$getStrictParentOfType$iv = $callExpression;
        boolean $i$f$getStrictParentOfType = false;
        KtExpression ktExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtExpression.class, true);
        if (ktExpression == null) {
            ktExpression = $callExpression;
        }
        bindingTrace.report(Errors.INTEGER_OVERFLOW.on((KtExpression)((PsiElement)ktExpression)));
        return Unit.INSTANCE;
    }

    private static final Unit evaluateBinaryAndCheck$lambda$1(ConstantExpressionEvaluatorVisitor this$0, KtExpression $callExpression) {
        BindingTrace bindingTrace = this$0.trace;
        PsiElement $this$getStrictParentOfType$iv = $callExpression;
        boolean $i$f$getStrictParentOfType = false;
        KtExpression ktExpression = PsiTreeUtil.getParentOfType($this$getStrictParentOfType$iv, KtExpression.class, true);
        if (ktExpression == null) {
            ktExpression = $callExpression;
        }
        bindingTrace.report(Errors.INTEGER_OVERFLOW.on((KtExpression)((PsiElement)ktExpression)));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ TypedCompileTimeConstant access$wrap(ConstantExpressionEvaluatorVisitor $this, ConstantValue $receiver, CompileTimeConstant.Parameters parameters2) {
        return $this.wrap($receiver, parameters2);
    }

    public static final /* synthetic */ KotlinBuiltIns access$getBuiltIns$p(ConstantExpressionEvaluatorVisitor $this) {
        return $this.builtIns;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u00018\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0002\u0010\t\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u00038\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\f\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluatorVisitor$OperationArgument;", "", "value", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "ctcType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expression", "<init>", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;Lorg/jetbrains/kotlin/psi/KtExpression;)V", "Ljava/lang/Object;", "getValue", "()Ljava/lang/Object;", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "getCtcType", "()Lorg/jetbrains/kotlin/resolve/constants/evaluate/CompileTimeType;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtExpression;"})
    private static final class OperationArgument {
        @NotNull
        private final Object value;
        @NotNull
        private final CompileTimeType ctcType;
        @NotNull
        private final KtExpression expression;

        public OperationArgument(@NotNull Object value2, @NotNull CompileTimeType ctcType, @NotNull KtExpression expression) {
            Intrinsics.checkNotNullParameter(value2, "value");
            Intrinsics.checkNotNullParameter((Object)ctcType, "ctcType");
            Intrinsics.checkNotNullParameter(expression, "expression");
            this.value = value2;
            this.ctcType = ctcType;
            this.expression = expression;
        }

        @NotNull
        public final Object getValue() {
            return this.value;
        }

        @NotNull
        public final CompileTimeType getCtcType() {
            return this.ctcType;
        }

        @NotNull
        public final KtExpression getExpression() {
            return this.expression;
        }
    }
}

