/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.deprecation;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.MavenComparableVersion;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirement;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0019\u0010\u0004\u001a\u00020\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0005\u001a\u0019\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\t\u0010\n"}, d2={"Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "", "isFulfilled", "(Lorg/jetbrains/kotlin/metadata/deserialization/VersionRequirement;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)Z", "", "version", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "createVersion", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/config/MavenComparableVersion;"})
public final class CommonDeprecationUtilsKt {
    public static final boolean isFulfilled(@NotNull VersionRequirement $this$isFulfilled, @NotNull LanguageVersionSettings languageVersionSettings) {
        MavenComparableVersion mavenComparableVersion;
        Intrinsics.checkNotNullParameter($this$isFulfilled, "<this>");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        MavenComparableVersion requiredVersion = CommonDeprecationUtilsKt.createVersion($this$isFulfilled.getVersion().asString());
        switch (WhenMappings.$EnumSwitchMapping$0[$this$isFulfilled.getKind().ordinal()]) {
            case 1: {
                mavenComparableVersion = new MavenComparableVersion(languageVersionSettings.getLanguageVersion().getVersionString());
                break;
            }
            case 2: {
                mavenComparableVersion = languageVersionSettings.getApiVersion().getVersion();
                break;
            }
            case 3: {
                String string2 = KotlinCompilerVersion.getVersion();
                if (string2 != null && (string2 = StringsKt.substringBefore$default(string2, '-', null, 2, null)) != null) {
                    String p0 = string2;
                    boolean bl = false;
                    mavenComparableVersion = CommonDeprecationUtilsKt.createVersion(p0);
                    break;
                }
                mavenComparableVersion = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        MavenComparableVersion currentVersion = mavenComparableVersion;
        return currentVersion == null || currentVersion.compareTo(requiredVersion) >= 0;
    }

    private static final MavenComparableVersion createVersion(String version) {
        MavenComparableVersion mavenComparableVersion;
        try {
            mavenComparableVersion = new MavenComparableVersion(version);
        }
        catch (Exception e) {
            mavenComparableVersion = null;
        }
        return mavenComparableVersion;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProtoBuf.VersionRequirement.VersionKind.values().length];
            try {
                nArray[ProtoBuf.VersionRequirement.VersionKind.LANGUAGE_VERSION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.VersionRequirement.VersionKind.API_VERSION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProtoBuf.VersionRequirement.VersionKind.COMPILER_VERSION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

