/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.deprecation;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.BuiltInAnnotationDescriptor;
import org.jetbrains.kotlin.resolve.annotations.UtilsKt;
import org.jetbrains.kotlin.resolve.constants.AnnotationValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.EnumValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationUtilKt;
import org.jetbrains.kotlin.resolve.deprecation.DescriptorBasedDeprecationInfo;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b0\u0018\u0000 \u001b2\u00020\u0001:\u0003\u001c\u001d\u001bB+\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001a\u0010\u0005\u001a\u00020\u00048\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u0011\u001a\u0004\b\u0014\u0010\u0013R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00158WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u00158AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\u0082\u0001\u0002\u001e\u001f"}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedByAnnotation;", "Lorg/jetbrains/kotlin/resolve/deprecation/DescriptorBasedDeprecationInfo;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "annotation", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "target", "", "propagatesToOverrides", "forcePropagationToOverrides", "<init>", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;ZZ)V", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "getAnnotation", "()Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getTarget", "()Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "Z", "getPropagatesToOverrides", "()Z", "getForcePropagationToOverrides", "", "getMessage", "()Ljava/lang/String;", "message", "getReplaceWithValue$frontend", "replaceWithValue", "Companion", "StandardDeprecated", "DeprecatedSince", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedByAnnotation$DeprecatedSince;", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedByAnnotation$StandardDeprecated;"})
public abstract class DeprecatedByAnnotation
extends DescriptorBasedDeprecationInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnnotationDescriptor annotation;
    @NotNull
    private final DeclarationDescriptor target;
    private final boolean propagatesToOverrides;
    private final boolean forcePropagationToOverrides;

    private DeprecatedByAnnotation(AnnotationDescriptor annotation, DeclarationDescriptor target, boolean propagatesToOverrides, boolean forcePropagationToOverrides) {
        this.annotation = annotation;
        this.target = target;
        this.propagatesToOverrides = propagatesToOverrides;
        this.forcePropagationToOverrides = forcePropagationToOverrides;
        if (!(!this.forcePropagationToOverrides || this.propagatesToOverrides)) {
            boolean bl = false;
            String string2 = "if something is `forcePropagationToOverrides`, it's expected that `propagatesToOverrides` == true, too";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public /* synthetic */ DeprecatedByAnnotation(AnnotationDescriptor annotationDescriptor, DeclarationDescriptor declarationDescriptor, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl2 = false;
        }
        this(annotationDescriptor, declarationDescriptor, bl, bl2, null);
    }

    @NotNull
    public final AnnotationDescriptor getAnnotation() {
        return this.annotation;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getTarget() {
        return this.target;
    }

    @Override
    public final boolean getPropagatesToOverrides() {
        return this.propagatesToOverrides;
    }

    @Override
    public final boolean getForcePropagationToOverrides() {
        return this.forcePropagationToOverrides;
    }

    @Override
    @Nullable
    public String getMessage() {
        ConstantValue<?> constantValue = UtilsKt.argumentValue(this.annotation, "message");
        StringValue stringValue = constantValue instanceof StringValue ? (StringValue)constantValue : null;
        return stringValue != null ? (String)stringValue.getValue() : null;
    }

    @Nullable
    public final String getReplaceWithValue$frontend() {
        AnnotationDescriptor replaceWithAnnotation2;
        ConstantValue<?> constantValue = UtilsKt.argumentValue(this.annotation, "replaceWith");
        AnnotationValue annotationValue = constantValue instanceof AnnotationValue ? (AnnotationValue)constantValue : null;
        AnnotationDescriptor annotationDescriptor = replaceWithAnnotation2 = annotationValue != null ? (AnnotationDescriptor)annotationValue.getValue() : null;
        constantValue = annotationDescriptor != null ? UtilsKt.argumentValue(annotationDescriptor, "expression") : null;
        StringValue stringValue = constantValue instanceof StringValue ? (StringValue)constantValue : null;
        return stringValue != null ? (String)stringValue.getValue() : null;
    }

    public /* synthetic */ DeprecatedByAnnotation(AnnotationDescriptor annotation, DeclarationDescriptor target, boolean propagatesToOverrides, boolean forcePropagationToOverrides, DefaultConstructorMarker $constructor_marker) {
        this(annotation, target, propagatesToOverrides, forcePropagationToOverrides);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J;\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000f"}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedByAnnotation$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "deprecatedAnnotation", "deprecatedSinceKotlinAnnotation", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "target", "", "propagatesToOverrides", "Lorg/jetbrains/kotlin/config/ApiVersion;", "apiVersion", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedByAnnotation;", "create", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;ZLorg/jetbrains/kotlin/config/ApiVersion;)Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedByAnnotation;"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DeprecatedByAnnotation create(@NotNull AnnotationDescriptor deprecatedAnnotation, @Nullable AnnotationDescriptor deprecatedSinceKotlinAnnotation, @NotNull DeclarationDescriptor target, boolean propagatesToOverrides, @NotNull ApiVersion apiVersion) {
            Intrinsics.checkNotNullParameter(deprecatedAnnotation, "deprecatedAnnotation");
            Intrinsics.checkNotNullParameter(target, "target");
            Intrinsics.checkNotNullParameter(apiVersion, "apiVersion");
            if (deprecatedSinceKotlinAnnotation != null) {
                DeprecationLevelValue deprecationLevelValue = DeprecationUtilKt.computeLevelForDeprecatedSinceKotlin(deprecatedSinceKotlinAnnotation, apiVersion);
                if (deprecationLevelValue == null) {
                    return null;
                }
                DeprecationLevelValue level = deprecationLevelValue;
                return new DeprecatedSince(deprecatedAnnotation, target, propagatesToOverrides, level);
            }
            BuiltInAnnotationDescriptor builtInAnnotationDescriptor = deprecatedAnnotation instanceof BuiltInAnnotationDescriptor ? (BuiltInAnnotationDescriptor)deprecatedAnnotation : null;
            boolean forcePropagationToOverrides = builtInAnnotationDescriptor != null ? builtInAnnotationDescriptor.getForcePropagationDeprecationToOverrides() : false;
            return new StandardDeprecated(deprecatedAnnotation, target, propagatesToOverrides || forcePropagationToOverrides, forcePropagationToOverrides);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0096\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\t\u001a\u00020\b8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedByAnnotation$DeprecatedSince;", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedByAnnotation;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "annotation", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "target", "", "propagatesToOverrides", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "deprecationLevel", "<init>", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;ZLorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;)V", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "getDeprecationLevel", "()Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;"})
    public static final class DeprecatedSince
    extends DeprecatedByAnnotation {
        @NotNull
        private final DeprecationLevelValue deprecationLevel;

        public DeprecatedSince(@NotNull AnnotationDescriptor annotation, @NotNull DeclarationDescriptor target, boolean propagatesToOverrides, @NotNull DeprecationLevelValue deprecationLevel) {
            Intrinsics.checkNotNullParameter(annotation, "annotation");
            Intrinsics.checkNotNullParameter(target, "target");
            Intrinsics.checkNotNullParameter((Object)deprecationLevel, "deprecationLevel");
            super(annotation, target, propagatesToOverrides, false, 8, null);
            this.deprecationLevel = deprecationLevel;
        }

        @Override
        @NotNull
        public DeprecationLevelValue getDeprecationLevel() {
            return this.deprecationLevel;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DeprecatedSince)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.getAnnotation(), ((DeprecatedSince)other).getAnnotation())) {
                return false;
            }
            if (!Intrinsics.areEqual(this.getTarget(), ((DeprecatedSince)other).getTarget())) {
                return false;
            }
            if (this.getPropagatesToOverrides() != ((DeprecatedSince)other).getPropagatesToOverrides()) {
                return false;
            }
            return this.getDeprecationLevel() == ((DeprecatedSince)other).getDeprecationLevel();
        }

        public int hashCode() {
            int hash = this.getAnnotation().hashCode();
            hash = hash * 31 + this.getTarget().hashCode();
            hash = hash * 31 + Boolean.hashCode(this.getPropagatesToOverrides());
            hash = hash * 31 + this.getDeprecationLevel().hashCode();
            return hash;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001a\u0010\r\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\u00128WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedByAnnotation$StandardDeprecated;", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecatedByAnnotation;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "annotation", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "target", "", "propagatesToOverrides", "forcePropagationToOverrides", "<init>", "(Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;ZZ)V", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "getDeprecationLevel", "()Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationLevelValue;", "deprecationLevel"})
    public static final class StandardDeprecated
    extends DeprecatedByAnnotation {
        public StandardDeprecated(@NotNull AnnotationDescriptor annotation, @NotNull DeclarationDescriptor target, boolean propagatesToOverrides, boolean forcePropagationToOverrides) {
            Intrinsics.checkNotNullParameter(annotation, "annotation");
            Intrinsics.checkNotNullParameter(target, "target");
            super(annotation, target, propagatesToOverrides, forcePropagationToOverrides, null);
        }

        public /* synthetic */ StandardDeprecated(AnnotationDescriptor annotationDescriptor, DeclarationDescriptor declarationDescriptor, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl2 = false;
            }
            this(annotationDescriptor, declarationDescriptor, bl, bl2);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @NotNull
        public DeprecationLevelValue getDeprecationLevel() {
            block8: {
                block6: {
                    block7: {
                        var2_1 = UtilsKt.argumentValue(this.getAnnotation(), "level");
                        v0 = var2_1 instanceof EnumValue != false ? (EnumValue)var2_1 : null;
                        v1 = v0 != null && (v0 = v0.getEnumEntryName()) != null ? v0.asString() : (var1_2 = null);
                        if (var1_2 == null) break block6;
                        switch (var1_2.hashCode()) {
                            case 66247144: {
                                if (var1_2.equals("ERROR")) break;
                                ** break;
                            }
                            case 2130809258: {
                                if (!var1_2.equals("HIDDEN")) {
                                    ** break;
                                }
                                break block7;
                            }
                            case 1842428796: {
                                if (!var1_2.equals("WARNING")) ** break;
                                v2 = DeprecationLevelValue.WARNING;
                                break block8;
                            }
                        }
                        v2 = DeprecationLevelValue.ERROR;
                        break block8;
                    }
                    v2 = DeprecationLevelValue.HIDDEN;
                    break block8;
                }
                v2 = DeprecationLevelValue.WARNING;
            }
            return v2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StandardDeprecated)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.getAnnotation(), ((StandardDeprecated)other).getAnnotation())) {
                return false;
            }
            if (!Intrinsics.areEqual(this.getTarget(), ((StandardDeprecated)other).getTarget())) {
                return false;
            }
            return this.getPropagatesToOverrides() == ((StandardDeprecated)other).getPropagatesToOverrides();
        }

        public int hashCode() {
            int hash = this.getAnnotation().hashCode();
            hash = hash * 31 + this.getTarget().hashCode();
            hash = hash * 31 + Boolean.hashCode(this.getPropagatesToOverrides());
            return hash;
        }
    }
}

