/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.AbstractKotlinSuppressCache;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticSuppressor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002.-B\u0011\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u000e\u001a\u00020\u0002H'\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u000e\u001a\u00020\u0002H\u0015\u00a2\u0006\u0004\b\u0015\u0010\u0016J%\u0010\u001b\u001a\u00020\u001a2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00172\u0006\u0010\u0019\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001f\u001a\u00020\u000b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0014\u00a2\u0006\u0004\b\u001f\u0010 J)\u0010$\u001a\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u000bH\u0015\u00a2\u0006\u0004\b$\u0010%R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010'R&\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u000b0(8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache;", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/project/Project;", "project", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "Lorg/jetbrains/kotlin/resolve/diagnostics/DiagnosticSuppressor;", "suppressor", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "diagnostic", "", "isSuppressedByExtension", "(Lorg/jetbrains/kotlin/resolve/diagnostics/DiagnosticSuppressor;Lorg/jetbrains/kotlin/diagnostics/Diagnostic;)Z", "annotated", "", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "getSuppressionAnnotations", "(Lcom/intellij/psi/PsiElement;)Ljava/util/List;", "", "", "getSuppressingStrings", "(Lcom/intellij/psi/PsiElement;)Ljava/util/Set;", "Lcom/google/common/collect/ImmutableSet$Builder;", "builder", "annotationDescriptor", "", "processAnnotation", "(Lcom/google/common/collect/ImmutableSet$Builder;Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;)V", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$SuppressRequest;", "request", "isSuppressed", "(Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$SuppressRequest;)Z", "element", "rootElement", "excludeSelf", "getClosestAnnotatedAncestorElement", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiElement;Z)Lcom/intellij/psi/PsiElement;", "diagnosticSuppressors", "Ljava/util/List;", "Lkotlin/Function1;", "filter", "Lkotlin/jvm/functions/Function1;", "getFilter", "()Lkotlin/jvm/functions/Function1;", "Companion", "DiagnosticSuppressRequest"})
public abstract class KotlinSuppressCache
extends AbstractKotlinSuppressCache<PsiElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<DiagnosticSuppressor> diagnosticSuppressors;
    @NotNull
    private final Function1<Diagnostic, Boolean> filter;

    /*
     * WARNING - void declaration
     */
    public KotlinSuppressCache(@Nullable Project project) {
        Object object;
        block3: {
            block2: {
                void it;
                KotlinSuppressCache kotlinSuppressCache = this;
                object = project;
                if (object == null) break block2;
                Project project2 = object;
                KotlinSuppressCache kotlinSuppressCache2 = kotlinSuppressCache;
                boolean bl = false;
                List list = DiagnosticSuppressor.Companion.getInstances((Project)it);
                kotlinSuppressCache = kotlinSuppressCache2;
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        kotlinSuppressCache.diagnosticSuppressors = object;
        this.filter = arg_0 -> KotlinSuppressCache.filter$lambda$1(this, arg_0);
    }

    @NotNull
    public final Function1<Diagnostic, Boolean> getFilter() {
        return this.filter;
    }

    protected boolean isSuppressedByExtension(@NotNull DiagnosticSuppressor suppressor, @NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter(suppressor, "suppressor");
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        return suppressor.isSuppressed(diagnostic);
    }

    @NotNull
    public abstract List<AnnotationDescriptor> getSuppressionAnnotations(@NotNull PsiElement var1);

    @Override
    @NotNull
    protected Set<String> getSuppressingStrings(@NotNull PsiElement annotated) {
        Intrinsics.checkNotNullParameter(annotated, "annotated");
        ImmutableSet.Builder<String> builder2 = ImmutableSet.builder();
        for (AnnotationDescriptor annotationDescriptor : this.getSuppressionAnnotations(annotated)) {
            Intrinsics.checkNotNull(builder2);
            this.processAnnotation(builder2, annotationDescriptor);
        }
        ImmutableCollection immutableCollection = builder2.build();
        Intrinsics.checkNotNullExpressionValue(immutableCollection, "build(...)");
        return (Set)((Object)immutableCollection);
    }

    private final void processAnnotation(ImmutableSet.Builder<String> builder2, AnnotationDescriptor annotationDescriptor) {
        if (!Intrinsics.areEqual(annotationDescriptor.getFqName(), StandardNames.FqNames.suppress)) {
            return;
        }
        for (ConstantValue<?> arrayValue : annotationDescriptor.getAllValueArguments().values()) {
            if (!(arrayValue instanceof ArrayValue)) continue;
            for (ConstantValue value2 : (List)((ArrayValue)arrayValue).getValue()) {
                if (!(value2 instanceof StringValue)) continue;
                String string2 = ((String)((StringValue)value2).getValue()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
                builder2.add((Object)string2);
            }
        }
    }

    @Override
    protected boolean isSuppressed(@NotNull AbstractKotlinSuppressCache.SuppressRequest<PsiElement> request) {
        Intrinsics.checkNotNullParameter(request, "request");
        PsiElement element = request.getElement();
        if (!element.isValid()) {
            return true;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 instanceof KtFile && KtPsiFactoryKt.getDoNotAnalyze((KtFile)file2) != null) {
            return true;
        }
        if (request instanceof DiagnosticSuppressRequest) {
            for (DiagnosticSuppressor suppressor : this.diagnosticSuppressors) {
                if (!this.isSuppressedByExtension(suppressor, ((DiagnosticSuppressRequest)request).getDiagnostic())) continue;
                return true;
            }
        }
        return super.isSuppressed(request);
    }

    @Override
    @Nullable
    protected PsiElement getClosestAnnotatedAncestorElement(@NotNull PsiElement element, @NotNull PsiElement rootElement, boolean excludeSelf) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(rootElement, "rootElement");
        return KtStubbedPsiUtil.getPsiOrStubParent(element, KtAnnotated.class, excludeSelf);
    }

    private static final boolean filter$lambda$1(KotlinSuppressCache this$0, Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
        return !this$0.isSuppressed(new DiagnosticSuppressRequest(diagnostic));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\t\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0001\u00a2\u0006\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "diagnostic", "", "getDiagnosticSuppressKey$frontend", "(Lorg/jetbrains/kotlin/diagnostics/Diagnostic;)Ljava/lang/String;", "getDiagnosticSuppressKey"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDiagnosticSuppressKey$frontend(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
            String string2 = diagnostic.getFactory().getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0004\u001a\u00020\u00038\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0007\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\u00028WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u00028WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u0012\u001a\u00020\u000f8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u00138WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$DiagnosticSuppressRequest;", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$SuppressRequest;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "diagnostic", "<init>", "(Lorg/jetbrains/kotlin/diagnostics/Diagnostic;)V", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getDiagnostic", "()Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getElement", "()Lcom/intellij/psi/PsiElement;", "element", "getRootElement", "rootElement", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "severity", "", "getSuppressKey", "()Ljava/lang/String;", "suppressKey"})
    protected static final class DiagnosticSuppressRequest
    implements AbstractKotlinSuppressCache.SuppressRequest<PsiElement> {
        @NotNull
        private final Diagnostic diagnostic;

        public DiagnosticSuppressRequest(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
            this.diagnostic = diagnostic;
        }

        @NotNull
        public final Diagnostic getDiagnostic() {
            return this.diagnostic;
        }

        @Override
        @NotNull
        public PsiElement getElement() {
            return this.diagnostic.getPsiElement();
        }

        @Override
        @NotNull
        public PsiElement getRootElement() {
            PsiFile psiFile = this.getElement().getContainingFile();
            Intrinsics.checkNotNullExpressionValue(psiFile, "getContainingFile(...)");
            return psiFile;
        }

        @Override
        @NotNull
        public Severity getSeverity() {
            return this.diagnostic.getSeverity();
        }

        @Override
        @NotNull
        public String getSuppressKey() {
            return Companion.getDiagnosticSuppressKey$frontend(this.diagnostic);
        }
    }
}

