/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.inline;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.coroutines.CoroutineUtilKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.AnalyzerExtensions;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.KtDescriptorUtilKt;
import org.jetbrains.kotlin.resolve.calls.components.ArgumentsUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineOnlyKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.inline.ReasonableInlineRule;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J'\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ'\u0010!\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b!\u0010\u0011J'\u0010\"\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\"\u0010\u0019J1\u0010)\u001a\u00020(2\u0006\u0010$\u001a\u00020#2\u0006\u0010&\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020'2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0004\b)\u0010*R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010+R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010,"}, d2={"Lorg/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension;", "Lorg/jetbrains/kotlin/resolve/AnalyzerExtensions$AnalyzerExtension;", "", "Lorg/jetbrains/kotlin/resolve/inline/ReasonableInlineRule;", "reasonableInlineRules", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "<init>", "(Ljava/lang/Iterable;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "functionOrProperty", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "trace", "", "process", "(Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "notSupportedInInlineCheck", "(Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "functionDescriptor", "Lorg/jetbrains/kotlin/psi/KtFunction;", "function", "checkDefaults", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;Lorg/jetbrains/kotlin/psi/KtFunction;Lorg/jetbrains/kotlin/resolve/BindingTrace;)V", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "parameterDescriptor", "Lorg/jetbrains/kotlin/psi/KtParameter;", "ktParameter", "checkDefaultValue", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;Lorg/jetbrains/kotlin/psi/KtParameter;)V", "callableDescriptor", "checkModalityAndOverrides", "checkHasInlinableAndNullability", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "parameter", "Lorg/jetbrains/kotlin/psi/KtElement;", "expression", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "", "checkInlinableParameter", "(Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lorg/jetbrains/kotlin/resolve/BindingTrace;)Z", "Ljava/lang/Iterable;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;"})
public final class InlineAnalyzerExtension
implements AnalyzerExtensions.AnalyzerExtension {
    @NotNull
    private final Iterable<ReasonableInlineRule> reasonableInlineRules;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public InlineAnalyzerExtension(@NotNull Iterable<? extends ReasonableInlineRule> reasonableInlineRules, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(reasonableInlineRules, "reasonableInlineRules");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.reasonableInlineRules = reasonableInlineRules;
        this.languageVersionSettings = languageVersionSettings;
    }

    @Override
    public void process(@NotNull CallableMemberDescriptor descriptor2, @NotNull KtCallableDeclaration functionOrProperty, @NotNull BindingTrace trace) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(functionOrProperty, "functionOrProperty");
        Intrinsics.checkNotNullParameter(trace, "trace");
        this.checkModalityAndOverrides(descriptor2, functionOrProperty, trace);
        this.notSupportedInInlineCheck(functionOrProperty, trace);
        if (descriptor2 instanceof FunctionDescriptor) {
            boolean bl = functionOrProperty instanceof KtNamedFunction;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-InlineAnalyzerExtension$process$42 = false;
                String $i$a$-assert-InlineAnalyzerExtension$process$42 = "Function descriptor " + descriptor2 + " should have corresponded KtNamedFunction, but has " + functionOrProperty;
                throw new AssertionError((Object)$i$a$-assert-InlineAnalyzerExtension$process$42);
            }
            this.checkDefaults((FunctionDescriptor)descriptor2, (KtNamedFunction)functionOrProperty, trace);
            this.checkHasInlinableAndNullability((FunctionDescriptor)descriptor2, (KtFunction)functionOrProperty, trace);
        } else {
            boolean bl = descriptor2 instanceof PropertyDescriptor;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-InlineAnalyzerExtension$process$52 = false;
                String $i$a$-assert-InlineAnalyzerExtension$process$52 = "PropertyDescriptor expected, but was " + descriptor2;
                throw new AssertionError((Object)$i$a$-assert-InlineAnalyzerExtension$process$52);
            }
            bl = functionOrProperty instanceof KtProperty;
            if (_Assertions.ENABLED && !bl) {
                boolean bl2 = false;
                String string2 = "Property descriptor " + descriptor2 + " should have corresponded KtProperty, but has " + functionOrProperty;
                throw new AssertionError((Object)string2);
            }
            boolean hasBackingField = Intrinsics.areEqual(trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)descriptor2), true);
            if (hasBackingField || ((KtProperty)functionOrProperty).getDelegateExpression() != null) {
                trace.report(Errors.INLINE_PROPERTY_WITH_BACKING_FIELD.on((KtDeclaration)((PsiElement)functionOrProperty)));
            }
        }
    }

    private final void notSupportedInInlineCheck(KtCallableDeclaration functionOrProperty, BindingTrace trace) {
        KtVisitorVoid visitor2 = new KtVisitorVoid(trace){
            final /* synthetic */ BindingTrace $trace;
            {
                this.$trace = $trace;
            }

            public void visitKtElement(KtElement element) {
                Intrinsics.checkNotNullParameter(element, "element");
                super.visitKtElement(element);
                element.acceptChildren(this);
            }

            public void visitClass(KtClass klass) {
                Intrinsics.checkNotNullParameter(klass, "klass");
                this.$trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtDeclaration)((PsiElement)klass), "Local classes"));
            }

            public void visitNamedFunction(KtNamedFunction function2) {
                Intrinsics.checkNotNullParameter(function2, "function");
                if (function2.getParent().getParent() instanceof KtObjectDeclaration) {
                    super.visitNamedFunction(function2);
                } else {
                    this.$trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtDeclaration)((PsiElement)function2), "Local functions"));
                }
            }
        };
        functionOrProperty.acceptChildren(visitor2);
    }

    private final void checkDefaults(FunctionDescriptor functionDescriptor, KtFunction function2, BindingTrace trace) {
        List<KtParameter> list = function2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
        List<KtParameter> ktParameters = list;
        for (ValueParameterDescriptor parameter : functionDescriptor.getValueParameters()) {
            Intrinsics.checkNotNull(parameter);
            if (!ArgumentsUtilsKt.hasDefaultValue(parameter)) continue;
            KtParameter ktParameter = ktParameters.get(parameter.getIndex());
            boolean inheritsDefaultValue = !parameter.declaresDefaultValue() && DescriptorUtilsKt.declaresOrInheritsDefaultValue(parameter);
            ParameterDescriptor parameterDescriptor = parameter;
            Intrinsics.checkNotNull(ktParameter);
            if (this.checkInlinableParameter(parameterDescriptor, ktParameter, functionDescriptor, null) || inheritsDefaultValue) {
                if (inheritsDefaultValue || !this.languageVersionSettings.supportsFeature(LanguageFeature.InlineDefaultFunctionalParameters)) {
                    trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtDeclaration)((PsiElement)ktParameter), "Functional parameters with inherited default values"));
                } else {
                    this.checkDefaultValue(trace, parameter, ktParameter);
                }
            }
            if (!functionDescriptor.isSuspend() || !InlineUtil.isInlineParameterExceptNullability(parameter) || !CoroutineUtilKt.getHasSuspendFunctionType(parameter)) continue;
            trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtDeclaration)((PsiElement)ktParameter), "Suspend functional parameters with default values"));
        }
    }

    private final void checkDefaultValue(BindingTrace trace, ValueParameterDescriptor parameterDescriptor, KtParameter ktParameter) {
        block1: {
            KtExpression ktExpression = ktParameter.getDefaultValue();
            if (ktExpression == null) break block1;
            KtExpression defaultValue = ktExpression;
            boolean bl = false;
            if (!InlineUtil.isInlinableParameterExpression(KtPsiUtil.deparenthesize(defaultValue))) {
                trace.report(Errors.INVALID_DEFAULT_FUNCTIONAL_PARAMETER_FOR_INLINE.on((KtElement)((PsiElement)defaultValue), defaultValue, parameterDescriptor));
            }
        }
    }

    private final void checkModalityAndOverrides(CallableMemberDescriptor callableDescriptor, KtCallableDeclaration functionOrProperty, BindingTrace trace) {
        boolean overridesAnything;
        if (callableDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor) {
            return;
        }
        if (DescriptorVisibilities.isPrivate(callableDescriptor.getVisibility())) {
            return;
        }
        Collection<? extends CallableMemberDescriptor> collection = callableDescriptor.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, "getOverriddenDescriptors(...)");
        boolean bl = overridesAnything = !collection.isEmpty();
        if (overridesAnything) {
            List<KtTypeParameter> list = functionOrProperty.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getTypeParameters(...)");
            List<KtTypeParameter> ktTypeParameters = list;
            for (TypeParameterDescriptor typeParameter : callableDescriptor.getTypeParameters()) {
                if (!typeParameter.isReified()) continue;
                KtTypeParameter ktTypeParameter = ktTypeParameters.get(typeParameter.getIndex());
                PsiElement psiElement = ktTypeParameter.getModifierList();
                if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.REIFIED_KEYWORD)) == null) {
                    psiElement = ktTypeParameter;
                }
                PsiElement reportOn = psiElement;
                trace.report(Errors.REIFIED_TYPE_PARAMETER_IN_OVERRIDE.on(reportOn));
            }
        }
        if (KtDescriptorUtilKt.isEffectivelyFinal(callableDescriptor, true)) {
            if (overridesAnything) {
                trace.report(Errors.OVERRIDE_BY_INLINE.on((KtDeclaration)((PsiElement)functionOrProperty)));
            }
            if (!KtDescriptorUtilKt.isEffectivelyFinal(callableDescriptor, false)) {
                trace.report(Errors.DECLARATION_CANT_BE_INLINED_WARNING.on((KtDeclaration)((PsiElement)functionOrProperty)));
            }
            return;
        }
        trace.report(Errors.DECLARATION_CANT_BE_INLINED.on((KtDeclaration)((PsiElement)functionOrProperty)));
    }

    private final void checkHasInlinableAndNullability(FunctionDescriptor functionDescriptor, KtFunction function2, BindingTrace trace) {
        boolean bl;
        block9: {
            boolean hasInlineArgs = false;
            List<KtParameter> list = function2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
            Iterable iterable = list;
            List<ValueParameterDescriptor> list2 = functionDescriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list2, "getValueParameters(...)");
            Iterable $this$forEach$iv = CollectionsKt.zip(iterable, (Iterable)list2);
            boolean $i$f$forEach = false;
            for (Object t : $this$forEach$iv) {
                Pair pair = (Pair)t;
                boolean bl2 = false;
                KtParameter parameter = (KtParameter)pair.component1();
                ValueParameterDescriptor descriptor2 = (ValueParameterDescriptor)pair.component2();
                Intrinsics.checkNotNull(descriptor2);
                ParameterDescriptor parameterDescriptor = descriptor2;
                Intrinsics.checkNotNull(parameter);
                hasInlineArgs |= this.checkInlinableParameter(parameterDescriptor, parameter, functionDescriptor, trace);
            }
            if (hasInlineArgs) {
                return;
            }
            if (InlineOnlyKt.isInlineWithReified(functionDescriptor) || InlineOnlyKt.isInlineOnly(functionDescriptor) || functionDescriptor.isExpect() || functionDescriptor.isSuspend()) {
                return;
            }
            Iterable<ReasonableInlineRule> $this$any$iv = this.reasonableInlineRules;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object object : $this$any$iv) {
                    ReasonableInlineRule it = (ReasonableInlineRule)object;
                    boolean bl3 = false;
                    CallableMemberDescriptor callableMemberDescriptor = functionDescriptor;
                    KtCallableDeclaration ktCallableDeclaration = function2;
                    BindingContext bindingContext = trace.getBindingContext();
                    Intrinsics.checkNotNullExpressionValue(bindingContext, "getBindingContext(...)");
                    if (!it.isInlineReasonable(callableMemberDescriptor, ktCallableDeclaration, bindingContext)) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        KotlinType kotlinType = functionDescriptor.getReturnType();
        boolean bl2 = kotlinType != null ? InlineClassesUtilsKt.needsMfvcFlattening(kotlinType) : false;
        if (bl2) {
            return;
        }
        PsiElement psiElement = function2.getModifierList();
        if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.INLINE_KEYWORD)) == null) {
            psiElement = function2;
        }
        PsiElement reportOn = psiElement;
        trace.report(Errors.NOTHING_TO_INLINE.on(reportOn));
    }

    private final boolean checkInlinableParameter(ParameterDescriptor parameter, KtElement expression, CallableDescriptor functionDescriptor, BindingTrace trace) {
        if (InlineUtil.isInlineParameterExceptNullability(parameter)) {
            if (parameter.getType().isMarkedNullable()) {
                BindingTrace bindingTrace = trace;
                if (bindingTrace != null) {
                    bindingTrace.report(Errors.NULLABLE_INLINE_PARAMETER.on((KtElement)((PsiElement)expression), expression, functionDescriptor));
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

