/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.modules;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.jvm.modules.JavaModuleInfo;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\bf\u0018\u00002\u00020\u0001:\u0003\u0019\u001a\u001bJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H&\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\t\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H&\u00a2\u0006\u0004\b\t\u0010\nR\u0014\u0010\r\u001a\u00020\u00078'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00138'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0017\u001a\u00020\u00048&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "", "exports", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "", "moduleName", "exportsTo", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;)Z", "getName", "()Ljava/lang/String;", "name", "", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Root;", "getModuleRoots", "()Ljava/util/List;", "moduleRoots", "Lcom/intellij/openapi/vfs/VirtualFile;", "getModuleInfoFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "moduleInfoFile", "isSourceModule", "()Z", "Root", "Automatic", "Explicit"})
public interface JavaModule {
    @NotNull
    public String getName();

    @NotNull
    public List<Root> getModuleRoots();

    @Nullable
    public VirtualFile getModuleInfoFile();

    public boolean isSourceModule();

    public boolean exports(@NotNull FqName var1);

    public boolean exportsTo(@NotNull FqName var1, @NotNull String var2);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0003\u001a\u00020\u00028\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u0012R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u001b\u001a\u0004\u0018\u00010\u00188WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Automatic;", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "", "name", "", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Root;", "moduleRoots", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "", "exports", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "moduleName", "exportsTo", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;)Z", "toString", "()Ljava/lang/String;", "Ljava/lang/String;", "getName", "Ljava/util/List;", "getModuleRoots", "()Ljava/util/List;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getModuleInfoFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "moduleInfoFile", "isSourceModule", "()Z"})
    public static final class Automatic
    implements JavaModule {
        @NotNull
        private final String name;
        @NotNull
        private final List<Root> moduleRoots;

        public Automatic(@NotNull String name, @NotNull List<Root> moduleRoots) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(moduleRoots, "moduleRoots");
            this.name = name;
            this.moduleRoots = moduleRoots;
        }

        @Override
        @NotNull
        public String getName() {
            return this.name;
        }

        @Override
        @NotNull
        public List<Root> getModuleRoots() {
            return this.moduleRoots;
        }

        @Override
        @Nullable
        public VirtualFile getModuleInfoFile() {
            return null;
        }

        @Override
        public boolean isSourceModule() {
            return false;
        }

        @Override
        public boolean exports(@NotNull FqName packageFqName) {
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            return true;
        }

        @Override
        public boolean exportsTo(@NotNull FqName packageFqName, @NotNull String moduleName) {
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            Intrinsics.checkNotNullParameter(moduleName, "moduleName");
            return true;
        }

        @NotNull
        public String toString() {
            return this.getName();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0013\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0013\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0011H\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\b\u001a\u00020\u00078\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\n\u0010 \u001a\u0004\b\n\u0010!R\u0014\u0010#\u001a\u00020\u00118WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0016R\u0014\u0010$\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010!"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Explicit;", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule;", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;", "moduleInfo", "", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Root;", "moduleRoots", "Lcom/intellij/openapi/vfs/VirtualFile;", "moduleInfoFile", "", "isJdkModuleFromCtSym", "<init>", "(Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;Ljava/util/List;Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "exports", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "", "moduleName", "exportsTo", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;)Z", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;", "getModuleInfo", "()Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModuleInfo;", "Ljava/util/List;", "getModuleRoots", "()Ljava/util/List;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getModuleInfoFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "Z", "()Z", "getName", "name", "isSourceModule"})
    public static final class Explicit
    implements JavaModule {
        @NotNull
        private final JavaModuleInfo moduleInfo;
        @NotNull
        private final List<Root> moduleRoots;
        @NotNull
        private final VirtualFile moduleInfoFile;
        private final boolean isJdkModuleFromCtSym;

        public Explicit(@NotNull JavaModuleInfo moduleInfo, @NotNull List<Root> moduleRoots, @NotNull VirtualFile moduleInfoFile, boolean isJdkModuleFromCtSym) {
            Intrinsics.checkNotNullParameter(moduleInfo, "moduleInfo");
            Intrinsics.checkNotNullParameter(moduleRoots, "moduleRoots");
            Intrinsics.checkNotNullParameter(moduleInfoFile, "moduleInfoFile");
            this.moduleInfo = moduleInfo;
            this.moduleRoots = moduleRoots;
            this.moduleInfoFile = moduleInfoFile;
            this.isJdkModuleFromCtSym = isJdkModuleFromCtSym;
        }

        public /* synthetic */ Explicit(JavaModuleInfo javaModuleInfo, List list, VirtualFile virtualFile, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl = false;
            }
            this(javaModuleInfo, list, virtualFile, bl);
        }

        @NotNull
        public final JavaModuleInfo getModuleInfo() {
            return this.moduleInfo;
        }

        @Override
        @NotNull
        public List<Root> getModuleRoots() {
            return this.moduleRoots;
        }

        @Override
        @NotNull
        public VirtualFile getModuleInfoFile() {
            return this.moduleInfoFile;
        }

        public final boolean isJdkModuleFromCtSym() {
            return this.isJdkModuleFromCtSym;
        }

        @Override
        @NotNull
        public String getName() {
            return this.moduleInfo.getModuleName();
        }

        @Override
        public boolean isSourceModule() {
            return Intrinsics.areEqual(this.getModuleInfoFile().getExtension(), "java") || Intrinsics.areEqual(this.getModuleInfoFile().getFileType(), JavaFileType.INSTANCE);
        }

        @Override
        public boolean exports(@NotNull FqName packageFqName) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
                Iterable $this$any$iv = this.moduleInfo.getExports();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        JavaModuleInfo.Exports exports = (JavaModuleInfo.Exports)element$iv;
                        boolean bl2 = false;
                        FqName fqName2 = exports.component1();
                        List<String> toModules = exports.component2();
                        if (!(Intrinsics.areEqual(fqName2, packageFqName) && toModules.isEmpty())) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @Override
        public boolean exportsTo(@NotNull FqName packageFqName, @NotNull String moduleName) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
                Intrinsics.checkNotNullParameter(moduleName, "moduleName");
                Iterable $this$any$iv = this.moduleInfo.getExports();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        JavaModuleInfo.Exports exports = (JavaModuleInfo.Exports)element$iv;
                        boolean bl2 = false;
                        FqName fqName2 = exports.component1();
                        List<String> toModules = exports.component2();
                        if (!(Intrinsics.areEqual(fqName2, packageFqName) && (toModules.isEmpty() || toModules.contains(moduleName)))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @NotNull
        public String toString() {
            return this.getName();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\fJ.\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u00c7\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0011\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0014\u001a\u00020\u0013H\u00d6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0010\u0010\u0017\u001a\u00020\u0016H\u00d7\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\nR\u001a\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001b\u001a\u0004\b\u0005\u0010\fR\u0017\u0010\u0006\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001b\u001a\u0004\b\u0006\u0010\f"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Root;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "file", "", "isBinary", "isBinarySignature", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;ZZ)V", "component1", "()Lcom/intellij/openapi/vfs/VirtualFile;", "component2", "()Z", "component3", "copy", "(Lcom/intellij/openapi/vfs/VirtualFile;ZZ)Lorg/jetbrains/kotlin/resolve/jvm/modules/JavaModule$Root;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFile", "Z"})
    public static final class Root {
        @NotNull
        private final VirtualFile file;
        private final boolean isBinary;
        private final boolean isBinarySignature;

        public Root(@NotNull VirtualFile file2, boolean isBinary, boolean isBinarySignature) {
            Intrinsics.checkNotNullParameter(file2, "file");
            this.file = file2;
            this.isBinary = isBinary;
            this.isBinarySignature = isBinarySignature;
        }

        public /* synthetic */ Root(VirtualFile virtualFile, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(virtualFile, bl, bl2);
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        public final boolean isBinary() {
            return this.isBinary;
        }

        public final boolean isBinarySignature() {
            return this.isBinarySignature;
        }

        @NotNull
        public final VirtualFile component1() {
            return this.file;
        }

        public final boolean component2() {
            return this.isBinary;
        }

        public final boolean component3() {
            return this.isBinarySignature;
        }

        @NotNull
        public final Root copy(@NotNull VirtualFile file2, boolean isBinary, boolean isBinarySignature) {
            Intrinsics.checkNotNullParameter(file2, "file");
            return new Root(file2, isBinary, isBinarySignature);
        }

        public static /* synthetic */ Root copy$default(Root root, VirtualFile virtualFile, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = root.file;
            }
            if ((n & 2) != 0) {
                bl = root.isBinary;
            }
            if ((n & 4) != 0) {
                bl2 = root.isBinarySignature;
            }
            return root.copy(virtualFile, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "Root(file=" + this.file + ", isBinary=" + this.isBinary + ", isBinarySignature=" + this.isBinarySignature + ')';
        }

        public int hashCode() {
            int result2 = this.file.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isBinary);
            result2 = result2 * 31 + Boolean.hashCode(this.isBinarySignature);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Root)) {
                return false;
            }
            Root root = (Root)other;
            if (!Intrinsics.areEqual(this.file, root.file)) {
                return false;
            }
            if (this.isBinary != root.isBinary) {
                return false;
            }
            return this.isBinarySignature == root.isBinarySignature;
        }
    }
}

