/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.konan.diagnostics;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;
import org.jetbrains.kotlin.resolve.konan.diagnostics.NativeHiddenFromObjCInheritanceCheckerKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J'\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeHiddenFromObjCInheritanceChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V"})
public final class NativeHiddenFromObjCInheritanceChecker
implements DeclarationChecker {
    @NotNull
    public static final NativeHiddenFromObjCInheritanceChecker INSTANCE = new NativeHiddenFromObjCInheritanceChecker();

    private NativeHiddenFromObjCInheritanceChecker() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        boolean bl;
        block8: {
            Intrinsics.checkNotNullParameter(declaration, "declaration");
            Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
            Intrinsics.checkNotNullParameter(context, "context");
            if (!(descriptor2 instanceof ClassDescriptor)) {
                return;
            }
            if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                return;
            }
            if (!((ClassDescriptor)descriptor2).getVisibility().isPublicAPI()) {
                return;
            }
            if (NativeHiddenFromObjCInheritanceCheckerKt.access$checkClassIsHiddenFromObjC((ClassDescriptor)descriptor2)) {
                return;
            }
            Iterable $this$any$iv = DescriptorUtilsKt.getSuperInterfaces((ClassDescriptor)descriptor2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClassDescriptor it = (ClassDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!NativeHiddenFromObjCInheritanceCheckerKt.access$checkClassIsHiddenFromObjC(it)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (!bl) {
            ClassDescriptor classDescriptor = DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)descriptor2);
            if (classDescriptor == null) return;
            ClassDescriptor it = classDescriptor;
            boolean bl3 = false;
            if (!NativeHiddenFromObjCInheritanceCheckerKt.access$checkClassIsHiddenFromObjC(it)) return;
            boolean bl4 = true;
            if (!bl4) return;
        }
        boolean bl5 = true;
        boolean isSubtypeOfHiddenFromObjC = bl5;
        if (!isSubtypeOfHiddenFromObjC) return;
        context.getTrace().report(ErrorsNative.SUBTYPE_OF_HIDDEN_FROM_OBJC.on((KtElement)((PsiElement)declaration)));
    }
}

