/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.konan.diagnostics;

import com.intellij.extapi.psi.ASTDelegatePsiElement;
import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.konan.diagnostics.ErrorsNative;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0010\f\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J'\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ/\u0010 \u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001b2\u000e\u0010\u001f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\u001d2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b \u0010!R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\"R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020$0#8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b%\u0010&"}, d2={"Lorg/jetbrains/kotlin/resolve/konan/diagnostics/NativeIdentifierChecker;", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "simpleNameExpression", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "diagnosticHolder", "", "checkIdentifier", "(Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;)V", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "declaration", "checkDeclaration", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;)V", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "descriptor", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "context", "check", "(Lorg/jetbrains/kotlin/psi/KtDeclaration;Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;)V", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "checkNamed", "(Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;)V", "", "name", "Lkotlin/Function0;", "Lcom/intellij/psi/PsiElement;", "reportOn", "reportIfNeeded", "(Ljava/lang/String;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;)V", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "", "", "invalidChars", "Ljava/util/Set;"})
public final class NativeIdentifierChecker
implements IdentifierChecker,
DeclarationChecker {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final Set<Character> invalidChars;

    public NativeIdentifierChecker(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
        Character[] characterArray = new Character[]{Character.valueOf('.'), Character.valueOf(';'), Character.valueOf(','), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('/'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(':'), Character.valueOf('\\'), Character.valueOf('$'), Character.valueOf('&'), Character.valueOf('~'), Character.valueOf('*'), Character.valueOf('?'), Character.valueOf('#'), Character.valueOf('|'), Character.valueOf('\u00a7'), Character.valueOf('%'), Character.valueOf('@')};
        this.invalidChars = SetsKt.setOf(characterArray);
    }

    @Override
    public void checkIdentifier(@NotNull KtSimpleNameExpression simpleNameExpression, @NotNull DiagnosticSink diagnosticHolder) {
        Intrinsics.checkNotNullParameter(simpleNameExpression, "simpleNameExpression");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        this.reportIfNeeded(simpleNameExpression.getReferencedName(), () -> NativeIdentifierChecker.checkIdentifier$lambda$0(simpleNameExpression), diagnosticHolder);
    }

    @Override
    public void checkDeclaration(@NotNull KtDeclaration declaration, @NotNull DiagnosticSink diagnosticHolder) {
        ASTDelegatePsiElement it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(diagnosticHolder, "diagnosticHolder");
        if (declaration instanceof KtDestructuringDeclaration) {
            List<KtDestructuringDeclarationEntry> list = ((KtDestructuringDeclaration)declaration).getEntries();
            Intrinsics.checkNotNullExpressionValue(list, "getEntries(...)");
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtDestructuringDeclarationEntry)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                this.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration instanceof KtCallableDeclaration) {
            List<KtParameter> list = ((KtCallableDeclaration)declaration).getValueParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getValueParameters(...)");
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                this.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration instanceof KtTypeParameterListOwner) {
            List<KtTypeParameter> list = ((KtTypeParameterListOwner)declaration).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue(list, "getTypeParameters(...)");
            $this$forEach$iv = list;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (KtTypeParameter)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it);
                this.checkNamed((KtNamedDeclaration)((Object)it), diagnosticHolder);
            }
        }
        if (declaration instanceof KtNamedDeclaration) {
            this.checkNamed((KtNamedDeclaration)declaration, diagnosticHolder);
        }
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(context, "context");
        if (declaration instanceof KtTypeAlias) {
            this.checkNamed((KtNamedDeclaration)declaration, context.getTrace());
        }
    }

    private final void checkNamed(KtNamedDeclaration declaration, DiagnosticSink diagnosticHolder) {
        String string2 = declaration.getName();
        if (string2 == null) {
            return;
        }
        String name = string2;
        this.reportIfNeeded(name, () -> NativeIdentifierChecker.checkNamed$lambda$4(declaration), diagnosticHolder);
    }

    private final void reportIfNeeded(String name, Function0<? extends PsiElement> reportOn, DiagnosticSink diagnosticHolder) {
        String string2 = KtPsiUtil.unquoteIdentifier(name);
        Intrinsics.checkNotNullExpressionValue(string2, "unquoteIdentifier(...)");
        String text = string2;
        if (((CharSequence)text).length() == 0) {
            PsiElement psiElement = reportOn.invoke();
            if (psiElement == null) {
                return;
            }
            diagnosticHolder.report(ErrorsNative.INVALID_CHARACTERS_NATIVE.on(this.languageVersionSettings, psiElement, "should not be empty"));
        } else {
            boolean bl;
            block6: {
                CharSequence $this$any$iv = text;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(i);
                    boolean bl2 = false;
                    if (!this.invalidChars.contains(Character.valueOf(it))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
            if (bl) {
                PsiElement psiElement = reportOn.invoke();
                if (psiElement == null) {
                    return;
                }
                diagnosticHolder.report(ErrorsNative.INVALID_CHARACTERS_NATIVE.on(this.languageVersionSettings, psiElement, "contains illegal characters: " + CollectionsKt.joinToString$default(CollectionsKt.intersect((Iterable)this.invalidChars, (Iterable)StringsKt.toSet(text)), "", "\"", "\"", 0, null, null, 56, null)));
            }
        }
    }

    private static final PsiElement checkIdentifier$lambda$0(KtSimpleNameExpression $simpleNameExpression) {
        return $simpleNameExpression.getIdentifier();
    }

    private static final PsiElement checkNamed$lambda$4(KtNamedDeclaration $declaration) {
        PsiElement psiElement = $declaration.getNameIdentifier();
        if (psiElement == null) {
            psiElement = $declaration;
        }
        return psiElement;
    }
}

